/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;

public class Clipboard {
    private static Clipboard theClipboard = new Clipboard();
    private static Library clipLib = null;
    private static Cell clipCell;
    private static boolean dupDistSet;
    private static double dupX;
    private static double dupY;
    static /* synthetic */ Class class$com$sun$electric$database$topology$NodeInst;
    static /* synthetic */ Class class$com$sun$electric$database$topology$ArcInst;
    static /* synthetic */ Class class$com$sun$electric$database$prototype$PortProto;

    private Clipboard() {
    }

    private static void init() {
        if (clipLib == null) {
            clipLib = Library.newInstance("Clipboard!!", null);
            clipLib.setHidden();
        }
        if (clipCell == null) {
            clipCell = Cell.newInstance(clipLib, "Clipboard!!");
        }
    }

    public static void clear() {
        NodeInst ni;
        Export pp;
        ArcInst ai;
        Clipboard.init();
        ArrayList<ArcInst> arcsToDelete = new ArrayList<ArcInst>();
        Iterator it = clipCell.getArcs();
        while (it.hasNext()) {
            ai = (ArcInst)it.next();
            arcsToDelete.add(ai);
        }
        it = arcsToDelete.iterator();
        while (it.hasNext()) {
            ai = (ArcInst)it.next();
            ai.kill();
        }
        ArrayList<Export> exportsToDelete = new ArrayList<Export>();
        Iterator it2 = clipCell.getPorts();
        while (it2.hasNext()) {
            pp = (Export)it2.next();
            exportsToDelete.add(pp);
        }
        it2 = exportsToDelete.iterator();
        while (it2.hasNext()) {
            pp = (Export)it2.next();
            pp.kill();
        }
        ArrayList<NodeInst> nodesToDelete = new ArrayList<NodeInst>();
        Iterator it3 = clipCell.getNodes();
        while (it3.hasNext()) {
            ni = (NodeInst)it3.next();
            nodesToDelete.add(ni);
        }
        it3 = nodesToDelete.iterator();
        while (it3.hasNext()) {
            ni = (NodeInst)it3.next();
            ni.kill();
        }
    }

    public static void copy() {
        CopyObjects job = new CopyObjects();
    }

    public static void cut() {
        CutObjects job = new CutObjects();
    }

    public static void duplicate() {
        DuplicateObjects job = new DuplicateObjects();
    }

    public static void paste() {
        Clipboard.init();
        int nTotal = clipCell.getNumNodes();
        int aTotal = clipCell.getNumArcs();
        int total = nTotal + aTotal;
        if (total == 0) {
            System.out.println("Nothing in the clipboard to paste");
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        List geoms = Highlight.getHighlighted(true, true);
        if (geoms.size() > 0) {
            if (nTotal == 2 && aTotal == 1) {
                ArcInst ai = (ArcInst)clipCell.getArcs().next();
                NodeInst niHead = ai.getHead().getPortInst().getNodeInst();
                NodeInst niTail = ai.getTail().getPortInst().getNodeInst();
                Iterator nIt = clipCell.getNodes();
                NodeInst ni1 = (NodeInst)nIt.next();
                NodeInst ni2 = (NodeInst)nIt.next();
                if (ni1 == niHead && ni2 == niTail || ni1 == niTail && ni2 == niHead) {
                    nTotal = 0;
                }
                total = nTotal + aTotal;
            }
            if (total > 1) {
                System.out.println("Can only paste a single object on top of selected objects");
                return;
            }
            Iterator it = geoms.iterator();
            while (it.hasNext()) {
                Job job;
                Geometric geom = (Geometric)it.next();
                if (geom instanceof NodeInst && nTotal == 1) {
                    NodeInst ni = (NodeInst)geom;
                    job = new PasteNodeToNode(ni, (NodeInst)clipCell.getNodes().next());
                    continue;
                }
                if (!(geom instanceof ArcInst) || aTotal != 1) continue;
                ArcInst ai = (ArcInst)geom;
                job = new PasteArcToArc(ai, (ArcInst)clipCell.getArcs().next());
            }
            return;
        }
        ArrayList<Geometric> pasteList = new ArrayList<Geometric>();
        Iterator it = clipCell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            pasteList.add(ni);
        }
        it = clipCell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            pasteList.add(ai);
        }
        if (!dupDistSet) {
            dupDistSet = true;
            dupY = 2.0;
            dupX = 2.0;
        }
        if (User.isMoveAfterDuplicate()) {
            EventListener currentListener = WindowFrame.getListener();
            WindowFrame.setListener(new PasteListener(wnd, pasteList, currentListener, null));
        } else {
            Point2D mouse = ClickZoomWireListener.theOne.getLastMouse();
            Point2D mouseDB = wnd.screenToDatabase((int)mouse.getX(), (int)mouse.getY());
            EditWindow.gridAlign(mouseDB);
            PasteObjects job = new PasteObjects(pasteList, -dupX - mouseDB.getX(), -dupY - mouseDB.getY());
        }
    }

    public String toString() {
        return "Clipboard";
    }

    private static void copyListToCell(EditWindow wnd, List list, Cell fromCell, Cell toCell, boolean highlight, double mouseX, double mouseY) {
        NodeInst ni;
        Geometric geom;
        double dX = -mouseX;
        double dY = -mouseY;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Geometric geom2 = (Geometric)it.next();
            if (fromCell == geom2.getParent()) continue;
            System.out.println("All duplicated objects must be in the same cell");
            return;
        }
        FlagSet inAreaFlag = Geometric.getFlagSet(1);
        Iterator it2 = fromCell.getNodes();
        while (it2.hasNext()) {
            NodeInst ni2 = (NodeInst)it2.next();
            ni2.clearBit(inAreaFlag);
        }
        it2 = list.iterator();
        while (it2.hasNext()) {
            geom = (Geometric)it2.next();
            if (geom instanceof NodeInst) continue;
            ArcInst ai = (ArcInst)geom;
            ai.getHead().getPortInst().getNodeInst().setBit(inAreaFlag);
            ai.getTail().getPortInst().getNodeInst().setBit(inAreaFlag);
        }
        it2 = list.iterator();
        while (it2.hasNext()) {
            geom = (Geometric)it2.next();
            if (geom instanceof ArcInst) continue;
            ni = (NodeInst)geom;
            ni.setBit(inAreaFlag);
        }
        ArrayList<NodeInst> theNodes = new ArrayList<NodeInst>();
        Iterator it3 = fromCell.getNodes();
        while (it3.hasNext()) {
            ni = (NodeInst)it3.next();
            if (!ni.isBit(inAreaFlag)) continue;
            theNodes.add(ni);
        }
        if (theNodes.size() == 0) {
            return;
        }
        inAreaFlag.freeFlagSet();
        it3 = theNodes.iterator();
        while (it3.hasNext()) {
            Cell niCell;
            ni = (NodeInst)it3.next();
            if (ni.getProto() instanceof PrimitiveNode || !Cell.isInstantiationRecursive(niCell = (Cell)ni.getProto(), toCell)) continue;
            System.out.println("Cannot: that would be recursive (cell " + toCell.describe() + " is beneath cell " + ni.getProto().describe() + ")");
            return;
        }
        Iterator nit = theNodes.iterator();
        NodeInst niFirst = (NodeInst)nit.next();
        Point2D.Double corner = new Point2D.Double();
        corner.setLocation(niFirst.getAnchorCenter());
        while (nit.hasNext()) {
            NodeInst ni3 = (NodeInst)nit.next();
            Point2D pt = ni3.getAnchorCenter();
            if (pt.getX() < ((Point2D)corner).getY()) {
                ((Point2D)corner).setLocation(pt.getX(), ((Point2D)corner).getY());
            }
            if (!(pt.getY() < ((Point2D)corner).getY())) continue;
            ((Point2D)corner).setLocation(((Point2D)corner).getX(), pt.getY());
        }
        Iterator it4 = list.iterator();
        while (it4.hasNext()) {
            Geometric geom3 = (Geometric)it4.next();
            if (geom3 instanceof NodeInst) continue;
            ArcInst ai = (ArcInst)geom3;
            double wid = ai.getWidth() - ai.getProto().getWidthOffset();
            Poly poly = ai.makePoly(ai.getLength(), wid, Poly.Type.FILLED);
            Rectangle2D bounds = poly.getBounds2D();
            if (bounds.getMinX() < ((Point2D)corner).getY()) {
                ((Point2D)corner).setLocation(bounds.getMinX(), ((Point2D)corner).getY());
            }
            if (!(bounds.getMinY() < ((Point2D)corner).getY())) continue;
            ((Point2D)corner).setLocation(((Point2D)corner).getX(), bounds.getMinY());
        }
        EditWindow.gridAlign(corner);
        ArrayList<Export> queuedExports = new ArrayList<Export>();
        Collections.sort(theNodes, new NodeNameCaseInsensitive());
        Iterator it5 = theNodes.iterator();
        while (it5.hasNext()) {
            NodeInst newNi;
            NodeInst ni4 = (NodeInst)it5.next();
            if (ni4.getProto() == Generic.tech.cellCenterNode && toCell.alreadyCellCenter()) continue;
            double width = ni4.getXSize();
            if (ni4.isXMirrored()) {
                width = -width;
            }
            double height = ni4.getYSize();
            if (ni4.isYMirrored()) {
                height = -height;
            }
            String name = null;
            if (ni4.isUsernamed()) {
                name = ElectricObject.uniqueObjectName(ni4.getName(), toCell, class$com$sun$electric$database$topology$NodeInst == null ? Clipboard.class$("com.sun.electric.database.topology.NodeInst") : class$com$sun$electric$database$topology$NodeInst);
            }
            if ((newNi = NodeInst.newInstance(ni4.getProto(), new Point2D.Double(ni4.getAnchorCenterX() + dX, ni4.getAnchorCenterY() + dY), width, height, ni4.getAngle(), toCell, name)) == null) {
                System.out.println("Cannot create node");
                return;
            }
            newNi.copyStateBits(ni4);
            newNi.clearWiped();
            newNi.clearShortened();
            newNi.setProtoTextDescriptor(ni4.getProtoTextDescriptor());
            newNi.setNameTextDescriptor(ni4.getNameTextDescriptor());
            newNi.copyVars(ni4);
            ni4.setTempObj(newNi);
            if (!User.isDupCopiesExports()) continue;
            Iterator eit = ni4.getExports();
            while (eit.hasNext()) {
                Export pp = (Export)eit.next();
                queuedExports.add(pp);
            }
        }
        Clipboard.createQueuedExports(queuedExports);
        ArrayList<Geometric> theArcs = new ArrayList<Geometric>();
        Iterator it6 = list.iterator();
        while (it6.hasNext()) {
            Geometric geom4 = (Geometric)it6.next();
            if (!(geom4 instanceof ArcInst)) continue;
            theArcs.add(geom4);
        }
        if (theArcs.size() > 0) {
            Collections.sort(theArcs, new ArcNameCaseInsensitive());
            it6 = theArcs.iterator();
            while (it6.hasNext()) {
                ArcInst newAr;
                ArcInst ai = (ArcInst)it6.next();
                PortInst oldHeadPi = ai.getHead().getPortInst();
                NodeInst headNi = (NodeInst)oldHeadPi.getNodeInst().getTempObj();
                PortInst headPi = headNi.findPortInstFromProto(oldHeadPi.getPortProto());
                PortInst oldTailPi = ai.getTail().getPortInst();
                NodeInst tailNi = (NodeInst)oldTailPi.getNodeInst().getTempObj();
                PortInst tailPi = tailNi.findPortInstFromProto(oldTailPi.getPortProto());
                String name = null;
                if (ai.isUsernamed()) {
                    name = ElectricObject.uniqueObjectName(ai.getName(), toCell, class$com$sun$electric$database$topology$ArcInst == null ? Clipboard.class$("com.sun.electric.database.topology.ArcInst") : class$com$sun$electric$database$topology$ArcInst);
                }
                if ((newAr = ArcInst.newInstance(ai.getProto(), ai.getWidth(), headPi, new Point2D.Double(ai.getHead().getLocation().getX() + dX, ai.getHead().getLocation().getY() + dY), tailPi, new Point2D.Double(ai.getTail().getLocation().getX() + dX, ai.getTail().getLocation().getY() + dY), name)) == null) {
                    System.out.println("Cannot create arc");
                    return;
                }
                newAr.copyStateBits(ai);
                newAr.copyVars(ai);
                newAr.setNameTextDescriptor(ai.getNameTextDescriptor());
                ai.setTempObj(newAr);
            }
        }
        if (highlight) {
            Highlight.clear();
            it6 = theNodes.iterator();
            while (it6.hasNext()) {
                NodeInst ni5 = (NodeInst)it6.next();
                if ((ni5 = (NodeInst)ni5.getTempObj()) == null) continue;
                if (ni5.isInvisiblePinWithText()) {
                    Poly[] polys = ni5.getAllText(false, wnd);
                    if (polys == null) continue;
                    for (int i = 0; i < polys.length; ++i) {
                        Poly poly = polys[i];
                        Highlight h = Highlight.addText(ni5, toCell, poly.getVariable(), poly.getName());
                    }
                    continue;
                }
                Highlight h = Highlight.addElectricObject(ni5, toCell);
            }
            it6 = list.iterator();
            while (it6.hasNext()) {
                Geometric geom5 = (Geometric)it6.next();
                if (geom5 instanceof NodeInst) continue;
                ArcInst ai = (ArcInst)geom5;
                ai = (ArcInst)ai.getTempObj();
                Highlight h = Highlight.addElectricObject(ai, toCell);
            }
            Highlight.finished();
        }
        it6 = list.iterator();
        while (it6.hasNext()) {
            Geometric geom6 = (Geometric)it6.next();
            geom6.setTempObj(null);
        }
        it6 = theNodes.iterator();
        while (it6.hasNext()) {
            NodeInst ni6 = (NodeInst)it6.next();
            ni6.setTempObj(null);
        }
    }

    public static void createQueuedExports(List queuedExports) {
        Collections.sort(queuedExports, new ExportNameCaseInsensitive());
        Iterator it = queuedExports.iterator();
        while (it.hasNext()) {
            String portName;
            Export origPp = (Export)it.next();
            PortInst pi = origPp.getOriginalPort();
            NodeInst ni = pi.getNodeInst();
            ni = (NodeInst)ni.getTempObj();
            PortProto pp = pi.getPortProto();
            PortInst newPi = ni.findPortInstFromProto(pp);
            Cell cell = ni.getParent();
            Export newPp = Export.newInstance(cell, newPi, portName = ElectricObject.uniqueObjectName(origPp.getName(), cell, class$com$sun$electric$database$prototype$PortProto == null ? Clipboard.class$("com.sun.electric.database.prototype.PortProto") : class$com$sun$electric$database$prototype$PortProto));
            if (newPp == null) {
                return;
            }
            newPp.setTextDescriptor(origPp.getTextDescriptor());
            newPp.copyVars(origPp);
        }
    }

    private static NodeInst pasteNodeToNode(NodeInst destNode, NodeInst srcNode) {
        if (destNode.getProto() != srcNode.getProto()) {
            destNode = CircuitChanges.replaceNodeInst(destNode, srcNode.getProto(), true, false);
            return destNode;
        }
        if (destNode.getProto() instanceof PrimitiveNode) {
            double dX = srcNode.getXSize() - destNode.getXSize();
            double dY = srcNode.getYSize() - destNode.getYSize();
            if (dX != 0.0 || dY != 0.0) {
                double dlx = -dX / 2.0;
                double dhx = dX / 2.0;
                double dly = -dY / 2.0;
                double dhy = dY / 2.0;
                destNode.modifyInstance(dlx, dly, 0.0, 0.0, 0);
            }
        }
        boolean checkAgain = true;
        block0: while (checkAgain) {
            checkAgain = false;
            Iterator it = destNode.getVariables();
            while (it.hasNext()) {
                Variable destVar = (Variable)it.next();
                Variable.Key key = destVar.getKey();
                Variable srcVar = srcNode.getVar(key.getName());
                if (srcVar != null) continue;
                destNode.delVar(key);
                checkAgain = true;
                continue block0;
            }
        }
        destNode.copyVars(srcNode);
        destNode.lowLevelSetUserbits(srcNode.lowLevelGetUserbits());
        destNode.clearExpanded();
        if (srcNode.isExpanded()) {
            destNode.setExpanded();
        }
        destNode.clearShortened();
        destNode.clearWiped();
        destNode.clearLocked();
        return destNode;
    }

    private static ArcInst pasteArcToArc(ArcInst destArc, ArcInst srcArc) {
        Variable.Key key;
        Iterator it;
        if (destArc.getProto() != srcArc.getProto() && (destArc = destArc.replace(srcArc.getProto())) == null) {
            return null;
        }
        double dw = srcArc.getWidth() - destArc.getWidth();
        if (dw != 0.0) {
            destArc.modify(dw, 0.0, 0.0, 0.0, 0.0);
        }
        boolean checkAgain = true;
        block0: while (checkAgain) {
            checkAgain = false;
            it = destArc.getVariables();
            while (it.hasNext()) {
                Variable destVar = (Variable)it.next();
                key = destVar.getKey();
                Variable srcVar = srcArc.getVar(key.getName());
                if (srcVar != null) continue;
                destArc.delVar(key);
                checkAgain = true;
                continue block0;
            }
        }
        it = srcArc.getVariables();
        while (it.hasNext()) {
            Variable srcVar = (Variable)it.next();
            key = srcVar.getKey();
            Variable destVar = destArc.newVar(key, srcVar.getObject());
            if (destVar == null) continue;
            destVar.setTextDescriptor(srcVar.getTextDescriptor());
        }
        if (srcArc.isRigid()) {
            destArc.setRigid();
        } else {
            destArc.clearRigid();
        }
        if (srcArc.isFixedAngle()) {
            destArc.setFixedAngle();
        } else {
            destArc.clearFixedAngle();
        }
        if (srcArc.isSlidable()) {
            destArc.setSlidable();
        } else {
            destArc.clearSlidable();
        }
        if (srcArc.isExtended()) {
            destArc.setExtended();
        } else {
            destArc.clearExtended();
        }
        if (srcArc.isDirectional()) {
            destArc.setDirectional();
        } else {
            destArc.clearDirectional();
        }
        if (srcArc.isSkipHead()) {
            destArc.setSkipHead();
        } else {
            destArc.clearSkipHead();
        }
        if (srcArc.isSkipTail()) {
            destArc.setSkipTail();
        } else {
            destArc.clearSkipTail();
        }
        if (srcArc.isReverseEnds()) {
            destArc.setReverseEnds();
        } else {
            destArc.clearReverseEnds();
        }
        if (srcArc.isHardSelect()) {
            destArc.setHardSelect();
        } else {
            destArc.clearHardSelect();
        }
        return destArc;
    }

    static {
        dupDistSet = false;
    }

    private static class PasteListener
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        private EditWindow wnd;
        private List pasteList;
        private EventListener currentListener;
        private int origX;
        private int origY;
        private double oX;
        private double oY;

        public PasteListener(EditWindow wnd, List pasteList, EventListener currentListener, Point2D startPaste) {
            Point2D mouseDB;
            this.wnd = wnd;
            this.pasteList = pasteList;
            this.currentListener = currentListener;
            if (startPaste == null) {
                Point2D mouse = ClickZoomWireListener.theOne.getLastMouse();
                mouseDB = wnd.screenToDatabase((int)mouse.getX(), (int)mouse.getY());
            } else {
                mouseDB = startPaste;
            }
            EditWindow.gridAlign(mouseDB);
            this.origX = (int)mouseDB.getX();
            this.origY = (int)mouseDB.getY();
            this.oX = mouseDB.getX();
            this.oY = mouseDB.getY();
            Highlight.pushHighlight();
            this.showList();
        }

        private void showList() {
            Cell cell = this.wnd.getCell();
            Highlight.clear();
            Iterator it = this.pasteList.iterator();
            while (it.hasNext()) {
                double tY;
                double tX;
                double fY;
                Geometric geom = (Geometric)it.next();
                Point2D[] points = null;
                if (geom instanceof ArcInst) {
                    ArcInst ai = (ArcInst)geom;
                    Poly poly = ai.makePoly(ai.getLength(), ai.getWidth() - ai.getProto().getWidthOffset(), Poly.Type.CLOSED);
                    points = poly.getPoints();
                } else {
                    NodeInst ni = (NodeInst)geom;
                    if (ni.isInvisiblePinWithText()) {
                        Iterator vIt = ni.getVariables();
                        while (vIt.hasNext()) {
                            Variable var = (Variable)vIt.next();
                            if (!var.isDisplay()) continue;
                            points = Highlight.describeHighlightText(this.wnd, geom, var, null);
                            break;
                        }
                    }
                    if (points != null) {
                        for (int i = 0; i < points.length; i += 2) {
                            double fX = points[i].getX();
                            fY = points[i].getY();
                            tX = points[i + 1].getX();
                            tY = points[i + 1].getY();
                            Highlight.addLine(new Point2D.Double(fX + this.oX, fY + this.oY), new Point2D.Double(tX + this.oX, tY + this.oY), cell);
                        }
                        continue;
                    }
                    SizeOffset so = ni.getSizeOffset();
                    AffineTransform trans = ni.rotateOutAboutTrueCenter();
                    double nodeLowX = ni.getTrueCenterX() - ni.getXSize() / 2.0 + so.getLowXOffset();
                    double nodeHighX = ni.getTrueCenterX() + ni.getXSize() / 2.0 - so.getHighXOffset();
                    double nodeLowY = ni.getTrueCenterY() - ni.getYSize() / 2.0 + so.getLowYOffset();
                    double nodeHighY = ni.getTrueCenterY() + ni.getYSize() / 2.0 - so.getHighYOffset();
                    double nodeX = (nodeLowX + nodeHighX) / 2.0;
                    double nodeY = (nodeLowY + nodeHighY) / 2.0;
                    Poly poly = new Poly(nodeX, nodeY, nodeHighX - nodeLowX, nodeHighY - nodeLowY);
                    poly.transform(trans);
                    points = poly.getPoints();
                }
                if (points == null) continue;
                for (int i = 0; i < points.length; ++i) {
                    int lastI = i - 1;
                    if (lastI < 0) {
                        lastI = points.length - 1;
                    }
                    double fX = points[lastI].getX();
                    fY = points[lastI].getY();
                    tX = points[i].getX();
                    tY = points[i].getY();
                    Highlight.addLine(new Point2D.Double(fX + this.oX, fY + this.oY), new Point2D.Double(tX + this.oX, tY + this.oY), cell);
                }
            }
            Highlight.finished();
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseDragged(MouseEvent evt) {
            this.mouseMoved(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            boolean ctrl = (evt.getModifiersEx() & 0x80) != 0;
            Point2D mouseDB = this.wnd.screenToDatabase(evt.getX(), evt.getY());
            if (ctrl) {
                mouseDB = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.origX, this.origY), mouseDB);
            }
            EditWindow.gridAlign(mouseDB);
            this.oX = mouseDB.getX();
            this.oY = mouseDB.getY();
            this.showList();
            WindowFrame.setListener(this.currentListener);
            Highlight.popHighlight();
            PasteObjects job = new PasteObjects(this.pasteList, -this.oX, -this.oY);
        }

        public void mouseMoved(MouseEvent evt) {
            boolean ctrl = (evt.getModifiersEx() & 0x80) != 0;
            Point2D mouseDB = this.wnd.screenToDatabase(evt.getX(), evt.getY());
            if (ctrl) {
                mouseDB = ClickZoomWireListener.convertToOrthogonal(new Point2D.Double(this.origX, this.origY), mouseDB);
            }
            EditWindow.gridAlign(mouseDB);
            this.oX = mouseDB.getX();
            this.oY = mouseDB.getY();
            this.showList();
            this.wnd.repaint();
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
        }

        public void keyPressed(KeyEvent evt) {
            int chr = evt.getKeyCode();
            if (chr == 27) {
                Highlight.clear();
                Highlight.finished();
                WindowFrame.setListener(this.currentListener);
                this.wnd.repaint();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    private static class ExportNameCaseInsensitive
    implements Comparator {
        private ExportNameCaseInsensitive() {
        }

        public int compare(Object o1, Object o2) {
            Export e1 = (Export)o1;
            Export e2 = (Export)o2;
            String s1 = e1.getName();
            String s2 = e1.getName();
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return s1.compareToIgnoreCase(s2);
        }
    }

    private static class ArcNameCaseInsensitive
    implements Comparator {
        private ArcNameCaseInsensitive() {
        }

        public int compare(Object o1, Object o2) {
            ArcInst a1 = (ArcInst)o1;
            ArcInst a2 = (ArcInst)o2;
            String s1 = a1.getName();
            String s2 = a1.getName();
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return s1.compareToIgnoreCase(s2);
        }
    }

    private static class NodeNameCaseInsensitive
    implements Comparator {
        private NodeNameCaseInsensitive() {
        }

        public int compare(Object o1, Object o2) {
            NodeInst n1 = (NodeInst)o1;
            NodeInst n2 = (NodeInst)o2;
            String s1 = n1.getName();
            String s2 = n1.getName();
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return s1.compareToIgnoreCase(s2);
        }
    }

    private static class PasteObjects
    extends Job {
        List pasteList;
        double dX;
        double dY;

        protected PasteObjects(List pasteList, double dX, double dY) {
            super("Paste", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.pasteList = pasteList;
            this.dX = dX;
            this.dY = dY;
            this.startJob();
        }

        public boolean doIt() {
            EditWindow wnd = EditWindow.needCurrent();
            Cell parent = wnd.getCell();
            if (CircuitChanges.cantEdit(parent, null, true)) {
                return false;
            }
            Clipboard.copyListToCell(wnd, this.pasteList, clipCell, parent, true, this.dX, this.dY);
            return true;
        }
    }

    private static class PasteNodeToNode
    extends Job {
        NodeInst src;
        NodeInst dst;

        protected PasteNodeToNode(NodeInst dst, NodeInst src) {
            super("Paste Node to Node", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.src = src;
            this.dst = dst;
            this.startJob();
        }

        public boolean doIt() {
            if (CircuitChanges.cantEdit(this.dst.getParent(), null, true)) {
                return false;
            }
            NodeInst ni = Clipboard.pasteNodeToNode(this.dst, this.src);
            if (ni == null) {
                System.out.println("Nothing was pasted");
            }
            if (ni != null) {
                Highlight.clear();
                Highlight.addElectricObject(ni, ni.getParent());
                Highlight.finished();
            }
            return true;
        }
    }

    private static class PasteArcToArc
    extends Job {
        ArcInst src;
        ArcInst dst;

        protected PasteArcToArc(ArcInst dst, ArcInst src) {
            super("Paste Arc to Arc", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.src = src;
            this.dst = dst;
            this.startJob();
        }

        public boolean doIt() {
            if (CircuitChanges.cantEdit(this.dst.getParent(), null, true)) {
                return false;
            }
            ArcInst ai = Clipboard.pasteArcToArc(this.dst, this.src);
            if (ai == null) {
                System.out.println("Nothing was pasted");
            }
            if (ai != null) {
                Highlight.clear();
                Highlight.addElectricObject(ai, ai.getParent());
                Highlight.finished();
            }
            return true;
        }
    }

    private static class DuplicateObjects
    extends Job {
        protected DuplicateObjects() {
            super("Duplicate", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            List geoms = Highlight.getHighlighted(true, true);
            if (geoms.size() == 0) {
                System.out.println("First select objects to copy");
                return false;
            }
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return false;
            }
            Cell parent = wnd.getCell();
            Clipboard.clear();
            Point2D mouse = ClickZoomWireListener.theOne.getLastMouse();
            Point2D mouseDB = wnd.screenToDatabase((int)mouse.getX(), (int)mouse.getY());
            EditWindow.gridAlign(mouseDB);
            Clipboard.copyListToCell(wnd, geoms, parent, clipCell, false, mouseDB.getX(), mouseDB.getY());
            Highlight.clear();
            Clipboard.paste();
            return true;
        }
    }

    private static class CutObjects
    extends Job {
        protected CutObjects() {
            super("Cut", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            List geoms = Highlight.getHighlighted(true, true);
            if (geoms.size() == 0) {
                System.out.println("First select objects to cut");
                return false;
            }
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return false;
            }
            Cell parent = wnd.getCell();
            Clipboard.clear();
            Point2D mouse = ClickZoomWireListener.theOne.getLastMouse();
            Point2D mouseDB = wnd.screenToDatabase((int)mouse.getX(), (int)mouse.getY());
            EditWindow.gridAlign(mouseDB);
            if (CircuitChanges.cantEdit(parent, null, true)) {
                return false;
            }
            Clipboard.copyListToCell(wnd, geoms, parent, clipCell, false, mouseDB.getX(), mouseDB.getY());
            CircuitChanges.eraseObjectsInList(parent, geoms);
            return true;
        }
    }

    private static class CopyObjects
    extends Job {
        protected CopyObjects() {
            super("Copy", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            List geoms = Highlight.getHighlighted(true, true);
            if (geoms.size() == 0) {
                System.out.println("First select objects to copy");
                return false;
            }
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return false;
            }
            Cell parent = wnd.getCell();
            Clipboard.clear();
            Point2D mouse = ClickZoomWireListener.theOne.getLastMouse();
            Point2D mouseDB = wnd.screenToDatabase((int)mouse.getX(), (int)mouse.getY());
            EditWindow.gridAlign(mouseDB);
            Clipboard.copyListToCell(wnd, geoms, parent, clipCell, false, mouseDB.getX(), mouseDB.getY());
            return true;
        }
    }
}

