/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AntennaRulesTab
extends PreferencePanel {
    private JList antennaArcList;
    private DefaultListModel antennaArcListModel;
    private HashMap antennaOptions;
    private boolean antennaRatioChanging = false;
    private JScrollPane antArcList;
    private JTextField antMaxRatio;
    private JLabel antTechnology;
    private JPanel antennaRules;
    private JLabel jLabel66;
    private JLabel jLabel68;

    public AntennaRulesTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.antennaRules;
    }

    public String getName() {
        return "Antenna Rules";
    }

    public void init() {
        this.antennaArcListModel = new DefaultListModel();
        this.antennaArcList = new JList(this.antennaArcListModel);
        this.antennaArcList.setSelectionMode(0);
        this.antArcList.setViewportView(this.antennaArcList);
        this.antennaArcList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AntennaRulesTab.this.antennaArcListClick();
            }
        });
        this.antMaxRatio.getDocument().addDocumentListener(new AntennaRatioDocumentListener(this));
        this.antTechnology.setText(this.curTech.getTechName());
        this.antennaOptions = new HashMap();
        Iterator it = this.curTech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            ArcProto.Function fun = ap.getFunction();
            if (!fun.isMetal() && fun != ArcProto.Function.POLY1) continue;
            double ratio = ap.getAntennaRatio();
            Pref pref = Pref.makeDoublePref(null, null, ratio);
            this.antennaOptions.put(ap, pref);
            this.antennaArcListModel.addElement(ap.describe() + " (" + ratio + ")");
        }
        this.antennaArcList.setSelectedIndex(0);
        this.antennaArcListClick();
    }

    private void antennaArcListClick() {
        PrimitiveArc ap;
        String arcName = (String)this.antennaArcList.getSelectedValue();
        int spacePos = arcName.indexOf(32);
        if (spacePos >= 0) {
            arcName = arcName.substring(0, spacePos);
        }
        if ((ap = this.curTech.findArcProto(arcName)) != null) {
            Pref pref = (Pref)this.antennaOptions.get(ap);
            if (pref == null) {
                return;
            }
            this.antennaRatioChanging = true;
            this.antMaxRatio.setText(Double.toString(pref.getDouble()));
            this.antennaRatioChanging = false;
        }
    }

    private void antennaValueChanged() {
        PrimitiveArc ap;
        if (this.antennaRatioChanging) {
            return;
        }
        String arcName = (String)this.antennaArcList.getSelectedValue();
        int spacePos = arcName.indexOf(32);
        if (spacePos >= 0) {
            arcName = arcName.substring(0, spacePos);
        }
        if ((ap = this.curTech.findArcProto(arcName)) == null) {
            return;
        }
        Pref pref = (Pref)this.antennaOptions.get(ap);
        if (pref == null) {
            return;
        }
        double ratio = TextUtils.atof(this.antMaxRatio.getText());
        pref.setDouble(ratio);
        int lineNo = this.antennaArcList.getSelectedIndex();
        this.antennaArcListModel.setElementAt(ap.describe() + " (" + ratio + ")", lineNo);
    }

    public void term() {
        Iterator it = this.antennaOptions.keySet().iterator();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            Pref pref = (Pref)this.antennaOptions.get(ap);
            if (pref.getDoubleFactoryValue() == pref.getDouble()) continue;
            ap.setAntennaRatio(pref.getDouble());
        }
    }

    private void initComponents() {
        this.antennaRules = new JPanel();
        this.jLabel66 = new JLabel();
        this.antTechnology = new JLabel();
        this.antArcList = new JScrollPane();
        this.jLabel68 = new JLabel();
        this.antMaxRatio = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AntennaRulesTab.this.closeDialog(evt);
            }
        });
        this.antennaRules.setLayout(new GridBagLayout());
        this.jLabel66.setText("Arcs in technology:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.antennaRules.add((Component)this.jLabel66, gridBagConstraints);
        this.antTechnology.setText("mocmos");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.antennaRules.add((Component)this.antTechnology, gridBagConstraints);
        this.antArcList.setPreferredSize(new Dimension(300, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.antennaRules.add((Component)this.antArcList, gridBagConstraints);
        this.jLabel68.setText("Maximum antenna ratio:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.antennaRules.add((Component)this.jLabel68, gridBagConstraints);
        this.antMaxRatio.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.antennaRules.add((Component)this.antMaxRatio, gridBagConstraints);
        this.getContentPane().add((Component)this.antennaRules, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class AntennaRatioDocumentListener
    implements DocumentListener {
        AntennaRulesTab dialog;

        AntennaRatioDocumentListener(AntennaRulesTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.antennaValueChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.antennaValueChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.antennaValueChanged();
        }
    }
}

