/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.tecEdit.LibToTech;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.tecEdit.Sample;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Example {
    List samples;
    Sample studySample;
    double lx;
    double hx;
    double ly;
    double hy;
    Example nextExample;

    static Example getExamples(Cell np, boolean isNode) {
        HashMap<NodeInst, Object> nodeExamples = new HashMap<NodeInst, Object>();
        Iterator it = np.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            int funct = Manipulate.getOptionOnNode(ni);
            if (funct == 8 || funct == 18 || funct == 19) continue;
            nodeExamples.put(ni, new Integer(0));
        }
        Example neList = null;
        Iterator it2 = np.getNodes();
        while (it2.hasNext()) {
            NodeInst ni = (NodeInst)it2.next();
            if (nodeExamples.get(ni) != null) continue;
            Example ne = new Example();
            ne.samples = new ArrayList();
            ne.nextExample = neList;
            neList = ne;
            SizeOffset so = ni.getSizeOffset();
            Poly poly = new Poly(ni.getAnchorCenterX(), ni.getAnchorCenterY(), ni.getXSize() - so.getLowXOffset() - so.getHighXOffset(), ni.getYSize() - so.getLowYOffset() - so.getHighYOffset());
            poly.transform(ni.rotateOut());
            Rectangle2D soFar = poly.getBounds2D();
            boolean gotBBox = false;
            boolean foundOne = true;
            int hCount = 0;
            while (foundOne) {
                Geometric geom;
                foundOne = false;
                Iterator oIt = np.searchIterator(soFar);
                while (oIt.hasNext() && (geom = (Geometric)oIt.next()) != null) {
                    if (!(geom instanceof NodeInst)) continue;
                    NodeInst otherNi = (NodeInst)geom;
                    SizeOffset oSo = otherNi.getSizeOffset();
                    Poly oPoly = new Poly(otherNi.getAnchorCenterX(), otherNi.getAnchorCenterY(), otherNi.getXSize() - oSo.getLowXOffset() - oSo.getHighXOffset(), otherNi.getYSize() - oSo.getLowYOffset() - oSo.getHighYOffset());
                    oPoly.transform(otherNi.rotateOut());
                    Rectangle2D otherRect = oPoly.getBounds2D();
                    if (!GenMath.rectsIntersect(otherRect, soFar)) continue;
                    Object otherAssn = nodeExamples.get(otherNi);
                    if (otherAssn != null) {
                        if (otherAssn instanceof Integer || (Example)otherAssn == ne) continue;
                        LibToTech.pointOutError(otherNi, np);
                        System.out.println("Examples are too close in " + np);
                        return null;
                    }
                    nodeExamples.put(otherNi, ne);
                    Sample ns = new Sample();
                    ns.node = otherNi;
                    ns.values = null;
                    ns.msg = null;
                    ns.parent = ne;
                    ne.samples.add(ns);
                    ns.assoc = null;
                    ns.xPos = otherRect.getCenterX();
                    ns.yPos = otherRect.getCenterY();
                    int funct = Manipulate.getOptionOnNode(otherNi);
                    switch (funct) {
                        case 18: {
                            if (!isNode) {
                                LibToTech.pointOutError(otherNi, np);
                                System.out.println(np + " cannot have ports.  Delete this");
                                return null;
                            }
                            ns.layer = Generic.tech.portNode;
                            break;
                        }
                        case 26: {
                            if (!isNode) {
                                LibToTech.pointOutError(otherNi, np);
                                System.out.println(np + " cannot have a grab point.  Delete this");
                                return null;
                            }
                            ns.layer = Generic.tech.cellCenterNode;
                            break;
                        }
                        case 19: {
                            ++hCount;
                            break;
                        }
                        default: {
                            ns.layer = Manipulate.getLayerCell(otherNi);
                            if (ns.layer != null) break;
                            LibToTech.pointOutError(otherNi, np);
                            System.out.println("No layer information on " + otherNi + " in " + np);
                            return null;
                        }
                    }
                    if (otherNi.getProto() != Generic.tech.cellCenterNode) {
                        if (!gotBBox) {
                            ne.lx = otherRect.getMinX();
                            ne.hx = otherRect.getMaxX();
                            ne.ly = otherRect.getMinY();
                            ne.hy = otherRect.getMaxY();
                            gotBBox = true;
                        } else {
                            if (otherRect.getMinX() < ne.lx) {
                                ne.lx = otherRect.getMinX();
                            }
                            if (otherRect.getMaxX() > ne.hx) {
                                ne.hx = otherRect.getMaxX();
                            }
                            if (otherRect.getMinY() < ne.ly) {
                                ne.ly = otherRect.getMinY();
                            }
                            if (otherRect.getMaxY() > ne.hy) {
                                ne.hy = otherRect.getMaxY();
                            }
                        }
                        soFar.setRect(ne.lx, ne.ly, ne.hx - ne.lx, ne.hy - ne.ly);
                    }
                    foundOne = true;
                }
            }
            if (hCount == 0) {
                LibToTech.pointOutError(null, np);
                System.out.println("No highlight layer in " + np + " example");
                return null;
            }
            if (hCount == true) continue;
            LibToTech.pointOutError(null, np);
            System.out.println("Too many highlight layers in " + np + " example.  Delete some");
            return null;
        }
        if (neList == null) {
            LibToTech.pointOutError(null, np);
            System.out.println("No examples found in " + np);
            return neList;
        }
        double sizeX = neList.hx - neList.lx;
        double sizeY = neList.hy - neList.ly;
        double locX = (neList.lx + neList.hx) / 2.0;
        double locY = (neList.ly + neList.hy) / 2.0;
        Example bestNe = neList;
        Example ne = neList;
        while (ne != null) {
            double newSize = ne.hx - ne.lx;
            if (!((newSize *= ne.hy - ne.ly) > sizeX * sizeY || newSize == sizeX * sizeY && (ne.lx + ne.hx) / 2.0 >= locX && (ne.ly + ne.hy) / 2.0 <= locY)) {
                sizeX = ne.hx - ne.lx;
                sizeY = ne.hy - ne.ly;
                locX = (ne.lx + ne.hx) / 2.0;
                locY = (ne.ly + ne.hy) / 2.0;
                bestNe = ne;
            }
            ne = ne.nextExample;
        }
        if (bestNe != neList) {
            ne = neList;
            while (ne != null) {
                if (ne.nextExample == bestNe) {
                    ne.nextExample = bestNe.nextExample;
                    break;
                }
                ne = ne.nextExample;
            }
            bestNe.nextExample = neList;
            neList = bestNe;
        }
        return neList;
    }
}

