/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class StatusBar
extends JPanel
implements HighlightListener,
DatabaseChangeListener {
    private WindowFrame frame;
    private String coords = null;
    private String hierCoords = null;
    private JLabel fieldSelected;
    private JLabel fieldSize;
    private JLabel fieldTech;
    private JLabel fieldCoords;
    private JLabel fieldHierCoords;
    private static String selectionOverride = null;

    public StatusBar(WindowFrame frame) {
        super(new GridBagLayout());
        this.setBorder(new BevelBorder(1));
        this.frame = frame;
        this.fieldSelected = new JLabel();
        this.addField(this.fieldSelected, 0, 0, 1);
        this.fieldSize = new JLabel();
        Dimension d = new Dimension(140, 16);
        this.fieldSize.setMinimumSize(d);
        this.fieldSize.setMaximumSize(d);
        this.fieldSize.setPreferredSize(d);
        this.addField(this.fieldSize, 1, 0, 1);
        this.fieldTech = new JLabel();
        d = new Dimension(200, 16);
        this.fieldTech.setMinimumSize(d);
        this.fieldTech.setMaximumSize(d);
        this.fieldTech.setPreferredSize(d);
        this.addField(this.fieldTech, 2, 0, 1);
        this.fieldCoords = new JLabel();
        this.fieldCoords.setMinimumSize(new Dimension(100, 16));
        this.fieldCoords.setMaximumSize(new Dimension(500, 16));
        this.fieldCoords.setPreferredSize(new Dimension(140, 16));
        this.fieldCoords.setHorizontalAlignment(4);
        this.addField(this.fieldCoords, 3, 0, 1);
        this.fieldHierCoords = new JLabel(" ");
        this.fieldHierCoords.setHorizontalAlignment(4);
        this.addField(this.fieldHierCoords, 0, 1, 4);
        if (!TopLevel.isMDIMode() && frame.getContent().getHighlighter() != null) {
            frame.getContent().getHighlighter().addHighlightListener(this);
        }
        Undo.addDatabaseChangeListener(this);
    }

    private void addField(JLabel field, int x, int y, int width) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        if (x == 0) {
            gbc.weightx = 1.0;
            gbc.fill = 2;
        }
        gbc.anchor = 17;
        int rightInsert = TopLevel.getOperatingSystem() == TopLevel.OS.MACINTOSH ? 20 : 4;
        gbc.insets = new Insets(0, 4, 0, rightInsert);
        this.add((Component)field, gbc);
    }

    private Highlighter getHighlighter() {
        if (TopLevel.isMDIMode()) {
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd == null) {
                return null;
            }
            return wnd.getHighlighter();
        }
        return this.frame.getContent().getHighlighter();
    }

    public static void setCoordinates(String coords, WindowFrame wf) {
        StatusBar sb = null;
        sb = TopLevel.isMDIMode() ? TopLevel.getCurrentJFrame().getStatusBar() : wf.getFrame().getStatusBar();
        sb.coords = coords;
        sb.redoStatusBar();
    }

    public static void setHierarchicalCoordinates(String hierCoords, WindowFrame wf) {
        StatusBar sb = null;
        sb = TopLevel.isMDIMode() ? TopLevel.getCurrentJFrame().getStatusBar() : wf.getFrame().getStatusBar();
        sb.hierCoords = hierCoords;
        sb.redoStatusBar();
    }

    public static void setSelectionOverride(String ov) {
        selectionOverride = ov;
        StatusBar.updateStatusBar();
    }

    public void highlightChanged(Highlighter which) {
        this.updateSelectedText();
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
    }

    public static void updateStatusBar() {
        if (TopLevel.isMDIMode()) {
            StatusBar sb = TopLevel.getCurrentJFrame().getStatusBar();
            sb.redoStatusBar();
        } else {
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                StatusBar sb = wf.getFrame().getStatusBar();
                if (sb == null) continue;
                sb.redoStatusBar();
            }
        }
    }

    private void redoStatusBar() {
        this.updateSelectedText();
        Cell cell = null;
        if (this.frame == null) {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
            if (wf != null) {
                cell = wf.getContent().getCell();
            }
        } else {
            Cell cellInPanel = this.frame.getContent().getCell();
            if (cellInPanel != null) {
                cell = cellInPanel;
            }
        }
        String sizeMsg = "";
        if (cell != null) {
            if (cell.getView().isTextView()) {
                int len = 0;
                String[] textLines = cell.getTextViewContents();
                if (textLines != null) {
                    len = textLines.length;
                }
                sizeMsg = "LINES: " + len;
            } else {
                Rectangle2D bounds = cell.getBounds();
                sizeMsg = "SIZE: " + TextUtils.formatDouble(bounds.getWidth(), 1) + "x" + TextUtils.formatDouble(bounds.getHeight(), 1);
            }
        }
        this.fieldSize.setText(sizeMsg);
        Technology tech = Technology.getCurrent();
        if (tech != null) {
            String message = "TECH: " + tech.getTechName();
            if (tech.isScaleRelevant()) {
                message = message + " (scale=" + tech.getScale() + "nm)";
            }
            this.fieldTech.setText(message);
        }
        if (this.coords == null) {
            this.fieldCoords.setText("");
        } else {
            this.fieldCoords.setText(this.coords);
        }
        if (this.hierCoords != null) {
            int width = this.fieldHierCoords.getFontMetrics(this.fieldHierCoords.getFont()).stringWidth(this.hierCoords);
            if (width > this.fieldHierCoords.getParent().getWidth()) {
                int chars = this.hierCoords.length() * this.fieldHierCoords.getParent().getWidth() / width;
                this.hierCoords = this.hierCoords.substring(this.hierCoords.length() - chars, this.hierCoords.length());
            }
            this.fieldHierCoords.setText(this.hierCoords);
        } else {
            this.fieldHierCoords.setText(" ");
        }
    }

    private void updateSelectedText() {
        String selectedMsg = "NOTHING SELECTED";
        if (selectionOverride != null) {
            selectedMsg = selectionOverride;
        } else {
            int nodeCount = 0;
            int arcCount = 0;
            int textCount = 0;
            Highlight lastHighlight = null;
            Highlighter highlighter = this.getHighlighter();
            if (highlighter == null) {
                this.fieldSelected.setText(selectedMsg);
                return;
            }
            Iterator hIt = highlighter.getHighlights().iterator();
            while (hIt.hasNext()) {
                Highlight h = (Highlight)hIt.next();
                if (h.getType() == Highlight.Type.EOBJ) {
                    ElectricObject eObj = h.getElectricObject();
                    if (eObj instanceof PortInst) {
                        lastHighlight = h;
                        ++nodeCount;
                        continue;
                    }
                    if (eObj instanceof NodeInst) {
                        lastHighlight = h;
                        ++nodeCount;
                        continue;
                    }
                    if (!(eObj instanceof ArcInst)) continue;
                    lastHighlight = h;
                    ++arcCount;
                    continue;
                }
                if (h.getType() != Highlight.Type.TEXT) continue;
                lastHighlight = h;
                ++textCount;
            }
            if (nodeCount + arcCount + textCount == 1) {
                selectedMsg = "SELECTED " + this.getSelectedText(lastHighlight);
            } else if (nodeCount + arcCount + textCount > 0) {
                StringBuffer buf = new StringBuffer();
                buf.append("SELECTED:");
                if (nodeCount > 0) {
                    buf.append(" " + nodeCount + " NODES");
                }
                if (arcCount > 0) {
                    if (nodeCount > 0) {
                        buf.append(",");
                    }
                    buf.append(" " + arcCount + " ARCS");
                }
                if (textCount > 0) {
                    if (nodeCount + arcCount > 0) {
                        buf.append(",");
                    }
                    buf.append(" " + textCount + " TEXT");
                }
                buf.append(". LAST: " + this.getSelectedText(lastHighlight));
                selectedMsg = buf.toString();
            }
        }
        this.fieldSelected.setText(selectedMsg);
    }

    private String getSelectedText(Highlight h) {
        if (h.getType() == Highlight.Type.EOBJ) {
            ElectricObject eObj = h.getElectricObject();
            if (eObj instanceof PortInst) {
                PortInst thePort = (PortInst)eObj;
                NodeInst theNode = thePort.getNodeInst();
                return "NODE: " + theNode.describe(true) + " PORT: '" + thePort.getPortProto().getName() + "'";
            }
            if (eObj instanceof NodeInst) {
                NodeInst theNode = (NodeInst)eObj;
                return "NODE: " + theNode.describe(true);
            }
            if (eObj instanceof ArcInst) {
                ArcInst theArc = (ArcInst)eObj;
                Netlist netlist = theArc.getParent().acquireUserNetlist();
                if (netlist == null) {
                    return "netlist exception! try again";
                }
                if (theArc.getArcIndex() == -1) {
                    return "netlist exception! try again. ArcIndex = -1";
                }
                Network net = netlist.getNetwork(theArc, 0);
                String netMsg = net != null ? "NETWORK: " + net.describe(true) + ", " : "";
                return netMsg + "ARC: " + theArc.describe(true);
            }
        } else if (h.getType() == Highlight.Type.TEXT) {
            if (h.getVar() != null) {
                return "TEXT: " + h.getVar().getFullDescription(h.getElectricObject());
            }
            if (h.getName() != null) {
                if (h.getElectricObject() instanceof NodeInst) {
                    return "TEXT: Node name " + h.getName().toString();
                }
                return "TEXT: Arc name " + h.getName().toString();
            }
            if (h.getElectricObject() instanceof Export) {
                return "TEXT: Export name " + ((Export)h.getElectricObject()).getName();
            }
            return "TEXT: Cell instance name ";
        }
        return null;
    }

    public void finished() {
        if (!TopLevel.isMDIMode() && this.frame.getContent().getHighlighter() != null) {
            this.frame.getContent().getHighlighter().removeHighlightListener(this);
        }
        Undo.removeDatabaseChangeListener(this);
    }

    public void databaseChanged(DatabaseChangeEvent e) {
        this.redoStatusBar();
    }
}

