/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellId;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ImmutableNodeInst {
    private static final int HARDSELECTN = 32768;
    private static final int NVISIBLEINSIDE = 0x800000;
    private static final int NTECHBITS = 0x7E0000;
    private static final int NTECHBITSSH = 17;
    private static final int NILOCKED = 0x1000000;
    private static final int FLAG_BITS = 0x1808000;
    public static final Flag HARD_SELECT;
    public static final Flag VIS_INSIDE;
    public static final Flag LOCKED;
    public final int nodeId;
    public final NodeProtoId protoId;
    public final Name name;
    public final int duplicate;
    public final ImmutableTextDescriptor nameDescriptor;
    public final Orientation orient;
    public final EPoint anchor;
    public final double width;
    public final double height;
    public final int flags;
    public final byte techBits;
    public final ImmutableTextDescriptor protoDescriptor;
    static final /* synthetic */ boolean $assertionsDisabled;

    ImmutableNodeInst(int nodeId, NodeProtoId protoId, Name name, int duplicate, ImmutableTextDescriptor nameDescriptor, Orientation orient, EPoint anchor, double width, double height, int flags, byte techBits, ImmutableTextDescriptor protoDescriptor) {
        this.nodeId = nodeId;
        this.protoId = protoId;
        this.name = name;
        this.duplicate = duplicate;
        this.nameDescriptor = nameDescriptor;
        this.orient = orient;
        this.anchor = anchor;
        this.width = width;
        this.height = height;
        this.flags = flags;
        this.techBits = techBits;
        this.protoDescriptor = protoDescriptor;
        this.check();
    }

    public static ImmutableNodeInst newInstance(int nodeId, NodeProtoId protoId, Name name, int duplicate, ImmutableTextDescriptor nameDescriptor, Orientation orient, EPoint anchor, double width, double height, int flags, int techBits, ImmutableTextDescriptor protoDescriptor) {
        if (protoId == null) {
            throw new NullPointerException("protoId");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isTempname() && name.isBus()) {
            throw new IllegalArgumentException("name");
        }
        if (name.hasDuplicates()) {
            throw new IllegalArgumentException("name");
        }
        if (duplicate < 0) {
            throw new IllegalArgumentException("duplicate");
        }
        if (orient == null) {
            throw new NullPointerException("orient");
        }
        if (anchor == null) {
            throw new NullPointerException("anchor");
        }
        if (!(width >= 0.0)) {
            throw new IllegalArgumentException("width");
        }
        if (!(height >= 0.0)) {
            throw new IllegalArgumentException("height");
        }
        if (protoId instanceof CellId) {
            height = 0.0;
            width = 0.0;
        }
        if (protoId == Generic.tech.cellCenterNode) {
            orient = Orientation.IDENT;
            anchor = EPoint.ORIGIN;
            height = 0.0;
            width = 0.0;
        }
        width = DBMath.round(width);
        height = DBMath.round(height);
        if (width == -0.0) {
            width = 0.0;
        }
        if (height == -0.0) {
            height = 0.0;
        }
        return new ImmutableNodeInst(nodeId, protoId, name, duplicate, nameDescriptor, orient, anchor, width, height, flags &= 0x1808000, (byte)(techBits &= 0x3F), protoDescriptor);
    }

    public ImmutableNodeInst withName(Name name, int duplicate) {
        if (this.name.equals(name) && this.duplicate == duplicate) {
            return this;
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isTempname() && name.isBus()) {
            throw new IllegalArgumentException("name");
        }
        if (name.hasDuplicates()) {
            throw new IllegalArgumentException("name");
        }
        if (duplicate < 0) {
            throw new IllegalArgumentException("duplicate");
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, name, duplicate, this.nameDescriptor, this.orient, this.anchor, this.width, this.height, this.flags, this.techBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withNameDescriptor(ImmutableTextDescriptor nameDescriptor) {
        if (this.nameDescriptor == nameDescriptor) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.duplicate, nameDescriptor, this.orient, this.anchor, this.width, this.height, this.flags, this.techBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withOrient(Orientation orient) {
        if (this.orient == orient) {
            return this;
        }
        if (orient == null) {
            throw new NullPointerException("orient");
        }
        if (this.protoId == Generic.tech.cellCenterNode) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.duplicate, this.nameDescriptor, orient, this.anchor, this.width, this.height, this.flags, this.techBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withAnchor(EPoint anchor) {
        if (this.anchor.equals(anchor)) {
            return this;
        }
        if (anchor == null) {
            throw new NullPointerException("anchor");
        }
        if (this.protoId == Generic.tech.cellCenterNode) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.duplicate, this.nameDescriptor, this.orient, anchor, this.width, this.height, this.flags, this.techBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withSize(double width, double height) {
        if (this.width == width && this.height == height) {
            return this;
        }
        if (!(width >= 0.0)) {
            throw new IllegalArgumentException("width");
        }
        if (!(height >= 0.0)) {
            throw new IllegalArgumentException("height");
        }
        if (this.protoId == Generic.tech.cellCenterNode) {
            return this;
        }
        if (this.protoId instanceof CellId) {
            return this;
        }
        width = DBMath.round(width);
        height = DBMath.round(height);
        if (width == -0.0) {
            width = 0.0;
        }
        if (height == -0.0) {
            height = 0.0;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.duplicate, this.nameDescriptor, this.orient, this.anchor, width, height, this.flags, this.techBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withFlags(int flags) {
        if (this.flags == (flags &= 0x1808000)) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.duplicate, this.nameDescriptor, this.orient, this.anchor, this.width, this.height, flags, this.techBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withFlag(Flag flag, boolean value) {
        return this.withFlags(flag.set(this.flags, value));
    }

    public ImmutableNodeInst withTechSpecific(int techBits) {
        if (this.techBits == (techBits &= 0x3F)) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.duplicate, this.nameDescriptor, this.orient, this.anchor, this.width, this.height, this.flags, (byte)techBits, this.protoDescriptor);
    }

    public ImmutableNodeInst withProtoDescriptor(ImmutableTextDescriptor protoDescriptor) {
        if (this.protoDescriptor == protoDescriptor) {
            return this;
        }
        return new ImmutableNodeInst(this.nodeId, this.protoId, this.name, this.duplicate, this.nameDescriptor, this.orient, this.anchor, this.width, this.height, this.flags, this.techBits, protoDescriptor);
    }

    public boolean is(Flag flag) {
        return flag.is(this.flags);
    }

    public void check() {
        if (!$assertionsDisabled && this.protoId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.name == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.name.isValid() && !this.name.hasEmptySubnames())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.name.isTempname() && this.name.isBus()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.name.hasDuplicates()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.anchor == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.duplicate < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.orient == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.anchor == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.width > 0.0 || this.width == 0.0 && 1.0 / this.width > 0.0)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.height > 0.0 || this.height == 0.0 && 1.0 / this.height > 0.0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && DBMath.round(this.width) != this.width) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && DBMath.round(this.height) != this.height) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (this.flags & 0xFE7F7FFF) != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (this.techBits & 0xFFFFFFC0) != 0) {
            throw new AssertionError();
        }
        if (this.protoId instanceof CellId && !$assertionsDisabled && (this.width != 0.0 || this.height != 0.0)) {
            throw new AssertionError();
        }
        if (!(this.protoId != Generic.tech.cellCenterNode || $assertionsDisabled || this.orient == Orientation.IDENT && this.anchor == EPoint.ORIGIN && this.width == 0.0 && this.height == 0.0)) {
            throw new AssertionError();
        }
    }

    public int getElibBits() {
        return this.flags | this.techBits << 17;
    }

    public static int flagsFromElib(int elibBits) {
        return elibBits & 0x1808000;
    }

    public static int techSpecificFromElib(int elibBits) {
        return (elibBits & 0x7E0000) >> 17;
    }

    public Rectangle2D computeBounds(NodeInst real) {
        double[] angles;
        if (this.protoId instanceof CellId) {
            Cell subCell = (Cell)real.getProto();
            Rectangle2D bounds = subCell.getBounds();
            Point2D.Double shift = new Point2D.Double(-bounds.getCenterX(), -bounds.getCenterY());
            AffineTransform trans = this.orient.pureRotate();
            trans.transform(shift, shift);
            double cX = this.anchor.getX();
            double cY = this.anchor.getY();
            Poly poly = new Poly(cX -= ((Point2D)shift).getX(), cY -= ((Point2D)shift).getY(), bounds.getWidth(), bounds.getHeight());
            trans = this.orient.rotateAbout(cX, cY);
            poly.transform(trans);
            return poly.getBounds2D();
        }
        if (this.width == 0.0 && this.height == 0.0) {
            return new Rectangle2D.Double(this.anchor.getX(), this.anchor.getY(), 0.0, 0.0);
        }
        PrimitiveNode pn = (PrimitiveNode)this.protoId;
        if (!(pn != Artwork.tech.circleNode && pn != Artwork.tech.thickCircleNode || (angles = real.getArcDegrees())[0] == 0.0 && angles[1] == 0.0)) {
            Point2D[] pointList = Artwork.fillEllipse(this.anchor, this.width, this.height, angles[0], angles[1]);
            Poly poly = new Poly(pointList);
            poly.setStyle(Poly.Type.OPENED);
            poly.transform(this.orient.rotateAbout(this.anchor.getX(), this.anchor.getY()));
            return poly.getBounds2D();
        }
        if (pn.isWipeOn1or2() && real.getNumExports() == 0 && real.pinUseCount()) {
            return new Rectangle2D.Double(this.anchor.getX(), this.anchor.getY(), 0.0, 0.0);
        }
        if (pn.isHoldsOutline() && real.getTrace() != null) {
            AffineTransform trans = this.orient.rotateAbout(this.anchor.getX(), this.anchor.getY());
            Poly[] polys = pn.getTechnology().getShapeOfNode(real);
            Rectangle2D.Double bounds = new Rectangle2D.Double();
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                poly.transform(trans);
                if (i == 0) {
                    ((Rectangle2D)bounds).setRect(poly.getBounds2D());
                    continue;
                }
                Rectangle2D.union(poly.getBounds2D(), bounds, bounds);
            }
            return bounds;
        }
        Poly poly = new Poly(this.anchor.getX(), this.anchor.getY(), this.width, this.height);
        AffineTransform trans = this.orient.rotateAbout(this.anchor.getX(), this.anchor.getY());
        poly.transform(trans);
        return poly.getBounds2D();
    }

    static {
        $assertionsDisabled = !ImmutableNodeInst.class.desiredAssertionStatus();
        HARD_SELECT = new Flag(32768);
        VIS_INSIDE = new Flag(0x800000);
        LOCKED = new Flag(0x1000000);
    }

    public static class Flag {
        private final int mask;

        private Flag(int mask) {
            this.mask = mask;
        }

        public boolean is(int userBits) {
            return (userBits & this.mask) != 0;
        }

        public int set(int userBits, boolean value) {
            return value ? userBits | this.mask : userBits & ~this.mask;
        }
    }
}

