/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.io.input.EpicReader;
import com.sun.electric.tool.io.input.EpicSignal;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Stimuli;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public class EpicOut
extends Simulate {
    private static String VERSION_STRING = ";! output_format 5.3";

    EpicOut() {
    }

    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        EpicOut.startProgressDialog("EPIC output", fileURL.getFile());
        Stimuli sd = this.readEpicFile(new MyEpicReader(fileURL));
        sd.setCell(cell);
        EpicOut.stopProgressDialog();
        return sd;
    }

    private Stimuli readEpicFile(MyEpicReader reader) throws IOException {
        char separator = '.';
        EpicStimuli sd = new EpicStimuli();
        sd.reader = reader;
        sd.setSeparatorChar(separator);
        sd.timeResolution = reader.timeResolution;
        sd.voltageResolution = reader.voltageResolution;
        sd.currentResolution = reader.currentResolution;
        ArrayList signals = new ArrayList();
        for (int i = 0; i < reader.signals.size(); ++i) {
            String name;
            EpicSignal s = (EpicSignal)reader.signals.get(i);
            if (s == null || (name = s.name) == null) continue;
            EpicAnalogSignal as = new EpicAnalogSignal(sd, i);
            if (name.startsWith("v(") && name.endsWith(")")) {
                name = name.substring(2, name.length() - 1);
            } else if (name.startsWith("i(") && name.endsWith(")")) {
                name = name.substring(2, name.length() - 1);
            } else if (name.startsWith("i1(") && name.endsWith(")")) {
                name = name.substring(3, name.length() - 1);
            }
            name = EpicOut.removeLeadingX(name);
            int lastSlashPos = name.lastIndexOf(separator);
            if (lastSlashPos > 0) {
                as.setSignalContext(name.substring(0, lastSlashPos));
                name = name.substring(lastSlashPos + 1);
            }
            double resolution = 1.0;
            switch (s.type) {
                case 1: {
                    resolution = reader.voltageResolution;
                    break;
                }
                case 2: {
                    resolution = reader.currentResolution;
                    name = "i(" + name + ")";
                }
            }
            as.setSignalName(name);
            Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, (double)s.minV * resolution, (double)reader.maxT * sd.timeResolution, (double)(s.maxV - s.minV) * resolution);
            as.setBounds(bounds);
        }
        return sd;
    }

    class MyEpicReader
    extends EpicReader {
        MyEpicReader(URL fileURL) {
            super(fileURL);
        }

        void showProgress(double ratio) {
            Input.progress.setProgress((int)(ratio * 100.0));
        }
    }

    private static class EpicAnalogSignal
    extends AnalogSignal {
        int sigNum;
        double[] data;

        EpicAnalogSignal(EpicStimuli sd, int sigNum) {
            super(sd);
            this.sigNum = sigNum;
        }

        public void getEvent(int sweep, int index, double[] result) {
            if (sweep != 0) {
                throw new IndexOutOfBoundsException();
            }
            EpicStimuli sd = (EpicStimuli)this.sd;
            if (this.data == null) {
                this.makeData();
            }
            result[0] = this.data[index * 2];
            result[1] = result[2] = this.data[index * 2 + 1];
        }

        public int getNumEvents(int sweep) {
            if (sweep != 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.data == null) {
                this.makeData();
            }
            return this.data.length / 2;
        }

        private void makeData() {
            EpicStimuli sd = (EpicStimuli)this.sd;
            EpicSignal s = (EpicSignal)sd.reader.signals.get(this.sigNum);
            double resolution = 1.0;
            switch (s.type) {
                case 1: {
                    resolution = sd.voltageResolution;
                    break;
                }
                case 2: {
                    resolution = sd.currentResolution;
                }
            }
            int[] intData = s.getWaveform();
            int len = intData.length / 2;
            this.data = new double[len * 2];
            for (int i = 0; i < len; ++i) {
                this.data[i * 2] = (double)intData[i * 2] * sd.timeResolution;
                this.data[i * 2 + 1] = (double)intData[i * 2 + 1] * resolution;
            }
        }

        private void setBounds(Rectangle2D bounds) {
            this.bounds = bounds;
            this.boundsCurrent = true;
        }
    }

    private static class EpicStimuli
    extends Stimuli {
        EpicReader reader;
        double timeResolution;
        double voltageResolution;
        double currentResolution;

        private EpicStimuli() {
        }
    }
}

