/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Router {
    protected boolean verbose = false;

    public void createRoute(Route route, Cell cell) {
        CreateRouteJob job = new CreateRouteJob(this, route, cell, this.verbose);
    }

    public static boolean createRouteNoJob(Route route, Cell cell, boolean verbose, boolean highlightRouteEnd, Highlighter highlighter) {
        RouteElementPort finalRE;
        Integer i;
        RouteElement e;
        Job.checkChanging();
        if (CircuitChanges.cantEdit(cell, null, true) != 0) {
            return false;
        }
        int arcsCreated = 0;
        int nodesCreated = 0;
        HashMap<ArcProto, Integer> arcsCreatedMap = new HashMap<ArcProto, Integer>();
        HashMap<NodeProto, Integer> nodesCreatedMap = new HashMap<NodeProto, Integer>();
        Iterator it = route.iterator();
        while (it.hasNext()) {
            e = (RouteElement)it.next();
            if (e.getAction() != RouteElement.RouteElementAction.newNode || e.isDone()) continue;
            e.doAction();
            ++nodesCreated;
            RouteElementPort rep = (RouteElementPort)e;
            i = (Integer)nodesCreatedMap.get(rep.getPortProto().getParent());
            if (i == null) {
                i = new Integer(0);
            }
            i = new Integer(i + 1);
            nodesCreatedMap.put(rep.getPortProto().getParent(), i);
        }
        it = route.iterator();
        while (it.hasNext()) {
            e = (RouteElement)it.next();
            e.doAction();
            if (e.getAction() != RouteElement.RouteElementAction.newArc) continue;
            ++arcsCreated;
            RouteElementArc rea = (RouteElementArc)e;
            i = (Integer)arcsCreatedMap.get(rea.getArcProto());
            if (i == null) {
                i = new Integer(0);
            }
            i = new Integer(i + 1);
            arcsCreatedMap.put(rea.getArcProto(), i);
        }
        if (verbose) {
            NodeProto np;
            ArcProto ap;
            ArrayList arcEntries = new ArrayList(arcsCreatedMap.keySet());
            ArrayList nodeEntries = new ArrayList(nodesCreatedMap.keySet());
            if (arcEntries.size() == 0 && nodeEntries.size() == 0) {
                System.out.println("Nothing wired");
            } else if (arcEntries.size() == 1 && nodeEntries.size() == 0) {
                ap = (ArcProto)arcEntries.iterator().next();
                i = (Integer)arcsCreatedMap.get(ap);
                System.out.println("Wiring added: " + i + " " + ap.describe() + " arcs");
            } else if (arcEntries.size() == 1 && nodeEntries.size() == 1) {
                ap = (ArcProto)arcEntries.iterator().next();
                np = (NodeProto)nodeEntries.iterator().next();
                Integer i2 = (Integer)arcsCreatedMap.get(ap);
                Integer i22 = (Integer)nodesCreatedMap.get(np);
                System.out.println("Wiring added: " + i2 + " " + ap.describe() + " arcs, " + i22 + " " + np.describe(true) + " nodes");
            } else {
                Integer i3;
                System.out.println("Wiring added:");
                Collections.sort(arcEntries, new TextUtils.ObjectsByToString());
                Collections.sort(nodeEntries, new TextUtils.ObjectsByToString());
                Iterator it2 = arcEntries.iterator();
                while (it2.hasNext()) {
                    ArcProto ap2 = (ArcProto)it2.next();
                    i3 = (Integer)arcsCreatedMap.get(ap2);
                    System.out.println("    " + i3 + " " + ap2.describe() + " arcs");
                }
                it2 = nodeEntries.iterator();
                while (it2.hasNext()) {
                    np = (NodeProto)it2.next();
                    i3 = (Integer)nodesCreatedMap.get(np);
                    System.out.println("    " + i3 + " " + np.describe(true) + " nodes");
                }
            }
            User.playSound(arcsCreated);
        }
        if (highlightRouteEnd && highlighter != null && (finalRE = route.getEnd()) != null) {
            highlighter.clear();
            PortInst pi = finalRE.getPortInst();
            if (pi != null) {
                highlighter.addElectricObject(pi, cell);
                highlighter.finished();
            }
        }
        return true;
    }

    public static ArcProto getArcToUse(PortProto port1, PortProto port2) {
        ArcProto curAp = User.getUserTool().getCurrentArcProto();
        ArcProto uni = Generic.tech.universal_arc;
        ArcProto invis = Generic.tech.invisible_arc;
        ArcProto unr = Generic.tech.unrouted_arc;
        PortProto pp1 = null;
        PortProto pp2 = null;
        if (port1 == null) {
            pp1 = port2;
        } else {
            pp1 = port1;
            pp2 = port2;
        }
        if (pp1 == null && pp2 == null) {
            return null;
        }
        if (pp2 == null) {
            if (pp1.connectsTo(curAp)) {
                return curAp;
            }
            Technology tech = pp1.getParent().getTechnology();
            Iterator it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = (ArcProto)it.next();
                if (!pp1.connectsTo(ap) || ap == uni || ap == invis || ap == unr) continue;
                return ap;
            }
            it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology anyTech = (Technology)it.next();
                Iterator aIt = anyTech.getArcs();
                while (aIt.hasNext()) {
                    ArcProto ap = (ArcProto)aIt.next();
                    if (!pp1.connectsTo(ap) || ap == uni || ap == invis || ap == unr) continue;
                    return ap;
                }
            }
        } else {
            if (pp1.connectsTo(curAp) && pp2.connectsTo(curAp)) {
                return curAp;
            }
            Technology tech = pp1.getParent().getTechnology();
            Iterator it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = (ArcProto)it.next();
                if (!pp1.connectsTo(ap) || !pp2.connectsTo(ap) || ap == uni || ap == invis || ap == unr) continue;
                return ap;
            }
            it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology anyTech = (Technology)it.next();
                Iterator aIt = anyTech.getArcs();
                while (aIt.hasNext()) {
                    ArcProto ap = (ArcProto)aIt.next();
                    if (!pp1.connectsTo(ap) || !pp2.connectsTo(ap) || ap == uni || ap == invis || ap == unr) continue;
                    return ap;
                }
            }
        }
        return null;
    }

    protected static void useWidestWire(Route route, ArcProto ap) {
        double width = Router.getArcWidthToUse(route, ap);
        Iterator it = route.iterator();
        while (it.hasNext()) {
            RouteElementArc reArc;
            RouteElement re = (RouteElement)it.next();
            if (!(re instanceof RouteElementArc) || (reArc = (RouteElementArc)re).getArcProto() != ap) continue;
            reArc.setArcWidth(width);
        }
    }

    protected static double getArcWidthToUse(Route route, ArcProto ap) {
        double widest = ap.getDefaultWidth();
        Iterator it = route.iterator();
        while (it.hasNext()) {
            RouteElement re = (RouteElement)it.next();
            double width = Router.getArcWidthToUse(re, ap);
            if (!(width > widest)) continue;
            widest = width;
        }
        return widest;
    }

    public static double getArcWidthToUse(PortInst pi, ArcProto ap) {
        Cell cell;
        Export export;
        PortInst exportedInst;
        double width2;
        if (pi == null) {
            return ap.getDefaultWidth();
        }
        double width = ap.getDefaultWidth();
        Iterator it = pi.getConnections();
        while (it.hasNext()) {
            double newWidth;
            Connection c = (Connection)it.next();
            ArcInst ai = c.getArc();
            if (ai.getProto() != ap || !(width < (newWidth = c.getArc().getWidth() - c.getArc().getProto().getWidthOffset()))) continue;
            width = newWidth;
        }
        NodeInst ni = pi.getNodeInst();
        if (ni.getProto() instanceof Cell && (width2 = Router.getArcWidthToUse(exportedInst = (export = (cell = (Cell)ni.getProto()).findExport(pi.getPortProto().getName())).getOriginalPort(), ap)) > width) {
            width = width2;
        }
        return width;
    }

    protected static double getArcWidthToUse(RouteElement re, ArcProto ap) {
        double width;
        double connectedWidth = width = ap.getDefaultWidth();
        if (re instanceof RouteElementPort) {
            double width2;
            RouteElementPort rePort = (RouteElementPort)re;
            connectedWidth = rePort.getWidestConnectingArc(ap);
            if (rePort.getPortInst() != null && (width2 = Router.getArcWidthToUse(rePort.getPortInst(), ap)) > connectedWidth) {
                connectedWidth = width2;
            }
        }
        if (re instanceof RouteElementArc) {
            RouteElementArc reArc = (RouteElementArc)re;
            connectedWidth = reArc.getOffsetArcWidth();
        }
        if (width > connectedWidth) {
            return width;
        }
        return connectedWidth;
    }

    protected static Dimension2D getContactSize(RouteElement startRE, RouteElement endRE) {
        Dimension2D start = Router.getContactSize(startRE);
        Dimension2D end = Router.getContactSize(endRE);
        Dimension2D.Double dim = new Dimension2D.Double(start);
        if (end.getWidth() > ((Dimension2D)dim).getWidth()) {
            ((Dimension2D)dim).setSize(end.getWidth(), ((Dimension2D)dim).getHeight());
        }
        if (end.getHeight() > ((Dimension2D)dim).getHeight()) {
            ((Dimension2D)dim).setSize(((Dimension2D)dim).getWidth(), end.getHeight());
        }
        return dim;
    }

    protected static Dimension2D getContactSize(RouteElement re) {
        Iterator it;
        RouteElementPort rePort;
        double width = -1.0;
        double height = -1.0;
        if (re instanceof RouteElementArc) {
            RouteElementArc reArc = (RouteElementArc)re;
            if (reArc.isArcVertical() && reArc.getOffsetArcWidth() > width) {
                width = reArc.getOffsetArcWidth();
            }
            if (reArc.isArcHorizontal() && reArc.getOffsetArcWidth() > height) {
                height = reArc.getOffsetArcWidth();
            }
        }
        if (re.getAction() == RouteElement.RouteElementAction.existingPortInst) {
            rePort = (RouteElementPort)re;
            PortInst pi = rePort.getPortInst();
            it = pi.getConnections();
            while (it.hasNext()) {
                Connection conn = (Connection)it.next();
                ArcInst arc = conn.getArc();
                EPoint head = arc.getHeadLocation();
                EPoint tail = arc.getTailLocation();
                double newWidth = arc.getWidth() - arc.getProto().getWidthOffset();
                if (((Point2D)head).getX() == ((Point2D)tail).getX() && newWidth > width) {
                    width = newWidth;
                }
                if (((Point2D)head).getY() != ((Point2D)tail).getY() || !(newWidth > height)) continue;
                height = newWidth;
            }
        }
        if (re.getAction() == RouteElement.RouteElementAction.newNode) {
            rePort = (RouteElementPort)re;
            Dimension2D dim = null;
            it = rePort.getNewArcs();
            while (it.hasNext()) {
                RouteElement newArcRE = (RouteElement)it.next();
                Dimension2D d = Router.getContactSize(newArcRE);
                if (dim == null) {
                    dim = d;
                }
                if (d.getWidth() > dim.getWidth()) {
                    dim.setSize(d.getWidth(), dim.getHeight());
                }
                if (!(d.getHeight() > dim.getHeight())) continue;
                dim.setSize(dim.getWidth(), d.getHeight());
            }
            if (dim == null) {
                dim = new Dimension2D.Double(-1.0, -1.0);
            }
            return dim;
        }
        return new Dimension2D.Double(width, height);
    }

    protected static class CreateRouteJob
    extends Job {
        protected Route route;
        protected boolean verbose;
        protected Cell cell;

        protected CreateRouteJob(Router router, Route route, Cell cell, boolean verbose) {
            super(router.toString(), Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.route = route;
            this.verbose = verbose;
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            if (CircuitChanges.cantEdit(this.cell, null, true) != 0) {
                return false;
            }
            EditWindow wnd = EditWindow.getCurrent();
            Highlighter highlighter = wnd == null ? null : wnd.getHighlighter();
            return Router.createRouteNoJob(this.route, this.cell, this.verbose, true, highlighter);
        }
    }
}

