/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ERCWellCheck {
    private Cell cell;
    private GeometryHandler.GHMode mode;
    private ErrorLogger errorLogger;
    private List<WellCon> wellCons = new ArrayList<WellCon>();
    private List<WellArea> wellAreas = new ArrayList<WellArea>();
    private HashMap<Cell, GeometryHandler> cellMerges = new HashMap();
    private HashMap<Cell, Cell> doneCells = new HashMap();
    private WellCheckJob job;
    private double worstPWellDist;
    private Point2D worstPWellCon;
    private Point2D worstPWellEdge;
    private double worstNWellDist;
    private Point2D worstNWellCon;
    private Point2D worstNWellEdge;
    private static final int ERCPWell = 1;
    private static final int ERCNWell = 2;
    private static final int ERCPSelect = 3;
    private static final int ERCNSelect = 4;
    private static final int ERCPSEUDO = 0;
    private static final List<Layer.Function> ercLayers = new ArrayList<Layer.Function>(7);

    private ERCWellCheck(Cell cell, WellCheckJob job, GeometryHandler.GHMode newAlgorithm) {
        this.job = job;
        this.mode = newAlgorithm;
        this.cell = cell;
    }

    public static void analyzeCurCell(GeometryHandler.GHMode newAlgorithm) {
        UserInterface ui = Job.getUserInterface();
        Cell curCell = ui.needCurrentCell();
        if (curCell == null) {
            return;
        }
        new WellCheckJob(curCell, newAlgorithm);
    }

    public static int checkERCWell(Cell cell, GeometryHandler.GHMode newAlgorithm) {
        ERCWellCheck check = new ERCWellCheck(cell, null, newAlgorithm);
        return check.doIt();
    }

    private int doIt() {
        PrimitiveNode.Function desiredContact;
        long startTime = System.currentTimeMillis();
        this.errorLogger = ErrorLogger.newInstance("ERC Well Check ");
        long initialMemory = 0L;
        System.out.println("Checking Wells and Substrates in '" + this.cell.libDescribe() + "' ...");
        Visitor wcVisitor = new Visitor(this);
        HierarchyEnumerator.enumerateCell(this.cell, VarContext.globalContext, wcVisitor);
        if (this.job != null && this.job.checkAbort()) {
            return 0;
        }
        int wellIndex = 0;
        GeometryHandler topMerge = this.cellMerges.get(this.cell);
        for (Layer layer : topMerge.getKeySet()) {
            Collection<PolyBase> set = topMerge.getObjects(layer, false, true);
            for (PolyBase poly : set) {
                WellArea wa = new WellArea();
                wa.poly = poly;
                wa.poly.setLayer(layer);
                wa.poly.setStyle(Poly.Type.FILLED);
                wa.index = wellIndex++;
                this.wellAreas.add(wa);
            }
        }
        boolean foundPWell = false;
        boolean foundNWell = false;
        for (WellArea wa : this.wellAreas) {
            int wellType = ERCWellCheck.getWellLayerType(wa.poly.getLayer());
            if (wellType != 1 && wellType != 2) continue;
            desiredContact = PrimitiveNode.Function.SUBSTRATE;
            String noContactError = "No N-Well contact found in this area";
            int contactAction = ERC.getNWellCheck();
            if (wellType == 1) {
                desiredContact = PrimitiveNode.Function.WELL;
                contactAction = ERC.getPWellCheck();
                noContactError = "No P-Well contact found in this area";
                foundPWell = true;
            } else {
                foundNWell = true;
            }
            boolean found = false;
            for (WellCon wc : this.wellCons) {
                if (wc.fun != desiredContact || !wa.poly.getBounds2D().contains(wc.ctr) || !wa.poly.contains(wc.ctr)) continue;
                wa.netNum = wc.netNum;
                found = true;
                break;
            }
            if (found || contactAction != 0) continue;
            this.errorLogger.logError(noContactError, wa.poly, this.cell, 0);
        }
        for (WellCon wc : this.wellCons) {
            if (wc.netNum == -1) {
                String errorMsg = "N-Well contact is floating";
                if (wc.fun == PrimitiveNode.Function.WELL) {
                    errorMsg = "P-Well contact is floating";
                }
                this.errorLogger.logError(errorMsg, new EPoint(wc.ctr.getX(), wc.ctr.getY()), this.cell, 0);
                continue;
            }
            if (wc.onProperRail) continue;
            if (wc.fun == PrimitiveNode.Function.WELL) {
                if (!ERC.isMustConnectPWellToGround()) continue;
                this.errorLogger.logError("P-Well contact not connected to ground", new EPoint(wc.ctr.getX(), wc.ctr.getY()), this.cell, 0);
                continue;
            }
            if (!ERC.isMustConnectNWellToPower()) continue;
            this.errorLogger.logError("N-Well contact not connected to power", new EPoint(wc.ctr.getX(), wc.ctr.getY()), this.cell, 0);
        }
        if (ERC.getNWellCheck() == 1 && foundNWell) {
            boolean found = false;
            for (WellCon wc : this.wellCons) {
                if (wc.fun != PrimitiveNode.Function.SUBSTRATE) continue;
                found = true;
                break;
            }
            if (!found) {
                this.errorLogger.logError("No N-Well contact found in this cell", this.cell, 0);
            }
        }
        if (ERC.getPWellCheck() == 1 && foundPWell) {
            boolean found = false;
            for (WellCon wc : this.wellCons) {
                if (wc.fun != PrimitiveNode.Function.WELL) continue;
                found = true;
                break;
            }
            if (!found) {
                this.errorLogger.logError("No P-Well contact found in this cell", this.cell, 0);
            }
        }
        if (ERC.isDRCCheck()) {
            HashMap<Layer, DRCTemplate> rulesCon = new HashMap<Layer, DRCTemplate>();
            HashMap<Layer, DRCTemplate> rulesNonCon = new HashMap<Layer, DRCTemplate>();
            for (WellArea wa : this.wellAreas) {
                for (WellArea oWa : this.wellAreas) {
                    int layertype;
                    double dist;
                    DRCTemplate rule;
                    Layer waLayer;
                    if (this.job != null && this.job.checkAbort()) {
                        return 0;
                    }
                    if (wa.index <= oWa.index || (waLayer = wa.poly.getLayer()) != oWa.poly.getLayer()) continue;
                    boolean con = false;
                    if (wa.netNum == oWa.netNum && wa.netNum >= 0) {
                        con = true;
                    }
                    DRCTemplate dRCTemplate = rule = con ? (DRCTemplate)rulesCon.get(waLayer) : (DRCTemplate)rulesNonCon.get(waLayer);
                    if (rule == null) {
                        rule = DRC.getSpacingRule(waLayer, null, waLayer, null, con, -1, 0.0, 0.0);
                        if (rule == null) {
                            System.out.println("Replace this");
                        }
                        if (con) {
                            rulesCon.put(waLayer, rule);
                        } else {
                            rulesNonCon.put(waLayer, rule);
                        }
                    }
                    if (rule == null || rule.value1 < 0.0 || wa.poly.getBounds2D().getMinX() > oWa.poly.getBounds2D().getMaxX() + rule.value1 || oWa.poly.getBounds2D().getMinX() > wa.poly.getBounds2D().getMaxX() + rule.value1 || wa.poly.getBounds2D().getMinY() > oWa.poly.getBounds2D().getMaxY() + rule.value1 || oWa.poly.getBounds2D().getMinY() > wa.poly.getBounds2D().getMaxY() + rule.value1 || !((dist = wa.poly.separation(oWa.poly)) > 0.0) || !(dist < rule.value1) || (layertype = ERCWellCheck.getWellLayerType(waLayer)) == 0) continue;
                    ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                    polyList.add(wa.poly);
                    polyList.add(oWa.poly);
                    this.errorLogger.logError(waLayer.getName() + " areas too close (are " + TextUtils.formatDouble(dist, 1) + ", should be " + TextUtils.formatDouble(rule.value1, 1) + ")", null, null, null, null, polyList, this.cell, 0);
                }
            }
        }
        if (ERC.isFindWorstCaseWell()) {
            this.worstPWellDist = 0.0;
            this.worstPWellCon = null;
            this.worstPWellEdge = null;
            this.worstNWellDist = 0.0;
            this.worstNWellCon = null;
            this.worstNWellEdge = null;
            for (WellArea wa : this.wellAreas) {
                int wellType = ERCWellCheck.getWellLayerType(wa.poly.getLayer());
                if (!ERCWellCheck.isERCLayerRelated(wa.poly.getLayer())) continue;
                desiredContact = PrimitiveNode.Function.SUBSTRATE;
                if (wellType == 1) {
                    desiredContact = PrimitiveNode.Function.WELL;
                }
                Point2D[] points = wa.poly.getPoints();
                int count = points.length;
                for (int i = 0; i < count * 2; ++i) {
                    Point2D testPoint = null;
                    if (i < count) {
                        int prev = i - 1;
                        if (i == 0) {
                            prev = count - 1;
                        }
                        testPoint = new Point2D.Double((points[prev].getX() + points[i].getX()) / 2.0, (points[prev].getY() + points[i].getY()) / 2.0);
                    } else {
                        testPoint = points[i - count];
                    }
                    boolean first = true;
                    double bestDist = 0.0;
                    WellCon bestWc = null;
                    for (WellCon wc : this.wellCons) {
                        if (wc.fun != desiredContact || !wa.poly.getBounds2D().contains(wc.ctr) || !wa.poly.contains(wc.ctr)) continue;
                        double dist = testPoint.distance(wc.ctr);
                        if (first || dist < bestDist) {
                            bestDist = dist;
                            bestWc = wc;
                        }
                        first = false;
                    }
                    if (first) continue;
                    if (wellType == 1) {
                        if (!(bestDist > this.worstPWellDist)) continue;
                        this.worstPWellDist = bestDist;
                        this.worstPWellCon = bestWc.ctr;
                        this.worstPWellEdge = testPoint;
                        continue;
                    }
                    if (!(bestDist > this.worstNWellDist)) continue;
                    this.worstNWellDist = bestDist;
                    this.worstNWellCon = bestWc.ctr;
                    this.worstNWellEdge = testPoint;
                }
            }
        }
        long endTime = System.currentTimeMillis();
        int errorCount = this.errorLogger.getNumErrors();
        if (errorCount == 0) {
            System.out.println("No Well errors found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
        } else {
            System.out.println("FOUND " + errorCount + " WELL ERRORS (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
        }
        this.wellAreas.clear();
        this.wellCons.clear();
        this.doneCells.clear();
        this.cellMerges.clear();
        this.errorLogger.termLogging(true);
        return errorCount;
    }

    private static boolean isERCLayerRelated(Layer layer) {
        int type = ERCWellCheck.getWellLayerType(layer);
        return type == 1 || type == 2 || type == 3 || type == 4;
    }

    private static int getWellLayerType(Layer layer) {
        Layer.Function fun = layer.getFunction();
        int extra = layer.getFunctionExtras();
        if ((extra & 0x1000) != 0) {
            return 0;
        }
        if (fun == Layer.Function.WELLP) {
            return 1;
        }
        if (fun == Layer.Function.WELL || fun == Layer.Function.WELLN) {
            return 2;
        }
        if (fun == Layer.Function.IMPLANTP) {
            return 3;
        }
        if (fun == Layer.Function.IMPLANT || fun == Layer.Function.IMPLANTN) {
            return 4;
        }
        if (fun == Layer.Function.SUBSTRATE) {
            if ((extra & 0x40) != 0) {
                return 3;
            }
            return 4;
        }
        return 0;
    }

    static {
        ercLayers.add(Layer.Function.WELLP);
        ercLayers.add(Layer.Function.WELL);
        ercLayers.add(Layer.Function.WELLN);
        ercLayers.add(Layer.Function.SUBSTRATE);
        ercLayers.add(Layer.Function.IMPLANTP);
        ercLayers.add(Layer.Function.IMPLANT);
        ercLayers.add(Layer.Function.IMPLANTN);
    }

    private static class Visitor
    extends HierarchyEnumerator.Visitor {
        ERCWellCheck check;

        public Visitor(ERCWellCheck check) {
            this.check = check;
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (this.check.job != null && this.check.job.checkAbort()) {
                return false;
            }
            Cell cell = info.getCell();
            GeometryHandler thisMerge = (GeometryHandler)this.check.cellMerges.get(cell);
            if (thisMerge == null) {
                thisMerge = GeometryHandler.createGeometryHandler(this.check.mode, ercLayers.size());
                this.check.cellMerges.put(cell, thisMerge);
            }
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
            boolean done;
            if (this.check.job != null && this.check.job.checkAbort()) {
                return;
            }
            Cell cell = info.getCell();
            GeometryHandler thisMerge = (GeometryHandler)this.check.cellMerges.get(info.getCell());
            if (thisMerge == null) {
                throw new Error("wrong condition in ERCWellCheck.enterCell()");
            }
            boolean bl = done = this.check.doneCells.get(cell) != null;
            if (!done) {
                Iterator<Geometric> it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = it.next();
                    Technology tech = ai.getProto().getTechnology();
                    for (Poly poly : tech.getShapeOfArc(ai, null, null, ercLayers)) {
                        Layer layer = poly.getLayer();
                        Poly newElem = poly;
                        thisMerge.add(layer, newElem);
                    }
                }
                thisMerge.postProcess(true);
                it = cell.getNodes();
                while (it.hasNext()) {
                    GeometryHandler subMerge;
                    NodeInst ni = (NodeInst)it.next();
                    if (!ni.isCellInstance() || (subMerge = (GeometryHandler)this.check.cellMerges.get(ni.getProto())) == null) continue;
                    AffineTransform tTrans = ni.translateOut(ni.rotateOut());
                    thisMerge.addAll(subMerge, tTrans);
                }
            }
            this.check.doneCells.put(cell, cell);
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            boolean wellSubsContact;
            NodeInst ni = no.getNodeInst();
            if (NodeInst.isSpecialNode(ni)) {
                return false;
            }
            Cell cell = info.getCell();
            GeometryHandler thisMerge = (GeometryHandler)this.check.cellMerges.get(cell);
            AffineTransform trans = null;
            PrimitiveNode.Function fun = ni.getFunction();
            boolean bl = wellSubsContact = fun == PrimitiveNode.Function.WELL || fun == PrimitiveNode.Function.SUBSTRATE;
            if (this.check.doneCells.get(cell) == null && !ni.isCellInstance()) {
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                Technology tech = pNp.getTechnology();
                for (Poly poly : tech.getShapeOfNode(ni, null, null, true, true, ercLayers)) {
                    Layer layer = poly.getLayer();
                    if (trans == null) {
                        trans = ni.rotateOut();
                    }
                    poly.transform(trans);
                    Poly newElem = poly;
                    thisMerge.add(layer, newElem);
                }
            }
            if (wellSubsContact) {
                WellCon wc = new WellCon();
                wc.ctr = ni.getTrueCenter();
                if (trans == null) {
                    trans = ni.rotateOut();
                }
                trans.transform(wc.ctr, wc.ctr);
                info.getTransformToRoot().transform(wc.ctr, wc.ctr);
                wc.fun = fun;
                PortInst pi = ni.getOnlyPortInst();
                Netlist netList = info.getNetlist();
                Network net = netList.getNetwork(pi);
                wc.netNum = info.getNetID(net);
                wc.onProperRail = false;
                if (net != null) {
                    boolean searchWell = fun == PrimitiveNode.Function.WELL;
                    Network parentNet = net;
                    HierarchyEnumerator.CellInfo cinfo = info;
                    while (cinfo.getParentInst() != null) {
                        parentNet = cinfo.getNetworkInParent(parentNet);
                        cinfo = cinfo.getParentInfo();
                    }
                    if (parentNet != null) {
                        Iterator<Export> it = parentNet.getExports();
                        while (!wc.onProperRail && it.hasNext()) {
                            Export exp = it.next();
                            if ((!searchWell || !exp.isGround()) && (searchWell || !exp.isPower())) continue;
                            wc.onProperRail = true;
                        }
                    }
                }
                this.check.wellCons.add(wc);
            }
            return true;
        }
    }

    private static class WellCheckJob
    extends Job {
        private Cell cell;
        private GeometryHandler.GHMode newAlgorithm;
        private double worstPWellDist;
        private double worstNWellDist;
        private EPoint worstPWellCon;
        private EPoint worstPWellEdge;
        private EPoint worstNWellCon;
        private EPoint worstNWellEdge;

        private WellCheckJob(Cell cell, GeometryHandler.GHMode newAlgorithm) {
            super("ERC Well Check on " + cell, ERC.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newAlgorithm = newAlgorithm;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            ERCWellCheck check = new ERCWellCheck(this.cell, this, this.newAlgorithm);
            int result = check.doIt();
            this.worstPWellDist = check.worstPWellDist;
            this.fieldVariableChanged("worstPWellDist");
            this.worstNWellDist = check.worstNWellDist;
            this.fieldVariableChanged("worstNWellDist");
            if (check.worstPWellCon != null) {
                this.worstPWellCon = new EPoint(check.worstPWellCon.getX(), check.worstPWellCon.getY());
                this.fieldVariableChanged("worstPWellCon");
            }
            if (check.worstPWellEdge != null) {
                this.worstPWellEdge = new EPoint(check.worstPWellEdge.getX(), check.worstPWellEdge.getY());
                this.fieldVariableChanged("worstPWellEdge");
            }
            if (check.worstNWellCon != null) {
                this.worstNWellCon = new EPoint(check.worstNWellCon.getX(), check.worstNWellCon.getY());
                this.fieldVariableChanged("worstNWellCon");
            }
            if (check.worstNWellEdge != null) {
                this.worstNWellEdge = new EPoint(check.worstNWellEdge.getX(), check.worstNWellEdge.getY());
                this.fieldVariableChanged("worstNWellEdge");
            }
            return result == 0;
        }

        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd != null && (this.worstPWellDist > 0.0 || this.worstNWellDist > 0.0)) {
                wnd.clearHighlighting();
                if (this.worstPWellDist > 0.0) {
                    wnd.addHighlightLine(this.worstPWellCon, this.worstPWellEdge, this.cell, false);
                    System.out.println("Farthest distance from a P-Well contact is " + this.worstPWellDist);
                }
                if (this.worstNWellDist > 0.0) {
                    wnd.addHighlightLine(this.worstNWellCon, this.worstNWellEdge, this.cell, false);
                    System.out.println("Farthest distance from an N-Well contact is " + this.worstNWellDist);
                }
                wnd.finishedHighlighting();
            }
        }
    }

    private static class WellCon {
        Point2D ctr;
        int netNum;
        boolean onProperRail;
        PrimitiveNode.Function fun;

        private WellCon() {
        }
    }

    private static class WellArea {
        PolyBase poly;
        int netNum;
        int index;

        private WellArea() {
        }
    }
}

