/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.CellLayersContainer;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.drc.MultiDRCToolJob;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MultiDRCAreaToolJob
extends MultiDRCToolJob {
    private DRCTemplate minAreaRule;
    private DRCTemplate enclosedAreaRule;
    private DRCTemplate spacingRule;
    private CellLayersContainer cellLayersCon;

    MultiDRCAreaToolJob(Cell c, String l, DRCTemplate minAreaR, DRCTemplate enclosedAreaR, DRCTemplate spacingR, CellLayersContainer cellLayersC, long globalStartT) {
        super(c, l, "Design-Rule MinArea Check " + c + ", layer " + l);
        this.minAreaRule = minAreaR;
        this.enclosedAreaRule = enclosedAreaR;
        this.spacingRule = spacingR;
        this.cellLayersCon = cellLayersC;
        this.globalStartTime = globalStartT;
        this.startJob();
    }

    public boolean doIt() {
        long startTime = System.currentTimeMillis();
        this.theLayer = this.topCell.getTechnology().findLayer(this.theLayerName);
        this.errorLogger = DRC.getDRCErrorLogger(true, false, ", Layer " + this.theLayerName);
        if (Job.BATCHMODE) {
            MultiDRCToolJob.MultiDRCCollectData.jobsList.add(this.errorLogger);
        }
        String msg = "Cell " + this.topCell.getName() + " , layer " + this.theLayer.getName();
        System.out.println("DRC for " + msg + " in thread " + Thread.currentThread().getName());
        LayerAreaEnumerator quickArea = new LayerAreaEnumerator(GeometryHandler.GHMode.ALGO_SWEEP, this.cellLayersCon);
        HierarchyEnumerator.enumerateCell(this.topCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)quickArea);
        long endTime = System.currentTimeMillis();
        this.fieldVariableChanged("errorLogger");
        int errorCount = this.errorLogger.getNumErrors();
        int warnCount = this.errorLogger.getNumWarnings();
        System.out.println(errorCount + " errors and " + warnCount + " warnings found in " + msg + " (took " + TextUtils.getElapsedTime(endTime - startTime) + " in thread " + Thread.currentThread().getName() + ")");
        long accuEndTime = System.currentTimeMillis() - this.globalStartTime;
        System.out.println("Accumulative time " + TextUtils.getElapsedTime(accuEndTime));
        return true;
    }

    public static void startMultiMinAreaChecking(Cell cell, Layer layer, CellLayersContainer cellLayersC, long globalStartT, GenMath.MutableBoolean polyDone) {
        if (layer.getFunction().isDiff() && layer.getName().toLowerCase().equals("p-active-well")) {
            return;
        }
        if (layer.getFunction().isPoly()) {
            if (polyDone.booleanValue()) {
                return;
            }
            polyDone.setValue(true);
        } else if (layer.getFunction().isContact()) {
            return;
        }
        DRCTemplate minAreaRule = DRC.getMinValue(layer, DRCTemplate.DRCRuleType.MINAREA);
        DRCTemplate enclosedAreaRule = DRC.getMinValue(layer, DRCTemplate.DRCRuleType.MINENCLOSEDAREA);
        DRCTemplate spaceRule = DRC.getSpacingRule(layer, null, layer, null, true, -1, -1.0, -1.0);
        if (minAreaRule == null && enclosedAreaRule == null && spaceRule == null) {
            return;
        }
        new MultiDRCAreaToolJob(cell, layer.getName(), minAreaRule, enclosedAreaRule, spaceRule, cellLayersC, globalStartT);
    }

    private class LayerAreaEnumerator
    extends HierarchyEnumerator.Visitor {
        private Map<Cell, GeometryHandlerLayerBucket> cellsMap;
        private Layer.Function.Set thisLayerFunction;
        private GeometryHandler.GHMode mode;
        private Collection<PrimitiveNode> nodesList;
        private Collection<ArcProto> arcsList;
        private CellLayersContainer cellLayersCon;

        LayerAreaEnumerator(GeometryHandler.GHMode m, CellLayersContainer cellLayersC) {
            this.thisLayerFunction = DRC.getMultiLayersSet(MultiDRCAreaToolJob.this.theLayer);
            this.mode = m;
            this.cellsMap = new HashMap<Cell, GeometryHandlerLayerBucket>();
            this.nodesList = new ArrayList<PrimitiveNode>();
            this.cellLayersCon = cellLayersC;
            block0: for (PrimitiveNode node : MultiDRCAreaToolJob.this.topCell.getTechnology().getNodesCollection()) {
                for (Technology.NodeLayer nLayer : node.getLayers()) {
                    if (!this.thisLayerFunction.contains(nLayer.getLayer().getFunction(), MultiDRCAreaToolJob.this.theLayer.getFunctionExtras())) continue;
                    this.nodesList.add(node);
                    continue block0;
                }
            }
            this.arcsList = new ArrayList<ArcProto>();
            block2: for (ArcProto ap : MultiDRCAreaToolJob.this.topCell.getTechnology().getArcsCollection()) {
                for (int i = 0; i < ap.getNumArcLayers(); ++i) {
                    if (ap.getLayer(i) != MultiDRCAreaToolJob.this.theLayer) continue;
                    this.arcsList.add(ap);
                    continue block2;
                }
            }
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            Set<String> set = this.cellLayersCon.getLayersSet(cell);
            if (set != null && !set.contains(MultiDRCAreaToolJob.this.theLayer.getName())) {
                return false;
            }
            GeometryHandlerLayerBucket bucket = this.cellsMap.get(cell);
            if (bucket != null) {
                assert (bucket.merged);
                return false;
            }
            bucket = new GeometryHandlerLayerBucket();
            this.cellsMap.put(cell, bucket);
            Iterator<ArcInst> it = info.getCell().getArcs();
            while (it.hasNext()) {
                boolean notFound;
                ArcInst ai = it.next();
                Network aNet = info.getNetlist().getNetwork(ai, 0);
                if (aNet == null) continue;
                ArcProto ap = ai.getProto();
                boolean bl = notFound = !this.arcsList.contains(ap);
                if (notFound) continue;
                Technology tech = ap.getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai, this.thisLayerFunction)) {
                    this.addElementLocal(poly, MultiDRCAreaToolJob.this.theLayer, bucket);
                }
            }
            return true;
        }

        private void addElementLocal(Poly poly, Layer layer, GeometryHandlerLayerBucket bucket) {
            bucket.local.add(layer, poly);
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            boolean isTopCell = cell == MultiDRCAreaToolJob.this.topCell;
            GeometryHandlerLayerBucket bucket = this.cellsMap.get(cell);
            bucket.mergeGeometry(cell);
            if (isTopCell) {
                for (Layer layer : bucket.local.getKeySet()) {
                    this.checkMinAreaLayerWithTree(bucket.local, MultiDRCAreaToolJob.this.topCell, layer);
                }
            }
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            boolean notFound;
            NodeInst ni = no.getNodeInst();
            if (NodeInst.isSpecialNode(ni)) {
                return false;
            }
            NodeProto np = ni.getProto();
            GeometryHandlerLayerBucket bucket = this.cellsMap.get(info.getCell());
            if (ni.isCellInstance()) {
                return true;
            }
            AffineTransform trans = ni.rotateOut();
            PrimitiveNode pNp = (PrimitiveNode)np;
            boolean bl = notFound = !this.nodesList.contains(pNp);
            if (notFound) {
                return false;
            }
            Technology tech = pNp.getTechnology();
            for (Poly poly : tech.getShapeOfNode(ni, false, true, this.thisLayerFunction)) {
                poly.roundPoints();
                poly.transform(trans);
                this.addElementLocal(poly, MultiDRCAreaToolJob.this.theLayer, bucket);
            }
            return true;
        }

        private int checkMinAreaLayerWithTree(GeometryHandler merge, Cell cell, Layer layer) {
            if (MultiDRCAreaToolJob.this.minAreaRule == null && MultiDRCAreaToolJob.this.enclosedAreaRule == null && MultiDRCAreaToolJob.this.spacingRule == null) {
                return 0;
            }
            Collection<PolyBase.PolyBaseTree> trees = merge.getTreeObjects(layer);
            GenMath.MutableInteger errorFound = new GenMath.MutableInteger(0);
            if (trees.isEmpty()) {
                System.out.println("Nothing for layer " + layer.getName() + " found.");
            }
            for (PolyBase.PolyBaseTree obj : trees) {
                this.traversePolyTree(layer, obj, 0, MultiDRCAreaToolJob.this.minAreaRule, MultiDRCAreaToolJob.this.enclosedAreaRule, MultiDRCAreaToolJob.this.spacingRule, cell, errorFound);
            }
            return errorFound.intValue();
        }

        private void traversePolyTree(Layer layer, PolyBase.PolyBaseTree obj, int level, DRCTemplate minAreaRule, DRCTemplate encloseAreaRule, DRCTemplate spacingRule, Cell cell, GenMath.MutableInteger count) {
            List<PolyBase.PolyBaseTree> sons = obj.getSons();
            for (PolyBase.PolyBaseTree son : sons) {
                this.traversePolyTree(layer, son, level + 1, minAreaRule, encloseAreaRule, spacingRule, cell, count);
            }
            boolean minAreaCheck = level % 2 == 0;
            boolean checkMin = false;
            boolean checkNotch = false;
            DRC.DRCErrorType errorType = DRC.DRCErrorType.MINAREAERROR;
            double minVal = 0.0;
            String ruleName = "";
            if (minAreaCheck) {
                if (minAreaRule == null) {
                    return;
                }
                minVal = minAreaRule.getValue(0);
                ruleName = minAreaRule.ruleName;
                checkMin = true;
            } else {
                errorType = DRC.DRCErrorType.ENCLOSEDAREAERROR;
                if (encloseAreaRule != null) {
                    minVal = encloseAreaRule.getValue(0);
                    ruleName = encloseAreaRule.ruleName;
                    checkMin = true;
                }
                checkNotch = spacingRule != null;
            }
            PolyBase poly = obj.getPoly();
            if (checkMin) {
                double area = poly.getArea();
                if (!DBMath.isGreaterThan(minVal, area)) {
                    return;
                }
                count.increment();
                DRC.createDRCErrorLogger(MultiDRCAreaToolJob.this.errorLogger, null, DRC.DRCCheckMode.ERROR_CHECK_DEFAULT, true, errorType, null, cell, minVal, area, ruleName, poly, null, layer, null, null, null);
            }
            if (checkNotch) {
                Rectangle2D bnd = poly.getBounds2D();
                if (bnd.getWidth() < spacingRule.getValue(0)) {
                    count.increment();
                    DRC.createDRCErrorLogger(MultiDRCAreaToolJob.this.errorLogger, null, DRC.DRCCheckMode.ERROR_CHECK_DEFAULT, true, DRC.DRCErrorType.NOTCHERROR, "(X axis)", cell, spacingRule.getValue(0), bnd.getWidth(), spacingRule.ruleName, poly, null, layer, null, null, layer);
                }
                if (bnd.getHeight() < spacingRule.getValue(1)) {
                    count.increment();
                    DRC.createDRCErrorLogger(MultiDRCAreaToolJob.this.errorLogger, null, DRC.DRCCheckMode.ERROR_CHECK_DEFAULT, true, DRC.DRCErrorType.NOTCHERROR, "(Y axis)", cell, spacingRule.getValue(1), bnd.getHeight(), spacingRule.ruleName, poly, null, layer, null, null, layer);
                }
            }
        }

        private class GeometryHandlerLayerBucket {
            GeometryHandler local;
            boolean merged = false;

            GeometryHandlerLayerBucket() {
                this.local = GeometryHandler.createGeometryHandler(LayerAreaEnumerator.this.mode, 1);
            }

            void mergeGeometry(Cell cell) {
                if (!this.merged) {
                    this.merged = true;
                    Iterator<NodeInst> it = cell.getNodes();
                    while (it.hasNext()) {
                        NodeInst ni = it.next();
                        if (!ni.isCellInstance()) continue;
                        AffineTransform trans = ni.transformOut();
                        Cell protoCell = (Cell)ni.getProto();
                        GeometryHandlerLayerBucket bucket = (GeometryHandlerLayerBucket)LayerAreaEnumerator.this.cellsMap.get(protoCell);
                        if (bucket == null) continue;
                        this.local.addAll(bucket.local, trans);
                    }
                    this.local.postProcess(true);
                } else assert (false);
            }
        }
    }
}

