/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetlistImpl
extends Netlist {
    private static final String[] NULL_STRING_ARRAY = new String[0];
    private String[][] names;
    private BitSet isUsernamed = new BitSet();
    private int[] exportedNamesCount = new int[this.getNumNetworks()];

    NetlistImpl(NetCell netCell, int numExternals, int[] map) {
        super(netCell, Netlist.ShortResistors.NO, numExternals, map);
        this.names = new String[this.getNumNetworks()][];
        Arrays.fill((Object[])this.names, NULL_STRING_ARRAY);
    }

    @Override
    Iterator<String> getNames(int netIndex) {
        return ArrayIterator.iterator(this.names[netIndex]);
    }

    @Override
    Iterator<String> getExportedNames(int netIndex) {
        return ArrayIterator.iterator(this.names[netIndex], 0, this.exportedNamesCount[netIndex]);
    }

    @Override
    String getName(int netIndex) {
        return this.names[netIndex][0];
    }

    @Override
    boolean hasName(int netIndex, String nm) {
        String[] theseNames = this.names[netIndex];
        for (int i = 0; i < theseNames.length; ++i) {
            if (!theseNames[i].equals(nm)) continue;
            return true;
        }
        return false;
    }

    @Override
    void fillNames(int netIndex, Collection<String> exportedNames, Collection<String> privateNames) {
        int i;
        if (!this.isUsernamed(netIndex)) {
            return;
        }
        String[] names = this.names[netIndex];
        int exportedNamesCount = this.exportedNamesCount[netIndex];
        for (i = 0; i < exportedNamesCount; ++i) {
            exportedNames.add(names[i]);
        }
        if (privateNames != null) {
            for (i = exportedNamesCount; i < names.length; ++i) {
                privateNames.add(names[i]);
            }
        }
    }

    @Override
    boolean isExported(int netIndex) {
        return this.exportedNamesCount[netIndex] > 0;
    }

    @Override
    boolean isUsernamed(int netIndex) {
        return this.isUsernamed.get(netIndex);
    }

    boolean hasNames(int netIndex) {
        return this.names[netIndex].length > 0;
    }

    void addUserName(int netIndex, Name nameKey, boolean exported) {
        int i;
        assert (!nameKey.isTempname());
        String name = nameKey.toString();
        String[] theseNames = this.names[netIndex];
        if (exported) assert (this.exportedNamesCount[netIndex] == theseNames.length);
        for (i = 0; i < theseNames.length; ++i) {
            String n = this.names[netIndex][i];
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(name, n);
            if (cmp == 0) {
                return;
            }
            if (cmp < 0 && (exported || i >= this.exportedNamesCount[netIndex])) break;
        }
        if (theseNames.length == 0) {
            this.names[netIndex] = new String[]{name};
        } else {
            String[] newNames = new String[theseNames.length + 1];
            System.arraycopy(theseNames, 0, newNames, 0, i);
            newNames[i] = name;
            System.arraycopy(theseNames, i, newNames, i + 1, theseNames.length - i);
            this.names[netIndex] = newNames;
        }
        if (exported) {
            int n = netIndex;
            this.exportedNamesCount[n] = this.exportedNamesCount[n] + 1;
        }
        this.isUsernamed.set(netIndex);
    }

    void addTempName(int netIndex, String name) {
        assert (this.names[netIndex].length == 0);
        this.names[netIndex] = new String[]{name};
    }
}

