/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.ui;

import com.sun.electric.plugins.j3d.View3DWindow;
import com.sun.electric.plugins.j3d.utils.J3DSerialization;
import com.sun.electric.plugins.j3d.utils.J3DUtils;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSlider;

public class J3DDemoDialog
extends EDialog {
    private View3DWindow view3D = null;
    private List<J3DUtils.ThreeDDemoKnot> knots = new ArrayList<J3DUtils.ThreeDDemoKnot>();
    private Map<TransformGroup, BranchGroup> interMap;
    private JCheckBox auto;
    private JButton close;
    private JButton demo;
    private JComboBox demoMode;
    private JButton enter;
    private JButton movie;
    private JButton read;
    private JButton save;
    private JSlider slider;

    public static void create3DDemoDialog(Frame parent, URL fileURL) {
        View3DWindow view3D = null;
        WindowContent content = WindowFrame.getCurrentWindowFrame().getContent();
        if (!(content instanceof View3DWindow)) {
            System.out.println("Current Window Frame is not a 3D View");
            return;
        }
        view3D = (View3DWindow)content;
        J3DDemoDialog dialog = new J3DDemoDialog(parent, view3D, false);
        if (fileURL == null || dialog.readDemoFromFile(fileURL)) {
            if (fileURL != null) {
                dialog.demoActionPerformed(null);
            }
            dialog.setVisible(true);
        }
    }

    public J3DDemoDialog(Frame parent, View3DWindow view3d, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.view3D = view3d;
        this.getRootPane().setDefaultButton(this.enter);
        if (J3DUtils.jAlpha != null) {
            this.slider.addChangeListener(J3DUtils.jAlpha);
            this.auto.setSelected(J3DUtils.jAlpha.getAutoMode());
        }
        this.demoMode.addItem("Viewplatform");
        this.demoMode.addItem("Scene");
        this.finishInitialization();
    }

    @Override
    protected void escapePressed() {
        this.closeActionPerformed(null);
    }

    private void initComponents() {
        this.slider = new JSlider();
        this.auto = new JCheckBox();
        this.close = new JButton();
        this.demo = new JButton();
        this.enter = new JButton();
        this.read = new JButton();
        this.save = new JButton();
        this.movie = new JButton();
        this.demoMode = new JComboBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("3D Demo Control Dialog");
        this.setBackground(Color.white);
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                J3DDemoDialog.this.closeDialog(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.slider, gridBagConstraints);
        this.auto.setText("Auto");
        this.auto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DDemoDialog.this.autoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.auto, gridBagConstraints);
        this.close.setText("Close");
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DDemoDialog.this.closeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.close, gridBagConstraints);
        this.demo.setText("Start Demo");
        this.demo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DDemoDialog.this.demoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.demo, gridBagConstraints);
        this.enter.setText("Enter Frame");
        this.enter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DDemoDialog.this.enterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.enter, gridBagConstraints);
        this.read.setText("Read Demo");
        this.read.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DDemoDialog.this.readActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.read, gridBagConstraints);
        this.save.setText("Save Demo");
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DDemoDialog.this.saveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.save, gridBagConstraints);
        this.movie.setText("Create Movie");
        this.movie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J3DDemoDialog.this.movieActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.movie, gridBagConstraints);
        this.demoMode.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.demoMode, gridBagConstraints);
        this.pack();
    }

    private void movieActionPerformed(ActionEvent evt) {
        String fileName = OpenFile.chooseOutputFile(FileType.MOV, "Save 3D Movie", "demo.mov");
        this.view3D.saveMovie(new File(fileName));
    }

    private void saveActionPerformed(ActionEvent evt) {
        String fileName = OpenFile.chooseOutputFile(FileType.J3D, "Save 3D Demo File", "demo.j3d");
        if (fileName == null || this.knots == null) {
            return;
        }
        try {
            Transform3D tmpTrans = new Transform3D();
            FileOutputStream outputStream = new FileOutputStream(fileName);
            ObjectOutputStream out = new ObjectOutputStream(outputStream);
            this.view3D.getObjTransform(tmpTrans);
            boolean useViewplatform = ((String)this.demoMode.getSelectedItem()).equals("Viewplatform");
            J3DSerialization serial = new J3DSerialization(new Boolean(useViewplatform), this.knots, tmpTrans);
            out.writeObject(serial);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean readDemoFromFile(URL fileURL) {
        if (fileURL == null) {
            return false;
        }
        InputStream stream = TextUtils.getURLStream(fileURL);
        this.knots = null;
        try {
            ObjectInputStream in = new ObjectInputStream(stream);
            J3DSerialization serial = (J3DSerialization)in.readObject();
            boolean useViewplatform = false;
            if (serial.useView != null) {
                useViewplatform = serial.useView;
            }
            this.demoMode.setSelectedIndex(useViewplatform ? 0 : 1);
            this.knots = serial.list;
            Transform3D tmpTrans = new Transform3D();
            tmpTrans.set(serial.matrix);
            this.view3D.setObjTransform(tmpTrans);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void readActionPerformed(ActionEvent evt) {
        String fileName = OpenFile.chooseInputFile(FileType.J3D, "Read 3D Demo Frames");
        this.readDemoFromFile(TextUtils.makeURLToFile(fileName));
    }

    private void enterActionPerformed(ActionEvent evt) {
        this.knots.add(this.view3D.addFrame(this.demoMode.getSelectedIndex() == 0));
        this.view3D.saveImage(true);
    }

    private void demoActionPerformed(ActionEvent evt) {
        if (this.demo.getText().equals("Start Demo")) {
            this.interMap = this.view3D.addInterpolatorPerGroup(this.knots, null, this.interMap, this.demoMode.getSelectedIndex() == 0);
            if (this.interMap != null) {
                this.demo.setText("Stop Demo");
            }
        } else {
            this.demo.setText("Start Demo");
            this.view3D.removeInterpolator(this.interMap);
            this.interMap.clear();
        }
    }

    private void autoActionPerformed(ActionEvent evt) {
        J3DUtils.jAlpha.setAutoMode(this.auto.isSelected());
    }

    private void closeActionPerformed(ActionEvent evt) {
        if (this.interMap != null) {
            this.view3D.removeInterpolator(this.interMap);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

