/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.dialogs.GetInfoText;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.help.ManualViewer;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.KeyBindings;
import com.sun.electric.tool.user.ui.KeyStrokePair;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.WaveSignal;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class KeyBindingManager
implements KeyEventDispatcher {
    private Map<KeyStroke, Set<String>> inputMap = new HashMap<KeyStroke, Set<String>>();
    private Map<String, Object> actionMap = new HashMap<String, Object>();
    private KeyStroke lastPrefix = null;
    private Map<KeyStroke, Map<KeyStroke, Set<String>>> prefixedInputMapMaps = new HashMap<KeyStroke, Map<KeyStroke, Set<String>>>();
    private PrefixAction prefixAction = new PrefixAction(this);
    private Preferences prefs;
    private String prefPrefix;
    private static List<KeyBindingManager> allManagers = new ArrayList<KeyBindingManager>();
    private static final boolean debugPrefs = false;
    private static final boolean DEBUG = false;
    private boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyBindingManager(String prefPrefix, Preferences prefs) {
        this.prefs = prefs;
        this.prefPrefix = prefPrefix;
        this.actionMap.put("KeyBindingManager prefix action", this.prefixAction);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        List<KeyBindingManager> list2 = allManagers;
        synchronized (list2) {
            allManagers.add(this);
        }
        this.initialize();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        return this.processKeyEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        List<KeyBindingManager> list2 = allManagers;
        synchronized (list2) {
            allManagers.remove(this);
        }
    }

    private synchronized void initialize() {
    }

    public void printKeyBindings() {
        HashMap set = new HashMap();
        ArrayList<String> keyList = new ArrayList<String>();
        ArrayList<KeyBindingColumn> columnList = new ArrayList<KeyBindingColumn>();
        KeyBindingColumn row = new KeyBindingColumn("Keys");
        HashSet<String> tmpSet = new HashSet<String>();
        columnList.add(row);
        for (Map.Entry<KeyStroke, Set<String>> map2 : this.inputMap.entrySet()) {
            String modifier;
            KeyBindingColumn newCol;
            int index;
            KeyBindingColumn col;
            KeyStroke keyS = map2.getKey();
            String key = KeyStrokePair.getStringFromKeyStroke(keyS);
            HashMap<String, Set<String>> m = (HashMap<String, Set<String>>)set.get(key);
            if (m == null) {
                m = new HashMap<String, Set<String>>();
                set.put(key, m);
                keyList.add(key);
                tmpSet.clear();
                tmpSet.add(key);
                row.addHit(tmpSet);
            }
            KeyBindingColumn keyBindingColumn = col = (index = columnList.indexOf(newCol = new KeyBindingColumn(modifier = KeyEvent.getKeyModifiersText(keyS.getModifiers())))) > -1 ? (KeyBindingColumn)columnList.get(index) : null;
            if (col == null) {
                col = newCol;
                columnList.add(col);
            }
            col.addHit(map2.getValue());
            m.put(modifier, map2.getValue());
        }
        Collections.sort(keyList);
        Collections.sort(columnList, new KeyBindingColumnSort());
        String headerLine = "\n";
        for (KeyBindingColumn column : columnList) {
            String header = column.getHeader();
            System.out.print(header);
            for (int i = 0; i < header.length(); ++i) {
                headerLine = headerLine + "-";
            }
        }
        System.out.println(headerLine);
        for (String key : keyList) {
            for (KeyBindingColumn column : columnList) {
                String value2 = column == row ? key : ((Map)set.get(key)).get(column.name);
                System.out.print(column.getColumn(value2));
            }
            System.out.println();
        }
    }

    private synchronized void setPrefixKey(KeyStroke prefix) {
        this.lastPrefix = prefix;
    }

    public static boolean validKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 37 || e.getKeyCode() == 39 || e.getKeyCode() == 38 || e.getKeyCode() == 40) {
            return true;
        }
        if (e.getID() != 401) {
            return false;
        }
        if (e.getKeyCode() == 17) {
            return false;
        }
        if (e.getKeyCode() == 16) {
            return false;
        }
        if (e.getKeyCode() == 18) {
            return false;
        }
        return e.getKeyCode() != 157;
    }

    public synchronized boolean processKeyEvent(KeyEvent e) {
        if (!KeyBindingManager.validKeyEvent(e)) {
            return false;
        }
        boolean valid = false;
        for (Component c = e.getComponent(); c != null; c = c.getParent()) {
            if (c instanceof EditWindow) {
                valid = true;
                break;
            }
            if (c instanceof WaveformWindow.OnePanel) {
                valid = true;
                break;
            }
            if (c instanceof TopLevel) {
                valid = true;
                break;
            }
            if (c instanceof EDialog) {
                this.lastPrefix = null;
                return false;
            }
            if (c instanceof EModelessDialog) {
                this.lastPrefix = null;
                return false;
            }
            if (c instanceof JOptionPane) {
                this.lastPrefix = null;
                return false;
            }
            if (c instanceof TextWindow.TextWindowPanel) {
                this.lastPrefix = null;
                return false;
            }
            if (c instanceof OpenFile.OpenFileSwing) {
                this.lastPrefix = null;
                return false;
            }
            if (c instanceof GetInfoText.EIPEditorPane) {
                this.lastPrefix = null;
                return false;
            }
            if (c instanceof GetInfoText.EIPTextField) {
                this.lastPrefix = null;
                return false;
            }
            if (c instanceof ManualViewer) {
                this.lastPrefix = null;
                return false;
            }
            if (c instanceof ManualViewer.EditHTML) {
                this.lastPrefix = null;
                return false;
            }
            if (!(c instanceof WaveSignal.EditSignalName)) continue;
            this.lastPrefix = null;
            return false;
        }
        if (!valid && (e.getModifiers() & 2) == 0) {
            this.lastPrefix = null;
            return false;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        JMenuBar mb = wf.getFrame().getJMenuBar();
        for (int i = 0; i < mb.getMenuCount(); ++i) {
            JMenu m = mb.getMenu(i);
            if (m == null || !m.isPopupMenuVisible()) continue;
            this.lastPrefix = null;
            return false;
        }
        KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
        if ((e.getModifiers() & 1) != 0 && !Character.isLetter(e.getKeyCode()) && !Character.isDigit(e.getKeyCode()) && e.getKeyCode() != 37 && e.getKeyCode() != 39 && e.getKeyCode() != 38 && e.getKeyCode() != 40) {
            stroke = KeyStroke.getKeyStroke(e.getKeyChar());
        }
        if (e.getKeyCode() == 91 || e.getKeyCode() == 93) {
            stroke = KeyStroke.getKeyStroke(e.getKeyChar());
        }
        if (e.isConsumed()) {
            this.lastPrefix = null;
            return false;
        }
        Map<KeyStroke, Set<String>> inputMapToUse = this.inputMap;
        if (this.lastPrefix != null && (inputMapToUse = this.prefixedInputMapMaps.get(this.lastPrefix)) == null) {
            this.lastPrefix = null;
            return false;
        }
        ActionListener action = null;
        ActionEvent evt = new ActionEvent(e, 1001, stroke.toString(), stroke.getModifiers());
        boolean actionPerformed = false;
        boolean prefixActionPerformed = false;
        Set<String> keyBindingList = inputMapToUse.get(stroke);
        if (keyBindingList != null) {
            for (String actionDesc : keyBindingList) {
                action = (ActionListener)this.actionMap.get(actionDesc);
                if (action instanceof PrefixAction) {
                    if (!prefixActionPerformed) {
                        action.actionPerformed(evt);
                        prefixActionPerformed = true;
                    }
                } else {
                    action.actionPerformed(evt);
                    this.lastPrefix = null;
                }
                actionPerformed = true;
            }
        }
        if (!actionPerformed) {
            Map<KeyStroke, Set<String>> prefixMap = this.prefixedInputMapMaps.get(stroke);
            if (prefixMap != null) {
                this.prefixAction.actionPerformed(evt);
                actionPerformed = true;
            } else {
                this.lastPrefix = null;
            }
        }
        if (actionPerformed) {
            e.consume();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<KeyBindings> getConflictsAllManagers(KeyStrokePair pair2) {
        ArrayList<KeyBindings> conflicts = new ArrayList<KeyBindings>();
        List<KeyBindingManager> list2 = allManagers;
        synchronized (list2) {
            for (KeyBindingManager m : allManagers) {
                conflicts.addAll(m.getConflictingKeyBindings(pair2));
            }
        }
        return conflicts;
    }

    public synchronized void addDefaultKeyBinding(String actionDesc, KeyStrokePair pair2) {
        if (pair2 == null) {
            return;
        }
        KeyBindings keys = (KeyBindings)this.actionMap.get(actionDesc);
        if (keys == null) {
            keys = new KeyBindings(actionDesc);
            this.actionMap.put(actionDesc, keys);
        }
        keys.addDefaultKeyBinding(pair2);
    }

    public synchronized void addUserKeyBinding(String actionDesc, KeyStrokePair pair2) {
        if (pair2 == null) {
            return;
        }
        KeyBindings keys = this.addKeyBinding(actionDesc, pair2);
        keys.setUsingDefaultKeys(false);
        this.setBindingsToPrefs(keys.getActionDesc());
    }

    public synchronized void addActionListener(String actionDesc, ActionListener action) {
        KeyBindings keys = (KeyBindings)this.actionMap.get(actionDesc);
        if (keys == null) {
            keys = new KeyBindings(actionDesc);
            this.actionMap.put(actionDesc, keys);
        }
        keys.addActionListener(action);
    }

    public synchronized void removeKeyBinding(String actionDesc, KeyStrokePair k) {
        Set<String> set;
        Map<KeyStroke, Set<String>> inputMapToUse = this.inputMap;
        if (k.getPrefixStroke() != null) {
            set = this.inputMap.get(k.getPrefixStroke());
            if (set != null) {
                for (String str : set) {
                    if (!str.equals("KeyBindingManager prefix action")) continue;
                    set.remove(str);
                    break;
                }
            }
            inputMapToUse = this.prefixedInputMapMaps.get(k.getPrefixStroke());
        }
        if (inputMapToUse != null && (set = inputMapToUse.get(k.getStroke())) != null) {
            set.remove(actionDesc);
        }
        KeyBindings bindings = (KeyBindings)this.actionMap.get(actionDesc);
        bindings.removeKeyBinding(k);
        bindings.setUsingDefaultKeys(false);
        this.setBindingsToPrefs(actionDesc);
    }

    public synchronized void resetKeyBindings(String actionDesc) {
        Iterator<KeyStrokePair> it;
        KeyBindings keys = (KeyBindings)this.actionMap.get(actionDesc);
        if (keys != null) {
            while ((it = keys.getKeyStrokePairs()).hasNext()) {
                KeyStrokePair pair2 = it.next();
                this.removeKeyBinding(actionDesc, pair2);
            }
        }
        this.prefs.remove(this.prefPrefix + actionDesc);
        it = keys.getDefaultKeyStrokePairs();
        while (it.hasNext()) {
            KeyStrokePair k = it.next();
            this.addKeyBinding(actionDesc, k);
        }
        keys.setUsingDefaultKeys(true);
    }

    public synchronized KeyBindings getKeyBindings(String actionDesc) {
        return (KeyBindings)this.actionMap.get(actionDesc);
    }

    public KeyMaps getKeyMaps() {
        KeyMaps km = new KeyMaps(this, this.inputMap, this.actionMap);
        return km;
    }

    public synchronized void setEventSource(String actionDesc, Object source) {
        KeyBindings keys = (KeyBindings)this.actionMap.get(actionDesc);
        keys.setEventSource(source);
    }

    public synchronized List<KeyBindings> getConflictingKeyBindings(KeyStrokePair pair2) {
        Set<String> set;
        ArrayList<KeyBindings> conflicts = new ArrayList<KeyBindings>();
        ArrayList<String> conflictsStrings = new ArrayList<String>();
        Map<KeyStroke, Set<String>> inputMapToUse = this.inputMap;
        if (pair2.getPrefixStroke() != null) {
            set = this.inputMap.get(pair2.getPrefixStroke());
            if (set != null) {
                for (String str : set) {
                    if (str.equals("KeyBindingManager prefix action")) continue;
                    conflictsStrings.add(str);
                }
            }
            inputMapToUse = this.prefixedInputMapMaps.get(pair2.getPrefixStroke());
        }
        if (inputMapToUse != null && (set = inputMapToUse.get(pair2.getStroke())) != null) {
            for (String str : set) {
                if (str.equals("KeyBindingManager prefix action")) {
                    Map<KeyStroke, Set<String>> prefixMap = this.prefixedInputMapMaps.get(pair2.getStroke());
                    if (prefixMap == null) continue;
                    for (Set<String> prefixList : prefixMap.values()) {
                        conflictsStrings.addAll(prefixList);
                    }
                    continue;
                }
                conflictsStrings.add(str);
            }
        }
        for (String aln : conflictsStrings) {
            ActionListener action = (ActionListener)this.actionMap.get(aln);
            if (action == null || action instanceof PrefixAction) continue;
            KeyBindings keys = (KeyBindings)action;
            KeyBindings conflicting = new KeyBindings(keys.getActionDesc());
            Iterator<KeyStrokePair> it2 = keys.getKeyStrokePairs();
            while (it2.hasNext()) {
                KeyStrokePair pair22 = it2.next();
                if (pair2.getPrefixStroke() != null) {
                    if (pair22.getPrefixStroke() != null) {
                        if (pair2.getStroke() != pair22.getStroke()) continue;
                        conflicting.addKeyBinding(pair22);
                        continue;
                    }
                    if (pair2.getPrefixStroke() != pair22.getStroke()) continue;
                    conflicting.addKeyBinding(pair22);
                    continue;
                }
                if (pair22.getPrefixStroke() != null) {
                    if (pair2.getStroke() != pair22.getPrefixStroke()) continue;
                    conflicting.addKeyBinding(pair22);
                    continue;
                }
                if (pair2.getStroke() != pair22.getStroke()) continue;
                conflicting.addKeyBinding(pair22);
            }
            Iterator<KeyStrokePair> conflictingIt = conflicting.getKeyStrokePairs();
            if (!conflictingIt.hasNext()) continue;
            conflicts.add(conflicting);
        }
        return conflicts;
    }

    public synchronized void setEnabled(String actionDesc, boolean b) {
        ActionListener action = (ActionListener)this.actionMap.get(actionDesc);
        if (action == null) {
            return;
        }
        if (action instanceof PrefixAction) {
            return;
        }
        KeyBindings k = (KeyBindings)action;
        k.setEnabled(b);
    }

    public synchronized boolean getEnabled(String actionDesc) {
        ActionListener action = (ActionListener)this.actionMap.get(actionDesc);
        if (action == null) {
            return false;
        }
        if (action instanceof PrefixAction) {
            return false;
        }
        KeyBindings k = (KeyBindings)action;
        return k.getEnabled();
    }

    public synchronized void deleteEmptyBindings() {
        Set<String> keys = this.actionMap.keySet();
        for (String key : keys) {
            KeyBindings bindings;
            Iterator<ActionListener> listenersIt;
            ActionListener action = (ActionListener)this.actionMap.get(key);
            if (!(action instanceof KeyBindings) || (listenersIt = (bindings = (KeyBindings)action).getActionListeners()).hasNext()) continue;
            System.out.println("Warning: Deleting defunct binding for " + key + " [ " + bindings.bindingsToString() + " ]...action does not exist anymore");
            this.removeBindingsFromPrefs(key);
        }
    }

    private synchronized KeyBindings addKeyBinding(String actionDesc, KeyStrokePair pair2) {
        Set<String> set;
        if (pair2 == null) {
            return null;
        }
        List<KeyBindings> conflicts = this.getConflictingKeyBindings(pair2);
        if (conflicts.size() > 0) {
            System.out.println("WARNING: Key binding for " + actionDesc + " [ " + pair2.toString() + " ] conflicts with:");
            for (KeyBindings k : conflicts) {
                System.out.println("  > " + k.getActionDesc() + " [ " + k.bindingsToString() + " ]");
            }
        }
        KeyStroke prefixStroke = pair2.getPrefixStroke();
        KeyStroke stroke = pair2.getStroke();
        Map<KeyStroke, Set<String>> inputMapToUse = this.inputMap;
        if (prefixStroke != null) {
            inputMapToUse = this.prefixedInputMapMaps.get(prefixStroke);
            if (inputMapToUse == null) {
                inputMapToUse = new HashMap<KeyStroke, Set<String>>();
                this.prefixedInputMapMaps.put(prefixStroke, inputMapToUse);
            }
            if ((set = this.inputMap.get(prefixStroke)) == null) {
                set = new HashSet<String>();
                this.inputMap.put(prefixStroke, set);
            }
            set.add("KeyBindingManager prefix action");
        }
        if ((set = inputMapToUse.get(stroke)) == null) {
            set = new HashSet<String>();
            inputMapToUse.put(stroke, set);
        }
        set.add(actionDesc);
        KeyBindings keys = (KeyBindings)this.actionMap.get(actionDesc);
        if (keys == null) {
            keys = new KeyBindings(actionDesc);
            this.actionMap.put(actionDesc, keys);
        }
        keys.addKeyBinding(pair2);
        return keys;
    }

    private synchronized void setBindingsToPrefs(String actionDesc) {
        if (this.prefs == null) {
            return;
        }
        if (actionDesc == null || actionDesc.equals("")) {
            return;
        }
        KeyBindings keyBindings = (KeyBindings)this.actionMap.get(actionDesc);
        if (keyBindings == null) {
            return;
        }
        String actionDescAbbrev = actionDesc;
        if (actionDesc.length() + this.prefPrefix.length() > 80) {
            int start = actionDesc.length() + this.prefPrefix.length() - 80;
            actionDescAbbrev = actionDesc.substring(start, actionDesc.length());
        }
        this.prefs.put(this.prefPrefix + actionDescAbbrev, keyBindings.bindingsToString());
    }

    private synchronized List<KeyStrokePair> getBindingsFromPrefs(String actionDesc) {
        String keys;
        if (this.prefs == null) {
            return null;
        }
        if (actionDesc == null || actionDesc.equals("")) {
            return null;
        }
        String actionDescAbbrev = actionDesc;
        if (actionDesc.length() + this.prefPrefix.length() > 80) {
            int start = actionDesc.length() + this.prefPrefix.length() - 80;
            actionDescAbbrev = actionDesc.substring(start, actionDesc.length());
        }
        if ((keys = this.prefs.get(this.prefPrefix + actionDescAbbrev, null)) == null) {
            return null;
        }
        KeyBindings k = new KeyBindings(actionDesc);
        k.addKeyBindings(keys);
        ArrayList<KeyStrokePair> bindings = new ArrayList<KeyStrokePair>();
        Iterator<KeyStrokePair> it = k.getKeyStrokePairs();
        while (it.hasNext()) {
            bindings.add(it.next());
        }
        return bindings;
    }

    public synchronized void restoreSavedBindings(boolean initialCall) {
        if (initialCall && this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.prefs == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.actionMap.entrySet()) {
            String actionDesc = entry.getKey();
            if (actionDesc == null || actionDesc.equals("") || entry.getValue() instanceof PrefixAction) continue;
            KeyBindings bindings = (KeyBindings)entry.getValue();
            bindings.clearKeyBindings();
            List<KeyStrokePair> keyPairs = this.getBindingsFromPrefs(bindings.getActionDesc());
            if (keyPairs == null) {
                bindings.setUsingDefaultKeys(true);
                Iterator<KeyStrokePair> it2 = bindings.getDefaultKeyStrokePairs();
                while (it2.hasNext()) {
                    KeyStrokePair pair2 = it2.next();
                    this.addKeyBinding(actionDesc, pair2);
                }
                continue;
            }
            bindings.setUsingDefaultKeys(false);
            for (KeyStrokePair pair2 : keyPairs) {
                this.addKeyBinding(actionDesc, pair2);
            }
        }
    }

    private synchronized void removeBindingsFromPrefs(String actionDesc) {
        if (this.prefs == null) {
            return;
        }
        if (actionDesc == null || actionDesc.equals("")) {
            return;
        }
        this.prefs.remove(this.prefPrefix + actionDesc);
    }

    private static class MyAbstractAction
    extends AbstractAction {
        private String actionName;
        private KeyBindingManager kbm;

        MyAbstractAction(String actionName, KeyBindingManager kbm) {
            this.actionName = actionName;
            this.kbm = kbm;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            KeyBindings kb = this.kbm.getKeyBindings(this.actionName);
            kb.actionPerformed(event);
        }
    }

    public static class KeyMaps {
        private InputMap im = new InputMap();
        private ActionMap am = new ActionMap();

        KeyMaps(KeyBindingManager kbm, Map<KeyStroke, Set<String>> inputMap, Map<String, Object> actionMap) {
            for (KeyStroke ks : inputMap.keySet()) {
                Set<String> theSet = inputMap.get(ks);
                if (theSet.size() <= 0) continue;
                String actionName = theSet.iterator().next();
                this.im.put(ks, actionName);
                this.am.put(actionName, new MyAbstractAction(actionName, kbm));
            }
        }

        public InputMap getInputMap() {
            return this.im;
        }

        public ActionMap getActionMap() {
            return this.am;
        }
    }

    private static class PrefixAction
    extends AbstractAction {
        public static final String actionDesc = "KeyBindingManager prefix action";
        private KeyBindingManager manager;

        public PrefixAction(KeyBindingManager manager) {
            this.manager = manager;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyEvent keyEvent = (KeyEvent)e.getSource();
            KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            this.manager.setPrefixKey(stroke);
        }
    }

    private static class KeyBindingColumnSort
    implements Comparator<KeyBindingColumn> {
        private KeyBindingColumnSort() {
        }

        @Override
        public int compare(KeyBindingColumn s1, KeyBindingColumn s2) {
            int bb1 = s1.hits;
            int bb2 = s2.hits;
            if (bb1 < bb2) {
                return 1;
            }
            if (bb1 > bb2) {
                return -1;
            }
            return 0;
        }
    }

    private static class KeyBindingColumn {
        int hits = 0;
        int maxLength = 0;
        String name;

        KeyBindingColumn(String n) {
            this.name = n;
        }

        public String toString() {
            return this.name;
        }

        public String getHeader() {
            String n = this.name;
            for (int l = this.name.length(); l < this.maxLength; ++l) {
                n = n + " ";
            }
            return n + " | ";
        }

        public String getColumn(Object value2) {
            String column = "";
            int fillStart = 0;
            if (value2 != null) {
                String n = value2.toString();
                fillStart = n.length();
                column = column + n;
            }
            for (int l = fillStart; l < this.maxLength; ++l) {
                column = column + " ";
            }
            return column + " | ";
        }

        public void addHit(Set<String> set) {
            ++this.hits;
            int len = set.toString().length();
            if (len > this.maxLength) {
                this.maxLength = len;
            }
        }

        public boolean equals(Object obj) {
            String key = obj.toString();
            boolean found = key.equals(this.name);
            return found;
        }
    }
}

