/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.flag.TaskPrinter;
import com.sun.electric.tool.generator.flag.router.ToConnect;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class Utils {
    private static TaskPrinter taskPrinter = new TaskPrinter();

    public static void prln(String s) {
        taskPrinter.prln(s);
    }

    public static void pr(String s) {
        taskPrinter.pr(s);
    }

    public static void error(boolean cond, String msg) {
        taskPrinter.error(cond, msg);
    }

    public static void saveTaskDescription(String msg) {
        taskPrinter.saveTaskDescription(msg);
    }

    public static void clearTaskDescription() {
        taskPrinter.clearTaskDescription();
    }

    public static boolean isPwr(PortProto pp) {
        return pp.getCharacteristic() == PortCharacteristic.PWR;
    }

    public static boolean isPwr(PortInst pi) {
        return Utils.isPwr(pi.getPortProto());
    }

    public static boolean isGnd(PortProto pp) {
        return pp.getCharacteristic() == PortCharacteristic.GND;
    }

    public static boolean isGnd(PortInst pi) {
        return Utils.isGnd(pi.getPortProto());
    }

    public static boolean isPwrGnd(PortProto pp) {
        return Utils.isPwr(pp) || Utils.isGnd(pp);
    }

    public static boolean isPwrGnd(PortInst pi) {
        return Utils.isPwr(pi) || Utils.isGnd(pi);
    }

    public static boolean isPwrGnd(ToConnect tc) {
        for (PortInst pi : tc.getPortInsts()) {
            if (!Utils.isPwrGnd(pi)) continue;
            return true;
        }
        return false;
    }

    public static boolean onTop(PortInst pi, Rectangle2D bounds, double fudge) {
        double y = pi.getCenter().getY();
        return Utils.nextToBoundary(y, bounds.getMaxY(), fudge);
    }

    public static boolean onBottom(PortInst pi, Rectangle2D bounds, double fudge) {
        double y = pi.getCenter().getY();
        return Utils.nextToBoundary(y, bounds.getMinY(), fudge);
    }

    public static boolean onTopOrBottom(PortInst pi, Rectangle2D bounds, double fudge) {
        return Utils.onTop(pi, bounds, fudge) || Utils.onBottom(pi, bounds, fudge);
    }

    public static boolean onLeftOrRight(PortInst pi, Rectangle2D bounds, double fudge) {
        double x2 = pi.getCenter().getX();
        return Utils.nextToBoundary(x2, bounds.getMinX(), fudge) || Utils.nextToBoundary(x2, bounds.getMaxX(), fudge);
    }

    public static boolean onBounds(PortInst pi, Rectangle2D bounds, double fudge) {
        return Utils.onTopOrBottom(pi, bounds, fudge) || Utils.onLeftOrRight(pi, bounds, fudge);
    }

    public static boolean nextToBoundary(double coord, double boundCoord, double fudge) {
        return Math.abs(coord - boundCoord) <= fudge;
    }

    public static Rectangle2D findBounds(Cell c) {
        double minY = Double.MAX_VALUE;
        double minX = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        double maxX = -1.7976931348623157E308;
        Iterator<NodeInst> niIt = c.getNodes();
        while (niIt.hasNext()) {
            NodeInst ni = niIt.next();
            if (!ni.isCellInstance()) continue;
            Rectangle2D bounds = ni.findEssentialBounds();
            Utils.error(bounds == null, "Layout Cell is missing essential bounds: " + ni.getProto().describe(false));
            minX = Math.min(minX, bounds.getMinX());
            maxX = Math.max(maxX, bounds.getMaxX());
            minY = Math.min(minY, bounds.getMinY());
            maxY = Math.max(maxY, bounds.getMaxY());
        }
        if (minX == Double.MAX_VALUE) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public static void printStackTrace(Throwable th) {
        boolean first = true;
        while (th != null) {
            if (!first) {
                Utils.pr("Caused by: ");
            }
            first = false;
            Utils.prln(th.toString());
            for (StackTraceElement elem2 : th.getStackTrace()) {
                Utils.prln("    " + elem2.toString());
            }
            th = th.getCause();
        }
    }
}

