/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.tool.Job;
import com.sun.electric.util.math.AbstractFixpRectangle;
import com.sun.electric.util.math.FixpCoord;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class RTNode<T extends RTBounds>
extends AbstractFixpRectangle {
    private static final int MINRTNODESIZE = 4;
    private static final int MAXRTNODESIZE = 8;
    private long fixpMinX;
    private long fixpMinY;
    private long fixpMaxX;
    private long fixpMaxY;
    private int total;
    private final Object[] pointers = new Object[8];
    private boolean flag;
    private RTNode<T> parent;
    private static int branchCount;

    @Override
    public long getFixpMinX() {
        return this.fixpMinX;
    }

    @Override
    public long getFixpMinY() {
        return this.fixpMinY;
    }

    @Override
    public long getFixpMaxX() {
        return this.fixpMaxX;
    }

    @Override
    public long getFixpMaxY() {
        return this.fixpMaxY;
    }

    @Override
    public void setFixp(long fixpMinX, long fixpMinY, long fixpMaxX, long fixpMaxY) {
        throw new UnsupportedOperationException();
    }

    void setFixpLow(long fixpMinX, long fixpMinY, long fixpMaxX, long fixpMaxY) {
        this.fixpMinX = fixpMinX;
        this.fixpMinY = fixpMinY;
        this.fixpMaxX = fixpMaxX;
        this.fixpMaxY = fixpMaxY;
    }

    @Override
    public AbstractFixpRectangle createFixp(long fixpMinX, long fixpMinY, long fixpMaxX, long fixpMaxY) {
        throw new UnsupportedOperationException();
    }

    public int getTotal() {
        return this.total;
    }

    void setTotal(int total) {
        this.total = total;
    }

    private RTNode<T> getParent() {
        return this.parent;
    }

    private void setParent(RTNode<T> parent) {
        this.parent = parent;
    }

    public Object getChild(int index) {
        return this.pointers[index];
    }

    public T getChildLeaf(int index) {
        return (T)((RTBounds)this.pointers[index]);
    }

    public RTNode<T> getChildTree(int index) {
        return (RTNode)this.pointers[index];
    }

    void setChild(int index, Object obj) {
        this.pointers[index] = obj;
    }

    public boolean getFlag() {
        return this.flag;
    }

    private void setFlag(boolean flag) {
        this.flag = flag;
    }

    private void setBounds(AbstractFixpRectangle bounds) {
        this.fixpMinX = bounds.getFixpMinX();
        this.fixpMinY = bounds.getFixpMinY();
        this.fixpMaxX = bounds.getFixpMaxX();
        this.fixpMaxY = bounds.getFixpMaxY();
    }

    private void unionBounds(AbstractFixpRectangle bounds) {
        this.fixpMinX = Math.min(this.fixpMinX, bounds.getFixpMinX());
        this.fixpMinY = Math.min(this.fixpMinY, bounds.getFixpMinY());
        this.fixpMaxX = Math.max(this.fixpMaxX, bounds.getFixpMaxX());
        this.fixpMaxY = Math.max(this.fixpMaxY, bounds.getFixpMaxY());
    }

    public static <T extends RTBounds> RTNode<T> makeTopLevel() {
        RTNode<T> top = new RTNode<T>();
        top.total = 0;
        top.flag = true;
        top.parent = null;
        return top;
    }

    public static <T extends RTBounds> RTNode<T> linkGeom(Object env, RTNode<T> root, T geom) {
        if (root == null) {
            return null;
        }
        AbstractFixpRectangle geomBounds = geom.getBounds();
        long geomMinX = geomBounds.getFixpMinX();
        long geomMinY = geomBounds.getFixpMinY();
        long geomMaxX = geomBounds.getFixpMaxX();
        long geomMaxY = geomBounds.getFixpMaxY();
        RTNode<T> rtn = root;
        while (!rtn.getFlag()) {
            double bestExpand = 0.0;
            int bestSubNode = 0;
            for (int i = 0; i < rtn.getTotal(); ++i) {
                RTNode<T> subrtn = rtn.getChildTree(i);
                double area = (double)subrtn.getFixpWidth() * (double)subrtn.getFixpHeight();
                long fixpNewUnionMinX = Math.min(geomMinX, subrtn.fixpMinX);
                long fixpNewUnionMinY = Math.min(geomMinY, subrtn.fixpMinY);
                long fixpNewUnionMaxX = Math.max(geomMaxX, subrtn.fixpMaxX);
                long fixpNewUnionMaxY = Math.max(geomMaxY, subrtn.fixpMaxY);
                double newArea = (double)(fixpNewUnionMaxX - fixpNewUnionMinX) * (double)(fixpNewUnionMaxY - fixpNewUnionMinY);
                double expand = newArea - area;
                if (i != 0 && expand > bestExpand) continue;
                bestExpand = expand;
                bestSubNode = i;
            }
            rtn = rtn.getChildTree(bestSubNode);
        }
        return super.addToRTNode(geom, env, root);
    }

    public static <T extends RTBounds> RTNode<T> unLinkGeom(Object env, RTNode<T> root, T geom) {
        return RTNode.unLinkGeom(env, root, geom, true);
    }

    public static <T extends RTBounds> RTNode<T> unLinkGeom(Object env, RTNode<T> root, T geom, boolean verbose) {
        RTNode whichRTN = null;
        int whichInd = 0;
        if (root == null) {
            return null;
        }
        FindResult<T> result2 = super.findGeom(geom);
        if (result2 != null) {
            whichRTN = ((FindResult)result2).rtnode;
            whichInd = ((FindResult)result2).index;
        } else {
            result2 = super.findGeomAnywhere(geom);
            if (result2 == null) {
                if (verbose) {
                    System.out.println("Internal error: cannot find " + geom + " in R-Tree");
                }
                return root;
            }
            whichRTN = ((FindResult)result2).rtnode;
            whichInd = ((FindResult)result2).index;
            if (verbose) {
                System.out.println("Internal warning: " + geom + " not in proper R-Tree location in " + env);
            }
        }
        return whichRTN.removeRTNode(whichInd, env, root);
    }

    public void printRTree(int indent) {
        if (indent == 0) {
            branchCount = 0;
        }
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            line.append(' ');
        }
        line.append("RTNodeFixp");
        if (this.flag) {
            line.append(" NUMBER ").append(++branchCount);
        }
        RTNode.appendRect(line, this);
        line.append(" has ").append(this.total).append(" children:");
        System.out.println(line);
        for (int j = 0; j < this.total; ++j) {
            if (this.flag) {
                line.setLength(0);
                for (int i = 0; i < indent + 3; ++i) {
                    line.append(' ');
                }
                T child = this.getChildLeaf(j);
                line.append("Child");
                RTNode.appendRect(line, child.getBounds());
                line.append(" is ").append(child);
                System.out.println(line);
                continue;
            }
            this.getChildTree(j).printRTree(indent + 3);
        }
    }

    private static void appendRect(StringBuilder sb, AbstractFixpRectangle r) {
        RTNode.appendRect(sb, r.getFixpMinX(), r.getFixpMinY(), r.getFixpMaxX(), r.getFixpMaxY());
    }

    private static void appendRect(StringBuilder sb, long fixpMinX, long fixpMinY, long fixpMaxX, long fixpMaxY) {
        sb.append(" X(").append(FixpCoord.fixpToLambda(fixpMinX)).append("-").append(FixpCoord.fixpToLambda(fixpMaxX)).append(") Y(").append(FixpCoord.fixpToLambda(fixpMinY)).append("-").append(FixpCoord.fixpToLambda(fixpMaxY)).append(")");
    }

    public void displayRTree(Cell cell) {
        EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
        wnd.clearHighlighting();
        this.displaySubRTree(cell);
        wnd.finishedHighlighting();
    }

    private void displaySubRTree(Cell cell) {
        EditWindow_ wnd = Job.getUserInterface().getCurrentEditWindow_();
        for (int j = 0; j < this.getTotal(); ++j) {
            if (this.getFlag()) {
                wnd.addHighlightArea(this.getChildLeaf(j).getBounds(), cell);
                continue;
            }
            super.displaySubRTree(cell);
        }
    }

    public int tallyRTree() {
        int total = 0;
        if (this.getFlag()) {
            total += this.getTotal();
        } else {
            for (int j = 0; j < this.getTotal(); ++j) {
                total += this.getChildTree(j).tallyRTree();
            }
        }
        return total;
    }

    public void checkRTree(int level, Object env) {
        long minX;
        long minY;
        long maxX;
        long maxY;
        if (this.total == 0) {
            maxY = 0L;
            maxX = 0L;
            minY = 0L;
            minX = 0L;
        } else {
            minY = Long.MAX_VALUE;
            minX = Long.MAX_VALUE;
            maxY = Long.MIN_VALUE;
            maxX = Long.MIN_VALUE;
            for (int i = 0; i < this.total; ++i) {
                AbstractFixpRectangle r = this.getBBox(i);
                minX = Math.min(minX, r.getFixpMinX());
                minY = Math.min(minY, r.getFixpMinY());
                maxX = Math.max(maxX, r.getFixpMaxX());
                maxY = Math.max(maxY, r.getFixpMaxY());
            }
        }
        if (minX != this.fixpMinX || minY != this.fixpMinY || maxX != this.fixpMaxX || maxY != this.fixpMaxY) {
            StringBuilder sb = new StringBuilder();
            sb.append("Tree of ").append(env).append(" at level ").append(level).append(" has bounds");
            RTNode.appendRect(sb, minX, minY, maxX, maxY);
            sb.append(" but stored bounds are");
            RTNode.appendRect(sb, this);
            System.out.println(sb);
            for (int i = 0; i < this.total; ++i) {
                sb.setLength(0);
                sb.append("  ---Child ").append(i).append(" is");
                RTNode.appendRect(sb, this.getBBox(i));
                System.out.println(sb);
            }
        }
        if (!this.flag) {
            for (int j = 0; j < this.total; ++j) {
                this.getChildTree(j).checkRTree(level + 1, env);
            }
        }
    }

    private AbstractFixpRectangle getBBox(int child) {
        return this.flag ? this.getChildLeaf(child).getBounds() : this.getChildTree(child);
    }

    private void figBounds() {
        if (this.total == 0) {
            this.fixpMaxY = 0L;
            this.fixpMaxX = 0L;
            this.fixpMinY = 0L;
            this.fixpMinX = 0L;
            return;
        }
        long minX = Long.MAX_VALUE;
        long minY = Long.MAX_VALUE;
        long maxX = Long.MIN_VALUE;
        long maxY = Long.MIN_VALUE;
        if (this.flag) {
            for (int i = 0; i < this.total; ++i) {
                AbstractFixpRectangle r = this.getChildLeaf(i).getBounds();
                minX = Math.min(minX, r.getFixpMinX());
                minY = Math.min(minY, r.getFixpMinY());
                maxX = Math.max(maxX, r.getFixpMaxX());
                maxY = Math.max(maxY, r.getFixpMaxY());
            }
        } else {
            for (int i = 0; i < this.total; ++i) {
                RTNode<T> subrt = this.getChildTree(i);
                minX = Math.min(minX, subrt.fixpMinX);
                minY = Math.min(minY, subrt.fixpMinY);
                maxX = Math.max(maxX, subrt.fixpMaxX);
                maxY = Math.max(maxY, subrt.fixpMaxY);
            }
        }
        this.fixpMinX = minX;
        this.fixpMinY = minY;
        this.fixpMaxX = maxX;
        this.fixpMaxY = maxY;
    }

    private RTNode<T> addToRTNode(Object rtnInsert, Object env, RTNode<T> root) {
        AbstractFixpRectangle bounds;
        if (this.getTotal() >= 8) {
            RTNode<T> temp = new RTNode<T>();
            temp.setTotal(this.getTotal());
            super.setFlag(this.getFlag());
            for (int i = 0; i < this.getTotal(); ++i) {
                temp.setChild(i, this.getChild(i));
            }
            if (rtnInsert instanceof RTBounds) {
                RTBounds leaf = (RTBounds)rtnInsert;
                bounds = leaf.getBounds();
            } else {
                RTNode tree = (RTNode)rtnInsert;
                bounds = tree;
            }
            long thisFixpCenterX = bounds.getFixpCenterX();
            long thisFixpCenterY = bounds.getFixpCenterY();
            double newDistSq = 0.0;
            int newN = 0;
            for (int i = 0; i < temp.getTotal(); ++i) {
                AbstractFixpRectangle thisv = super.getBBox(i);
                double distSq = Point2D.distanceSq(thisFixpCenterX, thisFixpCenterY, thisv.getFixpCenterX(), thisv.getFixpCenterY());
                if (!(distSq >= newDistSq)) continue;
                newDistSq = distSq;
                newN = i;
            }
            bounds = super.getBBox(newN);
            thisFixpCenterX = bounds.getFixpCenterX();
            thisFixpCenterY = bounds.getFixpCenterY();
            double oldDistSq = 0.0;
            int oldN = 0;
            if (oldN == newN) {
                ++oldN;
            }
            for (int i = 0; i < temp.getTotal(); ++i) {
                AbstractFixpRectangle thisv;
                double distSq;
                if (i == newN || !((distSq = Point2D.distanceSq(thisFixpCenterX, thisFixpCenterY, (thisv = super.getBBox(i)).getFixpCenterX(), thisv.getFixpCenterY())) >= oldDistSq)) continue;
                oldDistSq = distSq;
                oldN = i;
            }
            RTNode<T> newrtn = new RTNode<T>();
            super.setFlag(this.getFlag());
            super.setParent(super.getParent());
            newrtn.setChild(0, temp.getChild(newN));
            newrtn.setTotal(1);
            if (!newrtn.getFlag()) {
                super.setParent(newrtn);
            }
            temp.setChild(newN, null);
            RTNode<T> newBounds = super.getBBox(0);
            super.setBounds(newBounds);
            double newArea = (double)newBounds.getFixpWidth() * (double)newBounds.getFixpHeight();
            this.setChild(0, temp.getChild(oldN));
            if (!this.getFlag()) {
                super.setParent(this);
            }
            for (int i = 1; i < this.getTotal(); ++i) {
                this.setChild(i, null);
            }
            this.setTotal(1);
            temp.setChild(oldN, null);
            RTNode<T> oldBounds = super.getBBox(0);
            super.setBounds(oldBounds);
            double oldArea = (double)oldBounds.getFixpWidth() * (double)oldBounds.getFixpHeight();
            while (true) {
                int curPos;
                int i;
                int bestNewNode = -1;
                int bestOldNode = -1;
                double bestNewExpand = 0.0;
                double bestOldExpand = 0.0;
                for (i = 0; i < temp.getTotal(); ++i) {
                    if (temp.getChild(i) == null) continue;
                    bounds = super.getBBox(i);
                    long fixpNewUnionMinX = Math.min(((AbstractFixpRectangle)newBounds).getFixpMinX(), bounds.getFixpMinX());
                    long fixpNewUnionMinY = Math.min(((AbstractFixpRectangle)newBounds).getFixpMinY(), bounds.getFixpMinY());
                    long fixpNewUnionMaxX = Math.max(((AbstractFixpRectangle)newBounds).getFixpMaxX(), bounds.getFixpMaxX());
                    long fixpNewUnionMaxY = Math.max(((AbstractFixpRectangle)newBounds).getFixpMaxY(), bounds.getFixpMaxY());
                    double newAreaPlus = (double)(fixpNewUnionMaxX - fixpNewUnionMinX) * (double)(fixpNewUnionMaxY - fixpNewUnionMinY);
                    long fixpOldUnionMinX = Math.min(((AbstractFixpRectangle)oldBounds).getFixpMinX(), bounds.getFixpMinX());
                    long fixpOldUnionMinY = Math.min(((AbstractFixpRectangle)oldBounds).getFixpMinY(), bounds.getFixpMinY());
                    long fixpOldUnionMaxX = Math.max(((AbstractFixpRectangle)oldBounds).getFixpMaxX(), bounds.getFixpMaxX());
                    long fixpOldUnionMaxY = Math.max(((AbstractFixpRectangle)oldBounds).getFixpMaxY(), bounds.getFixpMaxY());
                    double oldAreaPlus = (double)(fixpOldUnionMaxX - fixpOldUnionMinX) * (double)(fixpOldUnionMaxY - fixpOldUnionMinY);
                    if (bestNewNode < 0 || newAreaPlus - newArea < bestNewExpand) {
                        bestNewExpand = newAreaPlus - newArea;
                        bestNewNode = i;
                    }
                    if (bestOldNode >= 0 && !(oldAreaPlus - oldArea < bestOldExpand)) continue;
                    bestOldExpand = oldAreaPlus - oldArea;
                    bestOldNode = i;
                }
                if (bestNewNode == -1 && bestOldNode == -1) break;
                if (bestNewNode == bestOldNode) {
                    bestOldNode = -1;
                    for (i = 0; i < temp.getTotal(); ++i) {
                        if (i == bestNewNode || temp.getChild(i) == null) continue;
                        bounds = super.getBBox(i);
                        long fixpOldUnionMinX = Math.min(((AbstractFixpRectangle)oldBounds).getFixpMinX(), bounds.getFixpMinX());
                        long fixpOldUnionMinY = Math.min(((AbstractFixpRectangle)oldBounds).getFixpMinY(), bounds.getFixpMinY());
                        long fixpOldUnionMaxX = Math.max(((AbstractFixpRectangle)oldBounds).getFixpMaxX(), bounds.getFixpMaxX());
                        long fixpOldUnionMaxY = Math.max(((AbstractFixpRectangle)oldBounds).getFixpMaxY(), bounds.getFixpMaxY());
                        double oldAreaPlus = (double)(fixpOldUnionMaxX - fixpOldUnionMinX) * (double)(fixpOldUnionMaxY - fixpOldUnionMinY);
                        if (bestOldNode >= 0 && !(oldAreaPlus - oldArea < bestOldExpand)) continue;
                        bestOldExpand = oldAreaPlus - oldArea;
                        bestOldNode = i;
                    }
                }
                if (bestOldNode != -1) {
                    curPos = this.getTotal();
                    this.setChild(curPos, temp.getChild(bestOldNode));
                    if (!this.getFlag()) {
                        super.setParent(this);
                    }
                    this.setTotal(curPos + 1);
                    temp.setChild(bestOldNode, null);
                    super.unionBounds(super.getBBox(curPos));
                    oldBounds = this;
                    oldArea = (double)oldBounds.getFixpWidth() * (double)oldBounds.getFixpHeight();
                }
                if (bestNewNode == -1) continue;
                curPos = newrtn.getTotal();
                newrtn.setChild(curPos, temp.getChild(bestNewNode));
                newrtn.setTotal(curPos + 1);
                if (!newrtn.getFlag()) {
                    super.setParent(newrtn);
                }
                temp.setChild(bestNewNode, null);
                super.unionBounds(super.getBBox(curPos));
                newBounds = newrtn;
                newArea = (double)newBounds.getFixpWidth() * (double)newBounds.getFixpHeight();
            }
            if (temp.getTotal() != this.getTotal() + newrtn.getTotal()) {
                System.out.println("R-trees: " + temp.getTotal() + " nodes split to " + this.getTotal() + " and " + newrtn.getTotal() + "!");
            }
            if (super.getParent() == null) {
                assert (root == this);
                RTNode<T> newroot = new RTNode<T>();
                newroot.setTotal(2);
                newroot.setChild(0, this);
                newroot.setChild(1, newrtn);
                super.setFlag(false);
                super.setParent(null);
                super.setParent(newroot);
                super.setParent(newroot);
                super.figBounds();
                root = newroot;
            } else {
                RTNode<T> r = super.getParent();
                while (r != null) {
                    super.figBounds();
                    r = super.getParent();
                }
                root = super.addToRTNode(newrtn, env, root);
            }
        }
        int curPos = this.getTotal();
        this.setChild(curPos, rtnInsert);
        this.setTotal(curPos + 1);
        bounds = this.getBBox(curPos);
        if (this.getTotal() == 1 && this.getParent() == null) {
            this.setBounds(bounds);
            return root;
        }
        RTNode<T> climb = this;
        while (true) {
            climb.unionBounds(bounds);
            if (climb.getParent() == null) break;
            climb = climb.getParent();
        }
        return root;
    }

    private RTNode<T> removeRTNode(int ind, Object env, RTNode<T> root) {
        int j = 0;
        for (int i = 0; i < this.getTotal(); ++i) {
            if (i == ind) continue;
            this.setChild(j++, this.getChild(i));
        }
        this.setTotal(j);
        if (this.getTotal() < 4) {
            RTNode<T> prtn = this.getParent();
            if (prtn == null) {
                int i;
                if (this.getFlag()) {
                    this.figBounds();
                    return root;
                }
                RTNode<T> temp = new RTNode<T>();
                temp.setTotal(this.getTotal());
                super.setFlag(true);
                for (i = 0; i < this.getTotal(); ++i) {
                    temp.setChild(i, this.getChild(i));
                }
                this.setTotal(0);
                super.setFlag(true);
                for (i = 0; i < temp.getTotal(); ++i) {
                    root = super.reInsert(env, root);
                }
                return root;
            }
            int found = -1;
            for (int i = 0; i < prtn.getTotal(); ++i) {
                if (prtn.getChild(i) != this) continue;
                found = i;
                break;
            }
            if (found < 0) {
                System.out.println("R-trees: cannot find entry in parent");
            }
            root = super.removeRTNode(found, env, root);
            return super.reInsert(env, root);
        }
        RTNode<T> climb = this;
        while (true) {
            climb.figBounds();
            if (climb.getParent() == null) break;
            climb = climb.getParent();
        }
        return root;
    }

    private RTNode<T> reInsert(Object env, RTNode<T> root) {
        if (this.getFlag()) {
            for (int i = 0; i < this.getTotal(); ++i) {
                root = RTNode.linkGeom(env, root, this.getChildLeaf(i));
            }
        } else {
            for (int i = 0; i < this.getTotal(); ++i) {
                root = super.reInsert(env, root);
            }
        }
        return root;
    }

    private FindResult<T> findGeom(T geom) {
        if (this.getFlag()) {
            for (int i = 0; i < this.getTotal(); ++i) {
                if (this.getChildLeaf(i) != geom) continue;
                return new FindResult(this, i);
            }
            return null;
        }
        AbstractFixpRectangle geomBounds = geom.getBounds();
        for (int i = 0; i < this.getTotal(); ++i) {
            FindResult<T> subRet;
            AbstractFixpRectangle bounds = this.getBBox(i);
            if (bounds.getFixpMaxX() < geomBounds.getFixpMinX() || bounds.getFixpMinX() > geomBounds.getFixpMaxX() || bounds.getFixpMaxY() < geomBounds.getFixpMinY() || bounds.getFixpMinY() > geomBounds.getFixpMaxY() || (subRet = super.findGeom(geom)) == null) continue;
            return subRet;
        }
        return null;
    }

    private FindResult<T> findGeomAnywhere(T geom) {
        if (this.getFlag()) {
            for (int i = 0; i < this.getTotal(); ++i) {
                if (this.getChildLeaf(i) != geom) continue;
                return new FindResult(this, i);
            }
            return null;
        }
        for (int i = 0; i < this.getTotal(); ++i) {
            FindResult<T> retVal = super.findGeomAnywhere(geom);
            if (retVal == null) continue;
            return retVal;
        }
        return null;
    }

    public static class Search<T extends RTBounds>
    implements Iterator<T> {
        private static final int MAXDEPTH = 100;
        private int depth = 0;
        private final RTNode<T>[] rtn = new RTNode[100];
        private int[] position = new int[100];
        private final long searchBoundsMinX;
        private final long searchBoundsMinY;
        private final long searchBoundsMaxX;
        private final long searchBoundsMaxY;
        private T nextObj;
        private final boolean includeEdges;

        public Search(Rectangle2D bounds, RTNode<T> root, boolean includeEdges) {
            this.rtn[0] = root;
            if (bounds instanceof AbstractFixpRectangle) {
                AbstractFixpRectangle fr = (AbstractFixpRectangle)bounds;
                this.searchBoundsMinX = fr.getFixpMinX();
                this.searchBoundsMinY = fr.getFixpMinY();
                this.searchBoundsMaxX = fr.getFixpMaxX();
                this.searchBoundsMaxY = fr.getFixpMaxY();
            } else {
                this.searchBoundsMinX = FixpCoord.lambdaToFixp(bounds.getMinX());
                this.searchBoundsMinY = FixpCoord.lambdaToFixp(bounds.getMinY());
                this.searchBoundsMaxX = FixpCoord.lambdaToFixp(bounds.getMaxX());
                this.searchBoundsMaxY = FixpCoord.lambdaToFixp(bounds.getMaxY());
            }
            this.includeEdges = includeEdges;
            this.nextObj = null;
        }

        public Search(RTNode<T> root) {
            this.rtn[0] = root;
            this.searchBoundsMinX = ((RTNode)root).fixpMinX;
            this.searchBoundsMinY = ((RTNode)root).fixpMinY;
            this.searchBoundsMaxX = ((RTNode)root).fixpMaxX;
            this.searchBoundsMaxY = ((RTNode)root).fixpMaxY;
            this.includeEdges = false;
            this.nextObj = null;
        }

        private T nextObject() {
            while (true) {
                int i;
                RTNode<T> rtnode = this.rtn[this.depth];
                int n = this.depth;
                this.position[n] = this.position[n] + 1;
                if (i < rtnode.getTotal()) {
                    AbstractFixpRectangle nodeBounds = ((RTNode)rtnode).getBBox(i);
                    if (!this.includeEdges ? nodeBounds.getFixpMaxX() <= this.searchBoundsMinX || nodeBounds.getFixpMinX() >= this.searchBoundsMaxX || nodeBounds.getFixpMaxY() <= this.searchBoundsMinY || nodeBounds.getFixpMinY() >= this.searchBoundsMaxY : nodeBounds.getFixpMaxX() < this.searchBoundsMinX || nodeBounds.getFixpMinX() > this.searchBoundsMaxX || nodeBounds.getFixpMaxY() < this.searchBoundsMinY || nodeBounds.getFixpMinY() > this.searchBoundsMaxY) continue;
                    if (rtnode.getFlag()) {
                        return rtnode.getChildLeaf(i);
                    }
                    if (this.depth >= 99) {
                        System.out.println("R-trees: search too deep");
                        continue;
                    }
                    ++this.depth;
                    this.rtn[this.depth] = rtnode.getChildTree(i);
                    this.position[this.depth] = 0;
                    continue;
                }
                if (this.depth == 0) break;
                --this.depth;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.nextObj == null) {
                this.nextObj = this.nextObject();
            }
            return this.nextObj != null;
        }

        @Override
        public T next() {
            if (this.nextObj != null) {
                T ret = this.nextObj;
                this.nextObj = null;
                return ret;
            }
            return this.nextObject();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Search.remove()");
        }
    }

    private static class FindResult<T extends RTBounds> {
        private final RTNode<T> rtnode;
        private int index;

        private FindResult(RTNode<T> rtnode, int index) {
            this.rtnode = rtnode;
            this.index = index;
        }
    }
}

