/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.math.DBMath;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class MimicStitch {
    private static InteractiveRouter router = null;
    private static final int NUMSITUATIONS = 7;
    private static final int LIKELYDIFFPORT = 1;
    private static final int LIKELYDIFFPORTWIDTH = 2;
    private static final int LIKELYDIFFARCCOUNT = 4;
    private static final int LIKELYDIFFNODETYPE = 8;
    private static final int LIKELYDIFFNODESIZE = 16;
    private static final int LIKELYARCSSAMEDIR = 32;
    private static final int LIKELYALREADYCONNECTED = 64;
    private static int[] situations = null;

    private static void buildLikelySituations() {
        int i;
        if (situations != null) {
            return;
        }
        int numSituations = 128;
        ArrayList<Integer> allSituations = new ArrayList<Integer>();
        for (i = 0; i < numSituations; ++i) {
            allSituations.add(new Integer(i));
        }
        Collections.sort(allSituations, new SituationSorter());
        situations = new int[numSituations];
        for (i = 0; i < numSituations; ++i) {
            MimicStitch.situations[i] = (Integer)allSituations.get(i);
        }
    }

    public static void mimicStitch(EditingPreferences ep, boolean forced) {
        MimicStitch.buildLikelySituations();
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.needCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        Routing.Activity lastActivity = Routing.getRoutingTool().getLastActivity();
        if (lastActivity == null) {
            System.out.println("No wiring activity to mimic");
            return;
        }
        if (lastActivity.numDeletedArcs == 1 && lastActivity.numCreatedArcs == 0) {
            MimicStitch.mimicdelete(lastActivity, ep);
            lastActivity.numDeletedArcs = 0;
            return;
        }
        if (lastActivity.numCreatedArcs == 1) {
            ArcInst ai = EDatabase.clientDatabase().getCell(lastActivity.createdArcsParents[0]).getArcById(lastActivity.createdArcs[0].arcId);
            new MimicStitchJob(ai, 0, ai, 1, ai.getLambdaBaseWidth(), ai.getProto(), 0.0, 0.0, forced);
            lastActivity.numCreatedArcs = 0;
            return;
        }
        if (lastActivity.numCreatedArcs > 1 && lastActivity.numCreatedNodes > 0) {
            HashSet<NodeInst> gotOne = new HashSet<NodeInst>();
            HashSet<NodeInst> gotMany = new HashSet<NodeInst>();
            for (int i = 0; i < lastActivity.numCreatedArcs; ++i) {
                ArcInst ai = EDatabase.clientDatabase().getCell(lastActivity.createdArcsParents[i]).getArcById(lastActivity.createdArcs[i].arcId);
                for (int e = 0; e < 2; ++e) {
                    NodeInst ni = ai.getPortInst(e).getNodeInst();
                    if (gotMany.contains(ni)) continue;
                    if (!gotOne.contains(ni)) {
                        gotOne.add(ni);
                        continue;
                    }
                    gotOne.remove(ni);
                    gotMany.add(ni);
                }
            }
            int foundEnds = 0;
            Connection[] ends2 = new Connection[2];
            double width = 0.0;
            for (int i = 0; i < lastActivity.numCreatedArcs; ++i) {
                ArcInst ai = EDatabase.clientDatabase().getCell(lastActivity.createdArcsParents[i]).getArcById(lastActivity.createdArcs[i].arcId);
                for (int e = 0; e < 2; ++e) {
                    NodeInst ni = ai.getPortInst(e).getNodeInst();
                    if (!gotOne.contains(ni)) continue;
                    if (foundEnds < 2) {
                        ends2[foundEnds] = ai.getConnection(e);
                        if (ai.getLambdaBaseWidth() > width) {
                            width = ai.getLambdaBaseWidth();
                        }
                    }
                    ++foundEnds;
                }
            }
            if (foundEnds == 2) {
                double prefX = 0.0;
                double prefY = 0.0;
                if (lastActivity.numCreatedNodes == 1) {
                    Poly portPoly0 = ends2[0].getPortInst().getPoly();
                    double x0 = portPoly0.getCenterX();
                    double y0 = portPoly0.getCenterY();
                    Poly portPoly1 = ends2[1].getPortInst().getPoly();
                    double x1 = portPoly1.getCenterX();
                    double y1 = portPoly1.getCenterY();
                    prefX = lastActivity.createdNodes[0].anchor.getLambdaX() - (x0 + x1) / 2.0;
                    prefY = lastActivity.createdNodes[0].anchor.getLambdaY() - (y0 + y1) / 2.0;
                } else if (lastActivity.numCreatedNodes == 2) {
                    Poly portPoly0 = ends2[0].getPortInst().getPoly();
                    double x0 = portPoly0.getCenterX();
                    double y0 = portPoly0.getCenterY();
                    Poly portPoly1 = ends2[1].getPortInst().getPoly();
                    double x1 = portPoly1.getCenterX();
                    double y1 = portPoly1.getCenterY();
                    prefX = (lastActivity.createdNodes[0].anchor.getLambdaX() + lastActivity.createdNodes[1].anchor.getLambdaX()) / 2.0 - (x0 + x1) / 2.0;
                    prefY = (lastActivity.createdNodes[0].anchor.getLambdaY() + lastActivity.createdNodes[1].anchor.getLambdaY()) / 2.0 - (y0 + y1) / 2.0;
                }
                new MimicStitchJob(ends2[0].getArc(), ends2[0].getEndIndex(), ends2[1].getArc(), ends2[1].getEndIndex(), width, null, prefX, prefY, forced);
            }
            lastActivity.numCreatedArcs = 0;
            return;
        }
    }

    private static void mimicdelete(Routing.Activity activity, EditingPreferences ep) {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.needCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        ImmutableArcInst mimicAi = activity.deletedArc;
        Cell cell = Cell.inCurrentThread(activity.deletedArcParent);
        if (cell == null) {
            return;
        }
        NodeInst mimicNiHead = cell.getNodeById(mimicAi.headNodeId);
        NodeInst mimicNiTail = cell.getNodeById(mimicAi.tailNodeId);
        if (mimicNiHead == null || mimicNiTail == null) {
            return;
        }
        ArcProtoId typ = mimicAi.protoId;
        EPoint pt0 = mimicAi.headLocation;
        EPoint pt1 = mimicAi.tailLocation;
        double dist = ((Point2D)pt0).distance(pt1);
        int angle = 0;
        if (dist != 0.0) {
            angle = DBMath.figureAngle(pt0, pt1);
        }
        ArrayList<PossibleArc> arcKills = new ArrayList<PossibleArc>();
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            int con2;
            int thisAngle;
            EPoint end1;
            EPoint end0;
            double thisDist;
            ArcInst ai = it.next();
            if (ai.getProto().getId() != typ || dist != (thisDist = ((Point2D)(end0 = ai.getHeadLocation())).distance(end1 = ai.getTailLocation())) || dist != 0.0 && angle % 1800 != (thisAngle = DBMath.figureAngle(end0, end1)) % 1800) continue;
            PossibleArc pa = new PossibleArc();
            pa.ai = ai;
            pa.situation = 0;
            boolean matchPort = false;
            if (ai.getHeadPortInst().getPortProto().getId() == activity.deletedPorts[0] && ai.getTailPortInst().getPortProto().getId() == activity.deletedPorts[1]) {
                matchPort = true;
            }
            if (ai.getHeadPortInst().getPortProto().getId() == activity.deletedPorts[1] && ai.getTailPortInst().getPortProto().getId() == activity.deletedPorts[0]) {
                matchPort = true;
            }
            if (!matchPort) {
                pa.situation |= 1;
            }
            NodeInst niHead = ai.getHeadPortInst().getNodeInst();
            NodeInst niTail = ai.getTailPortInst().getNodeInst();
            int con1 = mimicNiHead.getNumConnections() + mimicNiTail.getNumConnections() + 2;
            if (con1 != (con2 = niHead.getNumConnections() + niTail.getNumConnections())) {
                pa.situation |= 4;
            }
            boolean matchNode = false;
            if (niHead.getProto() == mimicNiHead.getProto() && niTail.getProto() == mimicNiTail.getProto()) {
                matchNode = true;
            }
            if (niHead.getProto() == mimicNiTail.getProto() && niTail.getProto() == mimicNiHead.getProto()) {
                matchNode = true;
            }
            if (!matchNode) {
                pa.situation |= 8;
            }
            double mimicWidHead = mimicNiHead.getLambdaBaseXSize();
            double mimicHeiHead = mimicNiHead.getLambdaBaseYSize();
            double mimicWidTail = mimicNiTail.getLambdaBaseXSize();
            double mimicHeiTail = mimicNiTail.getLambdaBaseYSize();
            double widHead = niHead.getLambdaBaseXSize();
            double heiHead = niHead.getLambdaBaseYSize();
            double widTail = niTail.getLambdaBaseXSize();
            double heiTail = niTail.getLambdaBaseYSize();
            if (widHead != mimicWidHead || heiHead != mimicHeiHead) {
                pa.situation |= 16;
            }
            if (widTail != mimicWidTail || heiTail != mimicHeiTail) {
                pa.situation |= 16;
            }
            arcKills.add(pa);
        }
        MimicOptions prefs = new MimicOptions();
        prefs.getOptionsFromPreferences();
        MimicStitch.processPossibilities(cell, arcKills, 0.0, 0.0, Job.Type.CLIENT_EXAMINE, true, ep, prefs);
    }

    public static void mimicOneArc(ArcInst ai1, int end1, ArcInst ai2, int end2, double oWidth, ArcProto oProto, double prefX, double prefY, boolean forced, Job.Type method, EditingPreferences ep, MimicOptions prefs, Job theJob) {
        if (forced) {
            System.out.println("Mimicing last arc...");
        }
        MimicStitch.buildLikelySituations();
        PortInst[] endPi = new PortInst[2];
        Connection conn1 = ai1.getConnection(end1);
        Connection conn2 = ai2.getConnection(end2);
        endPi[0] = conn1.getPortInst();
        endPi[1] = conn2.getPortInst();
        Point2D[] endPts = new Point2D[]{conn1.getLocation(), conn2.getLocation()};
        Cell cell = endPi[0].getNodeInst().getParent();
        Netlist netlist = cell.getNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted mimic-routing (network information unavailable).  Please try again");
            return;
        }
        int busWidth = netlist.getBusWidth(ai1);
        ArrayList<PossibleArc> possibleArcs = new ArrayList<PossibleArc>();
        int con1 = endPi[0].getNodeInst().getNumConnections() + endPi[1].getNodeInst().getNumConnections() - 2;
        HashMap<PortInst, Poly> cachedPortPoly = new HashMap<PortInst, Poly>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                if (oProto != null && !pi.getPortProto().connectsTo(oProto)) continue;
                cachedPortPoly.put(pi, pi.getPoly());
            }
        }
        if (cachedPortPoly.size() == 0) {
            return;
        }
        for (int end = 0; end < 2; ++end) {
            PortInst pi0 = endPi[end];
            PortInst pi1 = endPi[1 - end];
            NodeInst node0 = pi0.getNodeInst();
            NodeInst node1 = pi1.getNodeInst();
            PortProto port0 = pi0.getPortProto();
            PortProto port1 = pi1.getPortProto();
            Point2D pt0 = endPts[end];
            Point2D pt1 = endPts[1 - end];
            double dist = pt0.distance(pt1);
            double distX = pt1.getX() - pt0.getX();
            double distY = pt1.getY() - pt0.getY();
            int angle = 0;
            if (dist != 0.0) {
                angle = DBMath.figureAngle(pt0, pt1);
            }
            boolean useFAngle = false;
            double angleRadians = 0.0;
            if (angle % 900 != 0) {
                angleRadians = DBMath.figureAngleRadians(pt0, pt1);
                useFAngle = true;
            }
            Poly port0Poly = pi0.getPoly();
            double end0Offx = pt0.getX() - port0Poly.getCenterX();
            double end0Offy = pt0.getY() - port0Poly.getCenterY();
            double node0Wid = node0.getLambdaBaseXSize();
            double node0Hei = node0.getLambdaBaseYSize();
            double node1Wid = node1.getLambdaBaseXSize();
            double node1Hei = node1.getLambdaBaseYSize();
            Iterator<NodeInst> it2 = cell.getNodes();
            while (it2.hasNext()) {
                NodeInst ni = it2.next();
                ERectangle bounds = ni.getBounds();
                if (theJob != null && theJob.checkAbort()) {
                    System.out.println("Mimic Arc Job aborted");
                    return;
                }
                Iterator<NodeInst> oIt = cell.getNodes();
                while (oIt.hasNext()) {
                    NodeInst oNi = oIt.next();
                    ERectangle oBounds = oNi.getBounds();
                    if ((node0 != node1 ? ni == oNi : ni != oNi) || (!(distX > 0.0) ? ((RectangularShape)bounds).getMinX() + distX > ((RectangularShape)oBounds).getMaxX() || ((RectangularShape)bounds).getMaxX() + distX < ((RectangularShape)oBounds).getMinX() : ((RectangularShape)bounds).getMaxX() + distX < ((RectangularShape)oBounds).getMinX() || ((RectangularShape)bounds).getMinX() + distX > ((RectangularShape)oBounds).getMaxX())) continue;
                    if (distY > 0.0 ? ((RectangularShape)bounds).getMaxY() + distY < ((RectangularShape)oBounds).getMinY() || ((RectangularShape)bounds).getMinY() + distY > ((RectangularShape)oBounds).getMaxY() : ((RectangularShape)bounds).getMinY() + distY > ((RectangularShape)oBounds).getMaxY() || ((RectangularShape)bounds).getMaxY() + distY < ((RectangularShape)oBounds).getMinY()) continue;
                    Iterator<PortInst> pIt = ni.getPortInsts();
                    while (pIt.hasNext()) {
                        PortInst pi = pIt.next();
                        PortProto pp = pi.getPortProto();
                        Poly poly = (Poly)cachedPortPoly.get(pi);
                        if (poly == null) continue;
                        double x0 = poly.getCenterX();
                        double y0 = poly.getCenterY();
                        double wantX1 = x0 += end0Offx;
                        double wantY1 = y0 += end0Offy;
                        if (dist != 0.0) {
                            if (useFAngle) {
                                wantX1 = x0 + Math.cos(angleRadians) * dist;
                                wantY1 = y0 + Math.sin(angleRadians) * dist;
                            } else {
                                wantX1 = x0 + DBMath.cos(angle) * dist;
                                wantY1 = y0 + DBMath.sin(angle) * dist;
                            }
                        }
                        Point2D.Double xy0 = new Point2D.Double(x0, y0);
                        Point2D.Double want1 = new Point2D.Double(wantX1, wantY1);
                        Iterator<PortInst> oPIt = oNi.getPortInsts();
                        while (oPIt.hasNext()) {
                            int existingAngle;
                            int thisend;
                            ArcInst oAi;
                            PortInst aPi;
                            Connection con;
                            boolean ptInPoly;
                            Poly thisPoly;
                            PortInst oPi = oPIt.next();
                            PortProto oPp = oPi.getPortProto();
                            if (ni == oNi && pp == oPp || (thisPoly = (Poly)cachedPortPoly.get(oPi)) == null || pi == pi0 && oPi == pi1 || !(ptInPoly = thisPoly.isInside(want1))) continue;
                            int situation = 0;
                            if (netlist.sameNetwork(ni, pp, oNi, oPp)) {
                                situation |= 0x40;
                            }
                            int desiredAngle = -1;
                            if (x0 != wantX1 || y0 != wantY1) {
                                desiredAngle = DBMath.figureAngle(xy0, want1);
                            }
                            Iterator<Connection> pII = ni.getConnections();
                            while (pII.hasNext()) {
                                con = pII.next();
                                aPi = con.getPortInst();
                                if (aPi.getPortProto() != pp) continue;
                                oAi = con.getArc();
                                if (desiredAngle < 0) {
                                    if (oAi.getHeadLocation().getX() != oAi.getTailLocation().getX() || oAi.getHeadLocation().getY() != oAi.getTailLocation().getY()) continue;
                                    situation |= 0x20;
                                    break;
                                }
                                if (oAi.getHeadLocation().getX() == oAi.getTailLocation().getX() && oAi.getHeadLocation().getY() == oAi.getTailLocation().getY()) continue;
                                thisend = 0;
                                if (oAi.getTailPortInst() == aPi) {
                                    thisend = 1;
                                }
                                if ((existingAngle = DBMath.figureAngle(oAi.getLocation(thisend), oAi.getLocation(1 - thisend))) != desiredAngle) continue;
                                situation |= 0x20;
                                break;
                            }
                            desiredAngle = -1;
                            if (x0 != wantX1 || y0 != wantY1) {
                                desiredAngle = DBMath.figureAngle(want1, xy0);
                            }
                            pII = oNi.getConnections();
                            while (pII.hasNext()) {
                                con = pII.next();
                                aPi = con.getPortInst();
                                if (aPi.getPortProto() != oPp) continue;
                                oAi = con.getArc();
                                if (desiredAngle < 0) {
                                    if (oAi.getHeadLocation().getX() != oAi.getTailLocation().getX() || oAi.getHeadLocation().getY() != oAi.getTailLocation().getY()) continue;
                                    situation |= 0x20;
                                    break;
                                }
                                if (oAi.getHeadLocation().getX() == oAi.getTailLocation().getX() && oAi.getHeadLocation().getY() == oAi.getTailLocation().getY()) continue;
                                thisend = 0;
                                if (oAi.getTailPortInst() == aPi) {
                                    thisend = 1;
                                }
                                if ((existingAngle = DBMath.figureAngle(oAi.getLocation(thisend), oAi.getLocation(1 - thisend))) != desiredAngle) continue;
                                situation |= 0x20;
                                break;
                            }
                            if (pp instanceof Export && oPp instanceof Export) {
                                int e0Wid = netlist.getBusWidth((Export)pp);
                                int e1Wid = netlist.getBusWidth((Export)oPp);
                                if (e0Wid != busWidth || e1Wid != busWidth) {
                                    situation |= 2;
                                }
                            } else if (busWidth != 1) {
                                situation |= 2;
                            }
                            int con2 = ni.getNumConnections() + oNi.getNumConnections();
                            if (con1 != con2) {
                                situation |= 4;
                            }
                            if (ni.getProto() != node0.getProto() || oNi.getProto() != node1.getProto()) {
                                situation |= 8;
                            } else if (pp != port0 || oPp != port1) {
                                situation |= 1;
                            }
                            double wid = ni.getLambdaBaseXSize();
                            double hei = ni.getLambdaBaseYSize();
                            if (wid != node0Wid || hei != node0Hei) {
                                situation |= 0x10;
                            }
                            wid = oNi.getLambdaBaseXSize();
                            hei = oNi.getLambdaBaseYSize();
                            if (wid != node1Wid || hei != node1Hei) {
                                situation |= 0x10;
                            }
                            PossibleArc found = null;
                            for (PossibleArc pa : possibleArcs) {
                                if (pa.ni1 == ni && pa.pp1 == pp && pa.ni2 == oNi && pa.pp2 == oPp) {
                                    found = pa;
                                    break;
                                }
                                if (pa.ni2 != ni || pa.pp2 != pp || pa.ni1 != oNi || pa.pp1 != oPp) continue;
                                found = pa;
                                break;
                            }
                            if (found != null) {
                                if (found.situation == situation) continue;
                                int foundIndex = -1;
                                for (int k = 0; k < situations.length && found.situation != situations[k]; ++k) {
                                    if (situation != situations[k]) continue;
                                    foundIndex = k;
                                    break;
                                }
                                if (foundIndex >= 0 && found.situation == situations[foundIndex]) continue;
                            }
                            if (found == null) {
                                found = new PossibleArc();
                                possibleArcs.add(found);
                            }
                            found.ni1 = ni;
                            found.pp1 = pp;
                            found.ni2 = oNi;
                            found.pp2 = oPp;
                            found.situation = situation;
                        }
                    }
                }
            }
        }
        MimicStitch.processPossibilities(cell, possibleArcs, prefX, prefY, method, forced, ep, prefs);
    }

    private static void processPossibilities(Cell cell, List<PossibleArc> possibleArcs, double prefX, double prefY, Job.Type method, boolean forced, EditingPreferences ep, MimicOptions prefs) {
        router = new SimpleWirer(ep);
        if (prefs.mimicInteractive) {
            MimicInteractive task = new MimicInteractive(cell, possibleArcs, prefX, prefY);
            SwingUtilities.invokeLater(task);
            return;
        }
        int ifIgnorePorts = 0;
        int ifIgnorePortWidth = 0;
        int ifIgnoreArcCount = 0;
        int ifIgnoreNodeType = 0;
        int ifIgnoreNodeSize = 0;
        int ifIgnoreOtherSameDir = 0;
        int ifAlreadyConnected = 0;
        int count2 = 0;
        boolean deletion = false;
        for (int j = 0; j < situations.length; ++j) {
            ArrayList<Route> allRoutes = new ArrayList<Route>();
            ArrayList<ArcInst> allKills = new ArrayList<ArcInst>();
            int total = 0;
            for (PossibleArc pa : possibleArcs) {
                if (pa.ai != null) {
                    deletion = true;
                }
                if (pa.situation != situations[j]) continue;
                ++total;
                if (pa.ai != null) {
                    allKills.add(pa.ai);
                    continue;
                }
                Poly portPoly1 = pa.ni1.getShapeOfPort(pa.pp1);
                Poly portPoly2 = pa.ni2.getShapeOfPort(pa.pp2);
                Point2D.Double bend = new Point2D.Double((portPoly1.getCenterX() + portPoly2.getCenterX()) / 2.0 + prefX, (portPoly1.getCenterY() + portPoly2.getCenterY()) / 2.0 + prefY);
                PortInst pi1 = pa.ni1.findPortInstFromEquivalentProto(pa.pp1);
                PortInst pi2 = pa.ni2.findPortInstFromEquivalentProto(pa.pp2);
                Route route = router.planRoute(pa.ni1.getParent(), pi1, pi2, bend, null, ep, true, true, null, null);
                if (route.size() == 0) {
                    System.out.println("Problem creating arc");
                    continue;
                }
                allRoutes.add(route);
            }
            if (total == 0) continue;
            if (prefs.matchPorts && (situations[j] & 1) != 0) {
                ifIgnorePorts += total;
                continue;
            }
            if (prefs.matchPortWidth && (situations[j] & 2) != 0) {
                ifIgnorePortWidth += total;
                continue;
            }
            if (prefs.matchArcCount && (situations[j] & 4) != 0) {
                ifIgnoreArcCount += total;
                continue;
            }
            if (prefs.matchNodeType && (situations[j] & 8) != 0) {
                ifIgnoreNodeType += total;
                continue;
            }
            if (prefs.matchNodeSize && (situations[j] & 0x10) != 0) {
                ifIgnoreNodeSize += total;
                continue;
            }
            if (prefs.noOtherArcsThisDir && (situations[j] & 0x20) != 0) {
                ifIgnoreOtherSameDir += total;
                continue;
            }
            if (prefs.notAlreadyConnected && (situations[j] & 0x40) != 0) {
                ifAlreadyConnected += total;
                continue;
            }
            if (method == Job.Type.CLIENT_EXAMINE) {
                new MimicWireJob(allRoutes, allKills, false, prefs);
            } else {
                MimicStitch.runTheWires(allRoutes, ep);
            }
            count2 += total;
        }
        if (count2 == 0 && forced) {
            String activity = deletion ? "deleted" : "added";
            String msg = "No wires " + activity;
            if (ifIgnorePorts != 0) {
                msg = msg + ", might have " + activity + " " + ifIgnorePorts + " wires if 'ports must match' were off";
            }
            if (ifIgnorePortWidth != 0) {
                msg = msg + ", might have " + activity + " " + ifIgnorePortWidth + " wires if 'ports must match width' were off";
            }
            if (ifIgnoreArcCount != 0) {
                msg = msg + ", might have " + activity + " " + ifIgnoreArcCount + " wires if 'number of existing arcs must match' were off";
            }
            if (ifIgnoreNodeType != 0) {
                msg = msg + ", might have " + activity + " " + ifIgnoreNodeType + " wires if 'node types must match' were off";
            }
            if (ifIgnoreNodeSize != 0) {
                msg = msg + ", might have " + activity + " " + ifIgnoreNodeSize + " wires if 'nodes sizes must match' were off";
            }
            if (ifIgnoreOtherSameDir != 0) {
                msg = msg + ", might have " + activity + " " + ifIgnoreOtherSameDir + " wires if 'cannot have other arcs in the same direction' were off";
            }
            if (ifAlreadyConnected != 0) {
                msg = msg + ", might have " + activity + " " + ifAlreadyConnected + " wires if 'ignore if already connected elsewhere' were off";
            }
            System.out.println(msg);
            if (ifIgnorePorts + ifIgnoreArcCount + ifIgnoreNodeType + ifIgnoreNodeSize + ifIgnoreOtherSameDir != 0) {
                System.out.println(" (settings are in the Tools / Routing tab of the Preferences)");
            }
        }
    }

    private static List<PortInst> runTheWires(List<Route> allRoutes, EditingPreferences ep) {
        ArrayList<PortInst> portsToHighlight = new ArrayList<PortInst>();
        HashMap<ArcProto, Integer> arcsCreatedMap = new HashMap<ArcProto, Integer>();
        HashMap<NodeProto, Integer> nodesCreatedMap = new HashMap<NodeProto, Integer>();
        for (Route route : allRoutes) {
            PortInst showThis;
            RouteElement re = (RouteElement)route.get(0);
            Cell c = re.getCell();
            Router.createRouteNoJob(route, c, arcsCreatedMap, nodesCreatedMap, ep);
            RouteElementPort finalRE = route.getEnd();
            if (finalRE == null || (showThis = finalRE.getPortInst()) == null) continue;
            portsToHighlight.add(showThis);
        }
        boolean beep = User.isPlayClickSoundsWhenCreatingArcs();
        Router.reportRoutingResults("MIMIC ROUTING", arcsCreatedMap, nodesCreatedMap, beep);
        return portsToHighlight;
    }

    private static void presentNextSituation(int count2, int situationNumber, List<PossibleArc> possibleArcs, Cell cell, double prefX, double prefY, EditingPreferences ep) {
        for (int j = situationNumber; j < situations.length; ++j) {
            ArrayList<Route> allRoutes = new ArrayList<Route>();
            ArrayList<ArcInst> allKills = new ArrayList<ArcInst>();
            int total = 0;
            for (PossibleArc pa : possibleArcs) {
                if (pa.situation != situations[j]) continue;
                ++total;
                if (pa.ai != null) {
                    allKills.add(pa.ai);
                    continue;
                }
                Poly portPoly1 = pa.ni1.getShapeOfPort(pa.pp1);
                Poly portPoly2 = pa.ni2.getShapeOfPort(pa.pp2);
                Point2D.Double bend = new Point2D.Double((portPoly1.getCenterX() + portPoly2.getCenterX()) / 2.0 + prefX, (portPoly1.getCenterY() + portPoly2.getCenterY()) / 2.0 + prefY);
                PortInst pi1 = pa.ni1.findPortInstFromEquivalentProto(pa.pp1);
                PortInst pi2 = pa.ni2.findPortInstFromEquivalentProto(pa.pp2);
                Route route = router.planRoute(pa.ni1.getParent(), pi1, pi2, bend, null, ep, true, true, null, null);
                if (route.size() == 0) {
                    System.out.println("Problem creating arc");
                    continue;
                }
                allRoutes.add(route);
            }
            if (total == 0) continue;
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            List<Highlight> saveHighlights = wnd.saveHighlightList();
            wnd.clearHighlighting();
            for (Route route : allRoutes) {
                Poly sPi = route.getStart().getPortInst().getPoly();
                Poly ePi = route.getEnd().getPortInst().getPoly();
                double fX = sPi.getCenterX();
                double fY = sPi.getCenterY();
                double tX = ePi.getCenterX();
                double tY = ePi.getCenterY();
                if (fX == tX && fY == tY) {
                    Rectangle2D.Double pointRect = new Rectangle2D.Double(fX - 1.0, fY - 1.0, 2.0, 2.0);
                    wnd.addHighlightArea(pointRect, cell);
                    continue;
                }
                wnd.addHighlightLine(new Point2D.Double(fX, fY), new Point2D.Double(tX, tY), cell, false, false);
            }
            for (ArcInst ai : allKills) {
                wnd.addHighlightLine(ai.getHeadLocation().lambdaMutable(), ai.getTailLocation().lambdaMutable(), cell, false, false);
            }
            wnd.finishedHighlighting();
            new MimicDialog(TopLevel.getCurrentJFrame(), count2, allRoutes, allKills, saveHighlights, wnd, j + 1, possibleArcs, cell, prefX, prefY);
            return;
        }
        if (count2 != 0) {
            System.out.println("MIMIC ROUTING: Created " + count2 + " arcs");
        }
    }

    public static class MimicOptions
    implements Serializable {
        public boolean mimicPinsKept = false;
        public boolean mimicInteractive = false;
        public boolean matchPorts = false;
        public boolean matchPortWidth = false;
        public boolean matchArcCount = false;
        public boolean matchNodeType = true;
        public boolean matchNodeSize = false;
        public boolean noOtherArcsThisDir = true;
        public boolean notAlreadyConnected = true;

        public void getOptionsFromPreferences() {
            this.mimicPinsKept = Routing.isMimicStitchPinsKept();
            this.mimicInteractive = Routing.isMimicStitchInteractive();
            this.matchPorts = Routing.isMimicStitchMatchPorts();
            this.matchPortWidth = Routing.isMimicStitchMatchPortWidth();
            this.matchArcCount = Routing.isMimicStitchMatchNumArcs();
            this.matchNodeType = Routing.isMimicStitchMatchNodeType();
            this.matchNodeSize = Routing.isMimicStitchMatchNodeSize();
            this.noOtherArcsThisDir = Routing.isMimicStitchNoOtherArcsSameDir();
            this.notAlreadyConnected = Routing.isMimicStitchOnlyNewTopology();
        }
    }

    private static class MimicDialog
    extends EDialog {
        private int count;
        private List<Route> allRoutes;
        private List<ArcInst> allKills;
        private List<Highlight> saveHighlights;
        private EditWindow_ wnd;
        private int nextSituationNumber;
        private List<PossibleArc> possibleArcs;
        private Cell cell;
        private double prefX;
        private double prefY;
        private EditingPreferences ep;

        private MimicDialog(Frame parent, int count2, List<Route> allRoutes, List<ArcInst> allKills, List<Highlight> saveHighlights, EditWindow_ wnd, int nextSituationNumber, List<PossibleArc> possibleArcs, Cell cell, double prefX, double prefY) {
            super(parent, false);
            this.count = count2;
            this.allRoutes = allRoutes;
            this.allKills = allKills;
            this.saveHighlights = saveHighlights;
            this.wnd = wnd;
            this.nextSituationNumber = nextSituationNumber;
            this.possibleArcs = possibleArcs;
            this.cell = cell;
            this.prefX = prefX;
            this.prefY = prefY;
            this.ep = UserInterfaceMain.getEditingPreferences();
            String activity = allKills.size() > 0 ? "Delete" : "Create";
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle(activity + " wires?");
            this.setDefaultCloseOperation(0);
            JLabel question = new JLabel(activity + " " + (allRoutes.size() + allKills.size()) + " wires shown here?");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 4;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)question, gbc);
            JButton yes = new JButton("Yes");
            yes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MimicDialog.this.yes();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)yes, gbc);
            this.getRootPane().setDefaultButton(yes);
            JButton no = new JButton("No");
            no.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MimicDialog.this.no();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)no, gbc);
            JButton noAndStop = new JButton("No, and stop");
            noAndStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MimicDialog.this.noAndStopActionPerformed();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)noAndStop, gbc);
            JButton yesAndStop = new JButton("Yes, then stop");
            yesAndStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MimicDialog.this.yesAndStopActionPerformed();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)yesAndStop, gbc);
            this.pack();
            this.finishInitialization();
            this.setVisible(true);
        }

        @Override
        protected void escapePressed() {
            this.no();
        }

        private void yesAndStopActionPerformed() {
            this.wnd.clearHighlighting();
            this.wnd.restoreHighlightList(this.saveHighlights);
            this.wnd.finishedHighlighting();
            new MimicWireJob(this.allRoutes, this.allKills, false, null);
            this.count += this.allRoutes.size() + this.allKills.size();
            MimicStitch.presentNextSituation(this.count, situations.length, this.possibleArcs, this.cell, this.prefX, this.prefY, this.ep);
            this.setVisible(false);
            this.dispose();
        }

        private void noAndStopActionPerformed() {
            this.wnd.clearHighlighting();
            this.wnd.restoreHighlightList(this.saveHighlights);
            this.wnd.finishedHighlighting();
            MimicStitch.presentNextSituation(this.count, situations.length, this.possibleArcs, this.cell, this.prefX, this.prefY, this.ep);
            this.setVisible(false);
            this.dispose();
        }

        private void yes() {
            this.wnd.clearHighlighting();
            this.wnd.restoreHighlightList(this.saveHighlights);
            this.wnd.finishedHighlighting();
            new MimicWireJob(this.allRoutes, this.allKills, false, null);
            this.count += this.allRoutes.size() + this.allKills.size();
            MimicStitch.presentNextSituation(this.count, this.nextSituationNumber, this.possibleArcs, this.cell, this.prefX, this.prefY, this.ep);
            this.setVisible(false);
            this.dispose();
        }

        private void no() {
            this.wnd.clearHighlighting();
            this.wnd.restoreHighlightList(this.saveHighlights);
            this.wnd.finishedHighlighting();
            MimicStitch.presentNextSituation(this.count, this.nextSituationNumber, this.possibleArcs, this.cell, this.prefX, this.prefY, this.ep);
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class MimicInteractive
    implements Runnable {
        private Cell cell;
        private List<PossibleArc> possibleArcs;
        private double prefX;
        private double prefY;

        private MimicInteractive(Cell cell, List<PossibleArc> possibleArcs, double prefX, double prefY) {
            this.cell = cell;
            this.possibleArcs = possibleArcs;
            this.prefX = prefX;
            this.prefY = prefY;
        }

        @Override
        public void run() {
            MimicStitch.presentNextSituation(0, 0, this.possibleArcs, this.cell, this.prefX, this.prefY, UserInterfaceMain.getEditingPreferences());
        }
    }

    private static class MimicWireJob
    extends Job {
        private List<Route> allRoutes;
        private List<ArcInst> allKills;
        private boolean redisplay;
        private List<PortInst> portsToHighlight;
        private MimicOptions prefs;

        private MimicWireJob(List<Route> allRoutes, List<ArcInst> allKills, boolean redisplay, MimicOptions prefs) {
            super("Mimic-Stitch", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.allRoutes = allRoutes;
            this.allKills = allKills;
            this.redisplay = redisplay;
            this.prefs = prefs;
            if (this.prefs == null) {
                this.prefs = new MimicOptions();
                this.prefs.getOptionsFromPreferences();
            }
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (this.allRoutes.size() > 0) {
                this.portsToHighlight = MimicStitch.runTheWires(this.allRoutes, ep);
                this.fieldVariableChanged("portsToHighlight");
            } else {
                for (ArcInst ai : this.allKills) {
                    NodeInst h = ai.getHeadPortInst().getNodeInst();
                    NodeInst t = ai.getTailPortInst().getNodeInst();
                    ai.kill();
                    if (h.getProto().getFunction().isPin() && !h.hasConnections() && !h.hasExports() && !this.prefs.mimicPinsKept) {
                        h.kill();
                    }
                    if (!t.getProto().getFunction().isPin() || t.hasConnections() || t.hasExports() || this.prefs.mimicPinsKept) continue;
                    t.kill();
                }
            }
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.redisplay) {
                UserInterface ui = Job.getUserInterface();
                EditWindow_ wnd = ui.getCurrentEditWindow_();
                if (wnd != null) {
                    wnd.clearHighlighting();
                    for (PortInst pi : this.portsToHighlight) {
                        wnd.addElectricObject(pi, pi.getNodeInst().getParent());
                    }
                    wnd.finishedHighlighting();
                }
                ui.repaintAllWindows();
            }
        }
    }

    private static class MimicStitchJob
    extends Job {
        private ArcInst ai1;
        private ArcInst ai2;
        private int end1;
        private int end2;
        private double oWidth;
        private ArcProto oProto;
        private double prefX;
        private double prefY;
        private boolean forced;
        private MimicOptions prefs;

        private MimicStitchJob(ArcInst ai1, int end1, ArcInst ai2, int end2, double oWidth, ArcProto oProto, double prefX, double prefY, boolean forced) {
            super("Mimic-Stitch", Routing.getRoutingTool(), Job.Type.CLIENT_EXAMINE, null, null, Job.Priority.USER);
            this.ai1 = ai1;
            this.end1 = end1;
            this.ai2 = ai2;
            this.end2 = end2;
            this.oWidth = oWidth;
            this.oProto = oProto;
            this.prefX = prefX;
            this.prefY = prefY;
            this.forced = forced;
            this.setReportExecutionFlag(true);
            this.prefs = new MimicOptions();
            this.prefs.getOptionsFromPreferences();
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            MimicStitch.mimicOneArc(this.ai1, this.end1, this.ai2, this.end2, this.oWidth, this.oProto, this.prefX, this.prefY, this.forced, Job.Type.CLIENT_EXAMINE, this.getEditingPreferences(), this.prefs, this);
            return true;
        }
    }

    private static class PossibleArc {
        private int situation;
        private ArcInst ai;
        private NodeInst ni1;
        private NodeInst ni2;
        private PortProto pp1;
        private PortProto pp2;

        private PossibleArc() {
        }
    }

    private static class SituationSorter
    implements Comparator<Integer> {
        private SituationSorter() {
        }

        @Override
        public int compare(Integer r1, Integer r2) {
            int i1 = r1;
            int i2 = r2;
            int b1 = 0;
            int b2 = 0;
            for (int i = 0; i < 7; ++i) {
                int mask = 1 << i;
                if ((i1 & mask) != 0) {
                    ++b1;
                }
                if ((i2 & mask) == 0) continue;
                ++b2;
            }
            return b1 - b2;
        }
    }
}

