/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.logicaleffort.LENetlister;
import com.sun.electric.tool.logicaleffort.LENetlister2;
import com.sun.electric.tool.logicaleffort.LENetwork;
import com.sun.electric.tool.logicaleffort.LENodable;
import com.sun.electric.tool.logicaleffort.LEPin;
import com.sun.electric.tool.logicaleffort.LETool;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CachedCell {
    private Cell cell;
    private Map<Nodable, LENodable> lenodables;
    private Map<Nodable, CellNodable> cellnodables;
    private boolean containsSizableGates;
    private Map<Network, LENetwork> localNetworks;
    private Boolean contextFree;
    private static final boolean DEBUG = false;

    protected CachedCell(Cell cell, Netlist netlist) {
        this.cell = cell;
        this.lenodables = new HashMap<Nodable, LENodable>();
        this.localNetworks = new HashMap<Network, LENetwork>();
        this.cellnodables = new HashMap<Nodable, CellNodable>();
        this.containsSizableGates = false;
        this.contextFree = null;
        if (netlist != null) {
            Iterator<Network> it = netlist.getNetworks();
            while (it.hasNext()) {
                Network jnet = it.next();
                LENetwork net = new LENetwork(jnet.describe(false));
                if (this.localNetworks.containsKey(jnet)) {
                    System.out.println("Possible hashmap conflict in localNetworks!");
                }
                this.localNetworks.put(jnet, net);
            }
        }
    }

    protected boolean isContainsSizableGates() {
        return this.containsSizableGates;
    }

    protected LENodable getLENodable(Nodable no) {
        return this.lenodables.get(no);
    }

    protected Iterator getLENodables() {
        return this.lenodables.values().iterator();
    }

    protected CellNodable getCellNodable(Nodable no) {
        return this.cellnodables.get(no);
    }

    protected Iterator getCellNodables() {
        return this.cellnodables.values().iterator();
    }

    protected Map<Network, LENetwork> getLocalNetworks() {
        return this.localNetworks;
    }

    protected void add(Nodable no, LENodable leno) {
        if (leno.isLeGate()) {
            this.containsSizableGates = true;
        }
        for (LEPin pin : leno.getPins()) {
            Network jnet = pin.getNetwork();
            LENetwork net = this.localNetworks.get(jnet);
            net.add(pin);
        }
        if (this.lenodables.containsKey(no)) {
            System.out.println("Possible hash map conflict in lenodables!");
        }
        this.lenodables.put(no, leno);
    }

    protected void add(Nodable no, LENetlister2.LECellInfo info, CachedCell subCell, LENetlister2.LECellInfo subCellInfo, LENetlister.NetlisterConstants constants) {
        CellNodable ceno = new CellNodable();
        ceno.no = no;
        ceno.subCell = subCell;
        ceno.mfactorVar = LETool.getMFactor(no);
        if (this.cellnodables.containsKey(no)) {
            System.out.println("Possible hash map conflict in cellnodables!");
        }
        this.cellnodables.put(no, ceno);
        if (subCell.isContainsSizableGates()) {
            this.containsSizableGates = true;
            return;
        }
        if (!subCell.isContextFree(constants)) {
            ceno.subCell = subCell = subCell.copy();
        }
        for (Map.Entry<Network, LENetwork> entry : subCell.getLocalNetworks().entrySet()) {
            Network subJNet = entry.getKey();
            LENetwork subLENet = entry.getValue();
            Network localJNet = subCellInfo.getNetworkInParent(subJNet);
            if (localJNet == null) continue;
            LENetwork net = this.localNetworks.get(localJNet);
            if (net == null) {
                net = new LENetwork(localJNet.describe(false));
                this.localNetworks.put(localJNet, net);
            }
            net.add(subLENet);
        }
    }

    protected boolean isContextFree(LENetlister.NetlisterConstants constants) {
        if (this.contextFree == null) {
            if (this.isContainsSizableGates()) {
                this.contextFree = false;
            } else {
                boolean cf = this.isContextFreeRecurse(VarContext.globalContext, 1.0f, constants);
                this.contextFree = cf;
            }
        }
        return this.contextFree;
    }

    private boolean isContextFreeRecurse(VarContext context, float mfactor, LENetlister.NetlisterConstants constants) {
        for (LENodable lENodable : this.lenodables.values()) {
            boolean b = lENodable.setOnlyContext(context, null, mfactor, 0.0f, constants);
            if (b) continue;
            return false;
        }
        for (Map.Entry entry : this.cellnodables.entrySet()) {
            boolean b;
            Nodable no = (Nodable)entry.getKey();
            CellNodable ceno = (CellNodable)entry.getValue();
            float subCellMFactor = mfactor;
            if (ceno.mfactorVar != null) {
                Object retVal = context.evalVar(ceno.mfactorVar);
                if (retVal == null) {
                    return false;
                }
                subCellMFactor *= VarContext.objectToFloat(retVal, 1.0f);
            }
            if ((b = ceno.subCell.isContextFree(constants)) || ceno.subCell.isContextFreeRecurse(context.push(no), subCellMFactor, constants)) continue;
            return false;
        }
        return true;
    }

    private CachedCell copy() {
        CachedCell copy = new CachedCell(this.cell, null);
        HashMap<LENetwork, LENetwork> origSubNetsToCopySubNets = new HashMap<LENetwork, LENetwork>();
        for (Map.Entry<Nodable, CellNodable> entry : this.cellnodables.entrySet()) {
            Nodable no = entry.getKey();
            CellNodable ceno = entry.getValue();
            CellNodable cenoCopy = new CellNodable();
            cenoCopy.no = ceno.no;
            cenoCopy.mfactorVar = ceno.mfactorVar;
            cenoCopy.subCell = ceno.subCell.copy();
            if (copy.cellnodables.containsKey(no)) {
                System.out.println("Possible hash map conflict in copy.cellnodables!");
            }
            copy.cellnodables.put(no, cenoCopy);
            for (Map.Entry entry2 : ceno.subCell.localNetworks.entrySet()) {
                Network jnet = (Network)entry2.getKey();
                LENetwork origNet = (LENetwork)entry2.getValue();
                LENetwork copyNet = cenoCopy.subCell.localNetworks.get(jnet);
                origSubNetsToCopySubNets.put(origNet, copyNet);
            }
        }
        for (Map.Entry<Object, Object> entry : this.localNetworks.entrySet()) {
            Network jnet = (Network)entry.getKey();
            LENetwork net = (LENetwork)entry.getValue();
            LENetwork netCopy = new LENetwork(net.getName());
            Iterator<Object> nit = net.getSubNets();
            while (nit.hasNext()) {
                LENetwork lENetwork = nit.next();
                LENetwork copySubNet = (LENetwork)origSubNetsToCopySubNets.get(lENetwork);
                netCopy.add(copySubNet);
            }
            if (copy.localNetworks.containsKey(jnet)) {
                System.out.println("Possible hashmap conflict in copy.localNetworks!");
            }
            copy.localNetworks.put(jnet, netCopy);
        }
        for (LENodable lENodable : this.lenodables.values()) {
            LENodable lenoCopy = lENodable.copy();
            copy.add(lENodable.getNodable(), lenoCopy);
        }
        copy.containsSizableGates = this.containsSizableGates;
        copy.contextFree = this.contextFree;
        return copy;
    }

    protected void printContents(String indent, PrintStream out) {
        out.println(indent + "CachedCell " + this.cell.describe(true) + " contents:");
        for (LENodable lENodable : this.lenodables.values()) {
            out.println(lENodable.printOneLine(indent + "  "));
        }
        for (Map.Entry entry : this.localNetworks.entrySet()) {
            entry.getKey();
            LENetwork net = (LENetwork)entry.getValue();
            net.print(indent + "  ", out);
        }
        for (Map.Entry entry : this.cellnodables.entrySet()) {
            entry.getKey();
            CellNodable ceno = (CellNodable)entry.getValue();
            boolean subCachable = ceno.subCell.isContextFree(null);
            System.out.println(indent + indent + "contains subCachedCell for " + ceno.subCell.cell + " (" + (subCachable ? "cachable" : "not cachable") + ")");
        }
    }

    protected static class CellNodable {
        Nodable no;
        CachedCell subCell;
        Variable mfactorVar;

        protected CellNodable() {
        }
    }
}

