/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.ScreenPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.user.HighlightArea;
import com.sun.electric.tool.user.HighlightLine;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.redisplay.AbstractLayerDrawing;
import com.sun.electric.tool.user.redisplay.ERaster;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.Util;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public abstract class Highlight
implements Cloneable {
    public static final BasicStroke solidLine = new BasicStroke(0.0f);
    public static final BasicStroke dottedLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f);
    public static final BasicStroke dashedLine = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
    public static final BasicStroke boldLine = new BasicStroke(3.0f);
    protected final Cell cell;
    protected final Color color;
    public final boolean isError;
    private static final int CROSSSIZE = 3;
    private static final int PULSATE_ROTATE_PERIOD = 1000;
    private static final int PULSATE_STRIPE_LENGTH = 30;
    private static final int PULSATE_STRIPE_SEGMENTS = 10;

    Highlight(Cell c, Color color, boolean isError) {
        this.cell = c;
        this.color = color;
        this.isError = isError;
    }

    public Cell getCell() {
        return this.cell;
    }

    public boolean isValid() {
        return this.cell == null || this.cell.isLinked();
    }

    public boolean showInRaster() {
        return false;
    }

    public boolean isHighlightEOBJ() {
        return false;
    }

    public boolean isHighlightText() {
        return false;
    }

    public Object getObject() {
        return null;
    }

    public Variable.Key getVarKey() {
        return null;
    }

    public int getPoint() {
        return -1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean sameThing(Highlight obj, boolean exact) {
        return false;
    }

    public boolean nodeMovesWithText() {
        return false;
    }

    public void showHighlight(EditWindow wnd, Graphics g_, long highOffX, long highOffY, boolean onlyHighlight, Color mainColor, Stroke primaryStroke) {
        if (!this.isValid()) {
            return;
        }
        g_.setColor(mainColor);
        Graphics2D g2 = (Graphics2D)g_;
        g2.setStroke(primaryStroke);
        if (User.isErrorHighlightingPulsate() && this.isError) {
            long now = System.currentTimeMillis();
            for (int i = 0; i < 10; ++i) {
                float h = Util.hueFromColor(mainColor);
                float s = 1.0f;
                float v = (float)i / 10.0f;
                g2.setColor(Util.colorFromHSV(h, s, v));
                float segment_length = 3.0f;
                g2.setStroke(new BasicStroke(1.0f, 1, 1, 20.0f, new float[]{segment_length, 30.0f - segment_length}, (float)(now % 1000L * 30L) / 1000.0f + (float)i));
                this.showInternalHighlight(wnd, g2, highOffX, highOffY, onlyHighlight);
            }
        } else {
            this.showInternalHighlight(wnd, g_, highOffX, highOffY, onlyHighlight);
        }
    }

    abstract void showInternalHighlight(EditWindow var1, Graphics var2, long var3, long var5, boolean var7);

    public void showHighlight(FixpTransform outOfPlaceTransfrom, AbstractLayerDrawing ald, ERaster raster) {
        throw new UnsupportedOperationException();
    }

    void showHighlightsConnected(Graphics2D g2, EditWindow wnd) {
    }

    public void showHighlightsConnected(FixpTransform outOfPlaceTransform, AbstractLayerDrawing ald, ERaster raste) {
    }

    void getHighlightedEObjs(Highlighter highlighter, List<Geometric> list, boolean wantNodes, boolean wantArcs) {
    }

    static void getHighlightedEObjsInternal(Geometric geom, List<Geometric> list, boolean wantNodes, boolean wantArcs) {
        if (geom == null) {
            return;
        }
        if (!wantNodes && geom instanceof NodeInst) {
            return;
        }
        if (!wantArcs && geom instanceof ArcInst) {
            return;
        }
        if (list.contains(geom)) {
            return;
        }
        list.add(geom);
    }

    public Geometric getGeometric() {
        return null;
    }

    void getHighlightedNodes(Highlighter highlighter, Set<NodeInst> set) {
    }

    static void getHighlightedNodesInternal(Geometric geom, Set<NodeInst> set) {
        if (geom == null || !(geom instanceof NodeInst)) {
            return;
        }
        NodeInst ni = (NodeInst)geom;
        set.add(ni);
    }

    void getHighlightedArcs(Highlighter highlighter, Set<ArcInst> set) {
    }

    static void getHighlightedArcsInternal(Geometric geom, Set<ArcInst> set) {
        if (geom == null || !(geom instanceof ArcInst)) {
            return;
        }
        ArcInst ai = (ArcInst)geom;
        set.add(ai);
    }

    void getHighlightedNetworks(Set<Network> nets, Netlist netlist) {
    }

    void getHighlightedText(List<DisplayedText> list, boolean unique, List<Highlight> getHighlights) {
    }

    Rectangle2D getHighlightedArea(EditWindow wnd) {
        return null;
    }

    public ElectricObject getElectricObject() {
        return null;
    }

    Highlight overHighlighted(EditWindow wnd, int x, int y, Highlighter highlighter, boolean change) {
        return null;
    }

    public String getInfo() {
        return null;
    }

    public static List<ElectricObject> getEOBJElements(List<Highlight> list) {
        ArrayList<ElectricObject> l = new ArrayList<ElectricObject>();
        for (Highlight h : list) {
            ElectricObject eobj = h.getElectricObject();
            if (!h.isHighlightEOBJ()) continue;
            if (eobj instanceof PortInst) {
                l.add(((PortInst)eobj).getNodeInst());
                continue;
            }
            if (!(eobj instanceof ArcInst) && !(eobj instanceof NodeInst)) continue;
            l.add(eobj);
        }
        return l;
    }

    public static NodeInst getInfoCommand(List<Highlight> list, int[] counts) {
        NodeInst theNode = null;
        for (Highlight h : list) {
            ElectricObject eobj = h.getElectricObject();
            if (h.isHighlightEOBJ()) {
                if (eobj instanceof NodeInst || eobj instanceof PortInst) {
                    counts[1] = counts[1] + 1;
                    if (eobj instanceof NodeInst) {
                        theNode = (NodeInst)eobj;
                        continue;
                    }
                    theNode = ((PortInst)eobj).getNodeInst();
                    continue;
                }
                if (!(eobj instanceof ArcInst)) continue;
                counts[0] = counts[0] + 1;
                continue;
            }
            if (h.isHighlightText()) {
                if (h.getVarKey() == Export.EXPORT_NAME) {
                    counts[2] = counts[2] + 1;
                    continue;
                }
                if (h.getElectricObject() instanceof NodeInst) {
                    theNode = (NodeInst)h.getElectricObject();
                }
                counts[3] = counts[3] + 1;
                continue;
            }
            if (h instanceof HighlightArea) {
                counts[4] = counts[4] + 1;
                continue;
            }
            if (!(h instanceof HighlightLine)) continue;
            counts[4] = counts[4] + 1;
        }
        return theNode;
    }

    public static void drawOutlineFromPoints(EditWindow wnd, Graphics g, Point2D[] points, long offX, long offY, boolean opened, boolean thickLine) {
        boolean onePoint = true;
        if (points.length <= 0) {
            return;
        }
        ScreenPoint firstP = wnd.databaseToScreen(points[0].getX(), points[0].getY());
        for (int i = 1; i < points.length; ++i) {
            ScreenPoint p = wnd.databaseToScreen(points[i].getX(), points[i].getY());
            if (DBMath.doublesEqual(p.getX(), firstP.getX()) && DBMath.doublesEqual(p.getY(), firstP.getY())) continue;
            onePoint = false;
            break;
        }
        if (onePoint) {
            Highlight.drawLine(g, wnd, firstP.getX() + offX - 3L, firstP.getY() + offY, firstP.getX() + offX + 3L, firstP.getY() + offY);
            Highlight.drawLine(g, wnd, firstP.getX() + offX, firstP.getY() + offY - 3L, firstP.getX() + offX, firstP.getY() + offY + 3L);
            return;
        }
        int cX = 0;
        int cY = 0;
        Point p = new Point(0, 0);
        Point2D.Double ptXF = new Point2D.Double(0.0, 0.0);
        for (int i = 0; i < points.length; ++i) {
            int lastI = i - 1;
            if (lastI < 0) {
                if (opened) continue;
                lastI = points.length - 1;
            }
            Point2D pt = points[lastI];
            if (wnd.isInPlaceEdit()) {
                wnd.getInPlaceTransformOut().transform(pt, ptXF);
                pt = ptXF;
            }
            wnd.gridToScreen(DBMath.lambdaToGrid(pt.getX()), DBMath.lambdaToGrid(pt.getY()), p);
            long fX = (long)p.x + offX;
            long fY = (long)p.y + offY;
            pt = points[i];
            if (wnd.isInPlaceEdit()) {
                wnd.getInPlaceTransformOut().transform(pt, ptXF);
                pt = ptXF;
            }
            wnd.gridToScreen(DBMath.lambdaToGrid(pt.getX()), DBMath.lambdaToGrid(pt.getY()), p);
            long tX = (long)p.x + offX;
            long tY = (long)p.y + offY;
            Highlight.drawLine(g, wnd, fX, fY, tX, tY);
            if (!thickLine) continue;
            fX = fX < (long)cX ? --fX : ++fX;
            fY = fY < (long)cY ? --fY : ++fY;
            tX = tX < (long)cX ? --tX : ++tX;
            tY = tY < (long)cY ? --tY : ++tY;
            Highlight.drawLine(g, wnd, fX, fY, tX, tY);
        }
    }

    public static void drawOutlineFromPoints(FixpTransform outOfPlaceTransform, AbstractLayerDrawing ald, ERaster raster, Point2D[] points, int offX, int offY, boolean opened, boolean thickLine) {
        int i;
        boolean onePoint = true;
        if (points.length <= 0) {
            return;
        }
        Point firstP = new Point();
        Point p = new Point();
        ald.databaseToScreen(points[0].getX(), points[0].getY(), firstP);
        for (i = 1; i < points.length; ++i) {
            ald.databaseToScreen(points[i].getX(), points[i].getY(), p);
            if (p.equals(firstP)) continue;
            onePoint = false;
            break;
        }
        if (onePoint) {
            Point2D pt = points[0];
            if (outOfPlaceTransform != null) {
                outOfPlaceTransform.transform(pt, pt);
            }
            ald.drawCross((int)DBMath.lambdaToGrid(pt.getX()), (int)DBMath.lambdaToGrid(pt.getY()), 3, raster);
            return;
        }
        if (outOfPlaceTransform != null) {
            for (i = 0; i < points.length; ++i) {
                outOfPlaceTransform.transform(points[i], points[i]);
            }
        }
        for (i = 0; i < points.length; ++i) {
            int lastI = i - 1;
            if (lastI < 0) {
                if (opened) continue;
                lastI = points.length - 1;
            }
            Point2D pt1 = points[lastI];
            Point2D pt2 = points[i];
            ald.drawLine((int)DBMath.lambdaToGrid(pt1.getX()), (int)DBMath.lambdaToGrid(pt1.getY()), (int)DBMath.lambdaToGrid(pt2.getX()), (int)DBMath.lambdaToGrid(pt2.getY()), 0, raster);
        }
    }

    void internalDescribe(StringBuffer desc) {
    }

    public String describe() {
        StringBuffer desc = new StringBuffer();
        desc.append(this.getClass().getName());
        if (this.cell != null) {
            desc.append(" in ");
            desc.append(this.cell);
        }
        desc.append(": ");
        this.internalDescribe(desc);
        return desc.toString();
    }

    public static Poly getNodeInstOutline(NodeInst ni) {
        FixpTransform trans = ni.rotateOutAboutTrueCenter();
        Poly poly = null;
        if (!ni.isCellInstance()) {
            Poly.Type type;
            Poly[] polys;
            EPoint[] outline;
            PrimitiveNode pn = (PrimitiveNode)ni.getProto();
            if (pn.isHoldsOutline() && (outline = ni.getTrace()) != null) {
                int numPoints = outline.length;
                boolean whole = true;
                for (int i = 1; i < numPoints; ++i) {
                    if (outline[i] != null) continue;
                    whole = false;
                    break;
                }
                if (whole) {
                    Point2D[] pointList = new PolyBase.Point[numPoints];
                    for (int i = 0; i < numPoints; ++i) {
                        EPoint anchor = ni.getAnchorCenter();
                        pointList[i] = Poly.fromFixp(anchor.getFixpX() + outline[i].getFixpX(), anchor.getFixpY() + outline[i].getFixpY());
                    }
                    trans.transform(pointList, 0, pointList, 0, numPoints);
                    poly = new Poly((PolyBase.Point[])pointList);
                    if (ni.getFunction() == PrimitiveNode.Function.NODE) {
                        poly.setStyle(Poly.Type.FILLED);
                    } else {
                        poly.setStyle(Poly.Type.OPENED);
                    }
                    return poly;
                }
            }
            if (pn.getTechnology() == Artwork.tech() && (polys = pn.getTechnology().getShapeOfNode(ni)).length == 1 && ((type = polys[0].getStyle()) == Poly.Type.CIRCLE || type == Poly.Type.DISC || type == Poly.Type.CIRCLEARC || type == Poly.Type.THICKCIRCLE || type == Poly.Type.THICKCIRCLEARC)) {
                double[] angles = ni.getArcDegrees();
                PolyBase.Point[] pointList = Artwork.fillEllipse(ni.getAnchorCenter(), ni.getXSize(), ni.getYSize(), angles[0], angles[1]);
                poly = new Poly(pointList);
                poly.setStyle(Poly.Type.OPENED);
                poly.transform(ni.rotateOut());
            }
            if (pn.isCurvedPin()) {
                polys = pn.getTechnology().getShapeOfNode(ni);
                poly = polys[0];
                poly.transform(ni.rotateOut());
            }
        }
        if (poly == null) {
            poly = ni.getBaseShape();
        }
        return poly;
    }

    public static void drawLine(Graphics g, EditWindow wnd, long x1, long y1, long x2, long y2) {
        Dimension size = wnd.getScreenSize();
        Point pt1 = new Point((int)x1, (int)y1);
        Point pt2 = new Point((int)x2, (int)y2);
        if (GenMath.clipLine(pt1, pt2, 0, size.width - 1, 0, size.height - 1)) {
            return;
        }
        g.drawLine(pt1.x, pt1.y, pt2.x, pt2.y);
    }

    public static class Message
    extends Highlight {
        protected final String msg;
        protected final Point2D loc;
        protected final int corner;
        private final Color backgroundColor;

        Message(Cell c, String m, Point2D p, int co, Color backgroundColor) {
            super(c, null, false);
            this.msg = m;
            this.loc = p;
            this.corner = co;
            this.backgroundColor = backgroundColor;
        }

        @Override
        void internalDescribe(StringBuffer desc) {
            desc.append(this.msg);
        }

        @Override
        public String getInfo() {
            return this.msg;
        }

        @Override
        public void showInternalHighlight(EditWindow wnd, Graphics g, long highOffX, long highOffY, boolean onlyHighlight) {
            ScreenPoint location = wnd.databaseToScreen(this.loc.getX(), this.loc.getY());
            long locX = location.getX();
            long locY = location.getY();
            int width = 0;
            int height = 0;
            if (this.corner != 0 || this.backgroundColor != null) {
                Font font = g.getFont();
                FontRenderContext frc = new FontRenderContext(null, true, true);
                GlyphVector gv = font.createGlyphVector(frc, this.msg);
                LineMetrics lm = font.getLineMetrics(this.msg, frc);
                Rectangle2D rasRect = gv.getLogicalBounds();
                width = (int)rasRect.getWidth();
                height = (int)((double)lm.getHeight() + 0.5);
            }
            switch (this.corner) {
                case 1: {
                    locY += (long)height;
                    break;
                }
                case 2: {
                    locY += (long)height;
                    locX -= (long)width;
                    break;
                }
                case 3: {
                    locY += (long)height;
                    locX -= (long)width;
                }
            }
            Color oldColor = g.getColor();
            Color mainColor = this.color != null ? this.color : new Color(User.getColor(User.ColorPrefType.TEXT));
            int mainColorRed = mainColor.getRed() & 0xFF;
            int mainColorGreen = mainColor.getGreen() & 0xFF;
            int mainColorBlue = mainColor.getBlue() & 0xFF;
            Color shadowColor = new Color(255 - mainColorRed, 255 - mainColorGreen, 255 - mainColorBlue);
            if (this.backgroundColor == null) {
                g.setColor(shadowColor);
                g.drawString(this.msg, (int)(locX + 1L), (int)(locY + 1L));
            } else {
                g.setColor(this.backgroundColor);
                g.fillRect((int)locX, (int)(locY - (long)height), width, height);
            }
            g.setColor(mainColor);
            g.drawString(this.msg, (int)locX, (int)locY);
            g.setColor(oldColor);
        }

        @Override
        Rectangle2D getHighlightedArea(EditWindow wnd) {
            return new Rectangle2D.Double(this.loc.getX(), this.loc.getY(), 0.0, 0.0);
        }
    }

    public static class HighlightSorting
    implements Comparator<Highlight> {
        @Override
        public int compare(Highlight h1, Highlight h2) {
            String h1Info = h1.getInfo();
            String h2Info = h2.getInfo();
            if (h1Info == null) {
                h1Info = "";
            }
            if (h2Info == null) {
                h2Info = "";
            }
            return h1Info.compareTo(h2Info);
        }
    }
}

