/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io;

import gnu.prolog.io.Operator;
import gnu.prolog.term.CompoundTermTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorSet {
    List<OperatorLevel> priorityLevels = new ArrayList<OperatorLevel>();
    Map<String, Operator> xfOps = new HashMap<String, Operator>();
    Map<String, Operator> fxOps = new HashMap<String, Operator>();

    public synchronized Operator lookupXf(String value) {
        Operator op = this.xfOps.get(value);
        return op != null ? op : Operator.nonOperator;
    }

    public synchronized Operator lookupFx(String value) {
        Operator op = this.fxOps.get(value);
        return op != null ? op : Operator.nonOperator;
    }

    public synchronized Set<Operator> getOperators() {
        HashSet<Operator> rc = new HashSet<Operator>();
        rc.addAll(this.fxOps.values());
        rc.addAll(this.xfOps.values());
        return rc;
    }

    public synchronized void remove(Operator.SPECIFIER specifier, String name) {
        switch (specifier) {
            case FX: 
            case FY: {
                this.fxOps.remove(name);
                break;
            }
            case XFX: 
            case XFY: 
            case YFX: 
            case XF: 
            case YF: {
                this.xfOps.remove(name);
            }
        }
    }

    public synchronized Operator add(int priority, Operator.SPECIFIER specifier, String name) {
        int n = this.priorityLevels.size();
        OperatorLevel ol = null;
        int nlv = 0;
        int i = n - 1;
        while (i >= 0) {
            ol = this.priorityLevels.get(i);
            if (ol.priority == priority) {
                nlv = i;
                break;
            }
            if (ol.priority < priority) {
                nlv = i + 1;
                ol = new OperatorLevel(priority);
                if (nlv == n) {
                    this.priorityLevels.add(ol);
                    break;
                }
                this.priorityLevels.add(nlv, ol);
                break;
            }
            --i;
        }
        if (i < 0) {
            nlv = 0;
            ol = new OperatorLevel(priority);
            if (this.priorityLevels.size() == 0) {
                this.priorityLevels.add(ol);
            } else {
                this.priorityLevels.add(nlv, ol);
            }
        }
        Operator op = new Operator(name, specifier, priority);
        switch (specifier) {
            case FX: 
            case FY: {
                this.fxOps.put(name, op);
                break;
            }
            case XFX: 
            case XFY: 
            case YFX: 
            case XF: 
            case YF: {
                this.xfOps.put(name, op);
            }
        }
        return op;
    }

    public synchronized int getNextLevel(int priority) {
        int n = this.priorityLevels.size();
        int i = n - 1;
        while (i >= 0) {
            int p = this.priorityLevels.get((int)i).priority;
            if (p <= priority) {
                return p;
            }
            --i;
        }
        return 0;
    }

    public synchronized int getCommaLevel() {
        return 1000;
    }

    public synchronized int getMaxLevel() {
        return 1200;
    }

    public OperatorSet(boolean defaultSet) {
        if (defaultSet) {
            this.initDefault();
        }
    }

    public OperatorSet() {
        this(true);
    }

    protected void initDefault() {
        this.add(1200, Operator.SPECIFIER.XFX, "-->");
        this.add(1200, Operator.SPECIFIER.XFX, ":-");
        this.add(1200, Operator.SPECIFIER.FX, ":-");
        this.add(1200, Operator.SPECIFIER.FX, "?-");
        this.add(1100, Operator.SPECIFIER.XFY, ";");
        this.add(1050, Operator.SPECIFIER.XFY, "->");
        this.add(1000, Operator.SPECIFIER.XFY, ",");
        this.add(900, Operator.SPECIFIER.FX, "\\+");
        this.add(700, Operator.SPECIFIER.XFX, "=");
        this.add(700, Operator.SPECIFIER.XFX, "\\=");
        this.add(700, Operator.SPECIFIER.XFX, "==");
        this.add(700, Operator.SPECIFIER.XFX, "\\==");
        this.add(700, Operator.SPECIFIER.XFX, "@<");
        this.add(700, Operator.SPECIFIER.XFX, "@=<");
        this.add(700, Operator.SPECIFIER.XFX, "@>");
        this.add(700, Operator.SPECIFIER.XFX, "@>=");
        this.add(700, Operator.SPECIFIER.XFX, "=..");
        this.add(700, Operator.SPECIFIER.XFX, "is");
        this.add(700, Operator.SPECIFIER.XFX, "=:=");
        this.add(700, Operator.SPECIFIER.XFX, "=\\=");
        this.add(700, Operator.SPECIFIER.XFX, "<");
        this.add(700, Operator.SPECIFIER.XFX, "=<");
        this.add(700, Operator.SPECIFIER.XFX, ">");
        this.add(700, Operator.SPECIFIER.XFX, ">=");
        this.add(600, Operator.SPECIFIER.XFX, ":");
        this.add(500, Operator.SPECIFIER.YFX, "+");
        this.add(500, Operator.SPECIFIER.YFX, "-");
        this.add(500, Operator.SPECIFIER.YFX, "/\\");
        this.add(500, Operator.SPECIFIER.YFX, "\\/");
        this.add(400, Operator.SPECIFIER.YFX, "*");
        this.add(400, Operator.SPECIFIER.YFX, "/");
        this.add(400, Operator.SPECIFIER.YFX, "//");
        this.add(400, Operator.SPECIFIER.YFX, "rem");
        this.add(400, Operator.SPECIFIER.YFX, "mod");
        this.add(400, Operator.SPECIFIER.YFX, "<<");
        this.add(400, Operator.SPECIFIER.YFX, ">>");
        this.add(200, Operator.SPECIFIER.XFX, "**");
        this.add(200, Operator.SPECIFIER.XFY, "^");
        this.add(200, Operator.SPECIFIER.FY, "-");
        this.add(200, Operator.SPECIFIER.FY, "\\");
        this.add(100, Operator.SPECIFIER.XFX, "@");
    }

    public synchronized Operator getOperatorForTag(CompoundTermTag tag) {
        if (tag.arity == 1) {
            Operator op = this.lookupFx(tag.functor.value);
            if (op == Operator.nonOperator) {
                op = this.lookupXf(tag.functor.value);
            }
            if (op.tag != tag) {
                op = Operator.nonOperator;
            }
            return op;
        }
        if (tag.arity == 2) {
            Operator op = this.lookupXf(tag.functor.value);
            if (op.tag != tag) {
                op = Operator.nonOperator;
            }
            return op;
        }
        return Operator.nonOperator;
    }

    static class OperatorLevel {
        int priority;

        OperatorLevel(int p) {
            this.priority = p;
        }
    }
}

