/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.interpreter;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologCode;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import gnu.prolog.vm.interpreter.InterpretedCodeCompiler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicate_call
extends ExecuteOnlyCode {
    public static final AtomTerm headFunctor = AtomTerm.get("$$$call$$$");
    public static final Term[] termArrayType = new Term[0];

    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        return Predicate_call.staticExecute(interpreter, backtrackMode, args[0]);
    }

    public static int staticExecute(Interpreter interpreter, boolean backtrackMode, Term arg) throws PrologException {
        PrologCode code;
        Term[] args;
        Term callTerm;
        CallTermBacktrackInfo cbi;
        CallTermBacktrackInfo callTermBacktrackInfo = cbi = backtrackMode ? (CallTermBacktrackInfo)interpreter.popBacktrackInfo() : null;
        if (cbi == null) {
            Term body;
            callTerm = arg;
            if (callTerm instanceof VariableTerm) {
                PrologException.instantiationError();
            }
            HashMap<Term, VariableTerm> argumentsToArgumentVariables = new HashMap<Term, VariableTerm>();
            try {
                body = Predicate_call.getClause(callTerm, argumentsToArgumentVariables);
            }
            catch (IllegalArgumentException ex) {
                PrologException.typeError(TermConstants.callableAtom, callTerm);
                return -1;
            }
            Term[] headArgs = argumentsToArgumentVariables.values().toArray(termArrayType);
            CompoundTerm head = new CompoundTerm(headFunctor, headArgs);
            CompoundTerm clause = new CompoundTerm(TermConstants.clauseTag, head, body);
            args = argumentsToArgumentVariables.keySet().toArray(termArrayType);
            ArrayList<Term> clauses = new ArrayList<Term>(1);
            clauses.add(clause);
            code = InterpretedCodeCompiler.compile(clauses);
            code.install(interpreter.getEnvironment());
        } else {
            cbi.undo(interpreter);
            args = cbi.args;
            code = cbi.code;
            callTerm = cbi.callTerm;
        }
        int rc = code.execute(interpreter, backtrackMode, args);
        if (rc == 0) {
            cbi = new CallTermBacktrackInfo(interpreter, code, args, callTerm);
            cbi.environment = interpreter.getEnvironment();
            interpreter.pushBacktrackInfo(cbi);
        } else {
            code.uninstall(interpreter.getEnvironment());
            if (cbi != null) {
                cbi.code = null;
            }
        }
        return rc;
    }

    public static Term getClause(Term term, Map<Term, VariableTerm> argumentsToArgumentVariables) {
        if (term instanceof AtomTerm) {
            return term;
        }
        if (term instanceof VariableTerm) {
            if (!argumentsToArgumentVariables.containsKey(term)) {
                VariableTerm var1 = new VariableTerm();
                argumentsToArgumentVariables.put(term, var1);
                return var1;
            }
            return argumentsToArgumentVariables.get(term);
        }
        if (term instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)term;
            if (ct.tag == TermConstants.ifTag || ct.tag == TermConstants.conjunctionTag || ct.tag == TermConstants.disjunctionTag) {
                return new CompoundTerm(ct.tag, Predicate_call.getClause(ct.args[0].dereference(), argumentsToArgumentVariables), Predicate_call.getClause(ct.args[1].dereference(), argumentsToArgumentVariables));
            }
            Term[] newArgs = new Term[ct.tag.arity];
            int i = 0;
            while (i < newArgs.length) {
                Term arg = ct.args[i].dereference();
                if (!argumentsToArgumentVariables.containsKey(arg)) {
                    newArgs[i] = new VariableTerm();
                    argumentsToArgumentVariables.put(arg, (VariableTerm)newArgs[i]);
                } else {
                    newArgs[i] = argumentsToArgumentVariables.get(arg);
                }
                ++i;
            }
            return new CompoundTerm(ct.tag, newArgs);
        }
        throw new IllegalArgumentException("the term is not callable");
    }

    public static class CallTermBacktrackInfo
    extends BacktrackInfo {
        PrologCode code;
        Term[] args;
        Term callTerm;
        Environment environment;

        public CallTermBacktrackInfo(Interpreter in, PrologCode code, Term[] args, Term callTerm) {
            super(in.getUndoPosition(), -1);
            this.code = code;
            this.args = (Term[])args.clone();
            this.callTerm = callTerm;
        }

        protected void finalize() throws Throwable {
            if (this.code != null) {
                this.code.uninstall(this.environment);
            }
            super.finalize();
        }
    }
}

