/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.swing;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.EFrame;
import gnu.jemacs.buffer.EKeymap;
import gnu.jemacs.buffer.EWindow;
import gnu.jemacs.swing.IgnoreAction;
import gnu.jemacs.swing.Modeline;
import gnu.jemacs.swing.SwingBuffer;
import gnu.jemacs.swing.TooLongAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;

public class SwingWindow
extends EWindow
implements FocusListener,
KeyListener,
ChangeListener {
    static Hashtable panemap = new Hashtable();
    JTextPane jtextpane;
    JPanel panel;
    JScrollPane scrollPane;
    public Modeline modeline;

    public SwingWindow(Buffer buffer) {
        this(buffer, true);
    }

    public SwingWindow(Buffer buffer, boolean wantModeline) {
        super(null);
        this.jtextpane = new JTextPane(((SwingBuffer)buffer).doc);
        panemap.put(this.jtextpane, this);
        if (wantModeline) {
            this.modeline = new Modeline(this, ((SwingBuffer)buffer).modelineDocument);
        }
        this.buffer = buffer;
        this.jtextpane.addFocusListener(this);
        this.jtextpane.addKeyListener(this);
    }

    public JPanel wrap() {
        BorderLayout layout = new BorderLayout();
        JPanel panel = new JPanel(layout);
        this.scrollPane = new JScrollPane(this.jtextpane, 22, 31);
        panel.add((Component)this.scrollPane, "Center");
        if (this.modeline != null) {
            panel.add((Component)this.modeline, "South");
        }
        this.panel = panel;
        return panel;
    }

    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.setSelected();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void requestFocus() {
        this.jtextpane.requestFocus();
    }

    @Override
    public void setBuffer(Buffer buffer) {
        EWindow selected;
        if (this.buffer == buffer) {
            return;
        }
        super.setBuffer(buffer);
        this.jtextpane.setDocument(((SwingBuffer)buffer).doc);
        if (this.modeline != null) {
            this.modeline.setDocument(((SwingBuffer)buffer).modelineDocument);
        }
        if ((selected = SwingWindow.getSelected()) == this) {
            this.unselect();
            Caret caret = this.jtextpane.getCaret();
            caret.setDot(buffer.getDot());
            this.select(caret);
        }
    }

    @Override
    public void unselect() {
        int index;
        Caret caret = ((SwingBuffer)this.buffer).curPosition;
        if (caret == null) {
            return;
        }
        int point = caret.getDot();
        this.buffer.pointMarker.ipos = index = ((SwingBuffer)this.buffer).content.buffer.createPos(point, true);
        ((SwingBuffer)this.buffer).curPosition = null;
        this.jtextpane.getCaret().removeChangeListener(this);
    }

    @Override
    public void setSelected() {
        super.setSelected();
        this.select(this.jtextpane.getCaret());
    }

    @Override
    public int getPoint() {
        return 1 + this.jtextpane.getCaret().getDot();
    }

    @Override
    public void setDot(int offset) {
        this.jtextpane.getCaret().setDot(offset);
    }

    @Override
    public EWindow split(Buffer buffer, int lines, boolean horizontal) {
        EFrame frame97;
        SwingWindow window = new SwingWindow(buffer);
        window.frame = frame97 = this.frame;
        this.linkSibling(window, horizontal);
        window.modeline = new Modeline(window, ((SwingBuffer)buffer).modelineDocument);
        JPanel panel = this.getPanel();
        Dimension oldSize = panel.getSize();
        Container oldParent = panel.getParent();
        oldParent.remove(panel);
        JSplitPane split = new JSplitPane(horizontal ? 1 : 0, panel, window.wrap());
        split.setDividerSize(2);
        split.setDividerLocation((horizontal ? oldSize.width : oldSize.height) / 2);
        oldParent.add(split);
        oldParent.validate();
        if (this == EWindow.getSelected()) {
            this.requestFocus();
        }
        return window;
    }

    private void select(Caret caret) {
        ((SwingBuffer)this.buffer).curPosition = caret;
        if (!this.buffer.pointMarker.isPoint()) {
            ((SwingBuffer)this.buffer).content.buffer.releasePos(this.buffer.pointMarker.ipos);
        }
        this.buffer.pointMarker.sequence = null;
        caret.addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int dot;
        Caret caret;
        int mark;
        Object source = e.getSource();
        if (source instanceof Caret && this.buffer != null && (mark = (caret = (Caret)source).getMark()) != (dot = caret.getDot())) {
            this.buffer.markMarker.set(this.buffer, mark);
        }
    }

    public static JTextPane getContainedWindow(Container cont, boolean last) {
        while (!(cont instanceof JTextPane)) {
            if (cont instanceof JScrollPane) {
                cont = (Container)((JScrollPane)cont).getViewport().getView();
                continue;
            }
            if (cont instanceof JFrame) {
                cont = ((JFrame)cont).getContentPane();
                continue;
            }
            if (cont instanceof JSplitPane) {
                JSplitPane split = (JSplitPane)cont;
                cont = (Container)(last ? split.getRightComponent() : split.getLeftComponent());
                continue;
            }
            int count = cont.getComponentCount();
            if (count == 0) {
                return null;
            }
            cont = (Container)cont.getComponent(last ? count - 1 : 0);
        }
        return (JTextPane)cont;
    }

    public static SwingWindow getWindow(ActionEvent event) {
        Component component = (Component)event.getSource();
        while (!(component instanceof JTextPane)) {
            component = component.getParent();
        }
        return (SwingWindow)panemap.get(component);
    }

    @Override
    protected void deleteNoValidate() {
        super.deleteNoValidate();
        if (this.modeline != null) {
            this.panel.remove(this.modeline);
        }
        this.panel.remove(this.scrollPane);
        Container oldParent = this.panel.getParent();
        if (oldParent instanceof JSplitPane) {
            JSplitPane split = (JSplitPane)oldParent;
            Component other = this.panel == split.getLeftComponent() ? split.getRightComponent() : split.getLeftComponent();
            split.remove(this.jtextpane);
            split.remove(other);
            Container splitParent = split.getParent();
            if (splitParent instanceof JSplitPane) {
                JSplitPane outerSplit = (JSplitPane)splitParent;
                if (split == outerSplit.getLeftComponent()) {
                    outerSplit.setLeftComponent(other);
                } else {
                    outerSplit.setRightComponent(other);
                }
            } else {
                splitParent.remove(split);
                splitParent.add(other);
            }
        } else {
            oldParent.remove(this.panel);
        }
        panemap.remove(this.jtextpane);
        this.jtextpane = null;
        this.panel = null;
        this.scrollPane = null;
    }

    public void activateRegion() {
        System.err.println("(activateRegions)");
        Caret caret = this.jtextpane.getCaret();
        caret.setDot(this.buffer.markMarker.getOffset());
        caret.moveDot(this.buffer.getDot());
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = this.panel.getSize();
        if (this.modeline != null) {
            size = new Dimension(size.width, size.height - this.modeline.getPreferredSize().height);
        }
        return size;
    }

    @Override
    protected void getCharSize() {
        Font defaultFont = ((SwingBuffer)this.buffer).doc.getFont(SwingBuffer.defaultStyle);
        FontMetrics fm = this.jtextpane.getGraphics().getFontMetrics(defaultFont);
        this.charHeight = fm.getHeight();
        this.charWidth = fm.charWidth('m');
    }

    @Override
    public int getWidth() {
        return this.jtextpane.getWidth();
    }

    @Override
    public int getHeight() {
        return this.jtextpane.getWidth();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.handle(e, this.toInt(e, 0));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.handle(e, this.toInt(e, EKeymap.PRESSED));
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.handle(e, this.toInt(e, EKeymap.RELEASED));
    }

    protected void handle(KeyEvent e, int code) {
        Object action = this.lookupKey(code);
        this.pushPrefix(code);
        --this.pendingLength;
        if (action == null || action instanceof IgnoreAction) {
            e.consume();
            return;
        }
        this.handleCommand(action);
        e.consume();
    }

    int toInt(KeyEvent e, int kind) {
        int mods = e.getModifiers();
        if (kind == 0) {
            mods &= 0xFFFFFFFE;
        }
        return (kind == 0 ? e.getKeyChar() : e.getKeyCode()) | (mods | kind) << 16;
    }

    void flushPending() {
        this.pendingLength = 0;
    }

    @Override
    public Object tooLong(int pendingLength) {
        return new TooLongAction(pendingLength);
    }
}

