/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.CharSeq;
import gnu.lists.Consumer;
import gnu.lists.FString;
import gnu.lists.StableVector;
import gnu.lists.SubCharSeq;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

public class CharBuffer
extends StableVector
implements CharSeq,
Serializable {
    private FString string;

    public CharBuffer(FString str) {
        super(str);
        this.string = str;
    }

    public CharBuffer(int initialSize) {
        this(new FString(initialSize));
    }

    protected CharBuffer() {
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public char charAt(int index) {
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        return this.string.charAt(index);
    }

    public int indexOf(int ch, int fromChar) {
        char c2;
        char c1;
        if (ch >= 65536) {
            c1 = (char)((ch - 65536 >> 10) + 55296);
            c2 = (char)((ch & 0x3FF) + 56320);
        } else {
            c1 = (char)ch;
            c2 = '\u0000';
        }
        char[] arr = this.getArray();
        int i = fromChar;
        int limit = this.gapStart;
        if (i >= limit) {
            i += this.gapEnd - this.gapStart;
            limit = arr.length;
        }
        while (true) {
            if (i == limit) {
                limit = arr.length;
                if (i >= limit) break;
                i = this.gapEnd;
            }
            if (arr[i] == c1 && (c2 == '\u0000' || (i + 1 < limit ? arr[i + 1] == c2 : this.gapEnd < arr.length && arr[this.gapEnd] == c2))) {
                return i > this.gapStart ? i - (this.gapEnd - this.gapStart) : i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(int ch, int fromChar) {
        char c2;
        char c1;
        if (ch >= 65536) {
            c1 = (char)((ch - 65536 >> 10) + 55296);
            c2 = (char)((ch & 0x3FF) + 56320);
        } else {
            c1 = '\u0000';
            c2 = (char)ch;
        }
        int i = fromChar;
        while (--i >= 0) {
            if (this.charAt(i) != c2) continue;
            if (c1 == '\u0000') {
                return i;
            }
            if (i <= 0 || this.charAt(i - 1) != c1) continue;
            return i - 1;
        }
        return -1;
    }

    @Override
    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        int gapSize;
        int count;
        char[] array = this.string.data;
        if (srcBegin < this.gapStart && (count = (srcEnd < this.gapStart ? srcEnd : this.gapStart) - srcBegin) > 0) {
            System.arraycopy(array, srcBegin, dst, dstBegin, count);
            srcBegin += count;
            dstBegin += count;
        }
        if ((count = (srcEnd += (gapSize = this.gapEnd - this.gapStart)) - (srcBegin += gapSize)) > 0) {
            System.arraycopy(array, srcBegin, dst, dstBegin, count);
        }
    }

    @Override
    public void setCharAt(int index, char value) {
        if (index >= this.gapStart) {
            index += this.gapEnd - this.gapStart;
        }
        this.string.setCharAt(index, value);
    }

    public String substring(int start, int end) {
        int sz = this.size();
        if (start < 0 || end < start || end > sz) {
            throw new IndexOutOfBoundsException();
        }
        int len = end - start;
        start = this.getSegment(start, len);
        return new String(this.getArray(), start, len);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int sz = this.size();
        if (start < 0 || end < start || end > sz) {
            throw new IndexOutOfBoundsException();
        }
        return new SubCharSeq(this, this.base.createPos(start, false), this.base.createPos(end, true));
    }

    @Override
    public void fill(int fromIndex, int toIndex, char value) {
        int i;
        int limit;
        char[] array = this.string.data;
        int n = limit = this.gapStart < toIndex ? this.gapStart : toIndex;
        for (i = fromIndex; i < limit; ++i) {
            array[i] = value;
        }
        int gapSize = this.gapEnd - this.gapStart;
        i = limit + gapSize;
        limit += toIndex;
        while (i < limit) {
            array[i] = value;
            ++i;
        }
    }

    @Override
    public final void fill(char value) {
        char[] array = this.string.data;
        int i = array.length;
        while (--i >= this.gapEnd) {
            array[i] = value;
        }
        i = this.gapStart;
        while (--i >= 0) {
            array[i] = value;
        }
    }

    public char[] getArray() {
        return (char[])this.base.getBuffer();
    }

    public void delete(int where, int count) {
        int ipos = this.createPos(where, false);
        this.removePos(ipos, count);
        this.releasePos(ipos);
    }

    public void insert(int where, String str, boolean beforeMarkers) {
        int len = str.length();
        this.gapReserve(where, len);
        str.getChars(0, len, this.string.data, where);
        this.gapStart += len;
    }

    @Override
    public void consume(int start, int count, Consumer dest) {
        char[] array = this.string.data;
        if (start < this.gapStart) {
            int count0 = this.gapStart - start;
            if (count0 > count) {
                count0 = count;
            }
            dest.write(array, start, count0);
            start += (count -= count0);
        }
        if (count > 0) {
            dest.write(array, start += this.gapEnd - this.gapStart, count);
        }
    }

    @Override
    public String toString() {
        int len = this.size();
        int start = this.getSegment(0, len);
        return new String(this.getArray(), start, len);
    }

    @Override
    public void writeTo(int start, int count, Appendable dest) throws IOException {
        if (dest instanceof Writer) {
            this.writeTo(start, count, (Writer)dest);
        } else {
            dest.append(this, start, start + count);
        }
    }

    @Override
    public void writeTo(Appendable dest) throws IOException {
        this.writeTo(0, this.size(), dest);
    }

    public void writeTo(int start, int count, Writer dest) throws IOException {
        char[] array = this.string.data;
        if (start < this.gapStart) {
            int count0 = this.gapStart - start;
            if (count0 > count) {
                count0 = count;
            }
            dest.write(array, start, count0);
            start += (count -= count0);
        }
        if (count > 0) {
            dest.write(array, start += this.gapEnd - this.gapStart, count);
        }
    }

    public void writeTo(Writer dest) throws IOException {
        char[] array = this.string.data;
        dest.write(array, 0, this.gapStart);
        dest.write(array, this.gapEnd, array.length - this.gapEnd);
    }

    public void dump() {
        int i;
        System.err.println("Buffer Content dump.  size:" + this.size() + "  buffer:" + this.getArray().length);
        System.err.print("before gap: \"");
        System.err.print(new String(this.getArray(), 0, this.gapStart));
        System.err.println("\" (gapStart:" + this.gapStart + " gapEnd:" + this.gapEnd + ')');
        System.err.print("after gap: \"");
        System.err.print(new String(this.getArray(), this.gapEnd, this.getArray().length - this.gapEnd));
        System.err.println("\"");
        int poslen = this.positions == null ? 0 : this.positions.length;
        System.err.println("Positions (size: " + poslen + " free:" + this.free + "):");
        boolean[] isFree = null;
        if (this.free != -2) {
            isFree = new boolean[this.positions.length];
            i = this.free;
            while (i >= 0) {
                isFree[i] = true;
                i = this.positions[i];
            }
        }
        for (i = 0; i < poslen; ++i) {
            int pos = this.positions[i];
            if (!(this.free == -2 ? pos != -2 : !isFree[i])) continue;
            System.err.println("position#" + i + ": " + (pos >> 1) + " isAfter:" + (pos & 1));
        }
    }
}

