/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.Target;
import gnu.expr.Undefined;
import gnu.lists.FormatToConsumer;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Values;

public class QuoteExp
extends Expression {
    Object value;
    public static QuoteExp undefined_exp = new QuoteExp(Undefined.getInstance());
    public static QuoteExp voidExp = new QuoteExp(Values.empty);
    public static QuoteExp trueExp = new QuoteExp(Boolean.TRUE);
    public static QuoteExp falseExp = new QuoteExp(Boolean.FALSE);
    public static QuoteExp nullExp = new QuoteExp(null);

    public final Object getValue() {
        return this.value;
    }

    public final Type getType() {
        if (this.value == Values.empty) {
            return Type.void_type;
        }
        if (this.value == null) {
            return Type.nullType;
        }
        return Type.make(this.value.getClass());
    }

    public QuoteExp(Object object2) {
        this.value = object2;
    }

    public Object eval(Environment environment) {
        return this.value;
    }

    public void compile(Compilation compilation, Target target) {
        compilation.compileConstant(this.value, target);
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkQuoteExp(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Quote", ")", 2);
        outPort.writeSpaceLinear();
        FormatToConsumer formatToConsumer = outPort.objectFormat;
        try {
            outPort.objectFormat = Interpreter.getInterpreter().getFormat(true);
            outPort.print(this.value);
        }
        finally {
            outPort.objectFormat = formatToConsumer;
        }
        outPort.endLogicalBlock(")");
    }
}

