/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.kawa.functions.AppendValues;
import gnu.kawa.lispexpr.LispInterpreter;
import gnu.kawa.reflect.ClassMemberConstraint;
import gnu.kawa.reflect.StaticFieldConstraint;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.mapping.Environment;
import gnu.mapping.Named;
import gnu.mapping.Symbol;
import gnu.text.SourceMessages;
import java.util.Vector;
import kawa.lang.AutoloadProcedure;
import kawa.lang.Macro;
import kawa.lang.Syntax;

public class Translator
extends Compilation {
    private Environment env;
    public Macro currentMacroDefinition;
    private static Expression errorExp = new ErrorExp("unknown syntax error");
    Syntax currentSyntax;
    private Object nameToLookup;
    PairWithPosition positionPair;

    public boolean isLexical(Declaration declaration) {
        if (declaration == null) {
            return false;
        }
        if (!declaration.isFluid()) {
            return true;
        }
        ScopeExp scopeExp = this.currentScope();
        ScopeExp scopeExp2 = declaration.getContext();
        while (scopeExp != null) {
            if (scopeExp == scopeExp2) {
                return true;
            }
            if (scopeExp instanceof LambdaExp && !((LambdaExp)scopeExp).getInlineOnly()) {
                return false;
            }
            scopeExp = scopeExp.outer;
        }
        return false;
    }

    public Translator(Interpreter interpreter, SourceMessages sourceMessages) {
        super(interpreter, sourceMessages);
        this.env = interpreter.getEnvironment();
    }

    public final Environment getGlobalEnvironment() {
        return this.env;
    }

    public Expression parse(Object object2) {
        return this.rewrite(object2);
    }

    final Expression rewrite_car(Pair pair, boolean bl) {
        Object object2 = pair.car;
        if (pair instanceof PairWithPosition) {
            return this.rewrite_with_position(object2, bl, (PairWithPosition)pair);
        }
        return this.rewrite(object2, bl);
    }

    public Syntax getCurrentSyntax() {
        return this.currentSyntax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Expression apply_rewrite(Syntax syntax2, Pair pair) {
        Expression expression = errorExp;
        Syntax syntax3 = this.currentSyntax;
        this.currentSyntax = syntax2;
        try {
            expression = syntax2.rewriteForm(pair, this);
        }
        finally {
            this.currentSyntax = syntax3;
        }
        return expression;
    }

    public Expression syntaxError(String string) {
        this.error('e', string);
        return new ErrorExp(string);
    }

    static ReferenceExp getOriginalRef(Declaration declaration) {
        Expression expression;
        if (declaration != null && declaration.isAlias() && !declaration.isIndirectBinding() && (expression = declaration.getValue()) instanceof ReferenceExp) {
            return (ReferenceExp)expression;
        }
        return null;
    }

    public boolean matches(Object object2, String string) {
        ReferenceExp referenceExp;
        if (object2 instanceof Symbol && (referenceExp = Translator.getOriginalRef(this.lexical.lookup(object2, -1))) != null) {
            object2 = referenceExp.getSymbol();
        }
        return object2 == string;
    }

    public Declaration lookup(Object object2, int n) {
        Declaration declaration = this.lexical.lookup(object2, n);
        if (declaration != null && (this.getInterpreter().getNamespaceOf(declaration) & n) != 0) {
            return declaration;
        }
        return this.lookupGlobal(object2, n);
    }

    public Declaration lookupGlobal(Object object2) {
        return this.lookupGlobal(object2, -1);
    }

    public Declaration lookupGlobal(Object object2, int n) {
        ModuleExp moduleExp = this.currentModule();
        Declaration declaration = moduleExp.lookup(object2, this.getInterpreter(), n);
        if (declaration == null) {
            declaration = moduleExp.getNoDefine(object2);
            declaration.setIndirectBinding(true);
        }
        return declaration;
    }

    Object getBinding(Object object2, boolean bl) {
        if (object2 instanceof String || object2 instanceof Symbol) {
            Object object3;
            Declaration declaration = this.lexical.lookup(object2, bl);
            if (declaration != null) {
                object3 = Translator.getOriginalRef(declaration);
                if (object3 != null) {
                    declaration = ((ReferenceExp)object3).getBinding();
                    this.nameToLookup = object2 = ((ReferenceExp)object3).getSymbol();
                    object2 = declaration == null ? this.resolve(object2, bl) : declaration;
                } else {
                    this.nameToLookup = declaration.getSymbol();
                    object2 = declaration;
                }
            } else {
                this.nameToLookup = object2;
                object2 = this.resolve(object2, bl);
            }
            if (object2 instanceof Syntax) {
                return object2;
            }
            if (object2 instanceof Declaration && (object3 = Declaration.followAliases((Declaration)object2).getValue()) instanceof QuoteExp) {
                return ((QuoteExp)object3).getValue();
            }
            if (object2 != null) {
                if (object2 instanceof Declaration && !this.isLexical((Declaration)object2)) {
                    object2 = null;
                }
            } else {
                Object object4 = object3 = this.nameToLookup instanceof Symbol ? (Symbol)this.nameToLookup : this.env.lookup(this.nameToLookup.toString());
                if (object3 != null && ((Symbol)object3).isBound()) {
                    return ((Symbol)object3).get();
                }
            }
            return null;
        }
        return object2;
    }

    public Syntax check_if_Syntax(Object object2) {
        if ((object2 = this.getBinding(object2, true)) instanceof Syntax) {
            return (Syntax)object2;
        }
        return null;
    }

    public Expression rewrite_pair(Pair pair) {
        int n;
        Object object2;
        Object object3;
        if (pair.car instanceof Syntax) {
            return this.apply_rewrite((Syntax)pair.car, pair);
        }
        Object object4 = pair.cdr;
        Expression expression = this.rewrite_car(pair, true);
        Object object5 = null;
        ReferenceExp referenceExp = null;
        if (expression instanceof ReferenceExp) {
            referenceExp = (ReferenceExp)expression;
            Declaration declaration = referenceExp.getBinding();
            if (declaration == null) {
                Symbol symbol;
                object3 = referenceExp.getSymbol();
                if (object3 instanceof Symbol) {
                    symbol = (Symbol)object3;
                    object2 = symbol.getName();
                } else {
                    object2 = object3.toString();
                    symbol = this.env.lookup((String)object2);
                }
                if (symbol != null) {
                    object5 = this.getInterpreter().hasSeparateFunctionNamespace() ? symbol.getFunctionValue(null) : symbol.get(null);
                }
                if (object5 instanceof Syntax) {
                    return this.apply_rewrite((Syntax)object5, pair);
                }
                if (object5 instanceof AutoloadProcedure) {
                    try {
                        object5 = ((AutoloadProcedure)object5).getLoaded();
                    }
                    catch (RuntimeException runtimeException) {
                        object5 = null;
                    }
                }
            } else {
                object5 = (declaration = Declaration.followAliases(declaration)).getConstantValue();
                if (object5 instanceof Syntax) {
                    return this.apply_rewrite((Syntax)object5, pair);
                }
            }
            referenceExp.setProcedureName(true);
            if (this.getInterpreter().hasSeparateFunctionNamespace()) {
                expression.setFlag(ReferenceExp.PREFER_BINDING2);
            }
        }
        if ((n = LList.listLength(object4, false)) < 0) {
            return this.syntaxError("dotted list is not allowed");
        }
        object3 = new Expression[n];
        for (int i = 0; i < n; ++i) {
            object2 = (Pair)object4;
            object3[i] = this.rewrite_car((Pair)object2, false);
            object4 = ((Pair)object2).cdr;
        }
        return new ApplyExp(expression, (Expression[])object3);
    }

    public Expression rewrite(Object object2) {
        return this.rewrite(object2, false);
    }

    public Expression rewrite(Object object2, boolean bl) {
        if (object2 instanceof PairWithPosition) {
            return this.rewrite_with_position(object2, bl, (PairWithPosition)object2);
        }
        if (object2 instanceof Pair) {
            return this.rewrite_pair((Pair)object2);
        }
        if (object2 instanceof String || object2 instanceof Symbol) {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            int n;
            Object object8;
            Declaration declaration = this.lexical.lookup(object2, bl);
            Symbol symbol = null;
            if (declaration != null) {
                this.nameToLookup = declaration.getSymbol();
                object2 = null;
                object8 = Translator.getOriginalRef(declaration);
                if (object8 != null && (declaration = ((ReferenceExp)object8).getBinding()) == null) {
                    this.nameToLookup = object2 = ((ReferenceExp)object8).getSymbol();
                }
            } else {
                this.nameToLookup = object2;
            }
            if (this.nameToLookup instanceof String && declaration == null && (n = ((String)(object8 = (String)this.nameToLookup)).indexOf(58)) > 0 && n < ((String)object8).length() - 1) {
                object7 = ((String)object8).substring(0, n);
                object6 = ((String)object8).substring(n + 1);
                object5 = ("$Namespace$" + (String)object7).intern();
                object4 = this.lexical.lookup(object5, bl);
                if (object4 instanceof Declaration) {
                    declaration = Declaration.followAliases((Declaration)object4);
                    object3 = declaration.getValue();
                    if (object3 instanceof QuoteExp) {
                        String string = ((QuoteExp)object3).getValue().toString();
                        return this.rewrite(Symbol.make(string, (String)object6), bl);
                    }
                } else {
                    object3 = this.resolve(this.env.lookup((String)object5), bl);
                    if (object3 != null) {
                        return this.rewrite(Symbol.make(object3.toString(), (String)object6), bl);
                    }
                    try {
                        Class<?> clazz = Class.forName((String)object7);
                        return this.rewrite(Symbol.make("class:" + (String)object7, (String)object6), bl);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            symbol = object2 instanceof String ? this.env.lookup((String)object2) : (Symbol)object2;
            object8 = this.resolve(symbol, bl);
            n = this.getInterpreter().hasSeparateFunctionNamespace() ? 1 : 0;
            if (declaration != null) {
                if (!this.isLexical(declaration) || n != 0 && declaration.isProcedureDecl()) {
                    declaration = null;
                }
            } else if (object8 instanceof Named) {
                if (object8 instanceof AutoloadProcedure) {
                    try {
                        object8 = ((AutoloadProcedure)object8).getLoaded();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                object7 = (Named)object8;
                object6 = symbol.getConstraint();
                if (object6 instanceof StaticFieldConstraint) {
                    object5 = (StaticFieldConstraint)object6;
                    object4 = ((ClassMemberConstraint)object5).getName();
                    object3 = ((ClassMemberConstraint)object5).getDeclaringClass();
                    Field field = ((ClassType)object3).getDeclaredField((String)object4);
                    if (field != null && field.getStaticFlag()) {
                        int n2 = field.getModifiers();
                        declaration = new Declaration((Object)object7.getName(), field);
                        declaration.noteValue(new QuoteExp(object7));
                        if ((n2 & 0x10) != 0) {
                            declaration.setFlag(16384);
                        }
                        if (object8 instanceof Syntax) {
                            declaration.setFlag(32768);
                        }
                    }
                } else if (Compilation.inlineOk) {
                    declaration = Declaration.getDeclaration((Named)object7);
                }
            }
            if (declaration != null && declaration.getFlag(0x100000) && declaration.isProcedureDecl() && !bl) {
                return this.syntaxError("not implemented: variable reference to a method");
            }
            object7 = new ReferenceExp(this.nameToLookup, declaration);
            if (n != 0) {
                ((Expression)object7).setFlag(ReferenceExp.PREFER_BINDING2);
            }
            return object7;
        }
        if (object2 instanceof Expression) {
            return (Expression)object2;
        }
        return new QuoteExp(object2);
    }

    public static void setLine(Declaration declaration, Object object2) {
        if (object2 instanceof PairWithPosition) {
            PairWithPosition pairWithPosition = (PairWithPosition)object2;
            declaration.setFile(pairWithPosition.getFile());
            declaration.setLine(pairWithPosition.getLine(), pairWithPosition.getColumn());
        }
    }

    public Object pushPositionOf(Object object2) {
        if (!(object2 instanceof PairWithPosition)) {
            return null;
        }
        PairWithPosition pairWithPosition = (PairWithPosition)object2;
        PairWithPosition pairWithPosition2 = this.positionPair;
        if (this.positionPair == null || this.positionPair.getFile() != this.getFile() || this.positionPair.getLine() != this.getLine() || this.positionPair.getColumn() != this.getColumn()) {
            pairWithPosition2 = PairWithPosition.make(Special.eof, this.positionPair, this.getFile(), this.getLine(), this.getColumn());
        }
        this.setLine(object2);
        this.positionPair = pairWithPosition;
        return pairWithPosition2;
    }

    public void popPositionOf(Object object2) {
        if (object2 == null) {
            return;
        }
        this.setLine(object2);
        this.positionPair = (PairWithPosition)object2;
        if (this.positionPair.car == Special.eof) {
            this.positionPair = (PairWithPosition)this.positionPair.cdr;
        }
    }

    public void setLine(Object object2) {
        if (object2 instanceof PairWithPosition) {
            PairWithPosition pairWithPosition = (PairWithPosition)object2;
            this.setLine(pairWithPosition.getFile(), pairWithPosition.getLine(), pairWithPosition.getColumn());
        }
    }

    public void setLineOf(Expression expression) {
        if (expression.getFile() == null) {
            expression.setFile(this.getFile());
        }
        if (expression.getLine() == 0) {
            expression.setLine(this.getLine(), this.getColumn());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type exp2Type(Pair pair) {
        Object object2 = this.pushPositionOf(pair);
        try {
            Expression expression = this.rewrite_car(pair, false);
            if (expression instanceof ErrorExp) {
                Type type = null;
                return type;
            }
            Type type = this.getInterpreter().getTypeFor(expression);
            if (type == null) {
                if (expression instanceof ReferenceExp) {
                    this.error('e', "unknown type name '" + ((ReferenceExp)expression).getName() + '\'');
                } else {
                    this.error('e', "invalid type spec (must be \"type\" or 'type or <type>)");
                }
            }
            Type type2 = type;
            return type2;
        }
        finally {
            this.popPositionOf(object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite_with_position(Object object2, boolean bl, PairWithPosition pairWithPosition) {
        Expression expression;
        Object object3 = this.pushPositionOf(pairWithPosition);
        try {
            expression = object2 == pairWithPosition ? this.rewrite_pair(pairWithPosition) : this.rewrite(object2, bl);
            this.setLineOf(expression);
        }
        finally {
            this.popPositionOf(object3);
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scan_form(Object object2, Vector vector, ScopeExp scopeExp) {
        if (!(object2 instanceof Pair)) {
            vector.addElement(object2);
        } else {
            Pair pair = (Pair)object2;
            Object object3 = pair.car;
            Syntax syntax2 = this.check_if_Syntax(object3);
            if (syntax2 == null) {
                vector.addElement(object2);
            } else {
                String string = this.getFile();
                int n = this.getLine();
                int n2 = this.getColumn();
                try {
                    this.setLine(pair);
                    if (!syntax2.scanForDefinitions(pair, vector, scopeExp, this)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    this.setLine(string, n, n2);
                }
            }
        }
        return true;
    }

    public boolean scan_body(Object object2, Vector vector, ScopeExp scopeExp) {
        boolean bl = true;
        while (object2 != LList.Empty) {
            if (!(object2 instanceof Pair)) {
                vector.addElement(this.syntaxError("body is not a proper list"));
                return false;
            }
            Pair pair = (Pair)object2;
            Object object3 = pair.car;
            if (!this.scan_form(object3, vector, scopeExp)) {
                bl = false;
            }
            object2 = pair.cdr;
        }
        return bl;
    }

    public static Pair makePair(Pair pair, Object object2, Object object3) {
        if (pair instanceof PairWithPosition) {
            return new PairWithPosition((PairWithPosition)pair, object2, object3);
        }
        return new Pair(object2, object3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite_body(Object object2) {
        Object object3 = this.pushPositionOf(object2);
        Vector vector = new Vector(20);
        LetExp letExp = new LetExp(null);
        letExp.outer = this.current_scope;
        this.current_scope = letExp;
        try {
            Object object4;
            if (!this.scan_body(object2, vector, letExp)) {
                ErrorExp errorExp = new ErrorExp("error while scanning in body");
                return errorExp;
            }
            int n = vector.size();
            if (n == 0) {
                Expression expression = this.syntaxError("body with no expressions");
                return expression;
            }
            int n2 = letExp.countDecls();
            if (n2 != 0) {
                object4 = new Expression[n2];
                int n3 = n2;
                while (--n3 >= 0) {
                    object4[n3] = QuoteExp.nullExp;
                }
                letExp.inits = object4;
            }
            object4 = this.makeBody(vector, null);
            this.setLineOf((Expression)object4);
            if (n2 == 0) {
                Object object5 = object4;
                return object5;
            }
            this.mustCompileHere();
            letExp.body = object4;
            this.setLineOf(letExp);
            LetExp letExp2 = letExp;
            return letExp2;
        }
        finally {
            this.pop(letExp);
            this.popPositionOf(object3);
        }
    }

    public Expression makeBody(Vector vector, ScopeExp scopeExp) {
        int n = vector.size();
        if (n == 0) {
            return QuoteExp.voidExp;
        }
        if (n == 1) {
            return this.rewrite(vector.elementAt(0));
        }
        Expression[] expressionArray = new Expression[n];
        for (int i = 0; i < n; ++i) {
            expressionArray[i] = this.rewrite(vector.elementAt(i));
        }
        if (scopeExp instanceof ModuleExp) {
            return new ApplyExp(AppendValues.appendValues, expressionArray);
        }
        return ((LispInterpreter)this.getInterpreter()).makeBody(expressionArray);
    }

    public void finishModule(ModuleExp moduleExp, Vector vector) {
        boolean bl = moduleExp.isStatic();
        for (Declaration declaration = moduleExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.getFlag(512) && !declaration.getFlag(65536)) {
                String string = "'";
                String string2 = declaration.getFlag(1024) ? "' exported but never defined" : (declaration.getFlag(2048) ? "' declared static but never defined" : "' declared but never defined");
                this.error('e', declaration, string, string2);
            }
            if (moduleExp.getFlag(2048)) {
                if (declaration.getFlag(1024)) {
                    if (declaration.isPrivate()) {
                        if (declaration.getFlag(262144)) {
                            this.error('e', declaration, "'", "' is declared both private and exported");
                        }
                        declaration.setPrivate(false);
                    }
                } else {
                    declaration.setPrivate(true);
                }
            }
            if (bl) {
                declaration.setFlag(2048);
                continue;
            }
            if ((!moduleExp.getFlag(8192) || declaration.getFlag(2048)) && Compilation.moduleStatic >= 0 && !moduleExp.getFlag(16384)) continue;
            declaration.setFlag(4096);
        }
        if (!bl) {
            moduleExp.declareThis(null);
        }
        this.setModule(moduleExp);
        moduleExp.body = this.makeBody(vector, moduleExp);
        this.lexical.pop(moduleExp);
    }
}

