/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;
import gnu.expr.ThisExp;
import java.util.Hashtable;

public class FindCapturedVars
extends ExpWalker {
    Hashtable unknownDecls = null;
    ModuleExp currentModule = null;

    public static void findCapturedVars(Expression expression) {
        expression.walk(new FindCapturedVars());
    }

    protected Expression walkApplyExp(ApplyExp applyExp) {
        Expression expression;
        Declaration declaration;
        boolean bl = false;
        if (applyExp.func instanceof ReferenceExp && !Compilation.usingTailCalls && (declaration = Declaration.followAliases(((ReferenceExp)applyExp.func).binding)) != null && declaration.context instanceof ModuleExp && (expression = declaration.getValue()) instanceof LambdaExp) {
            LambdaExp lambdaExp = (LambdaExp)expression;
            LambdaExp lambdaExp2 = this.getCurrentLambda();
            if (!lambdaExp.getNeedsClosureEnv()) {
                bl = true;
            }
        }
        if (!bl) {
            applyExp.func = applyExp.func.walk(this);
        }
        if (this.exitValue == null) {
            applyExp.args = this.walkExps(applyExp.args);
        }
        return applyExp;
    }

    public void walkDefaultArgs(LambdaExp lambdaExp) {
        if (lambdaExp.defaultArgs == null) {
            return;
        }
        super.walkDefaultArgs(lambdaExp);
        Declaration declaration = lambdaExp.firstDecl();
        while (declaration != null) {
            if (!declaration.isSimple()) {
                lambdaExp.setFlag(true, 512);
                break;
            }
            declaration = declaration.nextDecl();
        }
    }

    protected Expression walkClassExp(ClassExp classExp) {
        Expression expression = super.walkClassExp(classExp);
        if (!classExp.getNeedsClosureEnv()) {
            Compilation.getConstructor(classExp.instanceType, classExp);
        }
        return expression;
    }

    protected Expression walkModuleExp(ModuleExp moduleExp) {
        ModuleExp moduleExp2 = this.currentModule;
        Hashtable hashtable = this.unknownDecls;
        this.currentModule = moduleExp;
        this.unknownDecls = null;
        try {
            Expression expression = this.walkLambdaExp(moduleExp);
            Object var6_5 = null;
            this.currentModule = moduleExp2;
            this.unknownDecls = hashtable;
            return expression;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.currentModule = moduleExp2;
            this.unknownDecls = hashtable;
            throw throwable;
        }
    }

    protected Expression walkFluidLetExp(FluidLetExp fluidLetExp) {
        Declaration declaration = fluidLetExp.firstDecl();
        while (declaration != null) {
            Declaration declaration2 = this.allocUnboundDecl(declaration.getName());
            this.capture(declaration2);
            declaration.base = declaration2;
            declaration = declaration.nextDecl();
        }
        return super.walkLetExp(fluidLetExp);
    }

    protected Expression walkLetExp(LetExp letExp) {
        if (letExp.body instanceof BeginExp) {
            Expression[] expressionArray = letExp.inits;
            int n = expressionArray.length;
            Expression[] expressionArray2 = ((BeginExp)letExp.body).exps;
            int n2 = 0;
            Declaration declaration = letExp.firstDecl();
            int n3 = 0;
            while (n3 < expressionArray2.length && n2 < n) {
                Expression expression = expressionArray2[n3];
                if (expression instanceof SetExp) {
                    SetExp setExp = (SetExp)expression;
                    if (setExp.binding == declaration && expressionArray[n2] == QuoteExp.nullExp && setExp.isDefining()) {
                        Expression expression2 = setExp.new_value;
                        if ((expression2 instanceof QuoteExp || expression2 instanceof LambdaExp) && declaration.getValue() == expression2) {
                            expressionArray[n2] = expression2;
                            expressionArray2[n3] = QuoteExp.voidExp;
                        }
                        ++n2;
                        declaration = declaration.nextDecl();
                    }
                }
                ++n3;
            }
        }
        return super.walkLetExp(letExp);
    }

    public void capture(Declaration declaration) {
        LambdaExp lambdaExp;
        Expression expression;
        Expression expression2;
        if (!declaration.getCanRead() && !declaration.getCanCall()) {
            return;
        }
        if (declaration.field != null && declaration.field.getStaticFlag()) {
            return;
        }
        if (declaration.getFlag(16384) && declaration.getValue() instanceof QuoteExp) {
            return;
        }
        LambdaExp lambdaExp2 = this.getCurrentLambda();
        LambdaExp lambdaExp3 = declaration.getContext().currentLambda();
        Expression expression3 = null;
        LambdaExp lambdaExp4 = null;
        while (lambdaExp2 != lambdaExp3 && lambdaExp2.getInlineOnly()) {
            expression2 = lambdaExp2.outerLambda();
            if (expression2 != expression3) {
                lambdaExp4 = expression2.firstChild;
                expression3 = expression2;
            }
            expression = lambdaExp2.returnContinuation;
            if (lambdaExp4 == null || expression == null) {
                lambdaExp2.setCanCall(false);
                return;
            }
            lambdaExp2 = ((ApplyExp)expression).context;
            lambdaExp4 = lambdaExp4.nextSibling;
        }
        if (Compilation.usingCPStyle() ? lambdaExp2 instanceof ModuleExp : lambdaExp2 == lambdaExp3) {
            return;
        }
        expression2 = declaration.getValue();
        if (expression2 == null || !(expression2 instanceof LambdaExp)) {
            expression = null;
        } else {
            expression = expression2;
            if (((LambdaExp)expression).getInlineOnly()) {
                return;
            }
            if (((LambdaExp)expression).isHandlingTailCalls()) {
                expression = null;
            } else if (expression == lambdaExp2 && !declaration.getCanRead()) {
                return;
            }
        }
        if (declaration.getFlag(65536)) {
            for (lambdaExp = lambdaExp2; lambdaExp != lambdaExp3; lambdaExp = lambdaExp.outerLambda()) {
                if (lambdaExp.nameDecl == null || !lambdaExp.nameDecl.getFlag(2048)) continue;
                declaration.setFlag(2048);
                break;
            }
        }
        if (declaration.base != null) {
            declaration.base.setCanRead(true);
            this.capture(declaration.base);
        } else if (declaration.getCanRead() || expression == null) {
            if (!declaration.isStatic()) {
                LambdaExp lambdaExp5;
                lambdaExp = lambdaExp2;
                lambdaExp.setImportsLexVars();
                LambdaExp lambdaExp6 = lambdaExp5 = lambdaExp.outerLambda();
                while (lambdaExp6 != lambdaExp3 && lambdaExp6 != null) {
                    lambdaExp = lambdaExp6;
                    if (!declaration.getCanRead() && expression == lambdaExp6) break;
                    lambdaExp.setNeedsStaticLink();
                    lambdaExp6 = lambdaExp.outerLambda();
                }
            }
            if (declaration.isSimple()) {
                if (!(lambdaExp3.capturedVars != null || declaration.isStatic() || lambdaExp3 instanceof ModuleExp || lambdaExp3 instanceof ClassExp)) {
                    lambdaExp3.heapFrame = new Variable("heapFrame");
                    lambdaExp3.heapFrame.setArtificial(true);
                }
                declaration.setSimple(false);
                if (!declaration.isPublic()) {
                    declaration.nextCapturedVar = lambdaExp3.capturedVars;
                    lambdaExp3.capturedVars = declaration;
                }
            }
        }
    }

    Declaration allocUnboundDecl(String string) {
        Declaration declaration;
        if (this.unknownDecls == null) {
            this.unknownDecls = new Hashtable(100);
            declaration = null;
        } else {
            declaration = (Declaration)this.unknownDecls.get(string);
        }
        if (declaration == null) {
            declaration = this.currentModule.addDeclaration(string);
            declaration.setSimple(false);
            declaration.setPrivate(true);
            if (this.currentModule.isStatic()) {
                declaration.setFlag(2048);
            }
            declaration.setCanRead(true);
            declaration.setFlag(65536);
            declaration.setIndirectBinding(true);
            this.unknownDecls.put(string, declaration);
        }
        return declaration;
    }

    protected Expression walkReferenceExp(ReferenceExp referenceExp) {
        Declaration declaration = referenceExp.getBinding();
        if (declaration == null) {
            declaration = this.allocUnboundDecl(referenceExp.getName());
            referenceExp.setBinding(declaration);
        }
        this.capture(Declaration.followAliases(declaration));
        return referenceExp;
    }

    protected Expression walkThisExp(ThisExp thisExp) {
        this.getCurrentLambda().setImportsLexVars();
        return thisExp;
    }

    protected Expression walkSetExp(SetExp setExp) {
        Declaration declaration = setExp.binding;
        if (declaration == null) {
            setExp.binding = declaration = this.allocUnboundDecl(setExp.getName());
        }
        this.capture(Declaration.followAliases(declaration));
        return super.walkSetExp(setExp);
    }
}

