/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolUtf8;
import gnu.bytecode.ExceptionsAttr;
import gnu.bytecode.Member;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Stack;

public class Method
implements AttrContainer,
Member {
    private String name;
    Type[] arg_types;
    Type return_type;
    int access_flags;
    int name_index;
    int signature_index;
    Method next;
    ClassType classfile;
    Attribute attributes;
    ExceptionsAttr exceptions;
    CodeAttr code;
    String signature;

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute attribute) {
        this.attributes = attribute;
    }

    public final ExceptionsAttr getExceptionAttr() {
        return this.exceptions;
    }

    public void setExceptions(short[] sArray) {
        if (this.exceptions == null) {
            this.exceptions = new ExceptionsAttr(this);
        }
        this.exceptions.setExceptions(sArray, this.classfile);
    }

    public void setExceptions(ClassType[] classTypeArray) {
        if (this.exceptions == null) {
            this.exceptions = new ExceptionsAttr(this);
        }
        this.exceptions.setExceptions(classTypeArray);
    }

    public final CodeAttr getCode() {
        return this.code;
    }

    private Method() {
    }

    public static Method makeCloneMethod(Type type) {
        Method method = new Method();
        method.name = "clone";
        method.access_flags = 1;
        method.arg_types = Type.typeArray0;
        method.return_type = type;
        method.classfile = Type.pointer_type;
        return method;
    }

    public Method(Method method, ClassType classType) {
        this.arg_types = method.arg_types;
        this.return_type = method.return_type;
        this.name = method.name;
        this.access_flags = method.access_flags;
        this.classfile = classType;
    }

    Method(ClassType classType, int n) {
        if (classType.last_method == null) {
            classType.methods = this;
        } else {
            classType.last_method.next = this;
        }
        classType.last_method = this;
        ++classType.methods_count;
        this.access_flags = n;
        this.classfile = classType;
    }

    public final void setStaticFlag(boolean bl) {
        this.access_flags = bl ? (this.access_flags |= 8) : (this.access_flags ^= 0xFFFFFFF7);
    }

    public final boolean getStaticFlag() {
        return (this.access_flags & 8) != 0;
    }

    public final boolean isAbstract() {
        return (this.access_flags & 0x400) != 0;
    }

    public int getModifiers() {
        return this.access_flags;
    }

    public void setModifiers(int n) {
        this.access_flags = n;
    }

    public final ConstantPool getConstants() {
        return this.classfile.constants;
    }

    public Scope pushScope() {
        this.prepareCode(0);
        return this.code.pushScope();
    }

    public final boolean reachableHere() {
        return this.code.reachableHere();
    }

    public Scope popScope() {
        return this.code.popScope();
    }

    public void allocate_local(Variable variable) {
        variable.allocateLocal(this.code);
    }

    public void initCode() {
        if (this.classfile.constants == null) {
            this.classfile.constants = new ConstantPool();
        }
        this.prepareCode(0);
        this.code.sourceDbgExt = this.classfile.sourceDbgExt;
        this.code.noteParamTypes();
        this.code.pushScope();
    }

    public void init_param_slots() {
        this.initCode();
        this.code.addParamLocals();
    }

    public CodeAttr startCode() {
        this.initCode();
        this.code.addParamLocals();
        return this.code;
    }

    void kill_local(Variable variable) {
        variable.freeLocal(this.code);
    }

    void prepareCode(int n) {
        if (this.code == null) {
            this.code = new CodeAttr(this);
        }
        this.code.reserve(n);
    }

    void instruction_start_hook(int n) {
        this.prepareCode(n);
    }

    final Type pop_stack_type() {
        return this.code.popType();
    }

    final void push_stack_type(Type type) {
        this.code.pushType(type);
    }

    public void compile_checkcast(Type type) {
        this.code.emitCheckcast(type);
    }

    public void maybe_compile_checkcast(Type type) {
        Type type2 = this.code.topType();
        if (type != type2) {
            this.code.emitCheckcast(type);
        }
    }

    public void push_var(Variable variable) {
        this.code.emitLoad(variable);
    }

    public void compile_push_value(Variable variable) {
        this.code.emitLoad(variable);
    }

    public void compile_store_value(Variable variable) {
        this.code.emitStore(variable);
    }

    public void compile_push_this() {
        this.code.emitPushThis();
    }

    void write(DataOutputStream dataOutputStream, ClassType classType) throws IOException {
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.signature_index);
        Attribute.writeAll(this, dataOutputStream);
    }

    public static String makeSignature(Type[] typeArray, Type type) {
        StringBuilder stringBuilder = new StringBuilder(100);
        int n = typeArray.length;
        stringBuilder.append('(');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(typeArray[i].getSignature());
        }
        stringBuilder.append(')');
        stringBuilder.append(type.getSignature());
        return stringBuilder.toString();
    }

    public String getSignature() {
        if (this.signature == null) {
            this.signature = Method.makeSignature(this.arg_types, this.return_type);
        }
        return this.signature;
    }

    public void setSignature(String string) {
        int n;
        int n2 = string.length();
        if (n2 < 3 || string.charAt(0) != '(') {
            throw new ClassFormatError("bad method signature");
        }
        int n3 = 1;
        Stack<Type> stack = new Stack<Type>();
        while (true) {
            if ((n = Type.signatureLength(string, n3)) < 0) {
                if (n3 < n2 && string.charAt(n3) == ')') break;
                throw new ClassFormatError("bad method signature");
            }
            Type type = Type.signatureToType(string, n3, n);
            stack.push(type);
            n3 += n;
        }
        this.arg_types = new Type[stack.size()];
        n = stack.size();
        while (--n >= 0) {
            this.arg_types[n] = (Type)stack.pop();
        }
        this.return_type = Type.signatureToType(string, n3 + 1, n2 - n3 - 1);
    }

    public void setSignature(int n) {
        CpoolUtf8 cpoolUtf8 = (CpoolUtf8)this.getConstants().getForced(n, 1);
        this.signature_index = n;
        this.setSignature(cpoolUtf8.string);
    }

    void assignConstants() {
        ConstantPool constantPool = this.getConstants();
        if (this.name_index == 0 && this.name != null) {
            this.name_index = constantPool.addUtf8((String)this.name).index;
        }
        if (this.signature_index == 0) {
            this.signature_index = constantPool.addUtf8((String)this.getSignature()).index;
        }
        Attribute.assignConstants(this, this.classfile);
    }

    public ClassType getDeclaringClass() {
        return this.classfile;
    }

    public final Type getReturnType() {
        return this.return_type;
    }

    public final Type[] getParameterTypes() {
        return this.arg_types;
    }

    public final ClassType[] getExceptions() {
        if (this.exceptions == null) {
            return null;
        }
        return this.exceptions.getExceptions();
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final void setName(int n) {
        if (n <= 0) {
            this.name = null;
        } else {
            CpoolUtf8 cpoolUtf8 = (CpoolUtf8)this.getConstants().getForced(n, 1);
            this.name = cpoolUtf8.string;
        }
        this.name_index = n;
    }

    public final Method getNext() {
        return this.next;
    }

    public void listParameters(StringBuffer stringBuffer) {
        int n = this.arg_types.length;
        stringBuffer.append('(');
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.arg_types[i].getName());
        }
        stringBuffer.append(')');
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.getDeclaringClass().getName());
        stringBuffer.append('.');
        stringBuffer.append(this.name);
        if (this.arg_types != null) {
            this.listParameters(stringBuffer);
            stringBuffer.append(this.return_type.getName());
        }
        return stringBuffer.toString();
    }

    public void cleanupAfterCompilation() {
        this.attributes = null;
        this.exceptions = null;
        this.code = null;
    }
}

