/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.AccessExp;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.util.IdentityHashTable;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.text.SourceMessages;

public class ApplyExp
extends Expression {
    Expression func;
    Expression[] args;
    public static final int TAILCALL = 1;
    public static final int INLINE_IF_CONSTANT = 2;
    LambdaExp context;
    public ApplyExp nextCall;
    protected Type type;

    public final Expression getFunction() {
        return this.func;
    }

    public final Expression[] getArgs() {
        return this.args;
    }

    public final int getArgCount() {
        return this.args.length;
    }

    public void setFunction(Expression expression) {
        this.func = expression;
    }

    public void setArgs(Expression[] expressionArray) {
        this.args = expressionArray;
    }

    public Expression getArg(int n) {
        return this.args[n];
    }

    public void setArg(int n, Expression expression) {
        this.args[n] = expression;
    }

    public final boolean isTailCall() {
        return this.getFlag(1);
    }

    public final void setTailCall(boolean bl) {
        this.setFlag(bl, 1);
    }

    public final Object getFunctionValue() {
        return this.func instanceof QuoteExp ? ((QuoteExp)this.func).getValue() : null;
    }

    public ApplyExp(Expression expression, Expression[] expressionArray) {
        this.func = expression;
        this.args = expressionArray;
    }

    public ApplyExp(Procedure procedure, Expression[] expressionArray) {
        this.func = new QuoteExp(procedure);
        this.args = expressionArray;
    }

    public ApplyExp(Method method, Expression[] expressionArray) {
        this.func = new QuoteExp(new PrimProcedure(method));
        this.args = expressionArray;
    }

    protected boolean mustCompile() {
        return false;
    }

    public void apply(CallContext callContext) throws Throwable {
        Object object2 = this.func.eval(callContext);
        int n = this.args.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.args[i].eval(callContext);
        }
        ((Procedure)object2).checkN(objectArray, callContext);
    }

    public static void compileToArray(Expression[] expressionArray, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (expressionArray.length == 0) {
            codeAttr.emitGetStatic(Compilation.noArgsField);
            return;
        }
        codeAttr.emitPushInt(expressionArray.length);
        codeAttr.emitNewArray(Type.pointer_type);
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression expression = expressionArray[i];
            if (compilation.usingCPStyle() && !(expression instanceof QuoteExp) && !(expression instanceof ReferenceExp)) {
                expression.compileWithPosition(compilation, Target.pushObject);
                codeAttr.emitSwap();
                codeAttr.emitDup(1, 1);
                codeAttr.emitSwap();
                codeAttr.emitPushInt(i);
                codeAttr.emitSwap();
            } else {
                codeAttr.emitDup(Compilation.objArrayType);
                codeAttr.emitPushInt(i);
                expression.compileWithPosition(compilation, Target.pushObject);
            }
            codeAttr.emitArrayStore(Type.pointer_type);
        }
    }

    public void compile(Compilation compilation, Target target) {
        ApplyExp.compile(this, compilation, target, true);
    }

    public static void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        ApplyExp.compile(applyExp, compilation, target, false);
    }

    static void compile(ApplyExp applyExp, Compilation compilation, Target target, boolean bl) {
        boolean bl2;
        Object object2;
        Object object3;
        Object object4;
        int n = applyExp.args.length;
        Expression expression = applyExp.func;
        LambdaExp lambdaExp = null;
        String string = null;
        Declaration declaration = null;
        if (expression instanceof LambdaExp) {
            lambdaExp = (LambdaExp)expression;
            string = lambdaExp.getName();
            if (string == null) {
                string = "<lambda>";
            }
        } else if (expression instanceof ReferenceExp) {
            object4 = (ReferenceExp)expression;
            declaration = ((AccessExp)object4).contextDecl();
            object3 = ((ReferenceExp)object4).binding;
            while (object3 != null && ((Declaration)object3).isAlias() && ((Declaration)object3).value instanceof ReferenceExp) {
                object4 = (ReferenceExp)((Declaration)object3).value;
                if (declaration != null || ((Declaration)object3).needsContext() || ((ReferenceExp)object4).binding == null) break;
                object3 = ((ReferenceExp)object4).binding;
                declaration = ((AccessExp)object4).contextDecl();
            }
            if (!((Declaration)object3).getFlag(65536)) {
                Expression expression2 = ((Declaration)object3).getValue();
                string = ((Declaration)object3).getName();
                if (expression2 != null && expression2 instanceof LambdaExp) {
                    lambdaExp = (LambdaExp)expression2;
                }
                if (expression2 != null && expression2 instanceof QuoteExp) {
                    object2 = ((QuoteExp)expression2).getValue();
                    if (bl && object2 instanceof Inlineable) {
                        ((Inlineable)object2).compile(applyExp, compilation, target);
                        return;
                    }
                }
            }
        } else if (expression instanceof QuoteExp && (object4 = ((QuoteExp)expression).getValue()) instanceof Inlineable && bl) {
            ((Inlineable)object4).compile(applyExp, compilation, target);
            return;
        }
        object4 = compilation.getCode();
        if (lambdaExp != null) {
            if (lambdaExp.max_args >= 0 && n > lambdaExp.max_args || n < lambdaExp.min_args) {
                throw new Error("internal error - wrong number of parameters for " + lambdaExp);
            }
            int n2 = lambdaExp.getCallConvention();
            if (compilation.inlineOk(lambdaExp) && (n2 <= 2 || n2 == 3 && !applyExp.isTailCall()) && (object3 = lambdaExp.getMethod(n)) != null) {
                object2 = new PrimProcedure((Method)object3, lambdaExp);
                boolean bl3 = ((Method)object3).getStaticFlag();
                boolean bl4 = false;
                if (!bl3 || lambdaExp.declareClosureEnv() != null) {
                    if (bl3) {
                        bl4 = true;
                    }
                    if (compilation.curLambda == lambdaExp) {
                        ((CodeAttr)object4).emitLoad(lambdaExp.closureEnv != null ? lambdaExp.closureEnv : lambdaExp.thisVariable);
                    } else if (declaration != null) {
                        declaration.load(null, 0, compilation, Target.pushObject);
                    } else {
                        lambdaExp.getOwningLambda().loadHeapFrame(compilation);
                    }
                }
                ((PrimProcedure)object2).compile(bl4 ? Type.voidType : null, applyExp, compilation, target);
                return;
            }
        }
        boolean bl5 = bl2 = applyExp.isTailCall() && lambdaExp != null && lambdaExp == compilation.curLambda;
        if (lambdaExp != null && lambdaExp.getInlineOnly() && !bl2 && lambdaExp.min_args == n) {
            ApplyExp.pushArgs(lambdaExp, applyExp.args, null, compilation);
            if (lambdaExp.getFlag(128)) {
                ApplyExp.popParams((CodeAttr)object4, lambdaExp, null, false);
                ((CodeAttr)object4).emitTailCall(false, lambdaExp.getVarScope());
                return;
            }
            lambdaExp.flags |= 0x80;
            object2 = compilation.curLambda;
            compilation.curLambda = lambdaExp;
            lambdaExp.allocChildClasses(compilation);
            lambdaExp.allocParameters(compilation);
            ApplyExp.popParams((CodeAttr)object4, lambdaExp, null, false);
            lambdaExp.enterFunction(compilation);
            lambdaExp.body.compileWithPosition(compilation, target);
            lambdaExp.compileEnd(compilation);
            lambdaExp.generateApplyMethods(compilation);
            ((CodeAttr)object4).popScope();
            compilation.curLambda = object2;
            return;
        }
        if (compilation.curLambda.isHandlingTailCalls() && (applyExp.isTailCall() || target instanceof ConsumerTarget) && !compilation.curLambda.getInlineOnly()) {
            object2 = Compilation.typeCallContext;
            expression.compile(compilation, new StackTarget(Compilation.typeProcedure));
            if (n <= 4) {
                for (int i = 0; i < n; ++i) {
                    applyExp.args[i].compileWithPosition(compilation, Target.pushObject);
                }
                compilation.loadCallContext();
                ((CodeAttr)object4).emitInvoke(Compilation.typeProcedure.getDeclaredMethod("check" + n, n + 1));
            } else {
                ApplyExp.compileToArray(applyExp.args, compilation);
                compilation.loadCallContext();
                ((CodeAttr)object4).emitInvoke(Compilation.typeProcedure.getDeclaredMethod("checkN", 2));
            }
            if (applyExp.isTailCall()) {
                ((CodeAttr)object4).emitReturn();
            } else if (((ConsumerTarget)target).isContextTarget()) {
                compilation.loadCallContext();
                ((CodeAttr)object4).emitInvoke(((ClassType)object2).getDeclaredMethod("runUntilDone", 0));
            } else {
                compilation.loadCallContext();
                ((CodeAttr)object4).emitLoad(((ConsumerTarget)target).getConsumerVariable());
                ((CodeAttr)object4).emitInvoke(((ClassType)object2).getDeclaredMethod("runUntilValue", 1));
            }
            return;
        }
        if (!bl2) {
            expression.compile(compilation, new StackTarget(Compilation.typeProcedure));
        }
        boolean bl6 = bl2 ? lambdaExp.min_args != lambdaExp.max_args : n > 4;
        int[] nArray = null;
        if (bl6) {
            ApplyExp.compileToArray(applyExp.args, compilation);
            object3 = Compilation.applyNmethod;
        } else if (bl2) {
            nArray = new int[applyExp.args.length];
            ApplyExp.pushArgs(lambdaExp, applyExp.args, nArray, compilation);
            object3 = null;
        } else {
            for (int i = 0; i < n; ++i) {
                applyExp.args[i].compileWithPosition(compilation, Target.pushObject);
                if (!((CodeAttr)object4).reachableHere()) break;
            }
            object3 = Compilation.applymethods[n];
        }
        if (!((CodeAttr)object4).reachableHere()) {
            compilation.error('e', "unreachable code");
            return;
        }
        if (bl2) {
            ApplyExp.popParams((CodeAttr)object4, lambdaExp, nArray, bl6);
            ((CodeAttr)object4).emitTailCall(false, lambdaExp.getVarScope());
            return;
        }
        ((CodeAttr)object4).emitInvokeVirtual((Method)object3);
        target.compileFromStack(compilation, Type.pointer_type);
    }

    public Expression deepCopy(IdentityHashTable identityHashTable) {
        Expression expression = ApplyExp.deepCopy(this.func, identityHashTable);
        Expression[] expressionArray = ApplyExp.deepCopy(this.args, identityHashTable);
        if (expression == null && this.func != null || expressionArray == null && this.args != null) {
            return null;
        }
        ApplyExp applyExp = new ApplyExp(expression, expressionArray);
        applyExp.flags = this.getFlags();
        return applyExp;
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkApplyExp(this);
    }

    public void walkArgs(ExpWalker expWalker) {
        this.args = expWalker.walkExps(this.args, this.args.length);
    }

    public void walkArgs(ExpWalker expWalker, boolean bl) {
        if (!bl) {
            this.args = expWalker.walkExps(this.args, this.args.length);
        }
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.func = expWalker.walk(this.func);
        if (expWalker.exitValue == null) {
            this.args = expWalker.walkExps(this.args, this.args.length);
        }
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Apply", ")", 2);
        if (this.isTailCall()) {
            outPort.print(" [tailcall]");
        }
        if (this.type != null && this.type != Type.pointer_type) {
            outPort.print(" => ");
            outPort.print(this.type);
        }
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        this.func.print(outPort);
        for (int i = 0; i < this.args.length; ++i) {
            outPort.writeSpaceLinear();
            this.args[i].print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    private static void pushArgs(LambdaExp lambdaExp, Expression[] expressionArray, int[] nArray, Compilation compilation) {
        Declaration declaration = lambdaExp.firstDecl();
        for (Expression expression : expressionArray) {
            if (declaration.ignorable()) {
                expression.compile(compilation, Target.Ignore);
            } else if (nArray == null || (nArray[var6_6] = SetExp.canUseInc(expression, declaration)) == 65536) {
                expression.compileWithPosition(compilation, StackTarget.getInstance(declaration.getType()));
            }
            declaration = declaration.nextDecl();
        }
    }

    private static void popParams(CodeAttr codeAttr, LambdaExp lambdaExp, int[] nArray, boolean bl) {
        Variable variable = lambdaExp.getVarScope().firstVar();
        Declaration declaration = lambdaExp.firstDecl();
        if (variable != null && variable.getName() == "this") {
            variable = variable.nextVar();
        }
        if (variable != null && variable.getName() == "$ctx") {
            variable = variable.nextVar();
        }
        if (variable != null && variable.getName() == "argsArray") {
            if (bl) {
                ApplyExp.popParams(codeAttr, 0, 1, null, declaration, variable);
                return;
            }
            variable = variable.nextVar();
        }
        ApplyExp.popParams(codeAttr, 0, lambdaExp.min_args, nArray, declaration, variable);
    }

    private static void popParams(CodeAttr codeAttr, int n, int n2, int[] nArray, Declaration declaration, Variable variable) {
        if (n2 > 0) {
            ApplyExp.popParams(codeAttr, n + 1, --n2, nArray, declaration.nextDecl(), declaration.getVariable() == null ? variable : variable.nextVar());
            if (!declaration.ignorable()) {
                if (nArray != null && nArray[n] != 65536) {
                    codeAttr.emitInc(variable, (short)nArray[n]);
                } else {
                    codeAttr.emitStore(variable);
                }
            }
        }
    }

    public final Type getTypeRaw() {
        return this.type;
    }

    public final void setType(Type type) {
        this.type = type;
    }

    public final Type getType() {
        Object object2;
        if (this.type != null) {
            return this.type;
        }
        Expression expression = this.func;
        this.type = Type.pointer_type;
        if (expression instanceof ReferenceExp) {
            object2 = ((ReferenceExp)expression).binding;
            if ((object2 = Declaration.followAliases((Declaration)object2)) != null && !((Declaration)object2).getFlag(65536)) {
                expression = ((Declaration)object2).getValue();
            }
        }
        if (expression instanceof QuoteExp) {
            object2 = ((QuoteExp)expression).getValue();
            if (object2 instanceof Inlineable) {
                this.type = ((Inlineable)object2).getReturnType(this.args);
            }
        } else if (expression instanceof LambdaExp) {
            this.type = ((LambdaExp)expression).getReturnType();
        }
        return this.type;
    }

    public final Expression inlineIfConstant(Procedure procedure, ExpWalker expWalker) {
        return this.inlineIfConstant(procedure, expWalker.getMessages());
    }

    public final Expression inlineIfConstant(Procedure procedure, SourceMessages sourceMessages) {
        int n = this.args.length;
        Object[] objectArray = new Object[n];
        int n2 = n;
        while (--n2 >= 0) {
            Declaration declaration;
            Expression expression = this.args[n2];
            if (expression instanceof ReferenceExp && (declaration = ((ReferenceExp)expression).getBinding()) != null && (expression = declaration.getValue()) == QuoteExp.undefined_exp) {
                return this;
            }
            if (!(expression instanceof QuoteExp)) {
                return this;
            }
            objectArray[n2] = ((QuoteExp)expression).getValue();
        }
        try {
            return new QuoteExp(procedure.applyN(objectArray));
        }
        catch (Throwable throwable) {
            if (sourceMessages != null) {
                sourceMessages.error('w', "call to " + procedure + " throws " + throwable);
            }
            return this;
        }
    }

    public String toString() {
        if (this == LambdaExp.unknownContinuation) {
            return "ApplyExp[unknownContinuation]";
        }
        return "ApplyExp/" + (this.args == null ? 0 : this.args.length) + '[' + this.func + ']';
    }
}

