/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Member;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ChainLambdas;
import gnu.expr.CheckedTarget;
import gnu.expr.ClassExp;
import gnu.expr.ConditionalTarget;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.FindCapturedVars;
import gnu.expr.FindTailCalls;
import gnu.expr.IfExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.Initializer;
import gnu.expr.InlineCalls;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.LitTable;
import gnu.expr.Literal;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.expr.NameLookup;
import gnu.expr.PairClassType;
import gnu.expr.PushApply;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.ThreadLocation;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.text.Lexer;
import gnu.text.Options;
import gnu.text.Path;
import gnu.text.SourceLocator;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Stack;
import java.util.Vector;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kawa.Shell;

public class Compilation
implements SourceLocator {
    public boolean mustCompile;
    int maxSelectorValue;
    public ClassType curClass;
    public ClassType mainClass;
    public ClassType moduleClass;
    public LambdaExp curLambda;
    public ModuleExp mainLambda;
    public Variable thisDecl;
    Variable moduleInstanceVar;
    private int state;
    public static final int PROLOG_PARSING = 1;
    public static final int PROLOG_PARSED = 2;
    public static final int BODY_PARSED = 4;
    public static final int RESOLVED = 6;
    public static final int WALKED = 8;
    public static final int COMPILE_SETUP = 10;
    public static final int COMPILED = 12;
    public static final int CLASS_WRITTEN = 14;
    public static final int ERROR_SEEN = 100;
    public ModuleInfo minfo;
    public Lexer lexer;
    boolean pedantic;
    Field moduleInstanceMainField;
    public Stack pendingImports;
    public static boolean fewerClasses;
    public static boolean debugPrintExpr;
    public static boolean debugPrintFinalExpr;
    public static Options options;
    public Options currentOptions = new Options(options);
    public static int defaultClassFileVersion;
    public static int defaultCallConvention;
    public static final int CALL_WITH_UNSPECIFIED = 0;
    public static final int CALL_WITH_RETURN = 1;
    public static final int CALL_WITH_CONSUMER = 2;
    public static final int CALL_WITH_TAILCALLS = 3;
    public static final int CALL_WITH_CONTINUATIONS = 4;
    public static int moduleStatic;
    ClassType[] classes;
    int numClasses;
    ArrayClassLoader loader;
    public boolean immediate;
    public Method method;
    Method clinitMethod;
    int method_counter;
    SwitchState fswitch;
    Field fswitchIndex;
    public static ClassType typeObject;
    public static ClassType scmBooleanType;
    public static ClassType typeString;
    public static ClassType javaStringType;
    public static ClassType scmKeywordType;
    public static ClassType scmSequenceType;
    public static ClassType scmListType;
    public static ClassType typePair;
    public static final ArrayType objArrayType;
    public static ClassType typeRunnable;
    public static ClassType typeType;
    public static ClassType typeObjectType;
    public static ClassType typeClass;
    public static ClassType typeClassType;
    public static ClassType typeProcedure;
    public static ClassType typeLanguage;
    public static ClassType typeEnvironment;
    public static ClassType typeLocation;
    public static ClassType typeSymbol;
    public static final Method getSymbolValueMethod;
    public static final Method getSymbolProcedureMethod;
    public static final Method getLocationMethod;
    public static final Method getProcedureBindingMethod;
    public static final Field trueConstant;
    public static final Field falseConstant;
    static final Method setNameMethod;
    static Method makeListMethod;
    public static final Type[] int1Args;
    public static final Type[] string1Arg;
    public static final Type[] sym1Arg;
    public static final Method getLocation1EnvironmentMethod;
    public static final Method getLocation2EnvironmentMethod;
    public static Method getCurrentEnvironmentMethod;
    public static Type[] apply0args;
    public static Type[] apply1args;
    public static Type[] apply2args;
    public static Type[] applyNargs;
    static Method checkArgCountMethod;
    public static Method apply0method;
    public static Method apply1method;
    public static Method apply2method;
    public static Method apply3method;
    public static Method apply4method;
    public static Method applyNmethod;
    public static Method[] applymethods;
    public static ClassType typeProcedure0;
    public static ClassType typeProcedure1;
    public static ClassType typeProcedure2;
    public static ClassType typeProcedure3;
    public static ClassType typeProcedure4;
    public static ClassType typeProcedureN;
    public static ClassType typeModuleBody;
    public static ClassType typeModuleWithContext;
    public static ClassType typeApplet;
    public static ClassType typeServlet;
    public static ClassType typeCallContext;
    public static final ClassType typeConsumer;
    public static Method getCallContextInstanceMethod;
    public static ClassType typeValues;
    public static Field noArgsField;
    public static Field pcCallContextField;
    public static ClassType typeMethodProc;
    public static ClassType typeModuleMethod;
    public static Field argsCallContextField;
    public static Field procCallContextField;
    private static Type[] applyCpsArgs;
    public static Method applyCpsMethod;
    public static ClassType[] typeProcedureArray;
    Initializer clinitChain;
    public static boolean generateMainDefault;
    public boolean generateMain = generateMainDefault;
    LitTable litTable;
    public static boolean generateAppletDefault;
    public boolean generateApplet = generateAppletDefault;
    public static boolean generateServletDefault;
    public boolean generateServlet = generateServletDefault;
    public static boolean inlineOk;
    public static String classPrefixDefault;
    public String classPrefix = classPrefixDefault;
    public static boolean emitSourceDebugExtAttr;
    int localFieldIndex;
    Variable callContextVar;
    Variable callContextVarForInit;
    protected Language language;
    public Stack exprStack;
    Method forNameHelper;
    private int keyUninitialized;
    private static Compilation chainUninitialized;
    private Compilation nextUninitialized;
    public NameLookup lexical;
    protected ScopeExp current_scope;
    protected SourceMessages messages;
    private static final ThreadLocation current;

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public void pushPendingImport(ModuleInfo moduleInfo, ScopeExp scopeExp) {
        if (this.pendingImports == null) {
            this.pendingImports = new Stack();
        }
        this.pendingImports.push(moduleInfo);
        this.pendingImports.push(scopeExp);
        ReferenceExp referenceExp = new ReferenceExp((Object)null);
        referenceExp.setLine(this);
        this.pendingImports.push(referenceExp);
    }

    public final boolean getBooleanOption(String string, boolean bl) {
        return this.currentOptions.getBoolean(string, bl);
    }

    public final boolean getBooleanOption(String string) {
        return this.currentOptions.getBoolean(string);
    }

    public boolean usingCPStyle() {
        return defaultCallConvention == 4;
    }

    public boolean usingTailCalls() {
        return defaultCallConvention >= 3;
    }

    public final CodeAttr getCode() {
        return this.method.getCode();
    }

    public final ClassType getModuleType() {
        return defaultCallConvention >= 2 ? typeModuleWithContext : typeModuleBody;
    }

    public void compileConstant(Object object2) {
        CodeAttr codeAttr = this.getCode();
        if (object2 == null) {
            codeAttr.emitPushNull();
        } else if (object2 instanceof String && !this.immediate) {
            codeAttr.emitPushString((String)object2);
        } else {
            codeAttr.emitGetStatic(this.compileConstantToField(object2));
        }
    }

    public Field compileConstantToField(Object object2) {
        Literal literal = this.litTable.findLiteral(object2);
        if (literal.field == null) {
            literal.assign(this.litTable);
        }
        return literal.field;
    }

    public boolean inlineOk(Expression expression) {
        if (expression instanceof LambdaExp && !(((LambdaExp)expression).currentLambda() instanceof ModuleExp)) {
            return true;
        }
        return inlineOk;
    }

    public boolean inlineOk(Procedure procedure) {
        return inlineOk;
    }

    public void compileConstant(Object object2, Target target) {
        Object object3;
        if (target instanceof IgnoreTarget) {
            return;
        }
        if (object2 instanceof Values) {
            object3 = ((Values)object2).getValues();
            int n = ((Object[])object3).length;
            if (target instanceof ConsumerTarget) {
                for (int i = 0; i < n; ++i) {
                    this.compileConstant(object3[i], target);
                }
                return;
            }
        }
        if (target instanceof ConditionalTarget) {
            object3 = (ConditionalTarget)target;
            this.getCode().emitGoto(this.getLanguage().isTrue(object2) ? ((ConditionalTarget)object3).ifTrue : ((ConditionalTarget)object3).ifFalse);
            return;
        }
        if (target instanceof StackTarget) {
            Object object4;
            object3 = ((StackTarget)target).getType();
            if (object3 instanceof PrimType) {
                try {
                    int n;
                    String string = ((Type)object3).getSignature();
                    object4 = this.getCode();
                    int n2 = n = string == null || string.length() != 1 ? 32 : (int)string.charAt(0);
                    if (object2 instanceof Number) {
                        Number number = (Number)object2;
                        switch (n) {
                            case 73: {
                                ((CodeAttr)object4).emitPushInt(number.intValue());
                                return;
                            }
                            case 83: {
                                ((CodeAttr)object4).emitPushInt(number.shortValue());
                                return;
                            }
                            case 66: {
                                ((CodeAttr)object4).emitPushInt(number.byteValue());
                                return;
                            }
                            case 74: {
                                ((CodeAttr)object4).emitPushLong(number.longValue());
                                return;
                            }
                            case 70: {
                                ((CodeAttr)object4).emitPushFloat(number.floatValue());
                                return;
                            }
                            case 68: {
                                ((CodeAttr)object4).emitPushDouble(number.doubleValue());
                                return;
                            }
                        }
                    }
                    if (n == 67) {
                        ((CodeAttr)object4).emitPushInt(((PrimType)object3).charValue(object2));
                        return;
                    }
                    if (n == 90) {
                        boolean bl = PrimType.booleanValue(object2);
                        ((CodeAttr)object4).emitPushInt(bl ? 1 : 0);
                        return;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (object3 == typeClass && object2 instanceof ClassType) {
                this.loadClassRef((ClassType)object2);
                return;
            }
            try {
                object2 = ((Type)object3).coerceFromObject(object2);
            }
            catch (Exception exception) {
                object4 = new StringBuffer();
                if (object2 == Values.empty) {
                    ((StringBuffer)object4).append("cannot convert void to ");
                } else {
                    ((StringBuffer)object4).append("cannot convert literal (of type ");
                    if (object2 == null) {
                        ((StringBuffer)object4).append("<null>");
                    } else {
                        ((StringBuffer)object4).append(object2.getClass().getName());
                    }
                    ((StringBuffer)object4).append(") to ");
                }
                ((StringBuffer)object4).append(((Type)object3).getName());
                this.error('w', ((StringBuffer)object4).toString());
            }
        }
        this.compileConstant(object2);
        target.compileFromStack(this, object2 == null ? target.getType() : Type.make(object2.getClass()));
    }

    private void dumpInitializers(Initializer initializer) {
        Initializer initializer2 = Initializer.reverse(initializer);
        while (initializer2 != null) {
            initializer2.emit(this);
            initializer2 = initializer2.next;
        }
    }

    public ClassType findNamedClass(String string) {
        for (int i = 0; i < this.numClasses; ++i) {
            if (!string.equals(this.classes[i].getName())) continue;
            return this.classes[i];
        }
        return null;
    }

    private static void putURLWords(String string, StringBuffer stringBuffer) {
        int n = string.indexOf(46);
        if (n > 0) {
            Compilation.putURLWords(string.substring(n + 1), stringBuffer);
            stringBuffer.append('.');
            string = string.substring(0, n);
        }
        stringBuffer.append(string);
    }

    public static String mangleURI(String string) {
        boolean bl = string.indexOf(47) >= 0;
        int n = string.length();
        if (n > 6 && string.startsWith("class:")) {
            return string.substring(6);
        }
        if (n > 5 && string.charAt(4) == ':' && string.substring(0, 4).equalsIgnoreCase("http")) {
            string = string.substring(5);
            n -= 5;
            bl = true;
        } else if (n > 4 && string.charAt(3) == ':' && string.substring(0, 3).equalsIgnoreCase("uri")) {
            string = string.substring(4);
            n -= 4;
        }
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            boolean bl2;
            int n3;
            int n4 = (n3 = string.indexOf(47, n2)) < 0 ? n : n3;
            boolean bl3 = bl2 = stringBuffer.length() == 0;
            if (bl2 && bl) {
                String string2 = string.substring(n2, n4);
                if (n4 - n2 > 4 && string2.startsWith("www.")) {
                    string2 = string2.substring(4);
                }
                Compilation.putURLWords(string2, stringBuffer);
            } else if (n2 != n4) {
                int n5;
                int n6;
                if (!bl2) {
                    stringBuffer.append('.');
                }
                if (n4 == n && (n6 = string.lastIndexOf(46, n)) > n2 + 1 && !bl2 && ((n5 = n - n6) <= 4 || n5 == 5 && string.endsWith("html"))) {
                    n4 = n -= n5;
                    string = string.substring(0, n);
                }
                stringBuffer.append(string.substring(n2, n4));
            }
            if (n3 < 0) break;
            n2 = n3 + 1;
        }
        return stringBuffer.toString();
    }

    public static String mangleName(String string) {
        return Compilation.mangleName(string, -1);
    }

    public static String mangleNameIfNeeded(String string) {
        if (string == null || Compilation.isValidJavaName(string)) {
            return string;
        }
        return Compilation.mangleName(string, 0);
    }

    public static boolean isValidJavaName(String string) {
        int n = string.length();
        if (n == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n2 = n;
        while (--n2 > 0) {
            if (Character.isJavaIdentifierPart(string.charAt(n2))) continue;
            return false;
        }
        return true;
    }

    public static String mangleName(String string, boolean bl) {
        return Compilation.mangleName(string, bl ? 1 : -1);
    }

    public static String mangleName(String string, int n) {
        boolean bl = n >= 0;
        int n2 = string.length();
        if (n2 == 6 && string.equals("*init*")) {
            return "<init>";
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (bl2) {
                c = Character.toTitleCase(c);
                bl2 = false;
            }
            if (Character.isDigit(c)) {
                if (i == 0) {
                    stringBuffer.append("$N");
                }
                stringBuffer.append(c);
                continue;
            }
            if (Character.isLetter(c) || c == '_') {
                stringBuffer.append(c);
                continue;
            }
            if (c == '$') {
                stringBuffer.append(n > 1 ? "$$" : "$");
                continue;
            }
            switch (c) {
                case '+': {
                    stringBuffer.append("$Pl");
                    break;
                }
                case '-': {
                    char c2;
                    if (bl) {
                        stringBuffer.append("$Mn");
                        break;
                    }
                    char c3 = c2 = i + 1 < n2 ? string.charAt(i + 1) : (char)'\u0000';
                    if (c2 == '>') {
                        stringBuffer.append("$To$");
                        ++i;
                        break;
                    }
                    if (Character.isLowerCase(c2)) break;
                    stringBuffer.append("$Mn");
                    break;
                }
                case '*': {
                    stringBuffer.append("$St");
                    break;
                }
                case '/': {
                    stringBuffer.append("$Sl");
                    break;
                }
                case '=': {
                    stringBuffer.append("$Eq");
                    break;
                }
                case '<': {
                    stringBuffer.append("$Ls");
                    break;
                }
                case '>': {
                    stringBuffer.append("$Gr");
                    break;
                }
                case '@': {
                    stringBuffer.append("$At");
                    break;
                }
                case '~': {
                    stringBuffer.append("$Tl");
                    break;
                }
                case '%': {
                    stringBuffer.append("$Pc");
                    break;
                }
                case '.': {
                    stringBuffer.append("$Dt");
                    break;
                }
                case ',': {
                    stringBuffer.append("$Cm");
                    break;
                }
                case '(': {
                    stringBuffer.append("$LP");
                    break;
                }
                case ')': {
                    stringBuffer.append("$RP");
                    break;
                }
                case '[': {
                    stringBuffer.append("$LB");
                    break;
                }
                case ']': {
                    stringBuffer.append("$RB");
                    break;
                }
                case '{': {
                    stringBuffer.append("$LC");
                    break;
                }
                case '}': {
                    stringBuffer.append("$RC");
                    break;
                }
                case '\'': {
                    stringBuffer.append("$Sq");
                    break;
                }
                case '\"': {
                    stringBuffer.append("$Dq");
                    break;
                }
                case '&': {
                    stringBuffer.append("$Am");
                    break;
                }
                case '#': {
                    stringBuffer.append("$Nm");
                    break;
                }
                case '?': {
                    char c2;
                    char c4 = c2 = stringBuffer.length() > 0 ? stringBuffer.charAt(0) : (char)'\u0000';
                    if (!bl && i + 1 == n2 && Character.isLowerCase(c2)) {
                        stringBuffer.setCharAt(0, Character.toTitleCase(c2));
                        stringBuffer.insert(0, "is");
                        break;
                    }
                    stringBuffer.append("$Qu");
                    break;
                }
                case '!': {
                    stringBuffer.append("$Ex");
                    break;
                }
                case ':': {
                    stringBuffer.append("$Cl");
                    break;
                }
                case ';': {
                    stringBuffer.append("$SC");
                    break;
                }
                case '^': {
                    stringBuffer.append("$Up");
                    break;
                }
                case '|': {
                    stringBuffer.append("$VB");
                    break;
                }
                default: {
                    stringBuffer.append('$');
                    stringBuffer.append(Character.forDigit(c >> 12 & 0xF, 16));
                    stringBuffer.append(Character.forDigit(c >> 8 & 0xF, 16));
                    stringBuffer.append(Character.forDigit(c >> 4 & 0xF, 16));
                    stringBuffer.append(Character.forDigit(c & 0xF, 16));
                }
            }
            if (bl) continue;
            bl2 = true;
        }
        String string2 = stringBuffer.toString();
        return string2.equals(string) ? string : string2;
    }

    public static char demangle2(char c, char c2) {
        switch (c << 16 | c2) {
            case 4259949: {
                return '&';
            }
            case 4259956: {
                return '@';
            }
            case 4391020: {
                return ':';
            }
            case 4391021: {
                return ',';
            }
            case 4456561: {
                return '\"';
            }
            case 0x440074: {
                return '.';
            }
            case 4522097: {
                return '=';
            }
            case 4522104: {
                return '!';
            }
            case 4653170: {
                return '>';
            }
            case 4980802: {
                return '[';
            }
            case 4980803: {
                return '{';
            }
            case 4980816: {
                return '(';
            }
            case 4980851: {
                return '<';
            }
            case 5046371: {
                return '%';
            }
            case 5046382: {
                return '-';
            }
            case 5111917: {
                return '#';
            }
            case 5242979: {
                return '%';
            }
            case 5242988: {
                return '+';
            }
            case 5308533: {
                return '?';
            }
            case 5374018: {
                return ']';
            }
            case 5374019: {
                return '}';
            }
            case 0x520050: {
                return ')';
            }
            case 5439555: {
                return ';';
            }
            case 5439596: {
                return '/';
            }
            case 5439601: {
                return '\\';
            }
            case 5439604: {
                return '*';
            }
            case 5505132: {
                return '~';
            }
            case 0x550070: {
                return '^';
            }
            case 5636162: {
                return '|';
            }
        }
        return '\uffff';
    }

    public static String demangleName(String string) {
        return Compilation.demangleName(string, false);
    }

    public static String demangleName(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (bl4 && !bl) {
                c2 = Character.toLowerCase(c2);
                bl4 = false;
            }
            if (!bl && c2 == 'i' && i == 0 && n > 2 && string.charAt(i + 1) == 's' && !Character.isLowerCase(c = string.charAt(i + 2))) {
                bl2 = true;
                bl3 = true;
                ++i;
                if (!Character.isUpperCase(c) && !Character.isTitleCase(c)) continue;
                stringBuffer.append(Character.toLowerCase(c));
                ++i;
                continue;
            }
            if (c2 == '$' && i + 2 < n) {
                char c3;
                char c4 = string.charAt(i + 1);
                c = Compilation.demangle2(c4, c3 = string.charAt(i + 2));
                if (c != '\uffff') {
                    stringBuffer.append(c);
                    i += 2;
                    bl2 = true;
                    bl4 = true;
                    continue;
                }
                if (c4 == 'T' && c3 == 'o' && i + 3 < n && string.charAt(i + 3) == '$') {
                    stringBuffer.append("->");
                    i += 3;
                    bl2 = true;
                    bl4 = true;
                    continue;
                }
            } else if (!bl && i > 1 && (Character.isUpperCase(c2) || Character.isTitleCase(c2)) && Character.isLowerCase(string.charAt(i - 1))) {
                stringBuffer.append('-');
                bl2 = true;
                c2 = Character.toLowerCase(c2);
            }
            stringBuffer.append(c2);
        }
        if (bl3) {
            stringBuffer.append('?');
        }
        return bl2 ? stringBuffer.toString() : string;
    }

    public String generateClassName(String string) {
        string = Compilation.mangleName(string, true);
        if (this.mainClass != null) {
            string = this.mainClass.getName() + '$' + string;
        } else if (this.classPrefix != null) {
            string = this.classPrefix + string;
        }
        if (this.findNamedClass(string) == null) {
            return string;
        }
        int n = 0;
        String string2;
        while (this.findNamedClass(string2 = string + n) != null) {
            ++n;
        }
        return string2;
    }

    public Compilation(Language language, SourceMessages sourceMessages, NameLookup nameLookup) {
        this.language = language;
        this.messages = sourceMessages;
        this.lexical = nameLookup;
    }

    public void walkModule(ModuleExp moduleExp) {
        if (debugPrintExpr) {
            OutPort outPort = OutPort.errDefault();
            outPort.println("[Module:" + moduleExp.getName());
            moduleExp.print(outPort);
            outPort.println(']');
            outPort.flush();
        }
        InlineCalls.inlineCalls(moduleExp, this);
        PushApply.pushApply(moduleExp);
        ChainLambdas.chainLambdas(moduleExp, this);
        FindTailCalls.findTailCalls(moduleExp, this);
    }

    public void outputClass(String string) throws IOException {
        char c = File.separatorChar;
        for (int i = 0; i < this.numClasses; ++i) {
            ClassType classType = this.classes[i];
            String string2 = string + classType.getName().replace('.', c) + ".class";
            String string3 = new File(string2).getParent();
            if (string3 != null) {
                new File(string3).mkdirs();
            }
            classType.writeToFile(string2);
        }
        this.cleanupAfterCompilation();
        this.litTable = null;
    }

    public void cleanupAfterCompilation() {
        for (int i = 0; i < this.numClasses; ++i) {
            this.classes[i].cleanupAfterCompilation();
        }
        this.classes = null;
        this.minfo.comp = null;
        if (this.minfo.exp != null) {
            this.minfo.exp.body = null;
        }
        this.mainLambda.body = null;
        this.mainLambda = null;
    }

    public void compileToArchive(ModuleExp moduleExp, String string) throws IOException {
        boolean bl = false;
        if (string.endsWith(".zip")) {
            bl = false;
        } else if (string.endsWith(".jar")) {
            bl = true;
        } else {
            string = string + ".zip";
            bl = false;
        }
        this.process(12);
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        ZipOutputStream zipOutputStream = bl ? new JarOutputStream(new FileOutputStream(file)) : new ZipOutputStream(new FileOutputStream(file));
        byte[][] byArrayArray = new byte[this.numClasses][];
        CRC32 cRC32 = new CRC32();
        for (int i = 0; i < this.numClasses; ++i) {
            ClassType classType = this.classes[i];
            byArrayArray[i] = classType.writeToArray();
            ZipEntry zipEntry = new ZipEntry(classType.getName().replace('.', '/') + ".class");
            zipEntry.setSize(byArrayArray[i].length);
            cRC32.reset();
            cRC32.update(byArrayArray[i], 0, byArrayArray[i].length);
            zipEntry.setCrc(cRC32.getValue());
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArrayArray[i]);
        }
        zipOutputStream.close();
    }

    private void registerClass(ClassType classType) {
        if (this.classes == null) {
            this.classes = new ClassType[20];
        } else if (this.numClasses >= this.classes.length) {
            ClassType[] classTypeArray = new ClassType[2 * this.classes.length];
            System.arraycopy(this.classes, 0, classTypeArray, 0, this.numClasses);
            this.classes = classTypeArray;
        }
        classType.addModifiers(classType.isInterface() ? 1 : 33);
        if (classType == this.mainClass && this.numClasses > 0) {
            classType = this.classes[0];
            this.classes[0] = this.mainClass;
        }
        this.classes[this.numClasses++] = classType;
    }

    public void addClass(ClassType classType) {
        if (this.mainLambda.filename != null) {
            if (emitSourceDebugExtAttr) {
                classType.setStratum(this.getLanguage().getName());
            }
            classType.setSourceFile(this.mainLambda.filename);
        }
        this.registerClass(classType);
        classType.setClassfileVersion(defaultClassFileVersion);
    }

    public boolean makeRunnable() {
        return !this.generateServlet && !this.generateApplet && !this.getModule().staticInitRun();
    }

    public void addMainClass(ModuleExp moduleExp) {
        ClassType classType;
        this.mustCompile = true;
        ClassType classType2 = this.mainClass = moduleExp.classFor(this);
        ClassType[] classTypeArray = moduleExp.getInterfaces();
        if (classTypeArray != null) {
            classType2.setInterfaces(classTypeArray);
        }
        if ((classType = moduleExp.getSuperType()) == null) {
            classType = this.generateApplet ? typeApplet : (this.generateServlet ? typeServlet : this.getModuleType());
        }
        if (this.makeRunnable()) {
            classType2.addInterface(typeRunnable);
        }
        classType2.setSuper(classType);
        moduleExp.type = classType2;
        this.addClass(classType2);
        Compilation.getConstructor(this.mainClass, moduleExp);
    }

    public final Method getConstructor(LambdaExp lambdaExp) {
        return Compilation.getConstructor(lambdaExp.getHeapFrameType(), lambdaExp);
    }

    public static final Method getConstructor(ClassType classType, LambdaExp lambdaExp) {
        Method method = classType.getDeclaredMethod("<init>", 0);
        if (method != null) {
            return method;
        }
        Type[] typeArray = lambdaExp instanceof ClassExp && lambdaExp.staticLinkField != null ? new Type[]{lambdaExp.staticLinkField.getType()} : apply0args;
        return classType.addMethod("<init>", 1, typeArray, Type.voidType);
    }

    public final void generateConstructor(LambdaExp lambdaExp) {
        this.generateConstructor(lambdaExp.getHeapFrameType(), lambdaExp);
    }

    public final void generateConstructor(ClassType classType, LambdaExp lambdaExp) {
        LambdaExp lambdaExp2;
        Method method;
        Method method2 = this.method;
        Variable variable = this.callContextVar;
        this.callContextVar = null;
        ClassType classType2 = this.curClass;
        this.curClass = classType;
        classType.constructor = method = Compilation.getConstructor(classType, lambdaExp);
        this.method = method;
        CodeAttr codeAttr = method.startCode();
        if (lambdaExp instanceof ClassExp && lambdaExp.staticLinkField != null) {
            codeAttr.emitPushThis();
            codeAttr.emitLoad(codeAttr.getCurrentScope().getVariable(1));
            codeAttr.emitPutField(lambdaExp.staticLinkField);
        }
        ClassType classType3 = classType.getSuperclass();
        ClassExp.invokeDefaultSuperConstructor(classType3, this, lambdaExp);
        if (this.curClass == this.mainClass && this.minfo != null && this.minfo.sourcePath != null) {
            codeAttr.emitPushThis();
            codeAttr.emitInvokeStatic(ClassType.make("gnu.expr.ModuleInfo").getDeclaredMethod("register", 1));
        }
        if (lambdaExp != null && lambdaExp.initChain != null) {
            Initializer initializer;
            lambdaExp2 = this.curLambda;
            this.curLambda = new LambdaExp();
            this.curLambda.closureEnv = codeAttr.getArg(0);
            this.curLambda.outer = lambdaExp2;
            while ((initializer = lambdaExp.initChain) != null) {
                lambdaExp.initChain = null;
                this.dumpInitializers(initializer);
            }
            this.curLambda = lambdaExp2;
        }
        if (lambdaExp instanceof ClassExp) {
            lambdaExp2 = (ClassExp)lambdaExp;
            this.callInitMethods(((ClassExp)lambdaExp2).getCompiledClassType(this), new Vector(10));
        }
        codeAttr.emitReturn();
        this.method = method2;
        this.curClass = classType2;
        this.callContextVar = variable;
    }

    void callInitMethods(ClassType classType, Vector vector) {
        int n;
        if (classType == null) {
            return;
        }
        String string = classType.getName();
        if ("java.lang.Object".equals(string)) {
            return;
        }
        int n2 = vector.size();
        while (--n2 >= 0) {
            if (((ClassType)vector.elementAt(n2)).getName() != string) continue;
            return;
        }
        vector.addElement(classType);
        ClassType[] classTypeArray = classType.getInterfaces();
        if (classTypeArray != null) {
            n = classTypeArray.length;
            for (int i = 0; i < n; ++i) {
                this.callInitMethods(classTypeArray[i], vector);
            }
        }
        n = 1;
        if (classType.isInterface()) {
            if (classType instanceof PairClassType) {
                classType = ((PairClassType)classType).instanceType;
            } else {
                try {
                    classType = (ClassType)Type.make(Class.forName(classType.getName() + "$class"));
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        } else {
            n = 0;
        }
        Method method = classType.getDeclaredMethod("$finit$", n);
        if (method != null) {
            CodeAttr codeAttr = this.getCode();
            codeAttr.emitPushThis();
            codeAttr.emitInvoke(method);
        }
    }

    public void generateMatchMethods(LambdaExp lambdaExp) {
        int n;
        int n2 = n = lambdaExp.applyMethods == null ? 0 : lambdaExp.applyMethods.size();
        if (n == 0) {
            return;
        }
        Method method = this.method;
        ClassType classType = this.curClass;
        ClassType classType2 = typeModuleMethod;
        this.curClass = lambdaExp.getHeapFrameType();
        if (!this.curClass.getSuperclass().isSubtype(typeModuleBody)) {
            this.curClass = this.moduleClass;
        }
        CodeAttr codeAttr = null;
        for (int i = 0; i <= 5; ++i) {
            Object object2;
            boolean bl = false;
            SwitchState switchState = null;
            String string = null;
            Type[] typeArray = null;
            int n3 = n;
            while (--n3 >= 0) {
                int n4;
                int n5;
                boolean bl2;
                object2 = (LambdaExp)lambdaExp.applyMethods.elementAt(n3);
                Method[] methodArray = ((LambdaExp)object2).primMethods;
                int n6 = methodArray.length;
                boolean bl3 = bl2 = ((LambdaExp)object2).max_args < 0 || ((LambdaExp)object2).max_args >= ((LambdaExp)object2).min_args + n6;
                if (i < 5) {
                    n5 = i - ((LambdaExp)object2).min_args;
                    if (n5 < 0 || n5 >= n6 || n5 == n6 - 1 && bl2) continue;
                    n6 = 1;
                    bl2 = false;
                } else {
                    n5 = 5 - ((LambdaExp)object2).min_args;
                    if (n5 > 0 && n6 <= n5 && !bl2) continue;
                    n5 = n6 - 1;
                }
                if (!bl) {
                    if (i < 5) {
                        string = "match" + i;
                        typeArray = new Type[i + 2];
                        for (n4 = i; n4 >= 0; --n4) {
                            typeArray[n4 + 1] = typeObject;
                        }
                        typeArray[i + 1] = typeCallContext;
                    } else {
                        string = "matchN";
                        typeArray = new Type[3];
                        typeArray[1] = objArrayType;
                        typeArray[2] = typeCallContext;
                    }
                    typeArray[0] = classType2;
                    this.method = this.curClass.addMethod(string, typeArray, Type.intType, 1);
                    codeAttr = this.method.startCode();
                    codeAttr.emitLoad(codeAttr.getArg(1));
                    codeAttr.emitGetField(classType2.getField("selector"));
                    switchState = codeAttr.startSwitch();
                    bl = true;
                }
                switchState.addCase(((LambdaExp)object2).getSelectorValue(this), codeAttr);
                n4 = ((Expression)object2).getLineNumber();
                if (n4 > 0) {
                    codeAttr.putLineNumber(((Expression)object2).getFileName(), n4);
                }
                Variable variable = codeAttr.getArg(i == 5 ? 3 : i + 2);
                if (i < 5) {
                    Declaration declaration = ((ScopeExp)object2).firstDecl();
                    for (int j = 1; j <= i; ++j) {
                        codeAttr.emitLoad(variable);
                        codeAttr.emitLoad(codeAttr.getArg(j + 1));
                        Type type = declaration.getType();
                        if (type != Type.objectType) {
                            if (type instanceof TypeValue) {
                                Label label = new Label(codeAttr);
                                Label label2 = new Label(codeAttr);
                                ConditionalTarget conditionalTarget = new ConditionalTarget(label, label2, this.getLanguage());
                                codeAttr.emitDup();
                                ((TypeValue)((Object)type)).emitIsInstance(null, this, conditionalTarget);
                                label2.define(codeAttr);
                                codeAttr.emitPushInt(0xFFF40000 | j);
                                codeAttr.emitReturn();
                                label.define(codeAttr);
                            } else if (type instanceof ClassType && type != Type.objectType && type != Type.toStringType) {
                                codeAttr.emitDup();
                                type.emitIsInstance(codeAttr);
                                codeAttr.emitIfIntEqZero();
                                codeAttr.emitPushInt(0xFFF40000 | j);
                                codeAttr.emitReturn();
                                codeAttr.emitFi();
                            }
                        }
                        codeAttr.emitPutField(typeCallContext.getField("value" + j));
                        declaration = declaration.nextDecl();
                    }
                } else {
                    codeAttr.emitLoad(variable);
                    codeAttr.emitLoad(codeAttr.getArg(2));
                    codeAttr.emitPutField(typeCallContext.getField("values"));
                }
                codeAttr.emitLoad(variable);
                if (defaultCallConvention < 2) {
                    codeAttr.emitLoad(codeAttr.getArg(1));
                } else {
                    codeAttr.emitLoad(codeAttr.getArg(0));
                }
                codeAttr.emitPutField(procCallContextField);
                codeAttr.emitLoad(variable);
                if (defaultCallConvention >= 2) {
                    codeAttr.emitPushInt(((LambdaExp)object2).getSelectorValue(this) + n5);
                } else {
                    codeAttr.emitPushInt(i);
                }
                codeAttr.emitPutField(pcCallContextField);
                codeAttr.emitPushInt(0);
                codeAttr.emitReturn();
            }
            if (!bl) continue;
            switchState.addDefault(codeAttr);
            n3 = i > 4 ? 2 : i + 1;
            ++n3;
            for (int j = 0; j <= n3; ++j) {
                codeAttr.emitLoad(codeAttr.getArg(j));
            }
            object2 = typeModuleBody.getDeclaredMethod(string, typeArray.length);
            codeAttr.emitInvokeSpecial((Method)object2);
            codeAttr.emitReturn();
            switchState.finish(codeAttr);
        }
        this.method = method;
        this.curClass = classType;
    }

    public void generateApplyMethodsWithContext(LambdaExp lambdaExp) {
        int n;
        int n2 = n = lambdaExp.applyMethods == null ? 0 : lambdaExp.applyMethods.size();
        if (n == 0) {
            return;
        }
        ClassType classType = this.curClass;
        this.curClass = lambdaExp.getHeapFrameType();
        if (!this.curClass.getSuperclass().isSubtype(typeModuleWithContext)) {
            this.curClass = this.moduleClass;
        }
        ClassType classType2 = typeModuleMethod;
        Method method = this.method;
        CodeAttr codeAttr = null;
        Type[] typeArray = new Type[]{typeCallContext};
        this.method = this.curClass.addMethod("apply", typeArray, Type.voidType, 1);
        codeAttr = this.method.startCode();
        Variable variable = codeAttr.getArg(1);
        codeAttr.emitLoad(variable);
        codeAttr.emitGetField(pcCallContextField);
        SwitchState switchState = codeAttr.startSwitch();
        for (int i = 0; i < n; ++i) {
            LambdaExp lambdaExp2 = (LambdaExp)lambdaExp.applyMethods.elementAt(i);
            Method[] methodArray = lambdaExp2.primMethods;
            int n3 = methodArray.length;
            for (int j = 0; j < n3; ++j) {
                Type type;
                Declaration declaration;
                int n4;
                boolean bl = j == n3 - 1 && (lambdaExp2.max_args < 0 || lambdaExp2.max_args >= lambdaExp2.min_args + n3);
                int n5 = j;
                switchState.addCase(lambdaExp2.getSelectorValue(this) + j, codeAttr);
                SourceLocator sourceLocator = this.messages.swapSourceLocator(lambdaExp2);
                int n6 = lambdaExp2.getLineNumber();
                if (n6 > 0) {
                    codeAttr.putLineNumber(lambdaExp2.getFileName(), n6);
                }
                Method method2 = methodArray[n5];
                Type[] typeArray2 = method2.getParameterTypes();
                int n7 = lambdaExp2.min_args + n5;
                Variable variable2 = null;
                int n8 = 0;
                if (j > 4 && n3 > 1) {
                    variable2 = codeAttr.addLocal(Type.intType);
                    codeAttr.emitLoad(variable);
                    codeAttr.emitGetField(typeCallContext.getDeclaredField("count"));
                    if (lambdaExp2.min_args != 0) {
                        codeAttr.emitPushInt(lambdaExp2.min_args);
                        codeAttr.emitSub(Type.intType);
                    }
                    codeAttr.emitStore(variable2);
                }
                int n9 = method2.getStaticFlag() ? 0 : 1;
                int n10 = n4 = n7 + (bl ? 2 : 1) < typeArray2.length ? 1 : 0;
                if (n9 + n4 > 0) {
                    codeAttr.emitPushThis();
                    if (this.curClass == this.moduleClass && this.mainClass != this.moduleClass) {
                        codeAttr.emitGetField(this.moduleInstanceMainField);
                    }
                }
                if ((declaration = lambdaExp2.firstDecl()) != null && declaration.isThisParameter()) {
                    declaration = declaration.nextDecl();
                }
                for (int k = 0; k < n7; ++k) {
                    if (variable2 != null && k >= lambdaExp2.min_args) {
                        codeAttr.emitLoad(variable2);
                        codeAttr.emitIfIntLEqZero();
                        codeAttr.emitLoad(variable);
                        codeAttr.emitInvoke(methodArray[k - lambdaExp2.min_args]);
                        codeAttr.emitElse();
                        ++n8;
                        codeAttr.emitInc(variable2, (short)-1);
                    }
                    codeAttr.emitLoad(variable);
                    if (k <= 4 && !bl && lambdaExp2.max_args <= 4) {
                        codeAttr.emitGetField(typeCallContext.getDeclaredField("value" + (k + 1)));
                    } else {
                        codeAttr.emitGetField(typeCallContext.getDeclaredField("values"));
                        codeAttr.emitPushInt(k);
                        codeAttr.emitArrayLoad(Type.objectType);
                    }
                    type = declaration.getType();
                    if (type != Type.objectType) {
                        SourceLocator sourceLocator2 = this.messages.swapSourceLocator(declaration);
                        CheckedTarget.emitCheckedCoerce(this, lambdaExp2, k + 1, type);
                        this.messages.swapSourceLocator(sourceLocator2);
                    }
                    declaration = declaration.nextDecl();
                }
                if (bl) {
                    Type type2 = typeArray2[n4 + n7];
                    if (type2 instanceof ArrayType) {
                        boolean bl2;
                        type = ((ArrayType)type2).getComponentType();
                        boolean bl3 = bl2 = !"java.lang.Object".equals(type.getName());
                        if (bl2) {
                            new Error("not implemented mustConvert restarg");
                        }
                        codeAttr.emitLoad(variable);
                        codeAttr.emitPushInt(n7);
                        codeAttr.emitInvokeVirtual(typeCallContext.getDeclaredMethod("getRestArgsArray", 1));
                    } else if ("gnu.lists.LList".equals(type2.getName())) {
                        codeAttr.emitLoad(variable);
                        codeAttr.emitPushInt(n7);
                        codeAttr.emitInvokeVirtual(typeCallContext.getDeclaredMethod("getRestArgsList", 1));
                    } else if (type2 == typeCallContext) {
                        codeAttr.emitLoad(variable);
                    } else {
                        throw new RuntimeException("unsupported #!rest type:" + type2);
                    }
                }
                codeAttr.emitLoad(variable);
                codeAttr.emitInvoke(method2);
                while (--n8 >= 0) {
                    codeAttr.emitFi();
                }
                if (defaultCallConvention < 2) {
                    Target.pushObject.compileFromStack(this, lambdaExp2.getReturnType());
                }
                this.messages.swapSourceLocator(sourceLocator);
                codeAttr.emitReturn();
            }
        }
        switchState.addDefault(codeAttr);
        Method method3 = typeModuleMethod.getDeclaredMethod("applyError", 0);
        codeAttr.emitInvokeStatic(method3);
        codeAttr.emitReturn();
        switchState.finish(codeAttr);
        this.method = method;
        this.curClass = classType;
    }

    public void generateApplyMethodsWithoutContext(LambdaExp lambdaExp) {
        int n;
        int n2;
        int n3 = n2 = lambdaExp.applyMethods == null ? 0 : lambdaExp.applyMethods.size();
        if (n2 == 0) {
            return;
        }
        ClassType classType = this.curClass;
        this.curClass = lambdaExp.getHeapFrameType();
        ClassType classType2 = typeModuleMethod;
        if (!this.curClass.getSuperclass().isSubtype(typeModuleBody)) {
            this.curClass = this.moduleClass;
        }
        Method method = this.method;
        CodeAttr codeAttr = null;
        int n4 = n = defaultCallConvention >= 2 ? 5 : 0;
        while (n < 6) {
            int n5;
            boolean bl = false;
            SwitchState switchState = null;
            String string = null;
            Type[] typeArray = null;
            for (n5 = 0; n5 < n2; ++n5) {
                Object object2;
                Object object3;
                Declaration declaration;
                int n6;
                int n7;
                LambdaExp lambdaExp2 = (LambdaExp)lambdaExp.applyMethods.elementAt(n5);
                Method[] methodArray = lambdaExp2.primMethods;
                int n8 = methodArray.length;
                boolean bl2 = lambdaExp2.max_args < 0 || lambdaExp2.max_args >= lambdaExp2.min_args + n8;
                boolean bl3 = false;
                if (n < 5) {
                    n7 = n - lambdaExp2.min_args;
                    if (n7 < 0 || n7 >= n8 || n7 == n8 - 1 && bl2) {
                        bl3 = true;
                    }
                    n8 = 1;
                    bl2 = false;
                } else {
                    n7 = 5 - lambdaExp2.min_args;
                    if (n7 > 0 && n8 <= n7 && !bl2) {
                        bl3 = true;
                    }
                    n7 = n8 - 1;
                }
                if (bl3) continue;
                if (!bl) {
                    if (n < 5) {
                        string = "apply" + n;
                        typeArray = new Type[n + 1];
                        for (int i = n; i > 0; --i) {
                            typeArray[i] = typeObject;
                        }
                    } else {
                        string = "applyN";
                        typeArray = new Type[2];
                        typeArray[1] = objArrayType;
                    }
                    typeArray[0] = classType2;
                    this.method = this.curClass.addMethod(string, typeArray, defaultCallConvention >= 2 ? Type.voidType : Type.objectType, 1);
                    codeAttr = this.method.startCode();
                    codeAttr.emitLoad(codeAttr.getArg(1));
                    codeAttr.emitGetField(classType2.getField("selector"));
                    switchState = codeAttr.startSwitch();
                    bl = true;
                }
                switchState.addCase(lambdaExp2.getSelectorValue(this), codeAttr);
                SourceLocator sourceLocator = this.messages.swapSourceLocator(lambdaExp2);
                int n9 = lambdaExp2.getLineNumber();
                if (n9 > 0) {
                    codeAttr.putLineNumber(lambdaExp2.getFileName(), n9);
                }
                Method method2 = methodArray[n7];
                Type[] typeArray2 = method2.getParameterTypes();
                int n10 = lambdaExp2.min_args + n7;
                Variable variable = null;
                int n11 = 0;
                if (n > 4 && n8 > 1) {
                    variable = codeAttr.addLocal(Type.intType);
                    codeAttr.emitLoad(codeAttr.getArg(2));
                    codeAttr.emitArrayLength();
                    if (lambdaExp2.min_args != 0) {
                        codeAttr.emitPushInt(lambdaExp2.min_args);
                        codeAttr.emitSub(Type.intType);
                    }
                    codeAttr.emitStore(variable);
                }
                int n12 = method2.getStaticFlag() ? 0 : 1;
                int n13 = n6 = n10 + (bl2 ? 1 : 0) < typeArray2.length ? 1 : 0;
                if (n12 + n6 > 0) {
                    codeAttr.emitPushThis();
                    if (this.curClass == this.moduleClass && this.mainClass != this.moduleClass) {
                        codeAttr.emitGetField(this.moduleInstanceMainField);
                    }
                }
                if ((declaration = lambdaExp2.firstDecl()) != null && declaration.isThisParameter()) {
                    declaration = declaration.nextDecl();
                }
                for (int i = 0; i < n10; ++i) {
                    if (variable != null && i >= lambdaExp2.min_args) {
                        codeAttr.emitLoad(variable);
                        codeAttr.emitIfIntLEqZero();
                        codeAttr.emitInvoke(methodArray[i - lambdaExp2.min_args]);
                        codeAttr.emitElse();
                        ++n11;
                        codeAttr.emitInc(variable, (short)-1);
                    }
                    object3 = null;
                    if (n <= 4) {
                        object3 = codeAttr.getArg(i + 2);
                        codeAttr.emitLoad((Variable)object3);
                    } else {
                        codeAttr.emitLoad(codeAttr.getArg(2));
                        codeAttr.emitPushInt(i);
                        codeAttr.emitArrayLoad(Type.objectType);
                    }
                    Type type = declaration.getType();
                    if (type != Type.objectType) {
                        object2 = this.messages.swapSourceLocator(declaration);
                        CheckedTarget.emitCheckedCoerce(this, lambdaExp2, i + 1, type, (Variable)object3);
                        this.messages.swapSourceLocator((SourceLocator)object2);
                    }
                    declaration = declaration.nextDecl();
                }
                if (bl2) {
                    Type type = typeArray2[n6 + n10];
                    if (type instanceof ArrayType) {
                        boolean bl4;
                        object3 = ((ArrayType)type).getComponentType();
                        boolean bl5 = bl4 = !"java.lang.Object".equals(((Type)object3).getName());
                        if (n10 == 0 && !bl4) {
                            codeAttr.emitLoad(codeAttr.getArg(2));
                        } else {
                            codeAttr.pushScope();
                            if (variable == null) {
                                variable = codeAttr.addLocal(Type.intType);
                                codeAttr.emitLoad(codeAttr.getArg(2));
                                codeAttr.emitArrayLength();
                                if (n10 != 0) {
                                    codeAttr.emitPushInt(n10);
                                    codeAttr.emitSub(Type.intType);
                                }
                                codeAttr.emitStore(variable);
                            }
                            codeAttr.emitLoad(variable);
                            codeAttr.emitNewArray((Type)object3);
                            object2 = new Label(codeAttr);
                            Label label = new Label(codeAttr);
                            label.setTypes(codeAttr);
                            codeAttr.emitGoto((Label)object2);
                            label.define(codeAttr);
                            codeAttr.emitDup(1);
                            codeAttr.emitLoad(variable);
                            codeAttr.emitLoad(codeAttr.getArg(2));
                            codeAttr.emitLoad(variable);
                            if (n10 != 0) {
                                codeAttr.emitPushInt(n10);
                                codeAttr.emitAdd(Type.intType);
                            }
                            codeAttr.emitArrayLoad(Type.objectType);
                            if (bl4) {
                                CheckedTarget.emitCheckedCoerce(this, lambdaExp2, lambdaExp2.getName(), 0, (Type)object3, null);
                            }
                            codeAttr.emitArrayStore((Type)object3);
                            ((Label)object2).define(codeAttr);
                            codeAttr.emitInc(variable, (short)-1);
                            codeAttr.emitLoad(variable);
                            codeAttr.emitGotoIfIntGeZero(label);
                            codeAttr.popScope();
                        }
                    } else if ("gnu.lists.LList".equals(type.getName())) {
                        codeAttr.emitLoad(codeAttr.getArg(2));
                        codeAttr.emitPushInt(n10);
                        codeAttr.emitInvokeStatic(makeListMethod);
                    } else if (type == typeCallContext) {
                        codeAttr.emitLoad(codeAttr.getArg(2));
                    } else {
                        throw new RuntimeException("unsupported #!rest type:" + type);
                    }
                }
                codeAttr.emitInvoke(method2);
                while (--n11 >= 0) {
                    codeAttr.emitFi();
                }
                if (defaultCallConvention < 2) {
                    Target.pushObject.compileFromStack(this, lambdaExp2.getReturnType());
                }
                this.messages.swapSourceLocator(sourceLocator);
                codeAttr.emitReturn();
            }
            if (bl) {
                switchState.addDefault(codeAttr);
                if (defaultCallConvention >= 2) {
                    Method method3 = typeModuleMethod.getDeclaredMethod("applyError", 0);
                    codeAttr.emitInvokeStatic(method3);
                } else {
                    n5 = n > 4 ? 2 : n + 1;
                    ++n5;
                    for (int i = 0; i < n5; ++i) {
                        codeAttr.emitLoad(codeAttr.getArg(i));
                    }
                    codeAttr.emitInvokeSpecial(typeModuleBody.getDeclaredMethod(string, typeArray));
                }
                codeAttr.emitReturn();
                switchState.finish(codeAttr);
            }
            ++n;
        }
        this.method = method;
        this.curClass = classType;
    }

    private Method startClassInit() {
        ClassType classType;
        Method method;
        this.method = this.curClass.addMethod("<clinit>", apply0args, Type.voidType, 9);
        CodeAttr codeAttr = this.method.startCode();
        if ((this.generateMain || this.generateApplet || this.generateServlet) && (method = (classType = (ClassType)Type.make(this.getLanguage().getClass())).getDeclaredMethod("registerEnvironment", 0)) != null) {
            codeAttr.emitInvokeStatic(method);
        }
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(int n) {
        Compilation compilation = Compilation.getCurrent();
        try {
            Object object2;
            Compilation.setCurrent(this);
            ModuleExp moduleExp = this.getModule();
            if (n >= 4 && this.getState() < 3) {
                this.setState(3);
                this.language.parse(this, 0);
                this.lexer.close();
                this.lexer = null;
                this.setState(this.messages.seenErrors() ? 100 : 4);
                if (this.pendingImports != null) {
                    return;
                }
            }
            if (n >= 6 && this.getState() < 6) {
                this.addMainClass(moduleExp);
                this.language.resolve(this);
                this.setState(this.messages.seenErrors() ? 100 : 6);
            }
            if (n >= 8 && this.getState() < 8) {
                this.walkModule(moduleExp);
                this.setState(this.messages.seenErrors() ? 100 : 8);
            }
            if (n >= 10 && this.getState() < 10) {
                this.litTable = new LitTable(this);
                moduleExp.setCanRead(true);
                FindCapturedVars.findCapturedVars(moduleExp, this);
                moduleExp.allocFields(this);
                moduleExp.allocChildMethods(this);
                this.setState(this.messages.seenErrors() ? 100 : 10);
            }
            if (n >= 12 && this.getState() < 12) {
                if (this.immediate) {
                    object2 = ObjectType.getContextClassLoader();
                    this.loader = new ArrayClassLoader((ClassLoader)object2);
                }
                this.generateBytecode();
                this.setState(this.messages.seenErrors() ? 100 : 12);
            }
            if (n >= 14 && this.getState() < 14) {
                object2 = ModuleManager.getInstance();
                this.outputClass(((ModuleManager)object2).getCompilationDirectory());
                this.setState(14);
            }
        }
        catch (SyntaxException syntaxException) {
            this.setState(100);
            if (syntaxException.getMessages() != this.getMessages()) {
                throw new RuntimeException("confussing syntax error: " + syntaxException);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.error('f', "caught " + iOException);
            this.setState(100);
        }
        finally {
            Compilation.setCurrent(compilation);
        }
    }

    void generateBytecode() {
        Member member;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Type[] typeArray;
        int n;
        Method method;
        Type[] typeArray2;
        int n2;
        Object object6;
        ModuleExp moduleExp = this.getModule();
        if (debugPrintFinalExpr) {
            object6 = OutPort.errDefault();
            ((PrintWriter)object6).println("[Compiling final " + moduleExp.getName() + " to " + this.mainClass.getName() + ":");
            moduleExp.print((OutPort)object6);
            ((PrintWriter)object6).println(']');
            ((PrintWriter)object6).flush();
        }
        object6 = this.getModuleType();
        if (this.mainClass.getSuperclass().isSubtype((Type)object6)) {
            this.moduleClass = this.mainClass;
        } else {
            this.moduleClass = new ClassType(this.generateClassName("frame"));
            this.moduleClass.setSuper((ClassType)object6);
            this.addClass(this.moduleClass);
            this.generateConstructor(this.moduleClass, null);
        }
        this.curClass = moduleExp.type;
        LambdaExp lambdaExp = this.curLambda;
        this.curLambda = moduleExp;
        if (moduleExp.isHandlingTailCalls()) {
            n2 = 1;
            typeArray2 = new Type[]{typeCallContext};
        } else if (moduleExp.min_args != moduleExp.max_args || moduleExp.min_args > 4 || fewerClasses && this.curClass == this.mainClass) {
            n2 = 1;
            typeArray2 = new Type[]{new ArrayType(typeObject)};
        } else {
            n2 = moduleExp.min_args;
            typeArray2 = new Type[n2];
            int n3 = n2;
            while (--n3 >= 0) {
                typeArray2[n3] = typeObject;
            }
        }
        Variable variable = moduleExp.heapFrame;
        boolean bl = moduleExp.isStatic();
        this.method = method = this.curClass.addMethod("run", typeArray2, Type.voidType, 17);
        this.method.initCode();
        CodeAttr codeAttr = this.getCode();
        this.thisDecl = this.method.getStaticFlag() ? null : moduleExp.declareThis(moduleExp.type);
        moduleExp.closureEnv = moduleExp.thisVariable;
        moduleExp.heapFrame = moduleExp.isStatic() ? null : moduleExp.thisVariable;
        moduleExp.allocChildClasses(this);
        if (moduleExp.isHandlingTailCalls() || this.usingCPStyle()) {
            this.callContextVar = new Variable("$ctx", typeCallContext);
            moduleExp.getVarScope().addVariableAfter(this.thisDecl, this.callContextVar);
            this.callContextVar.setParameter(true);
        }
        if ((n = moduleExp.getLineNumber()) > 0) {
            codeAttr.putLineNumber(moduleExp.getFileName(), n);
        }
        moduleExp.allocParameters(this);
        moduleExp.enterFunction(this);
        if (this.usingCPStyle()) {
            this.loadCallContext();
            codeAttr.emitGetField(pcCallContextField);
            this.fswitch = codeAttr.startSwitch();
            this.fswitch.addCase(0, codeAttr);
        }
        moduleExp.compileBody(this);
        moduleExp.compileEnd(this);
        Label label = null;
        Label label2 = null;
        Method method2 = null;
        if (this.curClass == this.mainClass) {
            typeArray = this.method;
            object5 = this.callContextVar;
            this.callContextVar = null;
            this.clinitMethod = method2 = this.startClassInit();
            codeAttr = this.getCode();
            label = new Label(codeAttr);
            label2 = new Label(codeAttr);
            codeAttr.fixupChain(label2, label);
            if (bl) {
                this.generateConstructor(moduleExp);
                codeAttr.emitNew(this.moduleClass);
                codeAttr.emitDup(this.moduleClass);
                codeAttr.emitInvokeSpecial(this.moduleClass.constructor);
                this.moduleInstanceMainField = this.moduleClass.addField("$instance", this.moduleClass, 25);
                codeAttr.emitPutStatic(this.moduleInstanceMainField);
            }
            while ((object4 = this.clinitChain) != null) {
                this.clinitChain = null;
                this.dumpInitializers((Initializer)object4);
            }
            if (!this.immediate && moduleExp.staticInitRun()) {
                codeAttr.emitGetStatic(this.moduleInstanceMainField);
                codeAttr.emitInvoke(typeModuleBody.getDeclaredMethod("run", 0));
            }
            codeAttr.emitReturn();
            if (!(this.moduleClass == this.mainClass || bl || this.generateMain || this.immediate)) {
                this.method = this.curClass.addMethod("run", 1, Type.typeArray0, Type.voidType);
                codeAttr = this.method.startCode();
                Variable variable2 = codeAttr.addLocal(typeCallContext);
                object3 = codeAttr.addLocal(typeConsumer);
                object2 = codeAttr.addLocal(Type.javalangThrowableType);
                codeAttr.emitInvokeStatic(getCallContextInstanceMethod);
                codeAttr.emitStore(variable2);
                member = typeCallContext.getDeclaredField("consumer");
                codeAttr.emitLoad(variable2);
                codeAttr.emitGetField((Field)member);
                codeAttr.emitStore((Variable)object3);
                codeAttr.emitLoad(variable2);
                codeAttr.emitGetStatic(ClassType.make("gnu.lists.VoidConsumer").getDeclaredField("instance"));
                codeAttr.emitPutField((Field)member);
                codeAttr.emitTryStart(false, Type.voidType);
                codeAttr.emitPushThis();
                codeAttr.emitLoad(variable2);
                codeAttr.emitInvokeVirtual((Method)typeArray);
                codeAttr.emitPushNull();
                codeAttr.emitStore((Variable)object2);
                codeAttr.emitTryEnd();
                codeAttr.emitCatchStart((Variable)object2);
                codeAttr.emitCatchEnd();
                codeAttr.emitTryCatchEnd();
                codeAttr.emitLoad(variable2);
                codeAttr.emitLoad((Variable)object2);
                codeAttr.emitLoad((Variable)object3);
                codeAttr.emitInvokeStatic(typeModuleBody.getDeclaredMethod("runCleanup", 3));
                codeAttr.emitReturn();
            }
            this.method = typeArray;
            this.callContextVar = object5;
        }
        moduleExp.generateApplyMethods(this);
        this.curLambda = lambdaExp;
        if (fewerClasses) {
            this.method.popScope();
        }
        moduleExp.heapFrame = variable;
        if (this.usingCPStyle() || fewerClasses && this.curClass == this.mainClass) {
            codeAttr = this.getCode();
            this.fswitch.finish(codeAttr);
        }
        if (label != null || this.callContextVar != null) {
            this.method = method2;
            codeAttr = this.getCode();
            typeArray = new Label(codeAttr);
            codeAttr.fixupChain(label, (Label)typeArray);
            if (this.callContextVarForInit != null) {
                codeAttr.emitInvokeStatic(getCallContextInstanceMethod);
                codeAttr.emitStore(this.callContextVarForInit);
            }
            try {
                if (this.immediate) {
                    codeAttr.emitPushInt(Compilation.registerForImmediateLiterals(this));
                    codeAttr.emitInvokeStatic(ClassType.make("gnu.expr.Compilation").getDeclaredMethod("setupLiterals", 1));
                } else {
                    this.litTable.emit();
                }
            }
            catch (Throwable throwable) {
                this.error('e', "Literals: Internal error:" + throwable);
            }
            codeAttr.fixupChain((Label)typeArray, label2);
        }
        if (this.generateMain && this.curClass == this.mainClass) {
            typeArray = new Type[]{new ArrayType(javaStringType)};
            this.method = this.curClass.addMethod("main", 9, typeArray, Type.voidType);
            codeAttr = this.method.startCode();
            if (Shell.defaultFormatName != null) {
                codeAttr.emitPushString(Shell.defaultFormatName);
                codeAttr.emitInvokeStatic(ClassType.make("kawa.Shell").getDeclaredMethod("setDefaultFormat", 1));
            }
            codeAttr.emitLoad(codeAttr.getArg(0));
            codeAttr.emitInvokeStatic(typeModuleBody.getDeclaredMethod("processArgs", 1));
            if (this.moduleInstanceMainField != null) {
                codeAttr.emitGetStatic(this.moduleInstanceMainField);
            } else {
                codeAttr.emitNew(this.curClass);
                codeAttr.emitDup(this.curClass);
                codeAttr.emitInvokeSpecial(this.curClass.constructor);
            }
            codeAttr.emitInvokeVirtual(typeModuleBody.getDeclaredMethod("runAsMain", 0));
            codeAttr.emitReturn();
        }
        if (this.minfo != null && (typeArray = this.minfo.getNamespaceUri()) != null) {
            object5 = ModuleManager.getInstance();
            object4 = this.mainClass.getName();
            int n4 = ((String)object4).lastIndexOf(46);
            if (n4 < 0) {
                object4 = "";
            } else {
                object3 = ((String)object4).substring(0, n4);
                try {
                    ((ModuleManager)object5).loadPackageInfo((String)object3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (Throwable throwable) {
                    this.error('e', "error loading map for " + (String)object3 + " - " + throwable);
                }
                object4 = ((String)object4).substring(0, n4 + 1);
            }
            object3 = new ClassType((String)object4 + "$ModulesMap$");
            object2 = ClassType.make("gnu.expr.ModuleSet");
            ((ClassType)object3).setSuper((ClassType)object2);
            this.registerClass((ClassType)object3);
            this.method = ((ClassType)object3).addMethod("<init>", 1, apply0args, Type.voidType);
            member = ((ClassType)object2).addMethod("<init>", 1, apply0args, Type.voidType);
            codeAttr = this.method.startCode();
            codeAttr.emitPushThis();
            codeAttr.emitInvokeSpecial((Method)member);
            codeAttr.emitReturn();
            ClassType classType = ClassType.make("gnu.expr.ModuleManager");
            Type[] typeArray3 = new Type[]{classType};
            this.method = ((ClassType)object3).addMethod("register", typeArray3, Type.voidType, 1);
            codeAttr = this.method.startCode();
            Method method3 = classType.getDeclaredMethod("register", 3);
            int n5 = ((ModuleManager)object5).numModules;
            while (--n5 >= 0) {
                ModuleInfo moduleInfo = ((ModuleManager)object5).modules[n5];
                String string = moduleInfo.className;
                if (string == null || !string.startsWith((String)object4)) continue;
                String string2 = moduleInfo.sourcePath;
                String string3 = moduleInfo.getNamespaceUri();
                codeAttr.emitLoad(codeAttr.getArg(1));
                this.compileConstant(string);
                if (!Path.valueOf(string2).isAbsolute()) {
                    try {
                        char c = File.separatorChar;
                        String string4 = ((ModuleManager)object5).getCompilationDirectory();
                        string4 = string4 + ((String)object4).replace('.', c);
                        string4 = Path.toURL(string4).toString();
                        int n6 = string4.length();
                        if (n6 > 0 && string4.charAt(n6 - 1) != c) {
                            string4 = string4 + c;
                        }
                        string2 = Path.relativize(moduleInfo.getSourceAbsPathname(), string4);
                    }
                    catch (Throwable throwable) {
                        throw new WrappedException("exception while fixing up '" + string2 + '\'', throwable);
                    }
                }
                this.compileConstant(string2);
                this.compileConstant(string3);
                codeAttr.emitInvokeVirtual(method3);
            }
            codeAttr.emitReturn();
        }
    }

    public Field allocLocalField(Type type, String string) {
        if (string == null) {
            string = "tmp_" + ++this.localFieldIndex;
        }
        Field field = this.curClass.addField(string, type, 0);
        return field;
    }

    public final void loadCallContext() {
        CodeAttr codeAttr = this.getCode();
        if (this.callContextVar != null && !this.callContextVar.dead()) {
            codeAttr.emitLoad(this.callContextVar);
        } else if (this.method == this.clinitMethod) {
            this.callContextVar = new Variable("$ctx", typeCallContext);
            this.callContextVar.reserveLocal(codeAttr.getMaxLocals(), codeAttr);
            codeAttr.emitLoad(this.callContextVar);
            this.callContextVarForInit = this.callContextVar;
        } else {
            codeAttr.emitInvokeStatic(getCallContextInstanceMethod);
            codeAttr.emitDup();
            this.callContextVar = new Variable("$ctx", typeCallContext);
            codeAttr.getCurrentScope().addVariable(codeAttr, this.callContextVar);
            codeAttr.emitStore(this.callContextVar);
        }
    }

    public void freeLocalField(Field field) {
    }

    public Expression parse(Object object2) {
        throw new Error("unimeplemented parse");
    }

    public Language getLanguage() {
        return this.language;
    }

    public LambdaExp currentLambda() {
        return this.current_scope.currentLambda();
    }

    public final ModuleExp getModule() {
        return this.mainLambda;
    }

    public void setModule(ModuleExp moduleExp) {
        this.mainLambda = moduleExp;
    }

    public boolean isStatic() {
        return this.mainLambda.isStatic();
    }

    public ModuleExp currentModule() {
        return this.current_scope.currentModule();
    }

    public void mustCompileHere() {
        this.mustCompile = true;
    }

    public ScopeExp currentScope() {
        return this.current_scope;
    }

    public void setCurrentScope(ScopeExp scopeExp) {
        int n;
        int n2 = ScopeExp.nesting(scopeExp);
        for (n = ScopeExp.nesting(this.current_scope); n > n2; --n) {
            this.pop(this.current_scope);
        }
        ScopeExp scopeExp2 = scopeExp;
        while (n2 > n) {
            scopeExp2 = scopeExp2.outer;
            --n2;
        }
        while (scopeExp2 != this.current_scope) {
            this.pop(this.current_scope);
            scopeExp2 = scopeExp2.outer;
        }
        this.pushChain(scopeExp, scopeExp2);
    }

    void pushChain(ScopeExp scopeExp, ScopeExp scopeExp2) {
        if (scopeExp != scopeExp2) {
            this.pushChain(scopeExp.outer, scopeExp2);
            this.pushScope(scopeExp);
            this.lexical.push(scopeExp);
        }
    }

    public ModuleExp pushNewModule(Lexer lexer) {
        this.lexer = lexer;
        return this.pushNewModule(lexer.getName());
    }

    public ModuleExp pushNewModule(String string) {
        ModuleExp moduleExp = new ModuleExp();
        if (string != null) {
            moduleExp.setFile(string);
        }
        if (generateAppletDefault) {
            moduleExp.setFlag(65536);
        }
        if (this.immediate) {
            moduleExp.setFlag(524288);
            new ModuleInfo().setCompilation(this);
        }
        this.mainLambda = moduleExp;
        this.push(moduleExp);
        return moduleExp;
    }

    public void push(ScopeExp scopeExp) {
        this.pushScope(scopeExp);
        this.lexical.push(scopeExp);
    }

    public final void pushScope(ScopeExp scopeExp) {
        if (!this.mustCompile && (scopeExp.mustCompile() || scopeExp instanceof LambdaExp && !(scopeExp instanceof ModuleExp))) {
            this.mustCompileHere();
        }
        scopeExp.outer = this.current_scope;
        this.current_scope = scopeExp;
    }

    public void pop(ScopeExp scopeExp) {
        this.lexical.pop(scopeExp);
        this.current_scope = scopeExp.outer;
    }

    public final void pop() {
        this.pop(this.current_scope);
    }

    public void push(Declaration declaration) {
        this.lexical.push(declaration);
    }

    public Declaration lookup(Object object2, int n) {
        return this.lexical.lookup(object2, n);
    }

    public void usedClass(Type type) {
        while (type instanceof ArrayType) {
            type = ((ArrayType)type).getComponentType();
        }
        if (this.immediate && type instanceof ClassType) {
            this.loader.addClass((ClassType)type);
        }
    }

    public SourceMessages getMessages() {
        return this.messages;
    }

    public void setMessages(SourceMessages sourceMessages) {
        this.messages = sourceMessages;
    }

    public void error(char c, String string, SourceLocator sourceLocator) {
        String string2 = sourceLocator.getFileName();
        int n = sourceLocator.getLineNumber();
        int n2 = sourceLocator.getColumnNumber();
        if (string2 == null || n <= 0) {
            string2 = this.getFileName();
            n = this.getLineNumber();
            n2 = this.getColumnNumber();
        }
        if (c == 'w' && this.getBooleanOption("warn-as-error", false)) {
            c = (char)101;
        }
        this.messages.error(c, string2, n, n2, string);
    }

    public void error(char c, String string) {
        if (c == 'w' && this.getBooleanOption("warn-as-error", false)) {
            c = (char)101;
        }
        this.messages.error(c, this, string);
    }

    public void error(char c, Declaration declaration, String string, String string2) {
        this.error(c, string + declaration.getName() + string2, null, declaration);
    }

    public void error(char c, String string, String string2, Declaration declaration) {
        if (c == 'w' && this.getBooleanOption("warn-as-error", false)) {
            c = (char)101;
        }
        String string3 = this.getFileName();
        int n = this.getLineNumber();
        int n2 = this.getColumnNumber();
        int n3 = declaration.getLineNumber();
        if (n3 > 0) {
            string3 = declaration.getFileName();
            n = n3;
            n2 = declaration.getColumnNumber();
        }
        this.messages.error(c, string3, n, n2, string, string2);
    }

    public Expression syntaxError(String string) {
        this.error('e', string);
        return new ErrorExp(string);
    }

    public final int getLineNumber() {
        return this.messages.getLineNumber();
    }

    public final int getColumnNumber() {
        return this.messages.getColumnNumber();
    }

    public final String getFileName() {
        return this.messages.getFileName();
    }

    public String getPublicId() {
        return this.messages.getPublicId();
    }

    public String getSystemId() {
        return this.messages.getSystemId();
    }

    public boolean isStableSourceLocation() {
        return false;
    }

    public void setFile(String string) {
        this.messages.setFile(string);
    }

    public void setLine(int n) {
        this.messages.setLine(n);
    }

    public void setColumn(int n) {
        this.messages.setColumn(n);
    }

    public final void setLine(Expression expression) {
        this.messages.setLocation(expression);
    }

    public void setLine(Object object2) {
        if (object2 instanceof SourceLocator) {
            this.messages.setLocation((SourceLocator)object2);
        }
    }

    public final void setLocation(SourceLocator sourceLocator) {
        this.messages.setLocation(sourceLocator);
    }

    public void setLine(String string, int n, int n2) {
        this.messages.setLine(string, n, n2);
    }

    public void letStart() {
        this.pushScope(new LetExp(null));
    }

    public Declaration letVariable(Object object2, Type type, Expression expression) {
        LetExp letExp = (LetExp)this.current_scope;
        Declaration declaration = letExp.addDeclaration(object2, type);
        declaration.noteValue(expression);
        return declaration;
    }

    public void letEnter() {
        LetExp letExp = (LetExp)this.current_scope;
        int n = letExp.countDecls();
        Expression[] expressionArray = new Expression[n];
        int n2 = 0;
        for (Declaration declaration = letExp.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            expressionArray[n2++] = declaration.getValue();
        }
        letExp.inits = expressionArray;
        this.lexical.push(letExp);
    }

    public LetExp letDone(Expression expression) {
        LetExp letExp = (LetExp)this.current_scope;
        letExp.body = expression;
        this.pop(letExp);
        return letExp;
    }

    private void checkLoop() {
        if (((LambdaExp)this.current_scope).getName() != "%do%loop") {
            throw new Error("internal error - bad loop state");
        }
    }

    public void loopStart() {
        LambdaExp lambdaExp = new LambdaExp();
        Expression[] expressionArray = new Expression[]{lambdaExp};
        LetExp letExp = new LetExp(expressionArray);
        String string = "%do%loop";
        Declaration declaration = letExp.addDeclaration(string);
        declaration.noteValue(lambdaExp);
        lambdaExp.setName(string);
        letExp.outer = this.current_scope;
        lambdaExp.outer = letExp;
        this.current_scope = lambdaExp;
    }

    public Declaration loopVariable(Object object2, Type type, Expression expression) {
        this.checkLoop();
        LambdaExp lambdaExp = (LambdaExp)this.current_scope;
        Declaration declaration = lambdaExp.addDeclaration(object2, type);
        if (this.exprStack == null) {
            this.exprStack = new Stack();
        }
        this.exprStack.push(expression);
        ++lambdaExp.min_args;
        return declaration;
    }

    public void loopEnter() {
        int n;
        this.checkLoop();
        LambdaExp lambdaExp = (LambdaExp)this.current_scope;
        lambdaExp.max_args = n = lambdaExp.min_args;
        Expression[] expressionArray = new Expression[n];
        int n2 = n;
        while (--n2 >= 0) {
            expressionArray[n2] = (Expression)this.exprStack.pop();
        }
        LetExp letExp = (LetExp)lambdaExp.outer;
        Declaration declaration = letExp.firstDecl();
        letExp.setBody(new ApplyExp(new ReferenceExp(declaration), expressionArray));
        this.lexical.push(lambdaExp);
    }

    public void loopCond(Expression expression) {
        this.checkLoop();
        this.exprStack.push(expression);
    }

    public void loopBody(Expression expression) {
        LambdaExp lambdaExp = (LambdaExp)this.current_scope;
        lambdaExp.body = expression;
    }

    public Expression loopRepeat(Expression[] expressionArray) {
        LambdaExp lambdaExp = (LambdaExp)this.current_scope;
        ScopeExp scopeExp = lambdaExp.outer;
        Declaration declaration = scopeExp.firstDecl();
        Expression expression = (Expression)this.exprStack.pop();
        ApplyExp applyExp = new ApplyExp(new ReferenceExp(declaration), expressionArray);
        lambdaExp.body = new IfExp(expression, new BeginExp(lambdaExp.body, applyExp), QuoteExp.voidExp);
        this.lexical.pop(lambdaExp);
        this.current_scope = scopeExp.outer;
        return scopeExp;
    }

    public Expression loopRepeat() {
        return this.loopRepeat(Expression.noExpressions);
    }

    public Expression loopRepeat(Expression expression) {
        Expression[] expressionArray = new Expression[]{expression};
        return this.loopRepeat(expressionArray);
    }

    public void loadClassRef(ObjectType objectType) {
        CodeAttr codeAttr = this.getCode();
        if (this.curClass.getClassfileVersion() >= 0x310000) {
            codeAttr.emitPushClass(objectType);
        } else if (objectType == this.mainClass && this.mainLambda.isStatic() && this.moduleInstanceMainField != null) {
            codeAttr.emitGetStatic(this.moduleInstanceMainField);
            codeAttr.emitInvokeVirtual(Type.objectType.getDeclaredMethod("getClass", 0));
        } else {
            String string = objectType instanceof ClassType ? objectType.getName() : objectType.getInternalName().replace('/', '.');
            codeAttr.emitPushString(string);
            codeAttr.emitInvokeStatic(this.getForNameHelper());
        }
    }

    public Method getForNameHelper() {
        if (this.forNameHelper == null) {
            Method method = this.method;
            this.forNameHelper = this.method = this.curClass.addMethod("class$", 9, string1Arg, typeClass);
            CodeAttr codeAttr = this.method.startCode();
            codeAttr.emitLoad(codeAttr.getArg(0));
            codeAttr.emitPushInt(0);
            codeAttr.emitPushString(this.mainClass.getName());
            codeAttr.emitInvokeStatic(typeClass.getDeclaredMethod("forName", 1));
            codeAttr.emitInvokeVirtual(typeClass.getDeclaredMethod("getClassLoader", 0));
            codeAttr.emitInvokeStatic(typeClass.getDeclaredMethod("forName", 3));
            codeAttr.emitReturn();
            this.method = method;
        }
        return this.forNameHelper;
    }

    public Object resolve(Object object2, boolean bl) {
        Environment environment = Environment.getCurrent();
        Symbol symbol = object2 instanceof String ? environment.defaultNamespace().lookup((String)object2) : (Symbol)object2;
        if (symbol == null) {
            return null;
        }
        if (bl && this.getLanguage().hasSeparateFunctionNamespace()) {
            return environment.getFunction(symbol, null);
        }
        return environment.get(symbol, null);
    }

    public static void setupLiterals(int n) {
        Compilation compilation = Compilation.findForImmediateLiterals(n);
        try {
            Class clazz = compilation.loader.loadClass(compilation.mainClass.getName());
            Literal literal = compilation.litTable.literalsChain;
            while (literal != null) {
                clazz.getDeclaredField(literal.field.getName()).set(null, literal.value);
                literal = literal.next;
            }
            compilation.litTable = null;
        }
        catch (Throwable throwable) {
            throw new WrappedException("internal error", throwable);
        }
    }

    public static synchronized int registerForImmediateLiterals(Compilation compilation) {
        int n = 0;
        Compilation compilation2 = chainUninitialized;
        while (compilation2 != null) {
            if (n <= compilation2.keyUninitialized) {
                n = compilation2.keyUninitialized + 1;
            }
            compilation2 = compilation2.nextUninitialized;
        }
        compilation.keyUninitialized = n;
        compilation.nextUninitialized = chainUninitialized;
        chainUninitialized = compilation;
        return n;
    }

    public static synchronized Compilation findForImmediateLiterals(int n) {
        Compilation compilation = null;
        Compilation compilation2 = chainUninitialized;
        while (true) {
            Compilation compilation3 = compilation2.nextUninitialized;
            if (compilation2.keyUninitialized == n) {
                if (compilation == null) {
                    chainUninitialized = compilation3;
                } else {
                    compilation.nextUninitialized = compilation3;
                }
                compilation2.nextUninitialized = null;
                return compilation2;
            }
            compilation = compilation2;
            compilation2 = compilation3;
        }
    }

    public static Compilation getCurrent() {
        return (Compilation)current.get();
    }

    public static void setCurrent(Compilation compilation) {
        current.set(compilation);
    }

    public String toString() {
        return "<compilation " + this.mainLambda + ">";
    }

    static {
        debugPrintExpr = false;
        options = new Options();
        options.add("warn-undefined-variable", 1, "warn if no compiler-visible binding for a variable");
        options.add("warn-invoke-unknown-method", 1, "warn if invoke calls an unknown method");
        options.add("warn-as-error", 1, "Make all warnings into errors");
        defaultClassFileVersion = 0x310000;
        moduleStatic = 0;
        typeObject = Type.objectType;
        scmBooleanType = ClassType.make("java.lang.Boolean");
        javaStringType = typeString = ClassType.make("java.lang.String");
        scmKeywordType = ClassType.make("gnu.expr.Keyword");
        scmSequenceType = ClassType.make("gnu.lists.Sequence");
        scmListType = ClassType.make("gnu.lists.LList");
        typePair = ClassType.make("gnu.lists.Pair");
        objArrayType = ArrayType.make(typeObject);
        typeRunnable = ClassType.make("java.lang.Runnable");
        typeType = ClassType.make("gnu.bytecode.Type");
        typeObjectType = ClassType.make("gnu.bytecode.ObjectType", typeType);
        typeClass = Type.javalangClassType;
        typeClassType = ClassType.make("gnu.bytecode.ClassType", typeObjectType);
        typeProcedure = ClassType.make("gnu.mapping.Procedure");
        typeLanguage = ClassType.make("gnu.expr.Language");
        typeEnvironment = ClassType.make("gnu.mapping.Environment");
        typeLocation = ClassType.make("gnu.mapping.Location");
        typeSymbol = ClassType.make("gnu.mapping.Symbol");
        getSymbolValueMethod = typeLanguage.getDeclaredMethod("getSymbolValue", 1);
        getSymbolProcedureMethod = typeLanguage.getDeclaredMethod("getSymbolProcedure", 1);
        getLocationMethod = typeLocation.addMethod("get", Type.typeArray0, Type.objectType, 1);
        getProcedureBindingMethod = typeSymbol.addMethod("getProcedure", Type.typeArray0, typeProcedure, 1);
        trueConstant = scmBooleanType.getDeclaredField("TRUE");
        falseConstant = scmBooleanType.getDeclaredField("FALSE");
        setNameMethod = typeProcedure.getDeclaredMethod("setName", 1);
        int1Args = new Type[]{Type.intType};
        string1Arg = new Type[]{javaStringType};
        sym1Arg = string1Arg;
        getLocation1EnvironmentMethod = typeEnvironment.getDeclaredMethod("getLocation", 1);
        Type[] typeArray = new Type[]{typeSymbol, Type.objectType};
        getLocation2EnvironmentMethod = typeEnvironment.addMethod("getLocation", typeArray, typeLocation, 17);
        typeArray = new Type[]{objArrayType, Type.intType};
        makeListMethod = scmListType.addMethod("makeList", typeArray, scmListType, 9);
        getCurrentEnvironmentMethod = typeEnvironment.addMethod("getCurrent", Type.typeArray0, typeEnvironment, 9);
        apply0args = Type.typeArray0;
        apply1args = new Type[]{typeObject};
        apply2args = new Type[]{typeObject, typeObject};
        applyNargs = new Type[]{objArrayType};
        apply0method = typeProcedure.addMethod("apply0", apply0args, typeObject, 17);
        apply1method = typeProcedure.addMethod("apply1", apply1args, typeObject, 1);
        apply2method = typeProcedure.addMethod("apply2", apply2args, typeObject, 1);
        typeArray = new Type[]{typeObject, typeObject, typeObject};
        apply3method = typeProcedure.addMethod("apply3", typeArray, typeObject, 1);
        Type[] typeArray2 = new Type[]{typeObject, typeObject, typeObject, typeObject};
        apply4method = typeProcedure.addMethod("apply4", typeArray2, typeObject, 1);
        applyNmethod = typeProcedure.addMethod("applyN", applyNargs, typeObject, 1);
        Type[] typeArray3 = new Type[]{typeProcedure, Type.intType};
        checkArgCountMethod = typeProcedure.addMethod("checkArgCount", typeArray3, Type.voidType, 9);
        applymethods = new Method[]{apply0method, apply1method, apply2method, apply3method, apply4method, applyNmethod};
        typeProcedure0 = ClassType.make("gnu.mapping.Procedure0", typeProcedure);
        typeProcedure1 = ClassType.make("gnu.mapping.Procedure1", typeProcedure);
        typeProcedure2 = ClassType.make("gnu.mapping.Procedure2", typeProcedure);
        typeProcedure3 = ClassType.make("gnu.mapping.Procedure3", typeProcedure);
        typeProcedure4 = ClassType.make("gnu.mapping.Procedure4", typeProcedure);
        typeProcedureN = ClassType.make("gnu.mapping.ProcedureN", typeProcedure);
        typeModuleBody = ClassType.make("gnu.expr.ModuleBody", typeProcedure0);
        typeModuleWithContext = ClassType.make("gnu.expr.ModuleWithContext", typeModuleBody);
        typeApplet = ClassType.make("java.applet.Applet");
        typeServlet = ClassType.make("gnu.kawa.servlet.KawaServlet");
        typeCallContext = ClassType.make("gnu.mapping.CallContext");
        typeConsumer = ClassType.make("gnu.lists.Consumer");
        getCallContextInstanceMethod = typeCallContext.getDeclaredMethod("getInstance", 0);
        typeValues = ClassType.make("gnu.mapping.Values");
        noArgsField = typeValues.getDeclaredField("noArgs");
        pcCallContextField = typeCallContext.getDeclaredField("pc");
        typeMethodProc = ClassType.make("gnu.mapping.MethodProc", typeProcedureN);
        typeModuleMethod = ClassType.make("gnu.expr.ModuleMethod", typeMethodProc);
        argsCallContextField = typeCallContext.getDeclaredField("values");
        procCallContextField = typeCallContext.getDeclaredField("proc");
        applyCpsArgs = new Type[]{typeCallContext};
        applyCpsMethod = typeProcedure.addMethod("apply", applyCpsArgs, Type.voidType, 1);
        typeProcedureArray = new ClassType[]{typeProcedure0, typeProcedure1, typeProcedure2, typeProcedure3, typeProcedure4};
        generateMainDefault = false;
        generateAppletDefault = false;
        generateServletDefault = false;
        inlineOk = true;
        classPrefixDefault = "";
        emitSourceDebugExtAttr = true;
        current = new ThreadLocation("current-compilation");
    }
}

