/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.CheckedTarget;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.IfExp;
import gnu.expr.InlineCalls;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.reflect.OccurrenceType;
import gnu.kawa.util.IdentityHashTable;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayOutPort;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure0;
import gnu.text.Printable;
import gnu.text.SourceLocator;
import java.io.PrintWriter;

public abstract class Expression
extends Procedure0
implements Printable,
SourceLocator {
    String filename;
    int position;
    public static final Expression[] noExpressions = new Expression[0];
    protected int flags;
    protected static final int NEXT_AVAIL_FLAG = 1;

    public final Object eval(CallContext callContext) throws Throwable {
        int n = callContext.startFromContext();
        try {
            this.match0(callContext);
            return callContext.getFromContext(n);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object eval(Environment environment) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        Environment environment2 = callContext.getEnvironmentRaw();
        if (environment != environment2) {
            callContext.setEnvironmentRaw(environment);
        }
        try {
            Object object2 = this.eval(callContext);
            return object2;
        }
        finally {
            if (environment != environment2) {
                callContext.setEnvironmentRaw(environment2);
            }
        }
    }

    protected abstract boolean mustCompile();

    public final int match0(CallContext callContext) {
        callContext.proc = this;
        callContext.pc = 0;
        return 0;
    }

    public final Object apply0() throws Throwable {
        CallContext callContext = CallContext.getInstance();
        this.check0(callContext);
        return callContext.runUntilValue();
    }

    public void apply(CallContext callContext) throws Throwable {
        throw new RuntimeException("internal error - " + this.getClass() + ".eval called");
    }

    public final void print(Consumer consumer) {
        if (consumer instanceof OutPort) {
            this.print((OutPort)consumer);
        } else if (consumer instanceof PrintWriter) {
            OutPort outPort = new OutPort((PrintWriter)((Object)consumer));
            this.print(outPort);
            outPort.close();
        } else {
            CharArrayOutPort charArrayOutPort = new CharArrayOutPort();
            this.print(charArrayOutPort);
            charArrayOutPort.close();
            charArrayOutPort.writeTo(consumer);
        }
    }

    public abstract void print(OutPort var1);

    public void printLineColumn(OutPort outPort) {
        int n = this.getLineNumber();
        if (n > 0) {
            outPort.print("line:");
            outPort.print(n);
            int n2 = this.getColumnNumber();
            if (n2 > 0) {
                outPort.print(':');
                outPort.print(n2);
            }
            outPort.writeSpaceFill();
        }
    }

    public abstract void compile(Compilation var1, Target var2);

    public final void compileWithPosition(Compilation compilation, Target target) {
        int n = this.getLineNumber();
        if (n > 0) {
            compilation.getCode().putLineNumber(this.getFileName(), n);
            this.compileNotePosition(compilation, target, this);
        } else {
            this.compile(compilation, target);
        }
    }

    public final void compileWithPosition(Compilation compilation, Target target, Expression expression) {
        int n = expression.getLineNumber();
        if (n > 0) {
            compilation.getCode().putLineNumber(expression.getFileName(), n);
            this.compileNotePosition(compilation, target, expression);
        } else {
            this.compile(compilation, target);
        }
    }

    public final void compileNotePosition(Compilation compilation, Target target, Expression expression) {
        String string = compilation.getFileName();
        int n = compilation.getLineNumber();
        int n2 = compilation.getColumnNumber();
        compilation.setLine(expression);
        this.compile(compilation, target);
        compilation.setLine(string, n, n2);
    }

    public final void compile(Compilation compilation, Type type) {
        this.compile(compilation, StackTarget.getInstance(type));
    }

    public final void compile(Compilation compilation, Declaration declaration) {
        this.compile(compilation, CheckedTarget.getInstance(declaration.getType(), declaration.getName(), -2));
    }

    public static void compileButFirst(Expression expression, Compilation compilation) {
        if (expression instanceof BeginExp) {
            BeginExp beginExp = (BeginExp)expression;
            int n = beginExp.length;
            if (n == 0) {
                return;
            }
            Expression[] expressionArray = beginExp.exps;
            Expression.compileButFirst(expressionArray[0], compilation);
            for (int i = 1; i < n; ++i) {
                expressionArray[i].compileWithPosition(compilation, Target.Ignore);
            }
        }
    }

    public static Expression deepCopy(Expression expression, IdentityHashTable identityHashTable) {
        if (expression == null) {
            return null;
        }
        Object v = identityHashTable.get(expression);
        if (v != null) {
            return (Expression)v;
        }
        Expression expression2 = expression.deepCopy(identityHashTable);
        identityHashTable.put(expression, expression2);
        return expression2;
    }

    public static Expression[] deepCopy(Expression[] expressionArray, IdentityHashTable identityHashTable) {
        if (expressionArray == null) {
            return null;
        }
        int n = expressionArray.length;
        Expression[] expressionArray2 = new Expression[n];
        for (int i = 0; i < n; ++i) {
            Expression expression = expressionArray[i];
            Expression expression2 = Expression.deepCopy(expression, identityHashTable);
            if (expression2 == null && expression != null) {
                return null;
            }
            expressionArray2[i] = expression2;
        }
        return expressionArray2;
    }

    protected static Expression deepCopy(Expression expression) {
        return Expression.deepCopy(expression, new IdentityHashTable());
    }

    protected Expression deepCopy(IdentityHashTable identityHashTable) {
        return null;
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkExpression(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, Declaration declaration, boolean bl) {
        if (!bl) {
            applyExp.args = inlineCalls.walkExps(applyExp.args, applyExp.args.length);
        }
        return applyExp;
    }

    public static Expression makeWhile(Object object2, Object object3, Compilation compilation) {
        Expression[] expressionArray = new Expression[1];
        LetExp letExp = new LetExp(expressionArray);
        String string = "%do%loop";
        Declaration declaration = letExp.addDeclaration(string);
        ApplyExp applyExp = new ApplyExp(new ReferenceExp(declaration), noExpressions);
        LambdaExp lambdaExp = new LambdaExp();
        compilation.push(lambdaExp);
        lambdaExp.body = new IfExp(compilation.parse(object2), new BeginExp(compilation.parse(object3), applyExp), QuoteExp.voidExp);
        lambdaExp.setName(string);
        compilation.pop(lambdaExp);
        expressionArray[0] = lambdaExp;
        declaration.noteValue(lambdaExp);
        letExp.setBody(new ApplyExp(new ReferenceExp(declaration), noExpressions));
        return letExp;
    }

    public final void setLocation(SourceLocator sourceLocator) {
        this.filename = sourceLocator.getFileName();
        this.setLine(sourceLocator.getLineNumber(), sourceLocator.getColumnNumber());
    }

    public final Expression setLine(Expression expression) {
        this.setLocation(expression);
        return this;
    }

    public final void setFile(String string) {
        this.filename = string;
    }

    public final void setLine(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        this.position = (n << 12) + n2;
    }

    public final void setLine(int n) {
        this.setLine(n, 0);
    }

    public final String getFileName() {
        return this.filename;
    }

    public void setLine(Compilation compilation) {
        int n = compilation.getLineNumber();
        if (n > 0) {
            this.setFile(compilation.getFileName());
            this.setLine(n, compilation.getColumnNumber());
        }
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.filename;
    }

    public final int getLineNumber() {
        int n = this.position >> 12;
        return n == 0 ? -1 : n;
    }

    public final int getColumnNumber() {
        int n = this.position & 0xFFF;
        return n == 0 ? -1 : n;
    }

    public boolean isStableSourceLocation() {
        return true;
    }

    public Type getType() {
        return Type.pointer_type;
    }

    public boolean isSingleValue() {
        return OccurrenceType.itemCountIsOne(this.getType());
    }

    public Object valueIfConstant() {
        return null;
    }

    public void setFlag(boolean bl, int n) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public void setFlag(int n) {
        this.flags |= n;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    public boolean side_effects() {
        return true;
    }

    public String toString() {
        String string = this.getClass().getName();
        if (string.startsWith("gnu.expr.")) {
            string = string.substring(9);
        }
        return string + "@" + Integer.toHexString(this.hashCode());
    }
}

