/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.reflect;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Member;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.CheckedTarget;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import gnu.kawa.reflect.Invoke;
import gnu.kawa.reflect.SlotGet;
import gnu.lists.FString;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure3;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import kawa.standard.Scheme;

public class SlotSet
extends Procedure3
implements CanInline,
Inlineable {
    boolean isStatic;
    boolean returnSelf;
    public static final SlotSet set$Mnfield$Ex = new SlotSet("set-field!", false);
    public static final SlotSet set$Mnstatic$Mnfield$Ex = new SlotSet("set-static-field!", true);
    public static final SlotSet setFieldReturnObject = new SlotSet("set-field-return-object!", false);

    public SlotSet(String string, boolean bl) {
        super(string);
        this.isStatic = bl;
    }

    public static void setField(Object object2, String string, Object object3) {
        SlotSet.apply(false, object2, string, object3);
    }

    public static void setStaticField(Object object2, String string, Object object3) {
        SlotSet.apply(true, object2, string, object3);
    }

    public static void apply(boolean bl, Object object2, String string, Object object3) {
        Language language = Language.getDefaultLanguage();
        boolean bl2 = false;
        String string2 = Compilation.mangleNameIfNeeded(string);
        Class<?> clazz = bl ? SlotGet.coerceToClass(object2) : object2.getClass();
        try {
            Field field = clazz.getField(string2);
            Class<?> clazz2 = field.getType();
            field.set(object2, language.coerceFromObject(clazz2, object3));
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            bl2 = true;
        }
        try {
            Class[] classArray;
            String string3;
            java.lang.reflect.Method method = null;
            try {
                string3 = ClassExp.slotToMethodName("get", string);
                method = clazz.getMethod(string3, SlotGet.noClasses);
            }
            catch (Exception exception) {
                classArray = ClassExp.slotToMethodName("is", string);
                method = clazz.getMethod((String)classArray, SlotGet.noClasses);
            }
            string3 = ClassExp.slotToMethodName("set", string);
            classArray = new Class[]{method.getReturnType()};
            java.lang.reflect.Method method2 = clazz.getMethod(string3, classArray);
            Object[] objectArray = new Object[]{language.coerceFromObject(classArray[0], object3)};
            method2.invoke(object2, objectArray);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw WrappedException.wrapIfNeeded(invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            bl2 = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (bl2) {
            throw new RuntimeException("illegal access for field " + string);
        }
        throw new RuntimeException("no such field " + string + " in " + clazz.getName());
    }

    public Object apply3(Object object2, Object object3, Object object4) {
        SlotSet.apply(this.isStatic, object2, object3.toString(), object4);
        return this.returnSelf ? object2 : Values.empty;
    }

    public static Member lookupMember(ObjectType objectType, String string, ClassType classType) {
        String string2;
        Method method;
        gnu.bytecode.Field field = objectType.getField(Compilation.mangleNameIfNeeded(string), -1);
        if (field != null) {
            if (classType == null) {
                classType = Type.pointer_type;
            }
            if (classType.isAccessible(field, objectType)) {
                return field;
            }
        }
        if ((method = objectType.getMethod(string2 = ClassExp.slotToMethodName("set", string), new Type[1])) == null) {
            return field;
        }
        return method;
    }

    static void compileSet(Procedure procedure, ClassType classType, Expression expression, Object object2, Compilation compilation) {
        boolean bl;
        CodeAttr codeAttr = compilation.getCode();
        Language language = compilation.getLanguage();
        boolean bl2 = bl = procedure instanceof SlotSet && ((SlotSet)procedure).isStatic;
        if (object2 instanceof gnu.bytecode.Field) {
            gnu.bytecode.Field field = (gnu.bytecode.Field)object2;
            boolean bl3 = field.getStaticFlag();
            Type type = language.getLangTypeFor(field.getType());
            if (bl && !bl3) {
                compilation.error('e', "cannot access non-static field `" + field.getName() + "' using `" + procedure.getName() + '\'');
            }
            expression.compile(compilation, CheckedTarget.getInstance(type));
            if (bl3) {
                codeAttr.emitPutStatic(field);
            } else {
                codeAttr.emitPutField(field);
            }
            return;
        }
        if (object2 instanceof Method) {
            Method method = (Method)object2;
            boolean bl4 = method.getStaticFlag();
            if (bl && !bl4) {
                compilation.error('e', "cannot call non-static getter method `" + method.getName() + "' using `" + procedure.getName() + '\'');
            }
            Type[] typeArray = method.getParameterTypes();
            expression.compile(compilation, CheckedTarget.getInstance(language.getLangTypeFor(typeArray[0])));
            if (bl4) {
                codeAttr.emitInvokeStatic(method);
            } else if (classType.isInterface()) {
                codeAttr.emitInvokeInterface(method);
            } else {
                codeAttr.emitInvokeVirtual(method);
            }
            return;
        }
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, boolean bl) {
        applyExp.walkArgs(inlineCalls, bl);
        if (this.isStatic && inlineCalls.getCompilation().mustCompile) {
            return Invoke.inlineClassName(applyExp, 0, inlineCalls);
        }
        return applyExp;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        Expression[] expressionArray = applyExp.getArgs();
        int n = expressionArray.length;
        if (n != 3) {
            String string = n < 3 ? "too few" : "too many";
            compilation.error('e', string + " arguments to `" + this.getName() + '\'');
            compilation.compileConstant(null, target);
            return;
        }
        Expression expression = expressionArray[0];
        Expression expression2 = expressionArray[1];
        Expression expression3 = expressionArray[2];
        Type type = this.isStatic ? Scheme.exp2Type(expression) : expression.getType();
        Member member = null;
        if (type instanceof ClassType && expression2 instanceof QuoteExp) {
            String string;
            ClassType classType;
            Object object2 = ((QuoteExp)expression2).getValue();
            ClassType classType2 = (ClassType)type;
            ClassType classType3 = classType = compilation.curClass != null ? compilation.curClass : compilation.mainClass;
            if (object2 instanceof String || object2 instanceof FString || object2 instanceof Symbol) {
                string = object2.toString();
                member = SlotSet.lookupMember(classType2, string, classType);
                if (member == null && type != Type.pointer_type) {
                    compilation.error('e', "no slot `" + string + "' in " + classType2.getName());
                }
            } else if (object2 instanceof Member) {
                member = (Member)object2;
                string = member.getName();
            } else {
                string = null;
            }
            if (member != null) {
                boolean bl;
                int n2 = member.getModifiers();
                boolean bl2 = bl = (n2 & 8) != 0;
                if (classType != null && !classType.isAccessible(member, classType2)) {
                    compilation.error('e', "slot '" + string + "' in " + member.getDeclaringClass().getName() + " not accessible here");
                }
                expressionArray[0].compile(compilation, bl ? Target.Ignore : Target.pushValue(classType2));
                if (this.returnSelf) {
                    compilation.getCode().emitDup(classType2);
                }
                SlotSet.compileSet(this, classType2, expressionArray[2], member, compilation);
                if (this.returnSelf) {
                    target.compileFromStack(compilation, classType2);
                } else {
                    compilation.compileConstant(Values.empty, target);
                }
                return;
            }
        }
        ApplyExp.compile(applyExp, compilation, target);
    }

    public Type getReturnType(Expression[] expressionArray) {
        if (this.returnSelf && expressionArray.length == 3) {
            return expressionArray[0].getType();
        }
        return Type.void_type;
    }

    static {
        SlotSet.setFieldReturnObject.returnSelf = true;
    }
}

