/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.expr.NameLookup;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.kawa.functions.ConstantFunction0;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.xml.XDataType;
import gnu.kawa.xml.XIntegerType;
import gnu.kawa.xml.XStringType;
import gnu.kawa.xml.XTimeType;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.InPort;
import gnu.mapping.MethodProc;
import gnu.mapping.Namespace;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.mapping.WrongType;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xml.XMLPrinter;
import gnu.xquery.lang.Prompter;
import gnu.xquery.lang.XQParser;
import gnu.xquery.lang.XQResolveNames;
import gnu.xquery.util.BooleanValue;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import kawa.standard.Scheme;

public class XQuery
extends Language {
    public static final String XQUERY_FUNCTION_NAMESPACE = "http://www.w3.org/2005/xpath-functions";
    public static final String KAWA_FUNCTION_NAMESPACE = "http://kawa.gnu.org/";
    public static final String QEXO_FUNCTION_NAMESPACE = "http://qexo.gnu.org/";
    public static final String LOCAL_NAMESPACE = "http://www.w3.org/2005/xquery-local-functions";
    public static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String SCHEMA_INSTANCE_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    public static final Namespace xqueryFunctionNamespace = Namespace.getInstance("http://www.w3.org/2005/xpath-functions");
    public static final Namespace kawaFunctionNamespace = Namespace.getInstance("http://kawa.gnu.org/");
    public static final Namespace qexoFunctionNamespace = Namespace.getInstance("http://qexo.gnu.org/");
    public static final Namespace[] defaultFunctionNamespacePath = new Namespace[]{qexoFunctionNamespace, xqueryFunctionNamespace, Namespace.EmptyNamespace, kawaFunctionNamespace};
    static boolean charIsInt = false;
    public static final String DEFAULT_ELEMENT_PREFIX = null;
    public static final String DEFAULT_FUNCTION_PREFIX = "(functions)";
    Namespace defaultNamespace;
    public static final int PARSE_WITH_FOCUS = 65536;
    public static final int VARIADIC_FUNCTION_NAMESPACE = -2;
    static int envCounter = 0;
    public static Environment extensionsEnvEnv = Environment.getInstance("http://kawa.gnu.org/");
    public static final Environment xqEnvironment = Environment.make("http://www.w3.org/2005/xpath-functions");
    public static final XQuery instance = new XQuery();
    public static QuoteExp falseExp;
    public static QuoteExp trueExp;
    public static final ConstantFunction0 falseFunction;
    public static final ConstantFunction0 trueFunction;
    static Object[] typeMap;

    public boolean hasSeparateFunctionNamespace() {
        return true;
    }

    public static Numeric asNumber(Object object2) {
        if (object2 instanceof Char) {
            return IntNum.make(((Char)object2).intValue());
        }
        return (Numeric)object2;
    }

    public static char asChar(Object object2) {
        if (object2 instanceof Char) {
            return ((Char)object2).charValue();
        }
        int n = object2 instanceof Numeric ? ((Numeric)object2).intValue() : -1;
        if (n < 0 || n > 65535) {
            throw new ClassCastException("not a character value");
        }
        return (char)n;
    }

    public boolean isTrue(Object object2) {
        return BooleanValue.booleanValue(object2);
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        return new XQParser(inPort, sourceMessages, this);
    }

    public Compilation getCompilation(Lexer lexer, SourceMessages sourceMessages, NameLookup nameLookup) {
        return new Compilation(this, sourceMessages, nameLookup);
    }

    public boolean parse(Compilation compilation, int n) throws IOException, SyntaxException {
        Object object2;
        ModuleExp moduleExp = compilation.mainLambda;
        Compilation.defaultCallConvention = 2;
        compilation.mustCompileHere();
        XQParser xQParser = (XQParser)compilation.lexer;
        if (xQParser.isInteractive()) {
            object2 = xQParser.parse(compilation);
            if (object2 == null) {
                return false;
            }
            moduleExp.body = object2;
        } else if ((n & 0x10000) != 0) {
            object2 = new LambdaExp(3);
            Declaration declaration = ((ScopeExp)object2).addDeclaration(XQParser.DOT_VARNAME);
            declaration.setFlag(262144);
            declaration.noteValue(null);
            ((ScopeExp)object2).addDeclaration(XQParser.POSITION_VARNAME, Type.intType);
            ((ScopeExp)object2).addDeclaration(XQParser.LAST_VARNAME, Type.intType);
            compilation.push((ScopeExp)object2);
            ((LambdaExp)object2).body = xQParser.parse(compilation);
            compilation.pop((ScopeExp)object2);
            moduleExp.body = object2;
        } else {
            object2 = new Vector(10);
            Expression expression = moduleExp.body;
            if (expression instanceof BeginExp) {
                BeginExp beginExp = (BeginExp)expression;
                int n2 = beginExp.getExpressionCount();
                Expression[] expressionArray = beginExp.getExpressions();
                for (int i = 0; i < n2; ++i) {
                    ((Vector)object2).addElement(expressionArray[i]);
                }
            } else if (expression != null && expression != QuoteExp.voidExp) {
                ((Vector)object2).addElement(expression);
            }
            while (true) {
                if ((expression = xQParser.parse(compilation)) == null) {
                    if (xQParser.parseCount != 0 || xQParser.isInteractive()) break;
                    xQParser.error('e', "empty module", "XPST0003");
                    return false;
                }
                ((Vector)object2).addElement(expression);
            }
            int n3 = ((Vector)object2).size();
            if (n3 == 0) {
                moduleExp.body = QuoteExp.voidExp;
            } else if (n3 == 1) {
                moduleExp.body = (Expression)((Vector)object2).elementAt(0);
            } else {
                Object[] objectArray = new Expression[n3];
                ((Vector)object2).copyInto(objectArray);
                moduleExp.body = new BeginExp((Expression[])objectArray);
            }
        }
        compilation.pop(moduleExp);
        object2 = new XQResolveNames(compilation);
        ((XQResolveNames)object2).functionNamespacePath = xQParser.functionNamespacePath;
        ((XQResolveNames)object2).parser = xQParser;
        ((XQResolveNames)object2).resolveModule(moduleExp);
        compilation.setState(4);
        return true;
    }

    public void resolve(Compilation compilation) {
    }

    public static int namespaceForFunctions(int n) {
        return n << 2 | 2;
    }

    public int getNamespaceOf(Declaration declaration) {
        if (declaration.isProcedureDecl()) {
            if (declaration.getCode() < 0) {
                return -2;
            }
            Expression expression = declaration.getValue();
            if (expression instanceof LambdaExp) {
                LambdaExp lambdaExp = (LambdaExp)expression;
                if (lambdaExp.min_args == lambdaExp.max_args) {
                    return XQuery.namespaceForFunctions(lambdaExp.min_args);
                }
            } else if (expression instanceof QuoteExp) {
                int n;
                Procedure procedure;
                int n2;
                Object object2 = ((QuoteExp)expression).getValue();
                if (object2 instanceof Procedure && (n2 = (procedure = (Procedure)object2).minArgs()) == (n = procedure.maxArgs())) {
                    return XQuery.namespaceForFunctions(n2);
                }
            } else if (expression instanceof ReferenceExp) {
                return this.getNamespaceOf(((ReferenceExp)expression).getBinding());
            }
            return -2;
        }
        return 1;
    }

    public boolean hasNamespace(Declaration declaration, int n) {
        int n2 = this.getNamespaceOf(declaration);
        return n2 == n || n2 == -2 && (n & 2) != 0 || n == -2 && (n2 & 2) != 0;
    }

    public Symbol getSymbol(String string) {
        return Symbol.make(this.defaultNamespace, string);
    }

    public void define(String string, Object object2) {
        Symbol symbol = Symbol.make(this.defaultNamespace, string);
        Object object3 = object2 instanceof Procedure ? EnvironmentKey.FUNCTION : null;
        this.environ.define(symbol, object3, object2);
    }

    protected void define_method(String string, String string2, String string3) {
        Symbol symbol = Symbol.make(this.defaultNamespace, string);
        ClassType classType = ClassType.make(string2);
        MethodProc methodProc = ClassMethods.apply(classType, string3, '\u0000', this);
        methodProc.setSymbol(symbol);
        this.environ.define(symbol, EnvironmentKey.FUNCTION, methodProc);
    }

    public String getName() {
        return "XQuery";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyWithFocus(Procedure procedure, Object object2, int n, int n2, Consumer consumer) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        procedure.check3(object2, IntNum.make(n), IntNum.make(n2), callContext);
        Consumer consumer2 = callContext.consumer;
        try {
            callContext.consumer = consumer;
            callContext.runUntilDone();
        }
        finally {
            callContext.consumer = consumer2;
        }
    }

    public Object applyWithFocus(Procedure procedure, Object object2, int n, int n2) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        int n3 = callContext.startFromContext();
        try {
            procedure.check3(object2, IntNum.make(n), IntNum.make(n2), callContext);
            return callContext.getFromContext(n3);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n3);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyWithFocus(Procedure procedure, Object object2, Consumer consumer) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        Consumer consumer2 = callContext.consumer;
        try {
            callContext.consumer = consumer;
            this.applyWithFocus$X(procedure, object2, callContext);
        }
        finally {
            callContext.consumer = consumer2;
        }
    }

    public Object applyWithFocus(Procedure procedure, Object object2) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        int n = callContext.startFromContext();
        try {
            this.applyWithFocus$X(procedure, object2, callContext);
            return callContext.getFromContext(n);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n);
            throw throwable;
        }
    }

    public void applyWithFocus$X(Procedure procedure, Object object2, CallContext callContext) throws Throwable {
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            int n = values.size();
            if (n == 0) {
                return;
            }
            int n2 = 0;
            IntNum intNum = IntNum.make(n);
            int n3 = 1;
            while (true) {
                procedure.check3(values.getPosNext(n2), IntNum.make(n3), intNum, callContext);
                callContext.runUntilDone();
                if (n3 != n) {
                    n2 = values.nextPos(n2);
                    ++n3;
                    continue;
                }
                break;
            }
        } else {
            IntNum intNum = IntNum.one();
            procedure.check3(object2, intNum, intNum, callContext);
            callContext.runUntilDone();
        }
    }

    public Procedure evalToFocusProc(String string) throws Throwable {
        SourceMessages sourceMessages = new SourceMessages();
        Procedure procedure = this.evalToFocusProc(new CharArrayInPort(string), sourceMessages);
        if (sourceMessages.seenErrors()) {
            throw new RuntimeException("invalid syntax in eval form:\n" + sourceMessages.toString(20));
        }
        return procedure;
    }

    public Procedure evalToFocusProc(Reader reader, SourceMessages sourceMessages) throws Throwable {
        InPort inPort = reader instanceof InPort ? (InPort)reader : new InPort(reader);
        Compilation compilation = this.parse(inPort, sourceMessages, 65537);
        CallContext callContext = CallContext.getInstance();
        int n = callContext.startFromContext();
        try {
            ModuleExp.evalModule(Environment.getCurrent(), callContext, compilation, null, null);
            return (Procedure)callContext.getFromContext(n);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n);
            throw throwable;
        }
    }

    public void evalWithFocus(Reader reader, SourceMessages sourceMessages, Object object2, Consumer consumer) throws Throwable {
        this.applyWithFocus(this.evalToFocusProc(reader, sourceMessages), object2, consumer);
    }

    public Object evalWithFocus(String string, Object object2) throws Throwable {
        return this.applyWithFocus(this.evalToFocusProc(string), object2);
    }

    public Object evalWithFocus(String string, Object object2, int n, int n2) throws Throwable {
        return this.applyWithFocus(this.evalToFocusProc(string), object2, n, n2);
    }

    public void evalWithFocus(Reader reader, SourceMessages sourceMessages, Object object2, int n, int n2, Consumer consumer) throws Throwable {
        this.applyWithFocus(this.evalToFocusProc(reader, sourceMessages), object2, n, n2, consumer);
    }

    public void eval_with_focus$X(String string, Object object2, CallContext callContext) throws Throwable {
        this.applyWithFocus$X(this.evalToFocusProc(string), object2, callContext);
    }

    public void eval_with_focus$X(String string, Object object2, int n, int n2, CallContext callContext) throws Throwable {
        Procedure procedure = this.evalToFocusProc(string);
        procedure.check3(object2, IntNum.make(n), IntNum.make(n2), callContext);
    }

    public XQuery() {
        this.environ = xqEnvironment;
        this.defaultNamespace = xqueryFunctionNamespace;
    }

    private void initXQuery() {
        ModuleBody.setMainPrintValues(true);
        this.defProcStFld("unescaped-data", "gnu.kawa.xml.MakeUnescapedData", "unescapedData");
        this.defProcStFld("item-at", "gnu.xquery.util.ItemAt", "itemAt");
        this.defProcStFld("count", "gnu.kawa.functions.CountValues", "countValues");
        this.define_method("sum", "gnu.xquery.util.Reduce", "sum");
        this.defProcStFld("avg", "gnu.xquery.util.Average", "avg");
        this.defProcStFld("sublist", "gnu.xquery.util.SubList", "subList");
        this.defProcStFld("subsequence", "gnu.xquery.util.SubList", "subList");
        this.define_method("empty", "gnu.xquery.util.SequenceUtils", "isEmptySequence");
        this.define_method("exists", "gnu.xquery.util.SequenceUtils", "exists");
        this.define_method("insert-before", "gnu.xquery.util.SequenceUtils", "insertBefore$X");
        this.define_method("remove", "gnu.xquery.util.SequenceUtils", "remove$X");
        this.define_method("reverse", "gnu.xquery.util.SequenceUtils", "reverse$X");
        this.defProcStFld("false", "gnu.xquery.lang.XQuery", "falseFunction");
        this.defProcStFld("true", "gnu.xquery.lang.XQuery", "trueFunction");
        this.defProcStFld("boolean", "gnu.xquery.util.BooleanValue", "booleanValue");
        this.define_method("trace", "gnu.xquery.util.Debug", "trace");
        this.define_method("error", "gnu.xquery.util.XQException", "error");
        this.defProcStFld("write-to", "gnu.kawa.xml.WriteTo", "writeTo");
        this.defProcStFld("write-to-if-changed", "gnu.kawa.xml.WriteTo", "writeToIfChanged");
        this.defProcStFld("iterator-items", "gnu.kawa.xml.IteratorItems", "iteratorItems");
        this.defProcStFld("list-items", "gnu.kawa.xml.ListItems", "listItems");
        this.define_method("node-name", "gnu.xquery.util.NodeUtils", "nodeName");
        this.define_method("nilled", "gnu.xquery.util.NodeUtils", "nilled");
        this.define_method("data", "gnu.xquery.util.NodeUtils", "data$X");
        this.define_method("lower-case", "gnu.xquery.util.StringUtils", "lowerCase");
        this.define_method("upper-case", "gnu.xquery.util.StringUtils", "upperCase");
        this.define_method("substring", "gnu.xquery.util.StringUtils", "substring");
        this.define_method("string-length", "gnu.xquery.util.StringUtils", "stringLength");
        this.define_method("substring-before", "gnu.xquery.util.StringUtils", "substringBefore");
        this.define_method("substring-after", "gnu.xquery.util.StringUtils", "substringAfter");
        this.define_method("translate", "gnu.xquery.util.StringUtils", "translate");
        this.define_method("encode-for-uri", "gnu.xquery.util.StringUtils", "encodeForUri");
        this.define_method("iri-to-uri", "gnu.xquery.util.StringUtils", "iriToUri");
        this.define_method("escape-html-uri", "gnu.xquery.util.StringUtils", "escapeHtmlUri");
        this.define_method("contains", "gnu.xquery.util.StringUtils", "contains");
        this.define_method("starts-with", "gnu.xquery.util.StringUtils", "startsWith");
        this.define_method("ends-with", "gnu.xquery.util.StringUtils", "endsWith");
        this.define_method("codepoint-equal", "gnu.xquery.util.StringUtils", "codepointEqual");
        this.define_method("normalize-unicode", "gnu.xquery.util.StringUtils", "normalizeUnicode");
        this.define_method("string-join", "gnu.xquery.util.StringUtils", "stringJoin");
        this.define_method("concat", "gnu.xquery.util.StringUtils", "concat$V");
        this.define_method("matches", "gnu.xquery.util.StringUtils", "matches");
        this.define_method("replace", "gnu.xquery.util.StringUtils", "replace");
        this.define_method("tokenize", "gnu.xquery.util.StringUtils", "tokenize$X");
        this.define_method("string-to-codepoints", "gnu.xquery.util.StringUtils", "stringToCodepoints$X");
        this.define_method("codepoints-to-string", "gnu.xquery.util.StringUtils", "codepointsToString");
        this.define_method("abs", "gnu.xquery.util.NumberValue", "abs");
        this.define_method("floor", "gnu.xquery.util.NumberValue", "floor");
        this.define_method("ceiling", "gnu.xquery.util.NumberValue", "ceiling");
        this.define_method("round", "gnu.xquery.util.NumberValue", "round");
        this.define_method("round-half-to-even", "gnu.xquery.util.NumberValue", "roundHalfToEven");
        this.define_method("QName", "gnu.xquery.util.QNameUtils", "makeQName");
        this.define_method("resolve-QName", "gnu.xquery.util.QNameUtils", "resolveQNameUsingElement");
        this.define_method("prefix-from-QName", "gnu.xquery.util.QNameUtils", "prefixFromQName");
        this.define_method("local-name-from-QName", "gnu.xquery.util.QNameUtils", "localNameFromQName");
        this.define_method("namespace-uri-from-QName", "gnu.xquery.util.QNameUtils", "namespaceURIFromQName");
        this.define_method("namespace-uri-for-prefix", "gnu.xquery.util.QNameUtils", "namespaceURIForPrefix");
        this.define_method("in-scope-prefixes", "gnu.xquery.util.NodeUtils", "inScopePrefixes$X");
        this.define_method("document-uri", "gnu.xquery.util.NodeUtils", "documentUri");
        this.define_method("years-from-duration", "gnu.xquery.util.TimeUtils", "yearsFromDuration");
        this.define_method("months-from-duration", "gnu.xquery.util.TimeUtils", "monthsFromDuration");
        this.define_method("days-from-duration", "gnu.xquery.util.TimeUtils", "daysFromDuration");
        this.define_method("hours-from-duration", "gnu.xquery.util.TimeUtils", "hoursFromDuration");
        this.define_method("minutes-from-duration", "gnu.xquery.util.TimeUtils", "minutesFromDuration");
        this.define_method("seconds-from-duration", "gnu.xquery.util.TimeUtils", "secondsFromDuration");
        this.define_method("year-from-dateTime", "gnu.xquery.util.TimeUtils", "yearFromDateTime");
        this.define_method("month-from-dateTime", "gnu.xquery.util.TimeUtils", "monthFromDateTime");
        this.define_method("day-from-dateTime", "gnu.xquery.util.TimeUtils", "dayFromDateTime");
        this.define_method("hours-from-dateTime", "gnu.xquery.util.TimeUtils", "hoursFromDateTime");
        this.define_method("minutes-from-dateTime", "gnu.xquery.util.TimeUtils", "minutesFromDateTime");
        this.define_method("seconds-from-dateTime", "gnu.xquery.util.TimeUtils", "secondsFromDateTime");
        this.define_method("timezone-from-dateTime", "gnu.xquery.util.TimeUtils", "timezoneFromDateTime");
        this.define_method("year-from-date", "gnu.xquery.util.TimeUtils", "yearFromDate");
        this.define_method("month-from-date", "gnu.xquery.util.TimeUtils", "monthFromDate");
        this.define_method("day-from-date", "gnu.xquery.util.TimeUtils", "dayFromDate");
        this.define_method("timezone-from-date", "gnu.xquery.util.TimeUtils", "timezoneFromDate");
        this.define_method("hours-from-time", "gnu.xquery.util.TimeUtils", "hoursFromTime");
        this.define_method("minutes-from-time", "gnu.xquery.util.TimeUtils", "minutesFromTime");
        this.define_method("seconds-from-time", "gnu.xquery.util.TimeUtils", "secondsFromTime");
        this.define_method("timezone-from-time", "gnu.xquery.util.TimeUtils", "timezoneFromTime");
        this.define_method("adjust-dateTime-to-timezone", "gnu.xquery.util.TimeUtils", "adjustDateTimeToTimezone");
        this.define_method("adjust-date-to-timezone", "gnu.xquery.util.TimeUtils", "adjustDateToTimezone");
        this.define_method("adjust-time-to-timezone", "gnu.xquery.util.TimeUtils", "adjustTimeToTimezone");
        this.define_method("dateTime", "gnu.xquery.util.TimeUtils", "dateTime");
        this.define_method("current-dateTime", "gnu.xquery.util.TimeUtils", "currentDateTime");
        this.define_method("current-date", "gnu.xquery.util.TimeUtils", "currentDate");
        this.define_method("current-time", "gnu.xquery.util.TimeUtils", "currentTime");
        this.define_method("implicit-timezone", "gnu.xquery.util.TimeUtils", "implicitTimezone");
        this.define_method("zero-or-one", "gnu.xquery.util.SequenceUtils", "zeroOrOne");
        this.define_method("one-or-more", "gnu.xquery.util.SequenceUtils", "oneOrMore");
        this.define_method("exactly-one", "gnu.xquery.util.SequenceUtils", "exactlyOne");
        this.defProcStFld("distinct-nodes", "gnu.kawa.xml.SortNodes", "sortNodes");
        this.defProcStFld("children", "gnu.kawa.xml.Children", "children");
        this.define_method("not", "gnu.xquery.util.BooleanValue", "not");
        this.defaultNamespace = qexoFunctionNamespace;
        this.defProcStFld("response-header", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("response-content-type", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("response-status", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("error-response", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("current-servlet", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("current-servlet-context", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("current-servlet-config", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("servlet-context-realpath", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("get-response", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("get-request", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("request-method", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("request-uri", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("request-url", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("request-path-info", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("request-path-translated", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("request-servlet-path", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("request-query-string", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("request-parameter", "gnu.kawa.servlet.HTTP");
        this.defProcStFld("request-parameters", "gnu.kawa.servlet.HTTP");
        this.defaultNamespace = xqueryFunctionNamespace;
    }

    public static XQuery getInstance() {
        return instance;
    }

    public static void registerEnvironment() {
        Language.setDefaults(instance);
    }

    public Consumer getOutputConsumer(Writer writer) {
        return new XMLPrinter(writer, false);
    }

    public static Type getStandardType(String string) {
        int n = typeMap.length;
        while ((n -= 2) >= 0) {
            if (!typeMap[n].equals(string)) continue;
            Object object2 = typeMap[n + 1];
            if (object2 instanceof String) {
                return Scheme.string2Type((String)object2);
            }
            return (Type)object2;
        }
        return null;
    }

    public Type getTypeFor(String string) {
        String string2 = string.startsWith("xs:") ? string.substring(3) : (string.startsWith("xdt:") ? string.substring(4) : string);
        Type type = XQuery.getStandardType(string2);
        return type != null ? type : Scheme.string2Type(string);
    }

    public String formatType(Type type) {
        String string = type.getName();
        if ("gnu.math.IntNum".equals(string)) {
            return "xs:integer";
        }
        if ("java.lang.String".equals(string) || "java.lang.CharSequence".equals(string)) {
            return "xs:string";
        }
        return type.toString();
    }

    public Type getTypeFor(Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            if (string.equals("boolean")) {
                return XDataType.booleanType;
            }
            return Scheme.getNamedType(string);
        }
        if (!clazz.isArray()) {
            String string = clazz.getName();
            if (string.equals("java.lang.String")) {
                return XDataType.stringStringType;
            }
            if (string.equals("gnu.kawa.xml.UntypedAtomic")) {
                return XDataType.untypedAtomicType;
            }
            if (string.equals("java.lang.Boolean")) {
                return XDataType.booleanType;
            }
            if (string.equals("java.lang.Float")) {
                return XDataType.floatType;
            }
            if (string.equals("java.lang.Double")) {
                return XDataType.doubleType;
            }
            if (string.equals("java.math.BigDecimal")) {
                return XDataType.decimalType;
            }
            if (string.equals("gnu.math.Duration")) {
                return XDataType.durationType;
            }
            if (string.equals("gnu.text.Path")) {
                return XDataType.anyURIType;
            }
        }
        return Type.make(clazz);
    }

    public Procedure getPrompter() {
        return new Prompter();
    }

    static void mangle(String string, int n, int n2, StringBuffer stringBuffer, char c) {
        int n3 = 80;
        int n4 = stringBuffer.length();
        int n5 = 0;
        while (n5 < n2) {
            boolean bl;
            char c2 = string.charAt(n + n5);
            ++n5;
            if (Character.isUpperCase(c2)) {
                bl = n3 != 85 || n5 < n2 && Character.isLowerCase(string.charAt(n + n5));
                n3 = 85;
            } else if (Character.isLowerCase(c2)) {
                bl = n3 != 76 || n3 != 85;
                n3 = 76;
            } else if (Character.isLetter(c2)) {
                bl = n3 != 79;
                n3 = 79;
            } else if (Character.isDigit(c2)) {
                bl = n3 != 68;
                n3 = 68;
            } else if (Character.isJavaIdentifierPart(c2)) {
                bl = n3 != 68 && n3 != 77;
                n3 = 77;
            } else {
                n3 = 80;
                continue;
            }
            if (bl || c == '_') {
                if (bl && c == '_' && stringBuffer.length() > n4) {
                    stringBuffer.append('_');
                }
                c2 = Character.toUpperCase(c2);
            }
            stringBuffer.append(c2);
        }
    }

    public static String mangle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        XQuery.mangle(string, 0, string.length(), stringBuffer, 'U');
        return stringBuffer.toString();
    }

    public static String makeClassName(String string) {
        int n;
        int n2 = (string = string.replace(File.separatorChar, '/')).lastIndexOf(47);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        if ((n = string.lastIndexOf(46)) >= 0) {
            string = string.substring(0, n);
        }
        return Compilation.mangleNameIfNeeded(string);
    }

    public static Object getExternal(Symbol symbol, Object object2) {
        Environment environment = Environment.getCurrent();
        Object object3 = environment.get(symbol, null, null);
        if (object3 == null) {
            object3 = environment.get(Symbol.makeWithUnknownNamespace(symbol.getLocalName(), symbol.getPrefix()), null, null);
        }
        if (object3 == null) {
            throw new RuntimeException("unbound external " + symbol);
        }
        if (object2 == null) {
            return object3;
        }
        if (object2 instanceof XDataType) {
            return ((XDataType)object2).cast(object3);
        }
        if (object2 instanceof ClassType) {
            String string = ((ClassType)object2).getName();
            if ("gnu.math.IntNum".equals(string)) {
                return IntNum.valueOf(object3.toString());
            }
            if ("gnu.math.RealNum".equals(string)) {
                return DFloNum.make(Double.parseDouble(object3.toString()));
            }
        }
        try {
            object3 = ((Type)object2).coerceFromObject(object3);
        }
        catch (ClassCastException classCastException) {
            throw new WrongType(symbol.toString(), -2, object3, object2.toString());
        }
        return object3;
    }

    static {
        instance.initXQuery();
        falseExp = new QuoteExp(Boolean.FALSE, XDataType.booleanType);
        trueExp = new QuoteExp(Boolean.TRUE, XDataType.booleanType);
        falseFunction = new ConstantFunction0("false", falseExp);
        trueFunction = new ConstantFunction0("true", trueExp);
        typeMap = new Object[]{"string", XDataType.stringType, "untypedAtomic", XDataType.untypedAtomicType, "boolean", XDataType.booleanType, "integer", XIntegerType.integerType, "long", XIntegerType.longType, "int", XIntegerType.intType, "short", XIntegerType.shortType, "byte", XIntegerType.byteType, "unsignedLong", XIntegerType.unsignedLongType, "unsignedInt", XIntegerType.unsignedIntType, "unsignedShort", XIntegerType.unsignedShortType, "unsignedByte", XIntegerType.unsignedByteType, "positiveInteger", XIntegerType.positiveIntegerType, "nonPositiveInteger", XIntegerType.nonPositiveIntegerType, "negativeInteger", XIntegerType.negativeIntegerType, "nonNegativeInteger", XIntegerType.nonNegativeIntegerType, "date", XTimeType.dateType, "dateTime", XTimeType.dateTimeType, "time", XTimeType.timeType, "duration", XTimeType.durationType, "yearMonthDuration", XTimeType.yearMonthDurationType, "dayTimeDuration", XTimeType.dayTimeDurationType, "gYearMonth", XTimeType.gYearMonthType, "gYear", XTimeType.gYearType, "gMonthDay", XTimeType.gMonthDayType, "gDay", XTimeType.gDayType, "gMonth", XTimeType.gMonthType, "decimal", XDataType.decimalType, "float", XDataType.floatType, "double", XDataType.doubleType, "anyURI", XDataType.anyURIType, "hexBinary", XDataType.hexBinaryType, "base64Binary", XDataType.base64BinaryType, "NOTATION", XDataType.NotationType, "QName", "gnu.mapping.Symbol", "normalizedString", XStringType.normalizedStringType, "token", XStringType.tokenType, "language", XStringType.languageType, "NMTOKEN", XStringType.NMTOKENType, "Name", XStringType.NameType, "NCName", XStringType.NCNameType, "ID", XStringType.IDType, "IDREF", XStringType.IDREFType, "ENTITY", XStringType.ENTITYType, "anyAtomicType", XDataType.anyAtomicType, "anySimpleType", XDataType.anySimpleType, "untyped", XDataType.untypedType, "anyType", Type.objectType};
    }
}

