/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.lists.CharBuffer;
import gnu.mapping.OutPort;
import gnu.text.QueueReader;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextPane;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import kawa.ReplDocument;
import kawa.ReplEditorKit;

public class ReplPane
extends JTextPane
implements KeyListener {
    ReplDocument document;
    public static final String ViewableElementName = "Viewable";
    public static final String PaintableElementName = "Paintable";
    public static final Object ViewableAttribute = new String("Viewable");
    public static final Object PaintableAttribute = new String("Paintable");

    public ReplPane(ReplDocument replDocument) {
        super(replDocument);
        this.document = replDocument;
        replDocument.pane = this;
        ++replDocument.paneCount;
        this.addKeyListener(this);
        this.addFocusListener(replDocument);
        EditorKit editorKit = this.getEditorKit();
        this.setCaretPosition(replDocument.outputMark);
    }

    protected EditorKit createDefaultEditorKit() {
        return new ReplEditorKit(this);
    }

    public void removeNotify() {
        super.removeNotify();
        if (--this.document.paneCount == 0) {
            this.document.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enter() {
        int n = this.getCaretPosition();
        CharBuffer charBuffer = this.document.content.buffer;
        int n2 = charBuffer.length() - 1;
        this.document.endMark = -1;
        if (n >= this.document.outputMark) {
            int n3 = charBuffer.indexOf(10, n);
            if (n3 == n2) {
                if (n2 > this.document.outputMark && charBuffer.charAt(n2 - 1) == '\n') {
                    --n3;
                } else {
                    this.document.insertString(n2, "\n", null);
                }
            }
            this.document.endMark = n3;
            QueueReader queueReader = this.document.in_r;
            synchronized (queueReader) {
                this.document.in_r.notifyAll();
            }
            if (n <= n3) {
                this.setCaretPosition(n3 + 1);
            }
        } else {
            int n4 = n == 0 ? 0 : 1 + charBuffer.lastIndexOf(10, n - 1);
            Element element = this.document.getCharacterElement(n4);
            int n5 = charBuffer.indexOf(10, n);
            if (element.getAttributes().isEqual(ReplDocument.promptStyle)) {
                n4 = element.getEndOffset();
            }
            String string = n5 < 0 ? charBuffer.substring(n4, n2) + '\n' : charBuffer.substring(n4, n5 + 1);
            this.setCaretPosition(this.document.outputMark);
            this.document.write(string, ReplDocument.inputStyle);
            if (this.document.in_r != null) {
                this.document.in_r.append(string);
            }
        }
    }

    public MutableAttributeSet getInputAttributes() {
        return ReplDocument.inputStyle;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            this.enter();
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public OutPort getStdout() {
        return this.document.out_stream;
    }

    public OutPort getStderr() {
        return this.document.err_stream;
    }
}

