/*
 * Decompiled with CFR 0.152.
 */
package org.domterm;

import java.awt.Desktop;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import org.domterm.util.Util;

public abstract class Backend {
    public int verbosity = 0;
    public String versionInfo;
    public char lineEditingMode = (char)97;
    protected Writer termWriter;

    protected void sendInputMode(char c) throws Exception {
        this.termWriter.write("\u001b[80;" + c + "u");
    }

    protected void setAutomaticNewline(boolean bl) throws Exception {
        this.termWriter.write(bl ? "\u001b[20h" : "\u001b[20l");
    }

    public boolean isCanonicalMode() {
        return true;
    }

    public void reportEvent(String string, String string2) {
        if (string.equals("KEY")) {
            if (this.termWriter != null && this.isCanonicalMode()) {
                try {
                    this.termWriter.write("\u001b]74;" + string2 + "\u0007");
                }
                catch (IOException iOException) {
                    if (this.verbosity > 0) {
                        System.err.println("PtyBackend caught " + iOException);
                    }
                }
            } else {
                int n = string2.indexOf(34);
                String string3 = Util.parseSimpleJsonString(string2, n, string2.length());
                this.processInputCharacters(string3);
            }
        } else if ("WS".equals(string)) {
            String[] stringArray = string2.split("  *");
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                int n4 = Integer.parseInt(stringArray[3]);
                this.setWindowSize(n, n2, n3, n3);
            }
            catch (Throwable throwable) {
                System.err.println("caught " + throwable);
            }
        } else if ("ALINK".equals(string)) {
            int n = string2.indexOf(34);
            String string4 = Util.parseSimpleJsonString(string2, n, string2.length());
            if (Desktop.isDesktopSupported()) {
                URI uRI;
                try {
                    uRI = new URI(string4);
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRI = URI.create("http:invalid-URI-syntax-in-link");
                }
                final URI uRI2 = uRI;
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Desktop.getDesktop().browse(uRI2);
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                }.start();
            }
        } else if ("VERSION".equals(string)) {
            this.addVersionInfo(string2);
        }
    }

    public synchronized String getVersionInfo() {
        return this.versionInfo;
    }

    public synchronized void addVersionInfo(String string) {
        this.versionInfo = this.versionInfo == null || this.versionInfo.length() == 0 ? string : this.versionInfo + ";" + string;
    }

    public abstract void processInputCharacters(String var1);

    public abstract void run(Writer var1) throws Exception;

    public void setWindowSize(int n, int n2, int n3, int n4) {
    }
}

