/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jline.terminal.impl.LineDisciplineTerminal;

public class ExternalTerminal
extends LineDisciplineTerminal {
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected final Thread pumpThread;
    protected final InputStream masterInput;

    public ExternalTerminal(String name, String type, InputStream masterInput, OutputStream masterOutput, String encoding) throws IOException {
        super(name, type, masterOutput, encoding);
        this.masterInput = masterInput;
        this.pumpThread = new Thread(this::pump, this.toString() + " input pump thread");
        this.pumpThread.start();
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.pumpThread.interrupt();
            super.close();
        }
    }

    public void pump() {
        try {
            int c;
            while ((c = this.masterInput.read()) >= 0 && !this.closed.get()) {
                this.processInputByte((char)c);
            }
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

