/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AVector;
import gnu.lists.AbstractSequence;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.Strings;
import gnu.text.Char;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.UnsupportedEncodingException;
import java.util.RandomAccess;

public class IString
extends AbstractSequence<Char>
implements CharSequence,
Externalizable,
Comparable<IString>,
AVector<Char>,
RandomAccess,
Consumable {
    String str;
    int cplength;
    int[] offsets;
    private static int[] NO_OFFSETS = new int[0];
    private static final int INDEX_STEP = 16;
    private static final int INDEX_STEP_LOG = 4;

    private static final int numSteps(int len) {
        return len >> 4;
    }

    private static final int restStep(int i) {
        return i % 16;
    }

    IString() {
    }

    public IString(String str) {
        this.init(str);
    }

    public static IString valueOf(CharSequence str) {
        if (str instanceof IString) {
            return (IString)str;
        }
        return new IString(str.toString());
    }

    public static IString valueOf(CharSequence str, int start, int count) {
        int slen = str.length();
        if (start < 0 || count < 0 || start + count > slen) {
            throw new IndexOutOfBoundsException();
        }
        if (str instanceof IString) {
            IString istr = (IString)str;
            if (start == 0 && count == slen) {
                return istr;
            }
            return new SubString(istr, start, start + count);
        }
        int jlStart = Character.offsetByCodePoints(str, 0, start);
        int jlEnd = Character.offsetByCodePoints(str, jlStart, count);
        return new IString(str.subSequence(jlStart, jlEnd).toString());
    }

    private void init(String str) {
        this.str = str;
        this.cplength = Strings.sizeInCodePoints(str);
        if (this.cplength != str.length()) {
            int n = IString.numSteps(this.cplength);
            this.offsets = n == 0 ? NO_OFFSETS : new int[n];
            int off = 0;
            for (int i = 0; i < n; ++i) {
                this.offsets[i] = off = str.offsetByCodePoints(off, 16);
            }
        }
    }

    @Override
    public int effectiveIndex(int index) {
        if (index < 0 || index >= this.cplength) {
            throw new StringIndexOutOfBoundsException();
        }
        return this.offsetByCodePoints(index) + this.jlStart();
    }

    @Override
    public Char getRaw(int index) {
        return Char.valueOf(this.str.codePointAt(index));
    }

    public int indexByCodePoints(int index) {
        return this.str.codePointAt(this.effectiveIndex(index));
    }

    public int offsetByCodePoints(int i) {
        int chi;
        int ihi;
        int clo;
        if (this.offsets == null) {
            return i;
        }
        int jlOffset = this.jlStart();
        int step = (i += this.cpStart()) >> 4;
        int ilo = i - IString.restStep(i);
        int n = clo = step == 0 ? 0 : this.offsets[step - 1];
        if (ilo <= this.cplength - 16) {
            ihi = ilo + 16;
            chi = this.offsets[step];
        } else {
            ihi = this.cplength;
            chi = this.str.length();
        }
        if (chi - clo == ihi - ilo) {
            return clo + IString.restStep(i) - jlOffset;
        }
        if (chi - clo == 2 * (ihi - ilo)) {
            return clo + 2 * IString.restStep(i) - jlOffset;
        }
        return this.str.offsetByCodePoints(clo, IString.restStep(i)) - jlOffset;
    }

    public int lengthByCodePoints() {
        return this.cplength;
    }

    @Override
    public int size() {
        return this.cplength;
    }

    @Override
    public char charAt(int i) {
        return this.str.charAt(i);
    }

    @Override
    public String toString() {
        return this.str;
    }

    @Override
    public int length() {
        return this.str.length();
    }

    @Override
    public IString subSequence(int from, int to) {
        if (to < from || to - from > this.length()) {
            throw new StringIndexOutOfBoundsException();
        }
        int jlStart = this.jlStart();
        return new IString(this.str.substring(from + jlStart, to + jlStart));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.str);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.init((String)in.readObject());
    }

    public char[] toCharArray() {
        return this.toString().toCharArray();
    }

    public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
        return this.toString().getBytes(charsetName);
    }

    @Override
    public void consume(Consumer out) {
        out.write(this.str, this.jlStart(), this.length());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IString) {
            IString str2 = (IString)other;
            return this.length() == str2.length() && Strings.compareTo(this, str2) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(IString other) {
        return Strings.compareTo(this, other);
    }

    int cpStart() {
        return 0;
    }

    int jlStart() {
        return 0;
    }

    public static final class SubString
    extends IString {
        int cpStart;
        int jlStart;
        int jlLength;
        private String jlString;

        public SubString(IString base2, int start, int end) {
            this(base2, start, end, base2.offsetByCodePoints(start), base2.offsetByCodePoints(end));
        }

        public SubString(IString base2, int start, int end, int jlStart, int jlEnd) {
            this.str = base2.str;
            this.jlStart = base2.jlStart() + jlStart;
            this.jlLength = jlEnd - jlStart;
            this.cpStart = start + base2.cpStart();
            this.cplength = end - start;
            if (this.jlLength != this.cplength) {
                this.offsets = base2.offsets;
            }
        }

        @Override
        int cpStart() {
            return this.cpStart;
        }

        @Override
        int jlStart() {
            return this.jlStart;
        }

        @Override
        public char charAt(int i) {
            if (i >= this.jlLength) {
                throw new StringIndexOutOfBoundsException(i);
            }
            return this.str.charAt(i + this.jlStart);
        }

        @Override
        public String toString() {
            String jstr = this.jlString;
            if (jstr == null) {
                this.jlString = jstr = this.str.substring(this.jlStart, this.jlStart + this.jlLength);
            }
            return jstr;
        }

        @Override
        public int length() {
            return this.jlLength;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.toString());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.str = (String)in.readObject();
        }

        public Object readResolve() throws ObjectStreamException {
            return new IString(this.str);
        }
    }
}

