<?php

//        # Copyright (C) 2012-2013 GNU remotecontrol authors.
//        #
//        # This program is free software: you can redistribute it and/or modify
//        # it under the terms of the GNU Affero General Public License as
//        # published by the Free Software Foundation, either version 3 of the
//        # License, or (at your option) any later version.
//        #
//        # This program is distributed in the hope that it will be useful,
//        # but WITHOUT ANY WARRANTY; without even the implied warranty of
//        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//        # GNU Affero General Public License for more details.
//        #
//        # You should have received a copy of the GNU Affero General Public License
//        # along with this program.  If not, see <http://www.gnu.org/licenses/>.

    class ResourceCollection extends ArrayObject
    {
        // Constructor
        public function __construct($loadData, $code, $useSortOrder = null, $depth = null, $onlyAtLevel = null) 
        {
            if($loadData)
            {
                    $this->Load($code, $useSortOrder, $depth, $onlyAtLevel);
            }
        }        
        
        // Methods
        public function FindResourceByCode($code)
        {
                foreach($this as $res)
                {
                        if($res->Code == $code)
                        {
                                return $res;
                        }
                }

                return null;
        }
        
        protected function Load($code, $useSortOrder, $depth, $onlyAtLevel)
        {            
                if ($code == 'All')
                {
                    $this->LoadAll();
                    
                    return;
                }
            
                $dataAccess = new MySqlDataAccess(Common::ConnectionString);
                $dataAccess->Command->CommandType = CommandType::StoredProcedure;
                
                $langcode = 'en';
                
                if (isset($_SESSION['User']))
                {
                    $langcode = $_SESSION['User']->LangCode;
                }                
                                                
                $useSortOrder2 = 'null';
                
                if ($useSortOrder === true)
                {
                    $useSortOrder2 = 1;
                }
                elseif ($useSortOrder === false)
                {
                    $useSortOrder2 = 0;
                }
                
                $depth2 = ($depth === null) ? 'null' : $depth;
                
                $onlyAtLevel2 = 'null';
                
                if ($onlyAtLevel === true)
                {
                    $onlyAtLevel2 = 1;
                }
                elseif ($onlyAtLevel === false)
                {
                    $onlyAtLevel2 = 0;
                }
                
                $dataAccess->Command->CommandText = "CALL sp_Resources_Load_By_Parent_Code('$langcode', '$code', $useSortOrder2, $depth2, $onlyAtLevel2)";
                $dataAccess->GetData();

                if($dataAccess->ResultSet)
                {
                        while($row = $dataAccess->ResultSet->fetch_assoc())
                        {
                                $this->append(new Resource($row['ResourceID'], $row['Code'], $row['Value'], $row['DropDownItemValue'], $row['StyleClass'], $row['SortOrder'], $row['LFT'], $row['RGT']));
                        }
                }

                $dataAccess->Cleanup();
        }
        
        private function LoadAll()
        {
            $dataAccess = new MySqlDataAccess(Common::ConnectionString);
            $dataAccess->Command->CommandType = CommandType::StoredProcedure;
            
            $dataAccess->Command->CommandText = "CALL sp_Resources_Load_All()";
            $dataAccess->GetData();

            if($dataAccess->ResultSet)
            {
                    while($row = $dataAccess->ResultSet->fetch_assoc())
                    {
                            $this->append(new Resource($row['ResourceID'], $row['Code'], $row['Value'], $row['DropDownItemValue'], $row['StyleClass'], $row['SortOrder'], $row['Page'], $row['LFT'], $row['RGT']));
                    }
            }

            $dataAccess->Cleanup();
        }
        
    }

?>
