<?php

//        # Copyright (C) 2012-2013 GNU remotecontrol authors.
//        #
//        # This program is free software: you can redistribute it and/or modify
//        # it under the terms of the GNU Affero General Public License as
//        # published by the Free Software Foundation, either version 3 of the
//        # License, or (at your option) any later version.
//        #
//        # This program is distributed in the hope that it will be useful,
//        # but WITHOUT ANY WARRANTY; without even the implied warranty of
//        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//        # GNU Affero General Public License for more details.
//        #
//        # You should have received a copy of the GNU Affero General Public License
//        # along with this program.  If not, see <http://www.gnu.org/licenses/>.

    class Language
    {
        // Properties
        public $Code;
        public $Description;

        // Constructor
        public function __construct()
        {
            $numargs = func_num_args();
            $args = func_get_args();
            
            switch ($numargs)
            {
                case 2:
                    
                    $this->Code = $args[0];
                    
                    if ($args[1] === true)
                    {
                        $this->Load();
                    }
                    elseif ($args[1] !== false)
                    {
                        $this->Description = $args[1];
                    }
                    
                    break;
                
                default:
                    
                    $this->Code = '';
                    $this->Description = '';
                    
                    break;
            }
        }
        
        // Methods
        private function Load()
        {
            $dataAccess = new MySqlDataAccess(Common::ConnectionString);
            $dataAccess->Command->CommandType = CommandType::StoredProcedure;
            $dataAccess->Command->CommandText = "CALL sp_Language_Load_Details('$this->Code')";
            $dataAccess->GetData();

            $row = $dataAccess->ResultSet->fetch_assoc();

            $this->Description = $row['Description'];            

            $dataAccess->Cleanup();
        }
        
        public function getLanguages()
        {
            $dataAccess = new MySqlDataAccess(Common::ConnectionString);
            $dataAccess->Command->CommandType = CommandType::StoredProcedure;
            $dataAccess->Command->CommandText = "CALL sp_Languages_Load_All";
            return $dataAccess->GetData()->ResultSet->fetch_assoc();
        }
        
        
    }

?>
